/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.timesten;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.timesten.TimesTenDatabase;
import oracle.javatools.db.timesten.TimesTenDatabaseDescriptor;
import oracle.javatools.db.timesten.TimesTenDatabaseImpl;

public class TimesTenDatabaseFactory
extends DatabaseFactory.DatabaseCreator {
    private DatabaseDescriptor m_descriptor;

    public TimesTenDatabaseFactory() {
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        dtr.registerProvider((DataTypeRegistry.Registerer)new TimesTenDatabaseImpl.Registerer(), TimesTenDatabaseImpl.class);
    }

    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        if (this.isTimesTenConnection(conn)) {
            return new TimesTenDatabaseImpl(connStore, connName, conn);
        }
        return null;
    }

    protected boolean isTimesTenConnection(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String dbName = dmd.getDatabaseProductName();
                boolean bl = dbName.startsWith("TimesTen");
                return bl;
            }
            catch (SQLException sqlx) {
                // empty catch block
            }
        }
        return false;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (TimesTenDatabase.class.isAssignableFrom(providerClass)) {
            if (this.m_descriptor == null) {
                this.m_descriptor = new TimesTenDatabaseDescriptor();
            }
            return this.m_descriptor;
        }
        return null;
    }
}

