/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaObjectValidator<T extends SchemaObject>
extends AbstractValidator<T> {
    public AbstractSchemaObjectValidator(DBObjectProvider pro) {
        super(pro);
    }

    private void validateSchema(SchemaObject object) throws ValidationException {
        Schema schema = object.getSchema();
        if (schema == null) {
            throw new ValidationException((DBObject)object, DBArb.getString((int)142));
        }
        DBObjectProvider pro = this.getProvider();
        String name = schema.getName();
        if (!ModelUtil.hasLength((String)name)) {
            throw new InvalidNameException((DBObject)schema, DBArb.getString((int)21));
        }
        if (!pro.isValidName("SCHEMA", pro.getExternalName(name))) {
            throw new InvalidNameException((DBObject)schema, DBArb.getString((int)331));
        }
    }

    @AbstractValidator.PropertyValidator(value={Property.schema})
    public void validateSchema(T original, T updated) throws ValidationException {
        Schema schema1 = original == null ? null : original.getSchema();
        Schema schema2 = updated.getSchema();
        if (schema1 == null) {
            this.validateSchema((SchemaObject)updated);
        } else if (ModelUtil.areDifferent((Object)schema1, (Object)schema2)) {
            if (this.canChangeSchema()) {
                this.validateSchema((SchemaObject)updated);
            } else {
                throw new ValidationException(updated, DBArb.getString((int)216));
            }
        }
    }

    protected boolean canChangeSchema() {
        return true;
    }
}

