/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Index;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.MissingValidatorException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidator<T extends DBObject>
implements DBObjectValidator<T> {
    private DBObjectProvider m_provider;
    private Map<Property[], Method> m_propMap;

    protected AbstractValidator(DBObjectProvider pro) {
        this.m_provider = pro;
    }

    public final void validateObject(T object) throws ValidationException {
        if (object instanceof SchemaObject && !(object instanceof Index) && this.findExistingObject(object) != null) {
            throw new NameInUseException(object);
        }
        this.validateObject(null, object);
    }

    public final void validateObjectProperty(T object, Object property) throws ValidationException {
        this.validateObjectProperty(this.findExistingObject(object), object, property);
    }

    public void validateObject(T original, T updated) throws ValidationException {
        for (Method m : this.getPropertyMethodMap().values()) {
            this.invokePropertyMethod(m, original, updated);
        }
    }

    public void validateObjectProperty(T original, T updated, Object property) throws ValidationException {
        Method validationMethod = this.findValidationPropertyMethod(property);
        if (validationMethod == null) {
            throw new MissingValidatorException(updated, "" + property);
        }
        this.invokePropertyMethod(validationMethod, original, updated);
    }

    private void invokePropertyMethod(Method m, T original, T updated) throws ValidationException {
        try {
            m.invoke((Object)this, original, updated);
        }
        catch (IllegalArgumentException e) {
            this.processPropException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof ValidationException) {
                throw (ValidationException)t;
            }
            this.processPropException(e);
        }
        catch (IllegalAccessException e) {
            this.processPropException(e);
        }
    }

    private void processPropException(Exception e) {
        DBLog.getLogger().log(Level.SEVERE, "Error calling property validation", e);
    }

    private Method findValidationPropertyMethod(Object property) {
        if (property == null) {
            return null;
        }
        Map<Property[], Method> propMap = this.getPropertyMethodMap();
        Property[] key = property instanceof Property ? new Property[]{(Property)((Object)property)} : (property instanceof Property[] ? (Property[])property : Property.fromPath(property.toString()));
        return propMap.get(key);
    }

    private synchronized Map<Property[], Method> getPropertyMethodMap() {
        if (this.m_propMap == null) {
            this.m_propMap = new TreeMap<Property[], Method>(new 1());
            Class<?> c = this.getClass();
            Method[] methodArray = c.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                Method m = methodArray[n];
                PropertyValidator v = m.getAnnotation(PropertyValidator.class);
                if (v != null) {
                    Property[] value = v.value();
                    if (v.path()) {
                        this.putPropertyMethod(m, value);
                    } else {
                        Property[] propertyArray = v.value();
                        int n2 = 0;
                        while (n2 < propertyArray.length) {
                            Property p = propertyArray[n2];
                            this.putPropertyMethod(m, p);
                            ++n2;
                        }
                    }
                }
                ++n;
            }
        }
        return this.m_propMap;
    }

    private void putPropertyMethod(Method m, Property ... p) {
        if (this.m_propMap.containsKey(p)) {
            throw new IllegalStateException("cannot have two methods validating " + p);
        }
        this.m_propMap.put(p, m);
    }

    @PropertyValidator(value={Property.type})
    public final void validateType(T original, T updated) throws ValidationException {
        if (original != null && ModelUtil.areDifferent((Object)original.getType(), (Object)updated.getType())) {
            throw new ValidationException(updated, DBArb.getString((int)334));
        }
    }

    @PropertyValidator(value={Property.name})
    public final void validateName(T original, T updated) throws ValidationException {
        this.validateName(updated);
        if (original == null) {
            this.validateNameInUse(updated);
        } else if (ModelUtil.areDifferent((Object)original.getName(), (Object)updated.getName())) {
            if (this.canRename()) {
                this.validateNameInUse(updated);
            } else {
                throw new ValidationException(updated, DBArb.getString((int)124));
            }
        }
    }

    protected final boolean isChildOfPendingObject(DBObject obj) {
        boolean childOfPendingObject = false;
        DBObject so = obj;
        while (so.getParent() != null) {
            so = so.getParent();
            childOfPendingObject = true;
        }
        if (so instanceof SchemaObject && !this.isPendingObject((SchemaObject)so)) {
            childOfPendingObject = false;
        }
        return childOfPendingObject;
    }

    protected final boolean isPendingObject(SchemaObject obj) {
        return TemplateExpander.isPendingObject((SchemaObject)obj);
    }

    protected void validateName(T obj) throws InvalidNameException {
        String name = obj.getName();
        if (!ModelUtil.hasLength((String)name) && !this.canHaveEmptyName()) {
            throw new InvalidNameException(obj, DBArb.getString((int)354));
        }
        if (this.m_provider != null && ModelUtil.hasLength((String)name)) {
            try {
                String extName = this.m_provider.getExternalName(name);
                this.m_provider.validateName(obj.getType(), extName);
            }
            catch (InvalidNameException ine) {
                String reason = ine.getMessage();
                throw new InvalidNameException(obj, DBArb.format((int)253, (Object)name, (Object)reason));
            }
        }
    }

    protected boolean canHaveEmptyName() {
        return false;
    }

    protected boolean canRename() {
        return true;
    }

    protected DBObjectProvider getProvider() {
        return this.m_provider;
    }

    protected void validateNameInUse(T object) throws NameInUseException {
        if (this.m_provider != null) {
            Schema schema = DBUtil.getSchema(object);
            String type = object.getType();
            String name = object.getName();
            this.m_provider.validateUniqueName(type, (DBObject)schema, name);
        }
    }

    protected T findExistingObject(T object) throws ValidationException {
        DBObjectID id = object.getID();
        DBObject existing = null;
        if (id != null) {
            try {
                if (id instanceof TemporaryObjectID) {
                    existing = this.getOriginal((TemporaryObjectID)id);
                    if (ModelUtil.areEqual(object, (Object)existing)) {
                        existing = null;
                    }
                } else {
                    existing = id.resolveID();
                }
            }
            catch (DBException dbe) {
                throw new ValidationException(object, dbe.getMessage());
            }
            if (existing != null && !existing.getType().equals(object.getType())) {
                throw new ValidationException(object, MessageFormat.format(DBArb.getString((int)344), object.getName()));
            }
        }
        if (existing == null && object instanceof SchemaObject && (id == null || id instanceof TemporaryObjectID)) {
            try {
                existing = DBUtil.getProviderDefinition((SchemaObject)((SchemaObject)object), (DBObjectProvider)this.getProvider());
            }
            catch (DBException dbe) {
                DBLog.logStackTrace((Throwable)dbe);
            }
        }
        return (T)existing;
    }

    private DBObject getOriginal(TemporaryObjectID tid) throws DBException {
        DBObjectID id;
        DBObject obj = tid.resolveOriginalID();
        DBObjectID dBObjectID = id = obj == null ? null : obj.getID();
        if (id instanceof TemporaryObjectID) {
            return this.getOriginal((TemporaryObjectID)id);
        }
        return obj;
    }

    protected boolean enforceChildNameUniqueInSchema(DBObject child) {
        return false;
    }

    @PropertyValidator(value={Property.Comment})
    public void validateComment(T original, T update) throws ValidationException {
        String comment = (String)update.getProperty("Comment");
        if (comment != null) {
            DatabaseDescriptor dd = this.getProvider().getDescriptor();
            try {
                dd.validateEncoding(comment, (Object)Property.Comment);
            }
            catch (ValidationException ve) {
                throw new ValidationException(update, ve.getMessage());
            }
        }
    }

    public static void validateUniqueNames(DBObject[] objs) throws ValidationException {
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < objs.length) {
            if (!(objs[i] instanceof ViewColumn) || !((ViewColumn)objs[i]).isAsterisk()) {
                String name = objs[i].getName();
                if (!ModelUtil.hasLength((String)name)) {
                    if (objs[i] instanceof ViewColumn) {
                        ViewColumn col = (ViewColumn)objs[i];
                        SelectObject sel = null;
                        if (col.getSelectObjectID() != null) {
                            try {
                                sel = (SelectObject)col.getSelectObjectID().resolveID();
                            }
                            catch (DBException e) {
                                // empty catch block
                            }
                        }
                        if (sel == null) {
                            throw new ValidationException(objs[i], DBArb.format((int)66, (Object)(col.getParent() == null ? "" : col.getParent().getName())));
                        }
                    }
                    throw new InvalidNameException(objs[i], DBArb.getString((int)354));
                }
                if (names.contains(name)) {
                    throw new InvalidNameException(objs[i], DBArb.format((int)165, (Object)name, (Object)objs[i].getType()));
                }
                names.add(name);
            }
            ++i;
        }
    }

    final class 1
    implements Comparator {
        public int compare(Property[] a, Property[] b) {
            String as = Property.createPath(a);
            String bs = Property.createPath(b);
            return as.compareTo(bs);
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected @interface PropertyValidator {
        public Property[] value();

        public boolean path() default false;
    }
}

