/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.List;
import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnValidator
extends AbstractValidator {
    static final /* synthetic */ boolean $assertionsDisabled;

    public ColumnValidator(DBObjectProvider prov) {
        super(prov);
    }

    public void validateObject(DBObject original, DBObject updated) throws ValidationException {
        DBObjectID id;
        Column cori = (Column)original;
        if (cori == null && (id = updated.getID()) instanceof TemporaryObjectID) {
            try {
                cori = (Column)((TemporaryObjectID)id).resolveOriginalID();
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        if (cori == null || ModelUtil.areDifferent((Object)cori, (Object)updated)) {
            super.validateObject(original, updated);
            if (cori != null && ModelUtil.areDifferent((Object)cori.getDataTypeUsage(), (Object)((Column)updated).getDataTypeUsage()) && !ColumnValidator.canChangeColumnDatatype(this.getProvider(), cori)) {
                throw new ValidationException(original, DBArb.format((int)95, (Object)ColumnValidator.formatRelationColumn(cori, null)), DBArb.getString((int)2));
            }
            this.validateColumnDefinition((Column)updated);
        }
    }

    protected void validateColumnDefinition(Column column) throws ValidationException {
        DataType dataType = null;
        try {
            dataType = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage());
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (dataType == null) {
            throw new ValidationException((DBObject)column, DBArb.format((int)40, (Object)ColumnValidator.formatRelationColumn(column, null)), DBArb.getString((int)100));
        }
        dataType.validateUsage(column.getDataTypeUsage(), (DBObject)column);
        this.validateDefaultValue(column, dataType);
    }

    protected void validateDefaultValue(Column column, DataType dataType) throws ValidationException {
        Object defaultValue = column.getDefault();
        if (defaultValue != null) {
            dataType.validateDefaultValue(defaultValue, column.getDataTypeUsage(), (DBObject)column);
        }
    }

    public static String formatRelationColumn(Column column, Relation rel) {
        StringBuffer format = new StringBuffer();
        if (column != null) {
            String parName;
            Relation par = column.getRelation();
            Relation relation = par = par == null ? rel : par;
            if (par != null && ModelUtil.hasLength((String)(parName = par.getName()))) {
                format.append(parName);
                format.append(".");
            }
            format.append(column.getName());
        }
        return format.toString();
    }

    static {
        $assertionsDisabled = ColumnValidator.class.desiredAssertionStatus() ^ true;
    }

    protected void validateNameInUse(DBObject object) throws NameInUseException {
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(object instanceof Column)) {
            throw new AssertionError();
        }
        Column column = (Column)object;
        try {
            if (column.getRelation() != null) {
                ColumnValidator.validateUniqueNames((DBObject[])column.getRelation().getColumns());
            }
        }
        catch (ValidationException x) {
            throw new NameInUseException(x.getObject());
        }
    }

    public static boolean canChangeColumnDatatype(DBObjectProvider prov, Column col) {
        boolean canChange = true;
        try {
            List usages = DBUtil.getColumnUsages((DBObjectProvider)prov, (Column)col);
            for (DBObject usage : usages) {
                if (usage instanceof FKConstraint) {
                    canChange = false;
                } else {
                    FKConstraint[] fkrefs;
                    if (!(usage instanceof PKConstraint) && !(usage instanceof UniqueConstraint)) continue;
                    if (usage.getID() instanceof TemporaryObjectID) {
                        usage = ((TemporaryObjectID)usage.getID()).resolveOriginalID();
                    }
                    if ((fkrefs = DBUtil.getReferences((Constraint)((Constraint)usage), (DBObjectProvider)prov)) == null || fkrefs.length <= 0) continue;
                    canChange = false;
                }
                break;
            }
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.SEVERE, "Unexpected exception", dbe);
            canChange = false;
        }
        return canChange;
    }
}

