/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.ArrayList;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintValidator
extends AbstractValidator {
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConstraintValidator(DBObjectProvider prov) {
        super(prov);
    }

    static {
        $assertionsDisabled = ConstraintValidator.class.desiredAssertionStatus() ^ true;
    }

    public void validateObject(DBObject original, DBObject updated) throws ValidationException {
        if (!$assertionsDisabled && updated == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(updated instanceof Constraint)) {
            throw new AssertionError();
        }
        Constraint constraint = (Constraint)updated;
        if (constraint.getParent() == null || !this.existsInParent(constraint)) {
            throw new IllegalStateException(DBArb.getString((int)206));
        }
        if (original == null || ModelUtil.areDifferent((Object)original, (Object)constraint)) {
            super.validateObject(original, constraint);
        }
        this.validateConstraintDefinition(constraint);
    }

    protected void validateNameInUse(DBObject object) throws NameInUseException {
        block7: {
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !(object instanceof Constraint)) {
                throw new AssertionError();
            }
            Constraint constraint = (Constraint)object;
            try {
                ConstraintValidator.validateUniqueNames((DBObject[])constraint.getRelation().getConstraints());
            }
            catch (ValidationException x) {
                throw new NameInUseException((DBObject)constraint);
            }
            if (this.enforceChildNameUniqueInSchema((DBObject)constraint)) {
                try {
                    super.validateNameInUse(constraint);
                }
                catch (NameInUseException x) {
                    Relation relation = constraint.getRelation();
                    if (!ModelUtil.areDifferent((Object)relation.getName(), (Object)x.getUserName()) && !ModelUtil.areDifferent((Object)relation.getType(), (Object)x.getUserType())) break block7;
                    throw x;
                }
            }
        }
    }

    protected void validateConstraintDefinition(Constraint con) throws ValidationException {
        block14: {
            Column[] conCols;
            boolean isFK;
            block13: {
                String type = con.getConstraintType();
                if (con instanceof CheckConstraint) {
                    Relation parent = (Relation)con.getParent();
                    String condition = ((CheckConstraint)con).getCheckCondition();
                    if (!ModelUtil.hasLength((String)condition)) {
                        throw new ValidationException((DBObject)con, DBArb.format((int)296, (Object)con.getName()));
                    }
                    try {
                        for (String[] nameComponents : ParserUtils.getColumnNames((String)condition, (ParserUtils.ExpressionType)ParserUtils.ExpressionType.BOOLEAN)) {
                            String colName = this.getProvider().getInternalName(nameComponents[0]);
                            Column column = parent.getColumn(colName);
                            if (column != null) continue;
                            throw new ValidationException((DBObject)con, DBArb.format((int)255, (Object)con.getName(), (Object)DBArb.format((int)372, (Object)this.getProvider().getExternalName(colName))));
                        }
                    }
                    catch (SQLQueryException e) {
                        throw new ValidationException((DBObject)con, DBArb.format((int)255, (Object)con.getName(), (Object)e.getMessage()));
                    }
                }
                isFK = "FKConstraint".equals(type);
                conCols = this.getConstraintColumns((ColumnConstraint)con);
                if (conCols.length == 0) {
                    throw new ValidationException((DBObject)con, DBArb.getString((int)(isFK ? 29 : 147)));
                }
                if (this.areDuplicateColumns(conCols)) {
                    throw new ValidationException((DBObject)con, DBArb.getString((int)220));
                }
                if (!(con instanceof UniqueConstraint)) break block13;
                if (type.equals("PKConstraint")) {
                    this.checkColumnDataType(conCols, 356);
                    this.markColumnsNotNull(conCols);
                } else {
                    this.checkColumnDataType(conCols, 85);
                }
                this.checkIsUniqueDefinition(con);
                break block14;
            }
            if (!isFK) break block14;
            FKConstraint fk = (FKConstraint)con;
            DBObjectID refID = fk.getReferenceID();
            if (refID == null) {
                throw new ValidationException((DBObject)con, DBArb.getString((int)281));
            }
            this.checkColumnDataType(conCols, 260);
            if (refID instanceof ReferenceID) {
                ReferenceID nbfk = (ReferenceID)refID;
                ReferenceID parID = (ReferenceID)nbfk.getParent();
                this.getProvider().validateName("SCHEMA", parID.getSchemaName());
                this.getProvider().validateName("TABLE", parID.getName());
                this.getProvider().validateName("CONSTRAINT", nbfk.getName());
                String[] stringArray = nbfk.getChildObjectNames();
                int n = 0;
                while (n < stringArray.length) {
                    String colName = stringArray[n];
                    this.getProvider().validateName("COLUMN", colName);
                    ++n;
                }
            } else {
                this.checkColumnsMatch(fk);
            }
        }
    }

    public boolean isCompatibleDataTypes(DataType fkColDataType, DataType refColDataType) {
        return this.incompatibleDataTypes(fkColDataType, refColDataType) ^ true;
    }

    protected boolean incompatibleDataTypes(DataType fkColDataType, DataType refColDataType) {
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        if (dtr.isSynonymType(fkColDataType)) {
            fkColDataType = dtr.getBaseType(fkColDataType);
        }
        if (dtr.isSynonymType(refColDataType)) {
            refColDataType = dtr.getBaseType(refColDataType);
        }
        return ModelUtil.areDifferent((Object)fkColDataType, (Object)refColDataType);
    }

    protected boolean isValidConstraintDatatype(String dataTypeName, DataTypeUsage dataTypeUsage) {
        return true;
    }

    private void checkColumnsMatch(FKConstraint fk) throws ValidationException {
        block10: {
            try {
                Column[] cols = fk.getColumns();
                DBObjectID id = fk.getReferenceID();
                UniqueConstraint refCon = null;
                try {
                    refCon = (UniqueConstraint)id.resolveID();
                }
                catch (DBException dbe) {
                    // empty catch block
                }
                if (refCon == null || cols == null) break block10;
                if (cols.length == refCon.getColumns().length) {
                    Column[] refCols = refCon.getColumns();
                    int i = 0;
                    while (i < cols.length) {
                        Column refCol = refCols[i];
                        if (refCol != null && cols[i] != null) {
                            String refColName = refCol.getName();
                            DataType colDataType = null;
                            DataType refColDataType = null;
                            try {
                                colDataType = DataTypeHelper.getDataType((DataTypeUsage)cols[i].getDataTypeUsage());
                                refColDataType = DataTypeHelper.getDataType((DataTypeUsage)refCol.getDataTypeUsage());
                            }
                            catch (DBException dbe) {
                                // empty catch block
                            }
                            if (this.incompatibleDataTypes(colDataType, refColDataType)) {
                                Object[] params = new Object[]{cols[i].getName(), colDataType.getName(), refColName, refColDataType.getName()};
                                throw new ValidationException((DBObject)fk, DBArb.format((int)290, (Object[])params));
                            }
                        }
                        ++i;
                    }
                    break block10;
                }
                throw new ValidationException((DBObject)fk, DBArb.format((int)276, (Object)cols.length, (Object)refCon.getColumns().length));
            }
            catch (IllegalStateException x) {
                throw new ValidationException((DBObject)fk, x.getMessage());
            }
        }
    }

    private void markColumnsNotNull(Column[] cols) throws ValidationException {
        int i = 0;
        while (i < cols.length) {
            Column col = cols[i];
            if (!col.isNotNull()) {
                col.setNotNull(true);
            }
            ++i;
        }
    }

    private void checkColumnDataType(Column[] cols, int errorMessage) throws ValidationException {
        int i = 0;
        while (i < cols.length) {
            Column col = cols[i];
            if (col != null && !(col instanceof ViewColumn)) {
                DataType dataType = null;
                try {
                    dataType = DataTypeHelper.getDataType((DataTypeUsage)col.getDataTypeUsage());
                }
                catch (DBException dbe) {
                    // empty catch block
                }
                if (dataType == null) {
                    throw new ValidationException((DBObject)col, DBArb.format((int)40, (Object)col.getName()));
                }
                if (!this.isValidConstraintDatatype(dataType.getName(), col.getDataTypeUsage())) {
                    throw new ValidationException((DBObject)col, DBArb.format((int)errorMessage, (Object)col.getName()));
                }
            }
            ++i;
        }
    }

    protected void checkIsUniqueDefinition(Constraint con) throws ValidationException {
        Column[] conColumns = ((UniqueConstraint)con).getColumns();
        Constraint[] constraints = con.getRelation().getConstraints();
        int j = 0;
        while (j < constraints.length) {
            if (constraints[j] instanceof UniqueConstraint && !constraints[j].equals((Object)con) && this.areIdenticalColumnLists(conColumns, ((UniqueConstraint)constraints[j]).getColumns())) {
                throw new ValidationException((DBObject)con, DBArb.format((int)230, (Object[])new Object[]{this.getConstraintTypeDisplayName(con), con.getName(), this.getConstraintTypeDisplayName(constraints[j]), constraints[j].getName()}));
            }
            ++j;
        }
    }

    private boolean areIdenticalColumnLists(Column[] thisConsColumns, Column[] otherConsColumns) {
        if (thisConsColumns.length != otherConsColumns.length) {
            return false;
        }
        int i = 0;
        while (i < thisConsColumns.length) {
            if (!thisConsColumns[i].getName().equals(otherConsColumns[i].getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String getConstraintTypeDisplayName(Constraint constraint) {
        return DBArb.getString((int)(constraint.getConstraintType().equals("PKConstraint") ? 48 : 99));
    }

    private boolean areDuplicateColumns(Column[] cols) {
        boolean result = false;
        int i = 0;
        while (i < cols.length - 1 && !result) {
            if (cols[i] != null) {
                int j = i + 1;
                while (j < cols.length) {
                    if (cols[i].equals((Object)cols[j])) {
                        result = true;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    private boolean missingColumns(Column[] consCols, Column[] relationCols) {
        boolean missing = false;
        int i = 0;
        while (i < consCols.length && !missing) {
            missing = true;
            int j = 0;
            while (j < relationCols.length) {
                if (consCols[i].equals((Object)relationCols[j])) {
                    missing = false;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return missing;
    }

    public static void validateOnePK(Constraint[] cons) throws ValidationException {
        boolean hasPK = false;
        int i = 0;
        while (i < cons.length) {
            String cType = cons[i].getConstraintType();
            if ("PKConstraint".equals(cType)) {
                if (hasPK) {
                    throw new ValidationException((DBObject)cons[i], DBArb.getString((int)237));
                }
                hasPK = true;
            }
            ++i;
        }
    }

    private boolean existsInParent(Constraint constraint) {
        Constraint[] constraints = constraint.getRelation().getConstraints();
        int i = 0;
        while (i < constraints.length) {
            if (constraint.equals((Object)constraints[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Column[] getConstraintColumns(ColumnConstraint con) throws ValidationException {
        ArrayList<Column> columns = new ArrayList<Column>();
        Relation parent = con.getRelation();
        DBObjectID[] dBObjectIDArray = con.getColumnIDs();
        int n = 0;
        while (n < dBObjectIDArray.length) {
            DBObjectID conID = dBObjectIDArray[n];
            Column c = (Column)parent.findOwnedObject(conID);
            if (c == null) {
                throw new ValidationException((DBObject)con, DBArb.getString((int)312));
            }
            columns.add(c);
            ++n;
        }
        return columns.toArray(new Column[columns.size()]);
    }
}

