/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.HashSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.diff.IndexObjectComparator;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.AbstractSchemaObjectValidator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexValidator
extends AbstractSchemaObjectValidator {
    static final /* synthetic */ boolean $assertionsDisabled;

    public IndexValidator(DBObjectProvider prov) {
        super(prov);
    }

    static {
        $assertionsDisabled = IndexValidator.class.desiredAssertionStatus() ^ true;
    }

    @Override
    public void validateObject(DBObject original, DBObject updated) throws ValidationException {
        if (!$assertionsDisabled && updated == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(updated instanceof Index)) {
            throw new AssertionError();
        }
        Index index = (Index)updated;
        if (index.getParent() == null) {
            throw new ValidationException((DBObject)index, DBArb.getString((int)322));
        }
        if (original == null || ModelUtil.areDifferent((Object)original, (Object)index)) {
            super.validateObject(original, index);
        }
        this.validateIndexDefinition(index);
    }

    protected void validateIndexDefinition(Index index) throws ValidationException {
        IndexObject[] ios = index.getColumnExpressions();
        if (ios.length <= 0) {
            throw new ValidationException((DBObject)index, DBArb.getString((int)137));
        }
        this.checkColumnExpressions(index);
        this.checkDefinitionIsUnique(index);
        this.checkInavildFunctions(index);
        OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        if (oip != null) {
            this.getProvider().validateObject((DBObject)oip);
        }
        this.checkBitmapIndexOnIOT(index);
    }

    public void validateNameInTable(Table table) throws ValidationException {
        Index[] tableIndexes = table.getIndexes();
        HashSet names = new HashSet();
        int i = 0;
        while (i < tableIndexes.length) {
            String indexName = tableIndexes[i].getName();
            if (names.contains(indexName)) {
                this.errorDuplicateName(tableIndexes[i]);
            }
            ++i;
        }
    }

    @Override
    protected void validateNameInUse(DBObject object) throws NameInUseException {
        block8: {
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !(object instanceof Index)) {
                throw new AssertionError();
            }
            Index index = (Index)object;
            Table table = index.getTable();
            try {
                IndexValidator.validateUniqueNames((DBObject[])table.getIndexes());
            }
            catch (ValidationException x) {
                throw new NameInUseException((DBObject)index);
            }
            if (this.enforceChildNameUniqueInSchema((DBObject)index)) {
                try {
                    super.validateNameInUse(index);
                }
                catch (NameInUseException x) {
                    String tableType = table.getType();
                    if (table instanceof MaterializedView) {
                        tableType = "TABLE";
                    }
                    if (!ModelUtil.areDifferent((Object)table.getName(), (Object)x.getUserName()) && !ModelUtil.areDifferent((Object)tableType, (Object)x.getUserType())) break block8;
                    throw x;
                }
            }
        }
    }

    @Override
    protected boolean enforceChildNameUniqueInSchema(DBObject obj) {
        return this.isChildOfPendingObject(obj) ^ true;
    }

    private void errorDuplicateName(Index index) throws ValidationException {
        String indexName = index.getName();
        throw new InvalidNameException((DBObject)index, DBArb.format((int)74, (Object)indexName));
    }

    protected void validateColumnType(Index index, Column col) throws ValidationException {
    }

    protected void checkColumnExpressions(Index index) throws ValidationException {
        IndexObject[] ios = index.getColumnExpressions();
        Table t = index.getTable();
        HashSet<String> columnNames = new HashSet<String>();
        boolean noColumns = t instanceof MaterializedView && t.getColumns().length == 0;
        int i = 0;
        while (i < ios.length) {
            SQLFragment expression = ios[i].getExpression();
            if (expression instanceof ColumnUsage) {
                ((ColumnUsage)expression).setProvider(this.getProvider());
            }
            String columnName = this.getProvider().getInternalName(expression.getSQLText());
            if (this.columnMustBeUnique()) {
                if (columnNames.contains(columnName)) {
                    throw new ValidationException((DBObject)index, DBArb.format((int)364, (Object)columnName, (Object)index.getName()));
                }
                columnNames.add(columnName);
            }
            if (!noColumns) {
                Column column = t.getColumn(columnName);
                if (column == null) {
                    throw new ValidationException((DBObject)index, DBArb.format((int)229, (Object)t.getName()));
                }
                this.validateColumnType(index, column);
            }
            ++i;
        }
    }

    protected boolean columnMustBeUnique() {
        return true;
    }

    protected void checkDefinitionIsUnique(Index index) throws ValidationException {
        IndexObject[] indexColExprs = index.getColumnExpressions();
        Table indexTable = index.getTable();
        Index[] indexes = indexTable.getIndexes();
        IndexObjectComparator ioComparator = new IndexObjectComparator();
        Object indexid = DBUtil.getOriginalID((DBObject)index);
        boolean compareName = indexid instanceof String;
        String indexName = index.getName();
        int j = 0;
        while (j < indexes.length) {
            IndexObject[] cffColExprs;
            Object indexjid = DBUtil.getOriginalID((DBObject)indexes[j]);
            String indexjName = indexes[j].getName();
            boolean nameSame = ModelUtil.areEqual((Object)indexName, (Object)indexjName);
            if (!((compareName |= indexjid instanceof String) && nameSame || !compareName && indexjid.equals(indexid) || indexColExprs.length != (cffColExprs = indexes[j].getColumnExpressions()).length)) {
                boolean iosAreDifferent = false;
                int i = 0;
                while (i < indexColExprs.length) {
                    if (ioComparator.compare(indexColExprs[i], cffColExprs[i]) != 0) {
                        iosAreDifferent = true;
                        break;
                    }
                    ++i;
                }
                if (!iosAreDifferent) {
                    throw new ValidationException((DBObject)index, DBArb.format((int)275, (Object)index.getName(), (Object)indexes[j].getName()));
                }
            }
            ++j;
        }
    }

    protected void checkInavildFunctions(Index index) throws ValidationException {
    }

    protected void checkBitmapIndexOnIOT(Index index) throws ValidationException {
    }
}

