/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.validators.AbstractSchemaObjectValidator;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationValidator
extends AbstractSchemaObjectValidator {
    protected static Map s_postfixes = new HashMap();

    public RelationValidator(DBObjectProvider prov) {
        super(prov);
    }

    @AbstractValidator.PropertyValidator(value={Property.constraints})
    public void validateConstraints(Relation original, Relation updated) throws ValidationException {
        Constraint[] originalConstraints = original == null ? null : original.getConstraints();
        Constraint[] cons = updated.getConstraints();
        ConstraintValidator.validateOnePK(cons);
        int i = 0;
        while (i < cons.length) {
            Constraint con = cons[i];
            String cname = con.getName();
            if (cname == null) {
                if (this.createConstraintNameIfNone()) {
                    String newName = this.makeConstraintName(con, updated);
                    newName = this.enforceChildNameUniqueInSchema((DBObject)con) ? this.getProvider().getUniqueName(con.getConstraintType(), (DBObject)DBUtil.getSchema((DBObject)con), newName) : this.getProvider().getUniqueName(con.getConstraintType(), (DBObject)con.getRelation(), newName);
                    con.setName(newName);
                } else {
                    throw new NameInUseException((DBObject)con);
                }
            }
            DBObjectID id = cons[i].getID();
            while (id != null && id instanceof TemporaryObjectID) {
                try {
                    DBObject originalObject = ((TemporaryObjectID)id).resolveOriginalID();
                    id = originalObject == null ? null : originalObject.getID();
                }
                catch (Exception e) {
                    DBLog.logStackTrace((Throwable)e);
                }
            }
            Constraint originalConstraint = null;
            if (id != null && originalConstraints != null) {
                int j = 0;
                while (j < originalConstraints.length) {
                    if (ModelUtil.areEqual((Object)id, (Object)originalConstraints[j].getID())) {
                        originalConstraint = originalConstraints[j];
                        break;
                    }
                    ++j;
                }
            }
            if (originalConstraint == null) {
                this.getProvider().validateObject((DBObject)con);
            } else {
                this.getProvider().validateObject(originalConstraint, (DBObject)con);
            }
            ++i;
        }
        if (original != null) {
            this.validateReferences();
        }
    }

    protected void validateReferences() throws ValidationException {
    }

    protected String makeConstraintName(Constraint con, Relation parent) {
        String base = parent.getName();
        String consType = con.getConstraintType();
        String postfix = (String)s_postfixes.get(consType);
        int maxlen = 30 - postfix.length() - 2;
        if (base.length() > maxlen) {
            base = base.substring(0, maxlen);
        }
        return base + postfix;
    }

    private void addConstraintNames(Set names, Relation rel) throws ValidationException {
        Constraint[] cs = rel.getConstraints();
        int k = 0;
        while (k < cs.length) {
            this.addConstraintName(names, cs[k]);
            ++k;
        }
    }

    private void addConstraintName(Set names, Constraint con) throws ValidationException {
        String name = con.getName();
        if (name != null) {
            if (names.contains(name)) {
                throw new InvalidNameException((DBObject)con, DBArb.format((int)165, (Object)name, (Object)"CONSTRAINT"));
            }
            names.add(name);
        }
    }

    protected boolean createConstraintNameIfNone() {
        return true;
    }

    @AbstractValidator.PropertyValidator(value={Property.columns})
    public void validateColumns(Relation original, Relation updated) throws ValidationException {
        Object[] cols = updated.getColumns();
        if (this.enforceOneColumnExists(original == null) && !ModelUtil.hasNonNullElement((Object[])cols)) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)272, (Object)updated.getName()), DBArb.getString((int)377));
        }
        int i = 0;
        while (i < cols.length) {
            if (!(cols[i] instanceof ViewColumn) || !((ViewColumn)cols[i]).isAsterisk()) {
                this.getProvider().validateObject((DBObject)cols[i]);
            }
            ++i;
        }
        RelationValidator.validateUniqueNames((DBObject[])cols);
    }

    protected boolean enforceOneColumnExists(boolean creating) {
        return this.getProvider() instanceof Database;
    }

    @Override
    public void validateObjectProperty(DBObject original, DBObject updated, Object prop) throws ValidationException {
        prop = this.upgradeLegacyProperty(prop);
        super.validateObjectProperty(original, updated, prop);
    }

    private final Object upgradeLegacyProperty(Object prop) {
        if ("COLUMN".equals(prop)) {
            return Property.columns;
        }
        if ("CONSTRAINT".equals(prop)) {
            return Property.constraints;
        }
        if ("INDEX".equals(prop)) {
            return Property.indexes;
        }
        return prop;
    }

    static {
        s_postfixes.put("PKConstraint", "_PK");
        s_postfixes.put("UniqueConstraint", "_UK");
        s_postfixes.put("FKConstraint", "_FK");
        s_postfixes.put("CheckConstraint", "_CHK");
    }
}

