/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.db.validators.RelationValidator;
import oracle.javatools.util.ModelUtil;

public class TableValidator
extends RelationValidator {
    public TableValidator(DBObjectProvider prov) {
        super(prov);
    }

    @AbstractValidator.PropertyValidator(value={Property.indexes})
    public void validateIndexes(Table original, Table updated) throws ValidationException {
        Index[] originalIndexes = original == null ? null : original.getIndexes();
        Index[] indexes = updated.getIndexes();
        int i = 0;
        while (i < indexes.length) {
            DBObjectID id = indexes[i].getID();
            while (id != null && id instanceof TemporaryObjectID) {
                try {
                    DBObject originalObject = ((TemporaryObjectID)id).resolveOriginalID();
                    id = originalObject == null ? null : originalObject.getID();
                }
                catch (Exception e) {
                    DBLog.logStackTrace((Throwable)e);
                }
            }
            Index originalIndex = null;
            if (id != null && originalIndexes != null) {
                int j = 0;
                while (j < originalIndexes.length) {
                    if (ModelUtil.areEqual((Object)id, (Object)originalIndexes[j].getID())) {
                        originalIndex = originalIndexes[j];
                        break;
                    }
                    ++j;
                }
            }
            if (originalIndex == null) {
                this.getProvider().validateObject((DBObject)indexes[i]);
            } else {
                this.getProvider().validateObject(originalIndex, (DBObject)indexes[i]);
            }
            ++i;
        }
    }
}

