/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.text.MessageFormat;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.plsql.TriggerDeclarator;
import oracle.javatools.db.validators.AbstractSchemaObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerValidator
extends AbstractSchemaObjectValidator {
    private String m_errors;
    private boolean m_creatingTrigger;

    private void $init$() {
        this.m_errors = "";
    }

    public TriggerValidator(DBObjectProvider prov) {
        super(prov);
        this.$init$();
    }

    @Override
    public void validateObject(DBObject original, DBObject updated) throws ValidationException {
        this.m_creatingTrigger = original == null;
        super.validateObject(original, updated);
        if (updated instanceof Trigger) {
            this.validateTrigger((Trigger)updated);
        }
    }

    protected void validateTrigger(Trigger trg) throws ValidationException {
        Trigger.BaseType baseType = trg.getBaseType();
        DBObjectID[] columnIDs = trg.getColumnIDs();
        String[] events = trg.getEvents();
        Trigger.Timing timing = trg.getTiming();
        boolean statementLevel = trg.isStatementLevel();
        this.m_errors = "";
        TriggerDeclarator td = new TriggerDeclarator(this.getProvider());
        try {
            td.validateReferences(trg);
        }
        catch (ValidationException e) {
            this.throwOrLog(trg, e.getMessage());
        }
        if (baseType == null) {
            this.throwOrLog(trg, MessageFormat.format(DBArb.getString((int)380), null));
        }
        int i = 0;
        while (i < columnIDs.length) {
            int j = i + 1;
            while (j < columnIDs.length) {
                if (columnIDs[i].equals(columnIDs[j])) {
                    this.throwOrLog(trg, MessageFormat.format(DBArb.getString((int)274), DBUtil.getDBObjectName((DBObjectID)columnIDs[i])));
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (baseType == Trigger.BaseType.VIEW && timing != Trigger.Timing.INSTEAD_OF || baseType != Trigger.BaseType.VIEW && timing != Trigger.Timing.BEFORE && timing != Trigger.Timing.AFTER) {
            this.throwOrLog(trg, MessageFormat.format(DBArb.getString((int)62), null));
        }
        if (!(statementLevel || baseType != Trigger.BaseType.DATABASE && baseType != Trigger.BaseType.SCHEMA)) {
            this.throwOrLog(trg, MessageFormat.format(DBArb.getString((int)219), null));
        }
        String code = trg.getCode();
        String source = trg.getSource();
        code = code == null ? "" : code.trim();
        String string = source = source == null ? "" : source.trim();
        if (!source.endsWith(code)) {
            if (!this.m_creatingTrigger) {
                trg.setCode("");
                trg.setSource(trg.getSource());
            } else {
                this.throwOrLog(trg, MessageFormat.format(DBArb.getString((int)106), null));
            }
        }
        if (events.length == 0) {
            this.throwOrLog(trg, MessageFormat.format(DBArb.getString((int)215), null));
        }
        int i2 = 0;
        while (i2 < events.length) {
            boolean duplicate = false;
            int j = i2 + 1;
            while (j < events.length) {
                if (events[i2].equalsIgnoreCase(events[j])) {
                    this.throwOrLog(trg, MessageFormat.format(DBArb.getString((int)41), events[i2]));
                    duplicate = true;
                    break;
                }
                ++j;
            }
            if (baseType != null && !duplicate && !Trigger.getEvents((Trigger.BaseType)baseType, (Trigger.Timing)timing).contains(events[i2])) {
                this.throwOrLog(trg, MessageFormat.format(DBArb.getString((int)125), events[i2]));
            }
            ++i2;
        }
        if (!this.m_errors.equals("")) {
            throw new ValidationException((DBObject)trg, this.m_errors);
        }
    }

    private void throwOrLog(Trigger trg, String message) throws ValidationException {
        if (this.m_creatingTrigger) {
            throw new ValidationException((DBObject)trg, message);
        }
        this.m_errors = this.m_errors + message + "\n";
    }
}

