/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.ArrayList;
import oracle.javatools.db.Database;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeStackFrameInfo;

final class DebugProbeBackTrace {
    DebugProbe dp;
    int stackDepth;
    DebugProbeStackFrameInfo[] stackFrames;

    DebugProbeBackTrace(DebugProbe dp) {
        this.dp = dp;
    }

    void clear() {
        if (this.stackFrames != null) {
            int i = 0;
            while (i < this.stackDepth) {
                this.stackFrames[i].clear();
                ++i;
            }
        }
        this.stackDepth = 0;
        this.stackFrames = null;
    }

    static String code(int stackDepth, String varName) {
        StringBuffer sb = new StringBuffer();
        int f = 1;
        while (f <= stackDepth) {
            sb.append(DebugProbeStackFrameInfo.code(varName + "(" + f + ")"));
            ++f;
        }
        return sb.toString();
    }

    static int registerParameters(int stackDepth, CallableStatement cs, int index) throws Exception {
        int i = stackDepth - 1;
        while (i >= 0) {
            index = DebugProbeStackFrameInfo.registerParameters(cs, index);
            --i;
        }
        return index;
    }

    int getParameters(int stackDepth, CallableStatement cs, int index) throws Exception {
        ArrayList<DebugProbeStackFrameInfo> temp = new ArrayList<DebugProbeStackFrameInfo>();
        int f = 1;
        int i = stackDepth - 1;
        while (i >= 0) {
            DebugProbeStackFrameInfo stackFrame = new DebugProbeStackFrameInfo(this.dp, i, f);
            index = stackFrame.getParameters(cs, index);
            if (!stackFrame.location.isAnonymousBlock()) {
                temp.add(0, stackFrame);
            }
            ++f;
            --i;
        }
        this.stackDepth = stackDepth = temp.size();
        this.stackFrames = new DebugProbeStackFrameInfo[stackDepth];
        int i2 = 0;
        while (i2 < stackDepth) {
            this.stackFrames[i2] = (DebugProbeStackFrameInfo)temp.get(i2);
            this.stackFrames[i2].frameNumber = i2;
            ++i2;
        }
        return index;
    }

    String dump(String margin, String backTraceName) {
        StringBuffer sb = new StringBuffer();
        sb.append(margin);
        sb.append(backTraceName);
        sb.append("\n");
        int i = 0;
        while (i < this.stackDepth) {
            sb.append(this.stackFrames[i].dump(margin + "  ", "stackFrames[" + i + "]"));
            ++i;
        }
        return sb.toString();
    }

    void fill(Database db, int stackDepth) {
        if (this.stackFrames == null && this.dp.checkVersion(2, 1) && stackDepth > 0) {
            try {
                Connection c = db.getConnection();
                StringBuffer sb = new StringBuffer();
                sb.append("DECLARE\n");
                sb.append("  backtrace   DBMS_DEBUG.backtrace_table;\n");
                sb.append("begin\n");
                sb.append("  DBMS_DEBUG.print_backtrace(backtrace);\n");
                sb.append(DebugProbeBackTrace.code(stackDepth, "backtrace"));
                sb.append("end; ");
                String s = sb.toString();
                CallableStatement cs = c.prepareCall(s);
                try {
                    DebugProbeBackTrace.registerParameters(stackDepth, cs, 1);
                    cs.execute();
                    this.getParameters(stackDepth, cs, 1);
                }
                finally {
                    cs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    DebugProbeStackFrameInfo[] listStack() {
        return this.stackFrames;
    }

    int getStackFrameCount() {
        return this.stackDepth;
    }

    DebugProbeStackFrameInfo getStackFrame(int frame) {
        if (frame < this.stackDepth) {
            return this.stackFrames[frame];
        }
        return null;
    }
}

