/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeBreakpoint;
import oracle.jdevimpl.debugger.probe.DebugProbeRuntimeInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeThreadInfo;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;

final class DebugProbeBreakpointException
extends DebugProbeBreakpoint
implements DebugBreakpointException {
    String exception;
    boolean caught;
    boolean uncaught;

    DebugProbeBreakpointException(DebugProbe dp, String exception, boolean caught, boolean uncaught) {
        super(dp);
        this.exception = exception;
        this.caught = caught;
        this.uncaught = uncaught;
    }

    public String getExceptionClassname() {
        return this.exception;
    }

    public boolean getCaught() {
        return this.caught;
    }

    public boolean getUncaught() {
        return this.uncaught;
    }

    public void setExceptionClassname(String exception) {
        this.setExceptionClassname(exception, true, true);
    }

    public void setExceptionClassname(String exception, boolean caught, boolean uncaught) {
        this.prepareForChange();
        this.exception = exception;
        this.caught = caught;
        this.uncaught = uncaught;
        if (this.dp != null) {
            this.dp.putBreakpoint(this);
        }
    }

    boolean isThisYourEvent(DebugProbeRuntimeInfo runtimeInfo, DebugProbeThreadInfo thread) {
        if (runtimeInfo.reason == 11) {
            boolean exceptionMatches = false;
            if (runtimeInfo.isOerSupported() && runtimeInfo.oer != 0) {
                if (this.exception.equals("java.lang.Throwable") || this.exception.equals("$Oracle.Builtin.EXCEPTION") || this.exception.equals("$Oracle.Builtin.EXCEPTION_ORA")) {
                    exceptionMatches = true;
                } else {
                    String prefix = "$Oracle.EXCEPTION_ORA_";
                    if (this.exception.startsWith("$Oracle.EXCEPTION_ORA_")) {
                        try {
                            int oer = Integer.parseInt(this.exception.substring("$Oracle.EXCEPTION_ORA_".length()));
                            if (oer == 0 || oer == runtimeInfo.oer) {
                                exceptionMatches = true;
                            }
                        }
                        catch (Exception e) {
                            exceptionMatches = true;
                        }
                    }
                }
            } else {
                exceptionMatches = true;
            }
            if (exceptionMatches) {
                return super.isThisYourEvent(runtimeInfo, thread);
            }
        }
        return false;
    }
}

