/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeBreakpoint;
import oracle.jdevimpl.debugger.probe.DebugProbeLocation;
import oracle.jdevimpl.debugger.probe.DebugProbeRuntimeInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeThreadInfo;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.support.DebugLocation;

final class DebugProbeBreakpointPackageFileLine
extends DebugProbeBreakpoint
implements DebugBreakpointPackageFileLine {
    String pkg;
    String filename;
    int line;
    int bn;
    DebugProbeLocation location;

    DebugProbeBreakpointPackageFileLine(DebugProbe dp, String pkg, String filename, int line) {
        super(dp);
        this.pkg = pkg;
        this.filename = filename;
        this.line = line;
        this.bn = -1;
    }

    public String getPackage() {
        return this.pkg;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public void setPackageFileLine(String pkg, String filename, int line) {
        this.prepareForChange();
        this.pkg = pkg;
        this.filename = filename;
        this.line = line;
        if (this.dp != null) {
            this.dp.putBreakpoint(this);
        }
    }

    public void setFileLine(String filename, int line) {
    }

    public void setEnabled(boolean enabled) {
        if (this.getEnabled() != enabled) {
            super.setEnabled(enabled);
            if (this.bn != -1) {
                if (enabled) {
                    this.dp.callEnableBreakpoint(this.bn);
                } else {
                    this.dp.callDisableBreakpoint(this.bn);
                }
            }
        }
    }

    public DebugLocation[] getLocations() {
        if (this.bn != -1 && this.location != null) {
            DebugLocation[] locations = new DebugLocation[]{this.location};
            return locations;
        }
        return super.getLocations();
    }

    void prepareForChange() {
        super.prepareForChange();
        if (this.bn != -1) {
            this.dp.callDeleteBreakpoint(this.bn);
            this.bn = -1;
            this.location = null;
        }
    }

    void verified(int bn, DebugProbeLocation location) {
        this.bn = bn;
        this.location = location;
    }

    boolean isThisYourEvent(DebugProbeRuntimeInfo runtimeInfo, DebugProbeThreadInfo thread) {
        if (runtimeInfo.reason == 3 && runtimeInfo.breakpoint == this.bn) {
            return super.isThisYourEvent(runtimeInfo, thread);
        }
        return false;
    }
}

