/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeArrayElementInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeClassInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeDataCompositeInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeValue;
import oracle.jdevimpl.debugger.probe.DebugProbeVariableContainer;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;

final class DebugProbeDataArrayInfo
extends DebugProbeDataCompositeInfo
implements DebugDataArrayInfo {
    private String elementType;
    private Map cachedNonNullArrayElements;
    private List cachedNullArrayElements;

    DebugProbeDataArrayInfo(DebugProbe dp, DebugProbeClassInfo classInfo, DebugProbeValue dpv, Object owner) {
        super(dp, classInfo, dpv, owner);
        this.figureOutElementType();
        this.cachedNonNullArrayElements = new HashMap();
        this.cachedNullArrayElements = new ArrayList();
    }

    private void figureOutElementType() {
        Object root = DebugProbe.findDataRoot(this.owner, null);
        if (root instanceof DebugProbeVariableContainer) {
            String typeDefinition;
            DebugProbeVariableContainer variableContainer = (DebugProbeVariableContainer)root;
            String type = this.dpv.getType();
            if (type != null && (typeDefinition = variableContainer.getTypeDefinition(type)) != null) {
                this.elementType = DebugProbeDataArrayInfo.getTableElementType(typeDefinition);
            }
        }
    }

    static String isTableElementName(String name) {
        int secondCloseParen;
        int secondOpenParen;
        int firstCloseParen;
        int firstOpenParen = name.indexOf("(");
        if (firstOpenParen != -1 && (firstCloseParen = name.indexOf(")")) != -1 && firstCloseParen > firstOpenParen && (secondOpenParen = name.indexOf("(", firstOpenParen + 1)) == -1 && (secondCloseParen = name.indexOf(")", firstCloseParen + 1)) == -1) {
            return name.substring(0, firstOpenParen);
        }
        return null;
    }

    static String getTableElementType(String tableType) {
        StringTokenizer st = new StringTokenizer(tableType);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equalsIgnoreCase("OF")) continue;
            if (!st.hasMoreTokens()) break;
            return st.nextToken();
        }
        return null;
    }

    public DebugClassInfo getArrayElementClassInfo() {
        return this.dp.unknownClass;
    }

    public int getArrayStart() {
        return 1;
    }

    public int getArrayCount() {
        return this.getArrayCount(false);
    }

    public DebugArrayElementInfo[] getArrayElements() {
        return this.getArrayElements(1, -1, false);
    }

    public DebugArrayElementInfo[] getArrayElements(int start, int count) {
        return this.getArrayElements(start, count, false);
    }

    public int getArrayCount(boolean nonNullCompositesOnly) {
        this.throwIfExpired();
        return -1;
    }

    public DebugArrayElementInfo[] getArrayElements(boolean nonNullCompositesOnly) {
        this.throwIfExpired();
        return new DebugArrayElementInfo[0];
    }

    public DebugArrayElementInfo[] getArrayElements(int start, int count, boolean nonNullCompositesOnly) {
        this.throwIfExpired();
        if (count != -1) {
            ArrayList<DebugProbeArrayElementInfo> temp = new ArrayList<DebugProbeArrayElementInfo>();
            int i = start;
            while (i < start + count) {
                Integer key = new Integer(i);
                DebugProbeArrayElementInfo element = (DebugProbeArrayElementInfo)this.cachedNonNullArrayElements.get(key);
                if (element == null && !this.cachedNullArrayElements.contains(key)) {
                    element = this.dp.getArrayElement(this, i, this.elementType);
                    if (element == null) {
                        this.cachedNullArrayElements.add(key);
                    } else {
                        this.cachedNonNullArrayElements.put(key, element);
                    }
                }
                if (element != null) {
                    temp.add(element);
                }
                ++i;
            }
            return temp.toArray(new DebugProbeArrayElementInfo[temp.size()]);
        }
        return new DebugArrayElementInfo[0];
    }

    public boolean equals(Object o) {
        if (o instanceof DebugProbeDataArrayInfo) {
            return super.equals(o);
        }
        return false;
    }
}

