/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeClassInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeValue;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

class DebugProbeDataInfo
implements DebugDataInfo {
    DebugProbe dp;
    DebugProbeClassInfo classInfo;
    DebugProbeValue dpv;
    Object owner;
    int stoppedCount;

    DebugProbeDataInfo(DebugProbe dp, DebugProbeClassInfo classInfo, DebugProbeValue dpv, Object owner) {
        this.dp = dp;
        this.classInfo = classInfo;
        this.dpv = dpv;
        this.owner = owner;
        this.stoppedCount = dp.stoppedCount;
    }

    public DebugVirtualMachine getVM() {
        return this.dp;
    }

    public boolean hasExpired() {
        return this.dp.stoppedCount != this.stoppedCount;
    }

    protected void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Data has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        return this.classInfo;
    }

    public String getValue() {
        return this.dpv.getValue();
    }

    public String getHexValue() {
        try {
            String s = this.dpv.getValue();
            long l = Long.parseLong(s);
            String string = Long.toHexString(l);
            return string;
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean canModifyDataWithString() {
        return this.dpv.canModify();
    }

    public boolean modifyDataWithString(String newValue) {
        DebugProbeValue modified;
        if (this.dpv.canModify() && (modified = this.dp.modifyData(this, this.dpv.getType(), newValue)) != null) {
            this.dpv = modified;
            return true;
        }
        return false;
    }

    public boolean canModifyDataWithData() {
        return this.canModifyDataWithString();
    }

    public boolean modifyDataWithData(DebugDataInfo newValue) {
        return this.modifyDataWithString(newValue.getValue());
    }

    public boolean canModifyDataWithNewObject() {
        return false;
    }

    public boolean modifyDataWithNewObject(DebugMethodInfo method, String[] arguments) {
        return false;
    }

    public int hashCode() {
        return this.classInfo.hashCode() + this.dpv.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DebugProbeDataInfo) {
            DebugProbeDataInfo other = (DebugProbeDataInfo)o;
            return ModelUtil.areEqual((Object)this.dp, (Object)other.dp) && ModelUtil.areEqual((Object)this.classInfo, (Object)other.classInfo) && ModelUtil.areEqual((Object)this.dpv, (Object)other.dpv);
        }
        return false;
    }
}

