/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.util.List;
import oracle.ide.model.Project;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeClassInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeLocation;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDisassembleInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

final class DebugProbeMethodInfo
implements DebugMethodInfo {
    DebugProbe dp;
    DebugProbeClassInfo classInfo;
    String piEntryPointName;
    String name;

    DebugProbeMethodInfo(DebugProbe dp, DebugProbeClassInfo classInfo, String piEntryPointName) {
        this.dp = dp;
        this.classInfo = classInfo;
        this.piEntryPointName = piEntryPointName;
        this.name = DebugProbeMethodInfo.makeMethodName(classInfo, piEntryPointName);
    }

    public DebugVirtualMachine getVM() {
        return this.dp;
    }

    public boolean hasExpired() {
        return this.classInfo.hasExpired();
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Method has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        return this.classInfo;
    }

    public boolean isCompiled() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithoutClass() {
        return DebugShared.getNameWithoutClass((String)this.name);
    }

    public String getNameWithoutSignature() {
        return DebugShared.getNameWithoutSignature((String)this.name);
    }

    public String getNameWithoutClassOrSignature() {
        return DebugShared.getNameWithoutClassOrSignature((String)this.name);
    }

    public String getParameterSignature() {
        return DebugShared.getMethodParameterSignature((String)this.name);
    }

    public int getAccess() {
        return 0;
    }

    public int[] getMethodLineRange() {
        int[] lines = new int[]{0, 0};
        return lines;
    }

    public int[] getMethodLines() {
        return new int[0];
    }

    public int[] getCodeCoverage() {
        return new int[0];
    }

    public double getCodeCoverageRatio() {
        return 0.0;
    }

    public DebugLocation getFirstLocation() {
        return this.getLocation(this.classInfo.getSourceFilename(), 1);
    }

    public DebugLocation getLocation(String filename, int line) {
        this.throwIfExpired();
        if (ModelUtil.areEqual((Object)filename, (Object)this.classInfo.getSourceFilename())) {
            return new DebugProbeLocation(this.dp, this.classInfo, line, this.piEntryPointName);
        }
        return null;
    }

    public DebugDisassembleInfo[] disassembleMethod(boolean java, boolean bytecode, boolean assembly, Project project) {
        return new DebugDisassembleInfo[0];
    }

    public boolean hasMethodChanged() {
        return false;
    }

    public byte[] getBytecodes() {
        return new byte[0];
    }

    public byte getBytecode(int offset) {
        return 0;
    }

    public DebugDataInfo invoke(List arguments) {
        return null;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DebugProbeMethodInfo) {
            DebugProbeMethodInfo other = (DebugProbeMethodInfo)o;
            return ModelUtil.areEqual((Object)this.dp, (Object)other.dp) && ModelUtil.areEqual((Object)this.name, (Object)other.name);
        }
        return false;
    }

    static String makeMethodName(DebugProbeClassInfo classInfo, String piEntryPointName) {
        String s = " " + classInfo.name + "." + piEntryPointName + "()";
        return s;
    }
}

