/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.sql.CallableStatement;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.plsql.old.PlsqlParser;
import oracle.javatools.parser.plsql.old.symbol.CodeBlockSymbol;
import oracle.javatools.parser.plsql.old.symbol.CompoundStatement;
import oracle.javatools.parser.plsql.old.symbol.FunctionSymbol;
import oracle.javatools.parser.plsql.old.symbol.NameSymbol;
import oracle.javatools.parser.plsql.old.symbol.PackageSymbol;
import oracle.javatools.parser.plsql.old.symbol.RootSymbol;
import oracle.javatools.parser.plsql.old.symbol.Statement;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeDataArrayInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeLocation;
import oracle.jdevimpl.debugger.probe.DebugProbeValue;
import oracle.jdevimpl.debugger.probe.DebugProbeVariableContainer;
import oracle.jdevimpl.debugger.probe.DebugProbeVariableInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

final class DebugProbeStackFrameInfo
extends DebugProbeVariableContainer
implements DebugStackFrameInfo {
    DebugProbe dp;
    boolean expired;
    int frameNumber;
    int probeFrameNumber;
    DebugProbeLocation location;
    private DebugProbeVariableInfo[] arguments;
    private DebugProbeVariableInfo[] locals;
    private String _sourceCode;
    private int _locationOffset;

    DebugProbeStackFrameInfo(DebugProbe dp, int frameNumber, int probeFrameNumber) {
        this.$init$();
        this.dp = dp;
        this.frameNumber = frameNumber;
        this.probeFrameNumber = probeFrameNumber;
    }

    public boolean hasExpired() {
        return this.expired;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public DebugLocation getLocation() {
        return this.location;
    }

    public DebugVariableInfo[] listArguments() {
        this.lookForVariables();
        return this.arguments;
    }

    public DebugVariableInfo[] listLocals() {
        this.lookForVariables();
        return this.locals;
    }

    public DebugVariableInfo getVariable(String name) {
        DebugProbeValue dpv = this.dp.getVariableValue(this, name, null);
        if (dpv != null) {
            String type = this.figureOutVariableType(name);
            if (type != null) {
                dpv.setType(type);
            }
            return new DebugProbeVariableInfo(this.dp, this, name, dpv, false, false);
        }
        return null;
    }

    public DebugStackSlotInfo[] listSlots() {
        return new DebugStackSlotInfo[0];
    }

    public int getLanguage() {
        return 2;
    }

    public boolean popBackToHere() {
        return false;
    }

    void clear() {
        this.expired = true;
    }

    static String code(String varName) {
        StringBuffer sb = new StringBuffer();
        sb.append("  ? := " + varName + ".LibunitType;\n");
        sb.append("  ? := " + varName + ".Owner;\n");
        sb.append("  ? := " + varName + ".Name;\n");
        sb.append("  ? := " + varName + ".Line#;\n");
        sb.append("  ? := " + varName + ".EntrypointName;\n");
        return sb.toString();
    }

    static int registerParameters(CallableStatement cs, int index) throws Exception {
        cs.registerOutParameter(index++, 4);
        cs.registerOutParameter(index++, 12);
        cs.registerOutParameter(index++, 12);
        cs.registerOutParameter(index++, 4);
        cs.registerOutParameter(index++, 12);
        return index;
    }

    int getParameters(CallableStatement cs, int index) throws Exception {
        int piLibunitType = cs.getInt(index++);
        String piOwner = cs.getString(index++);
        String piName = cs.getString(index++);
        int piLineNumber = cs.getInt(index++);
        String piEntryPointName = cs.getString(index++);
        this.location = new DebugProbeLocation(this.dp, piLibunitType, piOwner, piName, piLineNumber, piEntryPointName);
        return index;
    }

    String dump(String margin, String stackFrameInfoName) {
        StringBuffer sb = new StringBuffer();
        sb.append(margin);
        sb.append(stackFrameInfoName);
        sb.append("\n");
        sb.append(margin);
        sb.append("  libunitType:    ");
        sb.append(this.location.piLibunitType);
        sb.append("\n");
        sb.append(margin);
        sb.append("  owner:          ");
        sb.append(this.location.piOwner);
        sb.append("\n");
        sb.append(margin);
        sb.append("  name:           ");
        sb.append(this.location.piName);
        sb.append("\n");
        sb.append(margin);
        sb.append("  lineNumber:     ");
        sb.append(this.location.piLineNumber);
        sb.append("\n");
        sb.append(margin);
        sb.append("  entryPointName: ");
        sb.append(this.location.piEntryPointName);
        sb.append("\n");
        return sb.toString();
    }

    private String getSourceCode() {
        if (this._sourceCode == null) {
            this._sourceCode = this.dp.callShowFrameSource(this);
        }
        return this._sourceCode;
    }

    private void $init$() {
        this._locationOffset = -1;
    }

    private int getLocationOffset() {
        String sourceCode;
        if (this._locationOffset == -1 && this.location != null && this.location.piLineNumber > 0 && (sourceCode = this.getSourceCode()) != null) {
            int lineNumber = 1;
            int offset = 0;
            while (true) {
                if (this.location.piLineNumber == lineNumber) {
                    this._locationOffset = offset;
                    break;
                }
                if ((offset = sourceCode.indexOf("\n", offset)) == -1) break;
                ++offset;
                ++lineNumber;
            }
        }
        return this._locationOffset;
    }

    private void lookForVariables() {
        if (this.arguments == null || this.locals == null) {
            ArrayList listOfArguments;
            ArrayList listOfLocals;
            block5: {
                ArrayList listOfVariableNames = new ArrayList();
                listOfLocals = new ArrayList();
                listOfArguments = new ArrayList();
                String sourceCode = this.getSourceCode();
                if (sourceCode != null) {
                    int locationOffset = this.getLocationOffset();
                    try {
                        ReadTextBuffer buffer = TextBufferFactory.createReadTextBuffer((String)sourceCode);
                        RootSymbol rs = PlsqlParser.parse((ReadTextBuffer)buffer);
                        if (rs != null) {
                            this.processPackages(rs.getPackages(), locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
                            this.processFunctions(rs.getFunctions(), locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
                        }
                    }
                    catch (Throwable e) {
                        Assert.println((String)("exception during parsing: " + e));
                        if (!(e instanceof ThreadDeath)) break block5;
                        throw (ThreadDeath)e;
                    }
                }
            }
            this.arguments = listOfArguments.toArray(new DebugProbeVariableInfo[listOfArguments.size()]);
            this.locals = listOfLocals.toArray(new DebugProbeVariableInfo[listOfLocals.size()]);
        }
    }

    private void processPackages(PackageSymbol[] packages, int locationOffset, List listOfVariableNames, List listOfLocals, List listOfArguments) {
        if (packages != null) {
            int packagesLength = packages.length;
            int i = 0;
            while (i < packagesLength) {
                PackageSymbol pakkage = packages[i];
                if (locationOffset >= pakkage.getStartOffset() && locationOffset < pakkage.getEndOffset()) {
                    this.processFunctions(pakkage.getFunctions(), locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
                }
                ++i;
            }
        }
    }

    private void processFunctions(FunctionSymbol[] functions, int locationOffset, List listOfVariableNames, List listOfLocals, List listOfArguments) {
        if (functions != null) {
            int functionsLength = functions.length;
            int i = 0;
            while (i < functionsLength) {
                FunctionSymbol function = functions[i];
                if (locationOffset >= function.getStartOffset() && locationOffset < function.getEndOffset()) {
                    this.processCodeBlock((CodeBlockSymbol)function, locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
                    this.processVariables(function.getParameters(), listOfVariableNames, listOfArguments);
                }
                ++i;
            }
        }
    }

    private void processCodeBlock(CodeBlockSymbol codeBlock, int locationOffset, List listOfVariableNames, List listOfLocals, List listOfArguments) {
        this.processFunctions(codeBlock.getFunctions(), locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
        this.processStatements(codeBlock.getStatements(), locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
        this.processTypes(codeBlock.getTypes());
        this.processVariables(codeBlock.getVariables(), listOfVariableNames, listOfLocals);
    }

    private void processStatements(Statement[] statements, int locationOffset, List listOfVariableNames, List listOfLocals, List listOfArguments) {
        if (statements != null) {
            int statementsLength = statements.length;
            int i = 0;
            while (i < statementsLength) {
                Statement statement = statements[i];
                if (locationOffset >= statement.getStartOffset() && locationOffset < statement.getEndOffset()) {
                    NameSymbol nameSymbol;
                    CodeBlockSymbol codeBlock;
                    if (statement instanceof CompoundStatement) {
                        CompoundStatement compoundStatement = (CompoundStatement)statement;
                        this.processStatements(compoundStatement.getClauses(), locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
                    }
                    if ((codeBlock = statement.getBlock()) != null && locationOffset >= codeBlock.getStartOffset() && locationOffset < codeBlock.getEndOffset()) {
                        this.processCodeBlock(codeBlock, locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
                    }
                    if (statement instanceof CompoundStatement && (nameSymbol = ((CompoundStatement)statement).getVariableName()) != null) {
                        String name = nameSymbol.getValue();
                        this.processVariable(name, null, listOfVariableNames, listOfLocals);
                    }
                }
                ++i;
            }
        }
    }

    private String figureOutVariableType(String name) {
        String type = null;
        boolean tableElement = false;
        String baseName = name;
        String tableName = DebugProbeDataArrayInfo.isTableElementName(name);
        if (tableName != null) {
            baseName = tableName;
            tableElement = true;
        }
        this.lookForVariables();
        DebugProbeVariableInfo var = DebugProbeStackFrameInfo.lookForVariableNamed(baseName, this.arguments);
        if (var == null) {
            var = DebugProbeStackFrameInfo.lookForVariableNamed(baseName, this.locals);
        }
        if (var != null) {
            type = var.dpv.getType();
            String typeDefinition = this.getTypeDefinition(type);
            if (typeDefinition != null) {
                type = typeDefinition;
            }
            if (tableElement) {
                type = DebugProbeDataArrayInfo.getTableElementType(type);
            }
        }
        return type;
    }

    private static DebugProbeVariableInfo lookForVariableNamed(String name, DebugProbeVariableInfo[] vars) {
        if (name != null) {
            int i = vars.length - 1;
            while (i >= 0) {
                if (name.equalsIgnoreCase(vars[i].name)) {
                    return vars[i];
                }
                --i;
            }
        }
        return null;
    }

    protected Object getVariable(String name, String type) {
        DebugProbeValue dpv = this.dp.getVariableValue(this, name, type);
        if (dpv != null) {
            return new DebugProbeVariableInfo(this.dp, this, name, dpv, false, false);
        }
        return null;
    }

    void clearCachedData() {
        this.arguments = null;
        this.locals = null;
    }
}

