/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import oracle.ide.util.ModelUtil;

class DebugProbeValue {
    private int result;
    private String value;
    private String type;

    DebugProbeValue(int result, String value, String type) {
        switch (result) {
            case 0: {
                if (type == null || !type.toUpperCase().startsWith("VARCHAR")) break;
                value = "'" + value + "'";
                break;
            }
            case 32: {
                value = "NULL";
                break;
            }
            case 18: {
                value = "";
                break;
            }
        }
        this.result = result;
        this.value = value;
        this.type = type;
    }

    int getResult() {
        return this.result;
    }

    boolean isArray() {
        return this.result == 18;
    }

    String getValue() {
        return this.value;
    }

    String getType() {
        return this.type;
    }

    void setType(String type) {
        if (this.type == null) {
            this.type = type;
            if (type != null && type.toUpperCase().startsWith("VARCHAR")) {
                this.value = "'" + this.value + "'";
            }
        }
    }

    boolean isNull() {
        return this.result == 32;
    }

    boolean canModify() {
        return this.result == 0 || this.result == 32;
    }

    public int hashCode() {
        return this.result + this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DebugProbeValue) {
            DebugProbeValue other = (DebugProbeValue)o;
            return this.result == other.result && ModelUtil.areEqual((Object)this.value, (Object)other.value);
        }
        return false;
    }
}

