/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controls.StatusBar;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.AbstractClickPlugin;
import oracle.javatools.util.PlatformUtils;

public abstract class AbstractBrowseClickPlugin
extends AbstractClickPlugin {
    protected static final int ACTION_DECLARATION = 1;
    protected String _lastStatusText;
    private static HighlightStyle _declarationStyle;
    private static String _declarationText;
    private static final int MODIFIER_DECLARATION;

    protected int getActionTypeFor(MouseEvent event) {
        int ret = -1;
        if (this.hasModifierEx(event, MODIFIER_DECLARATION) && SwingUtilities.isLeftMouseButton(event) && !event.isPopupTrigger() && event.getID() == 500) {
            ret = 1;
        } else if (this.hasModifierEx(event, MODIFIER_DECLARATION) && event.getID() == 503) {
            ret = 1;
        } else if (2 == event.getButton() && 500 == event.getID() && (PlatformUtils.isWindows() || PlatformUtils.isMac())) {
            ret = 1;
            BasicEditorPane editorPane = this.getEditorPane();
            Point point = event.getPoint();
            int pos = editorPane.viewToModel(point);
            editorPane.setCaretPosition(pos);
        }
        return ret;
    }

    protected void handleClickAction(Point clickPoint, int actionType) {
        if (actionType == 1) {
            this.performDeclarationClick(clickPoint);
        }
    }

    protected HighlightStyle getHighlightStyleFor(int actionType) {
        if (actionType == 1) {
            return _declarationStyle;
        }
        return null;
    }

    protected String getHintTextFor(int actionType) {
        if (actionType == 1) {
            return _declarationText;
        }
        return null;
    }

    protected NumberRange getRegionFor(int offset, int actionType) {
        if (actionType == 1) {
            return this.getIdentifierAtOffset(offset);
        }
        return null;
    }

    private void $init$() {
        this._lastStatusText = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateHint(int actionType) {
        String hintToUse;
        StatusBar statusBar = Ide.getStatusBar();
        String textToSet = null;
        if (actionType != -1 && (hintToUse = this.getHintTextFor(actionType)) != null) {
            textToSet = hintToUse;
        }
        if (textToSet != null) {
            AbstractBrowseClickPlugin abstractBrowseClickPlugin = this;
            synchronized (abstractBrowseClickPlugin) {
                this._lastStatusText = textToSet;
                statusBar.setText(this._lastStatusText);
            }
        }
        AbstractBrowseClickPlugin abstractBrowseClickPlugin = this;
        synchronized (abstractBrowseClickPlugin) {
            if (statusBar.getText() == this._lastStatusText) {
                statusBar.setText("");
            }
            this._lastStatusText = null;
        }
    }

    protected abstract void performDeclarationClick(Point var1);

    protected abstract NumberRange getIdentifierAtOffset(int var1);

    static {
        boolean MAC_OS_X = System.getProperty("os.name").indexOf("Mac OS X") != -1;
        MODIFIER_DECLARATION = MAC_OS_X ? 256 : 128;
        _declarationText = MAC_OS_X ? CEditorArb.getString(0) : CEditorArb.getString(30);
        AbstractBrowseClickPlugin.registerHighlights();
    }

    public static void registerHighlights() {
        String name = CEditorArb.getString(6);
        _declarationStyle = CodeEditor.createHighlightStyle("click-navigation", name, 70, Color.blue, null, 0, 0, Color.blue);
    }

    public AbstractBrowseClickPlugin() {
        this.$init$();
    }
}

