/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import javax.swing.UIManager;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.Assert;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.FileOverviewMark;

class CEFileOverviewMargin
extends FileOverviewMargin {
    private CodeEditor codeEditor;

    CEFileOverviewMargin(CodeEditor codeEditor) {
        this.codeEditor = codeEditor;
    }

    protected int getTopOffset() {
        return 5 + UIManager.getInt("ScrollBar.width") - 2;
    }

    protected int getBottomOffset() {
        return 1 + UIManager.getInt("ScrollBar.width") - 2;
    }

    protected void navigate(int line, FileOverviewMark mark) {
        try {
            int selectionLength;
            int selectionStart = mark.getSelectionStart();
            if (selectionStart >= 0) {
                selectionLength = mark.getSelectionLength();
            } else {
                selectionStart = this.codeEditor.getLineStartOffset(line);
                selectionLength = 0;
            }
            OffsetNavigationPoint point = new OffsetNavigationPoint(this.codeEditor.getContext(), selectionStart, selectionLength);
            NavigationManager.getNavigationManager().navigateTo((NavigationPoint)point);
            return;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            super.navigate(line, mark);
            return;
        }
    }
}

