/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.Border;

public final class CEScrollPaneLayout
extends ScrollPaneLayout {
    public void syncWithScrollPane(JScrollPane scrollPane) {
        super.syncWithScrollPane(scrollPane);
        this.ensureScrollBarsVisible(scrollPane);
    }

    private void ensureScrollBarsVisible(JScrollPane scrollPane) {
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        if (this.vsbPolicy != 22 || this.hsbPolicy != 32) {
            throw new IllegalStateException("LM requires visible SBs");
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Border border;
        JScrollPane scrollPane = (JScrollPane)parent;
        Insets insets = parent.getInsets();
        int preferredWidth = insets.left + insets.right;
        int preferredHeight = insets.top + insets.bottom;
        if (this.viewport != null) {
            Dimension viewExtents = this.viewport.getPreferredSize();
            preferredWidth += viewExtents.width;
            preferredHeight += viewExtents.height;
        }
        if ((border = scrollPane.getViewportBorder()) != null) {
            Insets borderInsets = border.getBorderInsets(parent);
            preferredWidth += borderInsets.left + borderInsets.right;
            preferredHeight += borderInsets.top + borderInsets.bottom;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            preferredWidth += this.rowHead.getPreferredSize().width;
        }
        if (this.vsb != null) {
            preferredWidth += this.vsb.getPreferredSize().width;
        }
        if (this.hsb != null) {
            preferredHeight += this.hsb.getPreferredSize().height;
        }
        return new Dimension(preferredWidth, preferredHeight);
    }

    public Dimension minimumLayoutSize(Container parent) {
        Border border;
        JScrollPane scrollPane = (JScrollPane)parent;
        Insets insets = parent.getInsets();
        int minWidth = insets.left + insets.right;
        int minHeight = insets.top + insets.bottom;
        if (this.viewport != null) {
            Dimension viewExtents = this.viewport.getMinimumSize();
            minWidth += viewExtents.width;
            minHeight += viewExtents.height;
        }
        if ((border = scrollPane.getViewportBorder()) != null) {
            Insets borderInsets = border.getBorderInsets(parent);
            minWidth += borderInsets.left + borderInsets.right;
            minHeight += borderInsets.top + borderInsets.bottom;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            Dimension headerSize = this.rowHead.getMinimumSize();
            minWidth += headerSize.width;
            minHeight = Math.max(minHeight, headerSize.height);
        }
        if (this.vsb != null) {
            Dimension vsbSize = this.vsb.getMinimumSize();
            minWidth += vsbSize.width;
            minHeight = Math.max(minHeight, vsbSize.height);
        }
        if (this.hsb != null) {
            Dimension hsbSize = this.hsb.getMinimumSize();
            minHeight += hsbSize.height;
            minWidth = Math.max(minWidth, hsbSize.width);
        }
        return new Dimension(minWidth, minHeight);
    }

    public void layoutContainer(Container parent) {
        JScrollPane scrollPane = (JScrollPane)parent;
        boolean leftToRight = scrollPane.getComponentOrientation().isLeftToRight();
        Rectangle scrollRect = scrollPane.getBounds();
        int spaceX = scrollRect.width;
        int spaceY = scrollRect.height;
        Insets insets = parent.getInsets();
        spaceX -= insets.left + insets.right;
        spaceY -= insets.top + insets.bottom;
        int rowWidth = 0;
        if (this.rowHead != null) {
            rowWidth = this.rowHead.getPreferredSize().width;
            spaceX -= rowWidth;
        }
        int vsbWidth = 0;
        int hsbHeight = 0;
        if (this.vsb != null) {
            vsbWidth = this.vsb.getPreferredSize().width;
            spaceX -= vsbWidth;
        }
        if (this.hsb != null) {
            hsbHeight = this.hsb.getPreferredSize().height;
            spaceY -= hsbHeight;
        }
        if (this.viewport != null) {
            int viewportLeft = insets.left + (leftToRight ? rowWidth : vsbWidth);
            Border border = scrollPane.getViewportBorder();
            if (border != null) {
                Insets borderInsets = border.getBorderInsets(parent);
                this.viewport.setBounds(viewportLeft + borderInsets.left, insets.top + borderInsets.top, spaceX - borderInsets.left - borderInsets.right, spaceY - borderInsets.top - borderInsets.bottom);
            } else {
                this.viewport.setBounds(viewportLeft, insets.top, spaceX, spaceY);
            }
        }
        if (this.rowHead != null) {
            int headerLeft = insets.left + (leftToRight ? 0 : vsbWidth + spaceX);
            this.rowHead.setBounds(headerLeft, insets.top, rowWidth, spaceY);
        }
        if (this.vsb != null) {
            int vsbLeft = insets.left + (leftToRight ? rowWidth + spaceX : 0);
            this.vsb.setBounds(vsbLeft, insets.top, vsbWidth, spaceY);
        }
        if (this.hsb != null) {
            int hsbTop = insets.top + spaceY;
            int hsbWidth = spaceX + rowWidth + vsbWidth;
            this.hsb.setBounds(insets.left, hsbTop, hsbWidth, hsbHeight);
        }
    }
}

