/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CEFileOverviewMargin;
import oracle.ide.ceditor.CEToolTipProvider;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.ceditor.CodeEditorController;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeEditorPluginsFactory;
import oracle.ide.ceditor.CodeEditorViewSelectionSetter;
import oracle.ide.ceditor.CursorListener;
import oracle.ide.ceditor.DropHandlerPlugin;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.ceditor.EditorStatusBar;
import oracle.ide.ceditor.NodeUpdater;
import oracle.ide.ceditor.UndoWrapperCommand;
import oracle.ide.ceditor.ViewSelectionHelper;
import oracle.ide.ceditor.ViewSelectionHelperFactory;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.editor.TextEditor;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.Helpable;
import oracle.ide.help.HelpableProvider;
import oracle.ide.layout.BaseLayoutListener;
import oracle.ide.layout.Layout;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.print.DocumentPrintFactory;
import oracle.ide.print.PrintManager;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.Assert;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.vcs.VCSManager;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dnd.DndUtils;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.EditorSelection;
import oracle.javatools.editor.EditorSelectionColumns;
import oracle.javatools.editor.EditorSelectionWrap;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.plugins.DragDropPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.editor.plugins.TrailingSpacePlugin;

public final class CodeEditor
extends Editor
implements CaretListener,
FindableEditor,
StatusProvider,
ToolTipProvider,
UndoableEditListener,
BaseLayoutListener,
PopupManager,
TextEditor,
PropertyChangeListener {
    public static final String EDITOR_CONTEXT = "editor-ide-context";
    private static final int DEFAULT_CURSOR_LISTENER_DELAY = 250;
    private Component _fixedBottomMargin;
    public static final String TYPE_PLAIN = "txt";
    public static final String TYPE_JAVA = "java";
    public static final String TYPE_SQL = "sql";
    public static final String TYPE_PLSQL = "plsql";
    public static final String TYPE_JSP = "jsp";
    public static final String TYPE_HTML = "html";
    public static final String TYPE_XML = "xml";
    public static final String TYPE_PROPERTIES = "properties";
    public static final String TYPE_IDL = "idl";
    public static final String TYPE_CPP = "cpp";
    public static final String TYPE_JS = "js";
    public static final String TYPE_DIFF = "diff";
    private BasicEditorPane editorComponent;
    private JPanel leftMargin;
    private CEToolbar topToolbar;
    private MyStructureChangeListener structureChangeListener;
    private CodeEditorGutter gutterComponent;
    private CodeFoldingMargin codeFoldingMargin;
    private FileOverviewMargin fileOverviewMargin;
    private ArrayList cursorListeners;
    private ArrayList<CursorListener> cursorListenersBatched;
    private Timer cursorListenerTimer;
    private ArrayList providerList;
    private HelpInfo helpInfo;
    private NodeUpdater nodeUpdater;
    private ArrayList ceToolTipProviders;
    private EditorStatusBar statusBar;
    private static final String OFFSET_PROP = "offset";
    private static final String TAB_SIZE_PROP = "tabsize";
    private TextNode ideNode;
    private static List pluginsFactoryList;
    private static List<ViewSelectionHelperFactory> viewSelectionHelperFactoryList;
    private List<ViewSelectionHelper> viewSelectionHelperList;
    private static List classList;
    private static List typeList;
    private Element[] viewSelection;
    private static final DataFlavor CONTEXT_FLAVOR;
    private static final DataFlavor FILELIST_FLAVOR;
    private static final DataFlavor[] EXTRA_CUSTOM_FLAVORS;

    public CodeEditor() {
        this.$init$();
        this.cursorListeners = new ArrayList();
        this.cursorListenersBatched = new ArrayList();
        this.providerList = new ArrayList();
        this.ceToolTipProviders = new ArrayList(2);
        PrintManager printManager = PrintManager.getPrintManager();
        if (printManager != null) {
            printManager.registerDocumentPrintFactory(CodeEditor.class, DocumentPrintFactory.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFactory(EditorPluginsFactory factory) {
        if (factory != null) {
            List list = pluginsFactoryList;
            synchronized (list) {
                pluginsFactoryList.add(factory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNodeType(Class nodeClass, String highlightingType) {
        Class<TextNode> textNodeClass = TextNode.class;
        if (textNodeClass.isAssignableFrom(nodeClass)) {
            List list = classList;
            synchronized (list) {
                classList.add(nodeClass);
                typeList.add(highlightingType);
            }
        } else {
            Assert.println((String)("CodeEditor: node class does not implement TextNode: " + nodeClass.getName()));
        }
    }

    public void changeDocumentType(String highlightingType) {
        LanguageSupport support = LanguageModule.createSupportForFileType((String)highlightingType);
        if (support != null) {
            BasicDocument document = (BasicDocument)this.editorComponent.getDocument();
            document.setLanguageSupport(support);
        }
    }

    public static HighlightStyle createHighlightStyle(String internalName, String publicName, int priority, Color fgColor, Color bgColor) {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        return registry.createStyle(internalName, publicName, true, priority, fgColor, bgColor);
    }

    public static HighlightStyle createHighlightStyle(String internalName, String publicName, int priority, Color fgColor, Color bgColor, int fontStyle, int underlinePredefine, Color underlineColor) {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        return registry.createStyle(internalName, publicName, true, priority, fgColor, bgColor, fontStyle, underlinePredefine, underlineColor);
    }

    public Toolbar getToolbar() {
        if (this.topToolbar == null) {
            this.topToolbar = new CEToolbar();
            Preferences preferences = Preferences.getPreferences();
            EditorOptions editorOptions = EditorOptions.getInstance((PropertyStorage)preferences);
            this.structureChangeListener = new MyStructureChangeListener(null);
            editorOptions.addStructureChangeListener(this.structureChangeListener);
        }
        return this.topToolbar;
    }

    public void setFixedBottomMarginComponent(Component panel) {
        if (this._fixedBottomMargin != null && panel != null) {
            throw new IllegalStateException();
        }
        this._fixedBottomMargin = panel;
    }

    public String getText(int offset, int length) throws BadLocationException {
        return this.editorComponent.getText(offset, length);
    }

    public void setCaretPosition(int offset) {
        this.editorComponent.setCaretPosition(offset);
    }

    public void moveCaretPosition(int offset) {
        this.editorComponent.moveCaretPosition(offset);
    }

    public int getCaretPosition() {
        return this.editorComponent.getCaretPosition();
    }

    public int getCaretLine() {
        BasicDocument document = (BasicDocument)this.editorComponent.getDocument();
        document.readLock();
        int line = 0;
        try {
            int offset = this.editorComponent.getCaretPosition();
            LineMap lineMap = document.getLineMap();
            line = lineMap.getLineFromOffset(offset);
        }
        finally {
            document.readUnlock();
        }
        return ++line;
    }

    public void replaceSelection(String content) {
        this.editorComponent.replaceSelection(content);
    }

    public boolean hasSelectedText() {
        int selectionEnd;
        int selectionStart = this.editorComponent.getSelectionStart();
        return selectionStart != (selectionEnd = this.editorComponent.getSelectionEnd());
    }

    public String getSelectedText() {
        return this.editorComponent.getSelectedText();
    }

    public int getSelectionStart() {
        return this.editorComponent.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.editorComponent.getSelectionEnd();
    }

    public void setSelectionStart(int selectionStart) {
        this.editorComponent.setSelectionStart(selectionStart);
    }

    public void setSelectionEnd(int selectionEnd) {
        this.editorComponent.setSelectionEnd(selectionEnd);
    }

    public void addCursorListener(CursorListener listener) {
        this.addCursorListener(listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCursorListener(CursorListener listener, boolean batchEvents) {
        if (batchEvents) {
            ArrayList<CursorListener> arrayList = this.cursorListenersBatched;
            synchronized (arrayList) {
                if (!this.cursorListenersBatched.contains(listener)) {
                    this.cursorListenersBatched.add(listener);
                }
            }
        }
        if (this.cursorListeners != null) {
            ArrayList arrayList = this.cursorListeners;
            synchronized (arrayList) {
                if (this.cursorListeners.indexOf(listener) == -1) {
                    this.cursorListeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCursorListener(CursorListener listener) {
        if (this.cursorListeners != null) {
            ArrayList arrayList = this.cursorListeners;
            synchronized (arrayList) {
                int index = this.cursorListeners.indexOf(listener);
                if (index != -1) {
                    this.cursorListeners.remove(index);
                }
            }
        }
        ArrayList<CursorListener> arrayList = this.cursorListenersBatched;
        synchronized (arrayList) {
            this.cursorListenersBatched.remove(listener);
        }
    }

    public CodeEditorGutter getGutter() {
        return this.gutterComponent;
    }

    public FileOverviewMargin getFileOverviewMargin() {
        return this.fileOverviewMargin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCEToolTipProvider(CEToolTipProvider provider) {
        if (this.editorComponent != null) {
            ArrayList arrayList = this.ceToolTipProviders;
            synchronized (arrayList) {
                if (this.ceToolTipProviders.size() == 0) {
                    this.editorComponent.addToolTipProvider((ToolTipProvider)this);
                }
                this.ceToolTipProviders.add(provider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCEToolTipProvider(CEToolTipProvider provider) {
        if (this.editorComponent != null) {
            ArrayList arrayList = this.ceToolTipProviders;
            synchronized (arrayList) {
                this.ceToolTipProviders.remove(provider);
                if (this.ceToolTipProviders.size() == 0) {
                    this.editorComponent.removeToolTipProvider((ToolTipProvider)this);
                }
            }
        }
    }

    public boolean gotoOffset(int offset, int selectionLength) {
        BasicDocument document = (BasicDocument)this.editorComponent.getDocument();
        int documentLength = document.getLength();
        int startOffset = Math.max(0, Math.min(offset, documentLength));
        int endOffset = Math.max(startOffset, Math.min(startOffset + selectionLength, documentLength));
        this.editorComponent.setCaretPositionCenter(startOffset);
        if (startOffset != endOffset) {
            this.editorComponent.moveCaretPositionCenter(endOffset);
        }
        return offset == startOffset && selectionLength == endOffset - startOffset;
    }

    public boolean gotoLine(int line, int column, boolean highlightLine) {
        BasicDocument document = (BasicDocument)this.editorComponent.getDocument();
        LineMap lineMap = document.getLineMap();
        int numberLines = lineMap.getLineCount();
        boolean valid = true;
        if (--line < 0 || line >= numberLines) {
            line = line < 0 ? 0 : numberLines - 1;
            valid = false;
        }
        int lineStart = lineMap.getLineStartOffset(line);
        int lineEnd = lineMap.getLineEndOffset(line);
        int caretOffset = Math.min(lineEnd, lineStart + column);
        if (highlightLine) {
            this.editorComponent.setCaretPositionCenter(lineEnd);
            this.editorComponent.moveCaretPositionCenter(lineStart);
            this.editorComponent.getCaret().setSelectionVisible(true);
        } else {
            this.editorComponent.setCaretPositionCenter(caretOffset);
        }
        this.editorComponent.requestFocus();
        return valid;
    }

    public JComponent[] getCustomCells() {
        if (this.statusBar != null) {
            return this.statusBar.getStatusBarCells();
        }
        return null;
    }

    public boolean isExpandable(JComponent customCell) {
        return false;
    }

    public BasicEditorPane getFocusedEditorPane() {
        return this.editorComponent;
    }

    public void showPopup(BasicEditorPane editorPane, MouseEvent mouseEvent) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu != null) {
            Context context = new Context(this.getContext());
            if (context.getElement() == null) {
                Node element = context.getNode();
                context.setSelection(new Element[]{element});
                context.setElement((Element)element);
            }
            context.setEvent((EventObject)mouseEvent);
            contextMenu.show(context);
        }
    }

    public void hidePopup(BasicEditorPane editorPane) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        BasicCaret bCaret;
        String propertyName = event.getPropertyName();
        if (propertyName.equals("code-folding-margin")) {
            if (this.codeFoldingMargin != null) {
                this.leftMargin.remove((Component)this.codeFoldingMargin);
            }
            this.codeFoldingMargin = (CodeFoldingMargin)event.getNewValue();
            if (this.codeFoldingMargin != null) {
                this.leftMargin.add((Component)this.codeFoldingMargin, "East");
            }
        } else if (propertyName.equals("editor-font") && this.editorComponent.getCaret() instanceof BasicCaret && (bCaret = (BasicCaret)this.editorComponent.getCaret()).getEditorSelection() instanceof EditorSelectionColumns && !EditorSelectionColumns.isEditorFixedWidthFont((BasicEditorPane)this.editorComponent)) {
            IdeAction action = IdeAction.get((int)81);
            action.setState(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void caretUpdate(CaretEvent event) {
        CodeEditorController editorController = (CodeEditorController)this.getController();
        Context context = this.getContext();
        if (Ide.getMainWindow().getLastActiveView() == this) {
            editorController.checkCommandsAfterNavigation(context);
        }
        ArrayList arrayList = this.cursorListeners;
        synchronized (arrayList) {
            int listSize;
            int i = listSize = this.cursorListeners.size();
            while (i > 0) {
                CursorListener listener = (CursorListener)this.cursorListeners.get(--i);
                try {
                    listener.cursorUpdate(this);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
        }
        this._startOrResetCursorListenerTimer();
    }

    private void _startOrResetCursorListenerTimer() {
        if (this.cursorListenerTimer == null) {
            this.cursorListenerTimer = new Timer(250, new 1());
            this.cursorListenerTimer.setRepeats(false);
            this.cursorListenerTimer.start();
        } else {
            this.cursorListenerTimer.restart();
        }
    }

    public int getLineCount() {
        return this.editorComponent.getLineCount();
    }

    public int getLineFromOffset(int offset) {
        return this.editorComponent.getLineFromOffset(offset) + 1;
    }

    public int getLineStartOffset(int line) {
        return this.editorComponent.getLineStartOffset(line - 1);
    }

    public int getLineEndOffset(int line) {
        return this.editorComponent.getLineEndOffset(line - 1);
    }

    public static Context getContext(BasicEditorPane editor) {
        Context context = (Context)editor.getProperty(EDITOR_CONTEXT);
        return context;
    }

    protected Element[] getSelectionFromUI() {
        if (this.viewSelection != null) {
            return this.viewSelection;
        }
        if (this.ideNode != null) {
            return new Element[]{this.ideNode};
        }
        return View.EMPTY_SELECTION;
    }

    public static void registerViewSelectionHelperFactory(ViewSelectionHelperFactory factory) {
        if (!viewSelectionHelperFactoryList.contains(factory)) {
            viewSelectionHelperFactoryList.add(factory);
        }
    }

    public static CodeEditor getCodeEditor(BasicEditorPane editor) {
        View view;
        Context context = CodeEditor.getContext(editor);
        if (context != null && (view = context.getView()) instanceof CodeEditor) {
            return (CodeEditor)view;
        }
        return null;
    }

    public synchronized void setContext(Context context) {
        Node node;
        if (context != null && (node = context.getNode()) instanceof TextNode) {
            Context ourContext = new Context(context);
            Node element = context.getNode();
            ourContext.setSelection(new Element[]{element});
            ourContext.setElement((Element)element);
            if (this.editorComponent == null) {
                this.ideNode = (TextNode)node;
                this.updateSelection();
                super.setContext(ourContext);
                Context realContext = this.getContext();
                this.initializeEditor(realContext);
            } else {
                if (node != this.ideNode) {
                    throw new IllegalStateException("Reset of context w/ different node");
                }
                Project oldProject = this.getContext().getProject();
                super.setContext(ourContext);
                Context realContext = this.getContext();
                this.updateEditorContext(realContext);
                if (ourContext.getProject() == null && oldProject != null) {
                    Assert.println((String)"WARNING: Project reset to null in Code Editor's context");
                    Assert.println((String)"         Add following stack trace to bug 3274559,");
                    Assert.println((String)"         and reopen bug with the steps you used.");
                    Assert.printStackTrace((Throwable)new NullPointerException());
                }
            }
        }
    }

    public void open() {
        this.editorComponent.requestFocus();
    }

    public Component getDefaultFocusComponent() {
        return this.editorComponent;
    }

    public void close() {
        super.close();
        EditorManager.getEditorManager().removeLayoutListener(this.getId());
        this.gutterComponent.removeAllGutterColumns();
        this.gutterComponent = null;
        this.fileOverviewMargin = null;
        if (this.statusBar != null) {
            this.editorComponent.deinstallPlugin((EditorPlugin)this.statusBar);
            this.statusBar = null;
        }
        if (this.topToolbar != null) {
            this.topToolbar.dispose();
            this.topToolbar.removeAll();
        }
        if (this.structureChangeListener != null) {
            Preferences preferences = Preferences.getPreferences();
            EditorOptions editorOptions = EditorOptions.getInstance((PropertyStorage)preferences);
            editorOptions.removeStructureChangeListener(this.structureChangeListener);
            this.structureChangeListener = null;
        }
        BasicDocument editorDocument = (BasicDocument)this.editorComponent.getDocument();
        editorDocument.removeUndoableEditListener((UndoableEditListener)this);
        this.editorComponent.removePopupManager((PopupManager)this);
        this.editorComponent.removeCaretListener((CaretListener)this);
        this.editorComponent.dispose();
        this.editorComponent = null;
        this.ceToolTipProviders.clear();
        this.ceToolTipProviders = null;
        for (ViewSelectionHelper vsHelper : this.viewSelectionHelperList) {
            vsHelper.detach(this);
        }
        this.cursorListeners = null;
        this.cursorListenersBatched.clear();
        this.nodeUpdater = null;
    }

    public Controller getController() {
        return CodeEditorController.getDefaultController();
    }

    public Object getEditorAttribute(String attribute) {
        if (attribute.equals("menu_id")) {
            return CEditorArb.getString(11);
        }
        return super.getEditorAttribute(attribute);
    }

    public void saveSettings(StructuredPropertyAccess node) {
        try {
            int caretPosition = this.getCaretPosition();
            node.setProperty(OFFSET_PROP, Integer.toString(caretPosition));
            int tabSize = this.editorComponent.getIntegerProperty("tab-size");
            node.setProperty(TAB_SIZE_PROP, Integer.toString(tabSize));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        super.saveSettings(node);
    }

    public void loadSettings(StructuredPropertyAccess node) {
        int caretPos = node.getIntegerProperty(OFFSET_PROP, 0);
        int tabSize = node.getIntegerProperty(TAB_SIZE_PROP, 0);
        this.editorComponent.setCaretPositionCenter(caretPos);
        if (tabSize != 0) {
            this.editorComponent.putIntegerProperty("tab-size", tabSize);
        }
        super.loadSettings(node);
    }

    public Component getGUI() {
        return this.editorComponent;
    }

    public Component getScrollableLeftMargin() {
        return this.leftMargin;
    }

    public Component getFixedRightMargin() {
        return this.fileOverviewMargin;
    }

    public Component getFixedTopMargin() {
        return this.getToolbar();
    }

    public Component getFixedBottomMargin() {
        return this._fixedBottomMargin;
    }

    public Icon getTabIcon() {
        return CEditorArb.getIcon(35);
    }

    public void update(Object observed, UpdateMessage change) {
        int id = change.getMessageID();
        if (id == UpdateMessage.OBJECT_RENAMED) {
            Node removedNode;
            Node addedNode;
            List removeObjects;
            boolean isSimpleRename = false;
            List addObjects = change.getAddObjects();
            if (addObjects.size() == 1 && (removeObjects = change.getRemoveObjects()).size() == 1 && (addedNode = (Node)addObjects.get(0)) == (removedNode = (Node)removeObjects.get(0))) {
                isSimpleRename = true;
            }
            if (isSimpleRename) {
                this.owner().updateTitle((Object)this);
            } else {
                EditorManager editorManager = EditorManager.getEditorManager();
                editorManager.closeEditors(Collections.singletonList(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToolTipText(BasicEditorPane editorPane, MouseEvent mouseEvent, int offset) {
        String result = null;
        ArrayList arrayList = this.ceToolTipProviders;
        synchronized (arrayList) {
            int size = this.ceToolTipProviders.size();
            int i = 0;
            while (i < size) {
                CEToolTipProvider provider = (CEToolTipProvider)this.ceToolTipProviders.get(i);
                result = provider.getToolTipText(this, mouseEvent, offset);
                if (result != null && result.length() > 0) break;
                ++i;
            }
        }
        return result;
    }

    public void undoableEditHappened(UndoableEditEvent event) {
        UndoableEdit edit = event.getEdit();
        UndoWrapperCommand command = new UndoWrapperCommand(edit, this.nodeUpdater);
        CommandProcessor processor = CommandProcessor.getInstance();
        command.setContext(this.getContext());
        try {
            processor.invoke((Command)command);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void save(Layout layout) {
    }

    public void init(Layout layout) {
    }

    public void close(Layout layout) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HelpInfo getHelpInfo() {
        HelpInfo customInfo = null;
        ArrayList arrayList = this.providerList;
        synchronized (arrayList) {
            int numProviders = this.providerList.size();
            boolean hasNull = false;
            int i = numProviders - 1;
            while (i >= 0) {
                HelpableProvider provider = (HelpableProvider)this.providerList.get(i);
                if (provider != null) {
                    customInfo = provider.getHelpInfo((Helpable)this);
                } else {
                    hasNull = true;
                }
                if (customInfo != null) break;
                --i;
            }
            if (hasNull) {
                Iterator iterator = this.providerList.iterator();
                while (iterator.hasNext()) {
                    Object provider = iterator.next();
                    if (provider != null) continue;
                    iterator.remove();
                }
            }
        }
        if (customInfo != null) {
            return customInfo;
        }
        if (this.helpInfo != null) {
            return this.helpInfo;
        }
        return new HelpInfo("f1_idecodeeditor_html");
    }

    public void setHelpInfo(HelpInfo helpInfo) {
        this.helpInfo = helpInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHelpableProvider(HelpableProvider helpableProvider) {
        ArrayList arrayList = this.providerList;
        synchronized (arrayList) {
            if (!this.providerList.contains(helpableProvider)) {
                this.providerList.add(helpableProvider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHelpableProvider(HelpableProvider helpableProvider) {
        ArrayList arrayList = this.providerList;
        synchronized (arrayList) {
            int index = this.providerList.indexOf(helpableProvider);
            if (index != -1) {
                this.providerList.set(index, null);
            }
        }
    }

    public void setHelpableProvider(HelpableProvider helpableProvider) {
        this.addHelpableProvider(helpableProvider);
    }

    public HelpableProvider getHelpableProvider() {
        return null;
    }

    private void updateEditorContext(Context context) {
        this.editorComponent.putProperty(EDITOR_CONTEXT, (Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeEditor(Context context) {
        EditorManager.getEditorManager().addLayoutListener(this.getId(), (BaseLayoutListener)this);
        TextBuffer textBuffer = this.ideNode.acquireTextBuffer();
        this.editorComponent = EditorFactory.createIdeEditorPane();
        this.updateEditorContext(context);
        URL docURL = this.ideNode.getURL();
        URL parentURL = URLFileSystem.getParent((URL)docURL);
        String docFilename = URLFileSystem.getFileName((URL)docURL);
        String docDirectory = URLFileSystem.getPlatformPathName((URL)parentURL);
        String accessibleName = CEditorArb.format(21, docFilename, docDirectory);
        AccessibleUtils.updateAccessibleName((Accessible)this.editorComponent, (String)accessibleName, (boolean)true);
        String nodeType = CodeEditor.getTypeForNode(this.ideNode);
        if (nodeType == null) {
            nodeType = URLFileSystem.getPlatformPathName((URL)this.ideNode.getURL());
        }
        BasicDocument editorDocument = new BasicDocument(nodeType, textBuffer);
        editorDocument.addUndoableEditListener((UndoableEditListener)this);
        this.editorComponent.setDocument((Document)editorDocument);
        Attributes attributes = this.ideNode.getAttributes();
        if (attributes.isSet(ElementAttributes.NON_EDITABLE)) {
            this.editorComponent.setProtected(true);
        }
        this.editorComponent.addPopupManager((PopupManager)this);
        this.editorComponent.addCaretListener((CaretListener)this);
        this.editorComponent.setFocusTraversalKeysEnabled(false);
        TrailingSpacePlugin trailingPlugin = new TrailingSpacePlugin();
        this.editorComponent.installPlugin((EditorPlugin)trailingPlugin);
        this.leftMargin = new JPanel(new BorderLayout());
        this.gutterComponent = new CodeEditorGutter(this);
        this.editorComponent.installPlugin((EditorPlugin)this.gutterComponent);
        this.leftMargin.add((Component)((Object)this.gutterComponent), "Center");
        this.editorComponent.addPropertyChangeListener((PropertyChangeListener)this);
        this.fileOverviewMargin = new CEFileOverviewMargin(this);
        this.editorComponent.installPlugin((EditorPlugin)this.fileOverviewMargin);
        this.statusBar = new EditorStatusBar();
        this.editorComponent.installPlugin((EditorPlugin)this.statusBar);
        this.editorComponent.installPlugin((EditorPlugin)new LineHighlightPlugin());
        this.editorComponent.installPlugin((EditorPlugin)new CEDragDropPlugin(null));
        List list = pluginsFactoryList;
        synchronized (list) {
            Context ideContext = this.getContext();
            int listSize = pluginsFactoryList.size();
            int i = 0;
            while (i < listSize) {
                try {
                    EditorPluginsFactory factory = (EditorPluginsFactory)pluginsFactoryList.get(i);
                    List pluginsList = factory.createPlugins(ideContext);
                    int numPlugins = pluginsList.size();
                    int j = 0;
                    while (j < numPlugins) {
                        EditorPlugin plugin = (EditorPlugin)pluginsList.get(j);
                        if (plugin instanceof EditorPlugin) {
                            this.editorComponent.installPlugin(plugin);
                        }
                        ++j;
                    }
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
                ++i;
            }
        }
        this.editorComponent.installPlugin((EditorPlugin)new CEOpenEditorDropHandler(null));
        this.viewSelectionHelperList = new ArrayList<ViewSelectionHelper>();
        ViewSelectionSetterHelper setter = new ViewSelectionSetterHelper(null);
        for (ViewSelectionHelperFactory vshFactory : viewSelectionHelperFactoryList) {
            ViewSelectionHelper helper = vshFactory.createSelectionHelper(this);
            if (helper == null) continue;
            this.viewSelectionHelperList.add(helper);
            helper.attach(this, setter);
        }
        this.addMakeEditableVetoListeners(this.editorComponent, this.ideNode);
        this.nodeUpdater = NodeUpdater.getUpdater((Subject)this.ideNode, textBuffer);
        if (this.editorComponent.getCaret() instanceof BasicCaret) {
            EditorSelectionWrap editorSelection;
            IdeAction action = IdeAction.get((int)81);
            boolean shouldWrap = action.getState();
            if (shouldWrap) {
                editorSelection = new EditorSelectionWrap();
                this.editorComponent.putIntegerProperty("caret-editor-selection-type", 20);
            } else {
                editorSelection = new EditorSelectionColumns();
                if (editorSelection.canSupportEditor(this.editorComponent)) {
                    this.editorComponent.putIntegerProperty("caret-editor-selection-type", 21);
                } else {
                    editorSelection = new EditorSelectionWrap();
                    this.editorComponent.putIntegerProperty("caret-editor-selection-type", 20);
                    action.setState(true);
                }
            }
            ((BasicCaret)this.editorComponent.getCaret()).setEditorSelection((EditorSelection)editorSelection);
            editorSelection.install(this.editorComponent);
        }
    }

    private void addMakeEditableVetoListeners(BasicEditorPane editor, TextNode ideNode) {
        editor.addVetoableChangeListener((VetoableChangeListener)new 2());
        editor.addVetoableChangeListener((VetoableChangeListener)new 3(this, ideNode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getTypeForNode(TextNode textNode) {
        Class nodeClass = textNode.getClass();
        List list = classList;
        synchronized (list) {
            int numClasses = classList.size();
            int i = 0;
            while (i < numClasses) {
                Class registeredClass = (Class)classList.get(i);
                if (registeredClass == nodeClass) {
                    String string = (String)typeList.get(i);
                    return string;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < numClasses) {
                Class registeredClass = (Class)classList.get(i2);
                if (registeredClass.isAssignableFrom(nodeClass)) {
                    String string = (String)typeList.get(i2);
                    return string;
                }
                ++i2;
            }
        }
        return null;
    }

    private void setSelection(Element[] selectedElements) {
        this.viewSelection = selectedElements;
        this.updateSelectionImpl(false);
    }

    protected BasicEditorPane getEditorComponent() {
        return this.editorComponent;
    }

    protected String getEditorText() {
        return this.editorComponent.getText();
    }

    protected boolean canCut() {
        return this.editorComponent.canCut();
    }

    protected boolean canCopy() {
        return this.editorComponent.canCopy();
    }

    protected boolean canPaste() {
        return this.editorComponent.canPaste();
    }

    private void $init$() {
        this.viewSelection = View.EMPTY_SELECTION;
    }

    static {
        classList = new ArrayList();
        typeList = new ArrayList();
        pluginsFactoryList = new ArrayList();
        viewSelectionHelperFactoryList = new ArrayList<ViewSelectionHelperFactory>();
        CodeEditor.registerFactory(new CodeEditorPluginsFactory());
        CONTEXT_FLAVOR = TransferableContext.contextFlavor;
        FILELIST_FLAVOR = DataFlavor.javaFileListFlavor;
        EXTRA_CUSTOM_FLAVORS = new DataFlavor[]{CONTEXT_FLAVOR, FILELIST_FLAVOR};
    }

    static CEToolbar ra$topToolbar(CodeEditor codeEditor) {
        return codeEditor.topToolbar;
    }

    static BasicEditorPane ra$editorComponent(CodeEditor codeEditor) {
        return codeEditor.editorComponent;
    }

    static CodeFoldingMargin ra$codeFoldingMargin(CodeEditor codeEditor) {
        return codeEditor.codeFoldingMargin;
    }

    static DataFlavor ra$CONTEXT_FLAVOR() {
        return CONTEXT_FLAVOR;
    }

    static DataFlavor ra$FILELIST_FLAVOR() {
        return FILELIST_FLAVOR;
    }

    static DataFlavor[] ra$EXTRA_CUSTOM_FLAVORS() {
        return EXTRA_CUSTOM_FLAVORS;
    }

    static void mav$setSelection(CodeEditor codeEditor, Element[] elementArray) {
        codeEditor.setSelection(elementArray);
    }

    static ArrayList ra$cursorListenersBatched(CodeEditor codeEditor) {
        return codeEditor.cursorListenersBatched;
    }

    static void wa$cursorListenerTimer(CodeEditor codeEditor, Timer timer) {
        codeEditor.cursorListenerTimer = timer;
    }

    protected class CEToolbar
    extends Toolbar {
        protected CEToolbar() {
            this.updateVisibility();
        }

        protected void addImpl(Component comp, Object constraints, int index) {
            super.addImpl(comp, constraints, index);
            this.updateVisibility();
        }

        public void remove(int i) {
            super.remove(i);
            this.updateVisibility();
        }

        protected void updateVisibility() {
            Preferences preferences;
            EditorOptions editorOptions;
            boolean visible = false;
            if (this.getComponentCount() > 0 && (editorOptions = EditorOptions.getInstance((PropertyStorage)(preferences = Preferences.getPreferences()))).getShowToolbar()) {
                visible = true;
            }
            this.setVisible(visible);
        }
    }

    private class MyStructureChangeListener
    extends StructureChangeListener {
        public void structureValuesChanged(StructureChangeEvent e) {
            CodeEditor.ra$topToolbar(CodeEditor.this).updateVisibility();
        }

        private MyStructureChangeListener() {
        }

        MyStructureChangeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            int listSize;
            int i = listSize = CodeEditor.ra$cursorListenersBatched(CodeEditor.this).size();
            while (i > 0) {
                CursorListener listener = (CursorListener)CodeEditor.ra$cursorListenersBatched(CodeEditor.this).get(--i);
                try {
                    listener.cursorUpdate(CodeEditor.this);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            CodeEditor.wa$cursorListenerTimer(CodeEditor.this, null);
        }
    }

    final class 2
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (pce.getPropertyName().equals("consumerVetoForMakeEditable")) {
                throw new PropertyVetoException(null, pce);
            }
        }
    }

    final class 3
    implements VetoableChangeListener {
        private long _checkOutFailureTimeMillis;
        private final /* synthetic */ TextNode v$ideNode;
        final /* synthetic */ CodeEditor this$0;

        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (!pce.getPropertyName().equals("isEditable")) {
                return;
            }
            if (!pce.getOldValue().equals(Boolean.FALSE)) {
                return;
            }
            if (!pce.getNewValue().equals(Boolean.TRUE)) {
                return;
            }
            if (System.currentTimeMillis() - this._checkOutFailureTimeMillis < 250L) {
                throw new PropertyVetoException(null, pce);
            }
            VCSManager vcsManager = VCSManager.getVCSManager();
            if (vcsManager != null && !vcsManager.checkOutNode((Node)this.v$ideNode, CommandProcessor.getInstance())) {
                this._checkOutFailureTimeMillis = System.currentTimeMillis();
                throw new PropertyVetoException(null, pce);
            }
        }

        public 3(CodeEditor codeEditor, TextNode textNode) {
            this.v$ideNode = textNode;
            this.this$0 = codeEditor;
        }
    }

    private final class CEDragDropPlugin
    extends DragDropPlugin
    implements ActionListener {
        private int EXPANSION_DELAY;
        private Timer _expansionTimer;
        private int _expansionBlockID;

        private void $init$() {
            this.EXPANSION_DELAY = 500;
            this._expansionTimer = new Timer(this.EXPANSION_DELAY, this);
            this._expansionBlockID = -1;
        }

        protected void handleDragEvent(DropTargetDragEvent event) {
            this.maybeExpandFoldedBlock(event.getLocation());
            DropHandlerPlugin[] handlers = DropHandlerPlugin.getHandlers(this.editor);
            int i = 0;
            while (i < handlers.length) {
                DropHandlerPlugin handler = handlers[i];
                try {
                    int acceptAction = handler.shouldAllowDrag(event);
                    if (acceptAction != 0) {
                        Point paintLocation = handler.getDropLocationToPaint(event);
                        if (paintLocation != null) {
                            this.paintDropLocation(paintLocation);
                        }
                        event.acceptDrag(event.getDropAction());
                        return;
                    }
                }
                catch (RuntimeException e) {
                    ExceptionDialog.showExceptionDialog((Component)this.editor, (Throwable)e);
                    return;
                }
                ++i;
            }
            super.handleDragEvent(event);
        }

        protected void handleDropEvent(DropTargetDropEvent event) {
            DropHandlerPlugin[] handlers = DropHandlerPlugin.getHandlers(this.editor);
            int i = 0;
            while (i < handlers.length) {
                DropHandlerPlugin handler = handlers[i];
                try {
                    int acceptAction = handler.shouldAllowDrop(event);
                    if (acceptAction != 0) {
                        this.clearDropLocation();
                        int dropAction = event.getDropAction();
                        if (this.isDropActionSupported(dropAction)) {
                            event.acceptDrop(acceptAction);
                            boolean dropSuccess = handler.performDrop(event);
                            event.dropComplete(dropSuccess);
                        } else {
                            event.rejectDrop();
                        }
                        return;
                    }
                }
                catch (RuntimeException e) {
                    ExceptionDialog.showExceptionDialog((Component)this.editor, (Throwable)e);
                    return;
                }
                ++i;
            }
            super.handleDropEvent(event);
        }

        protected void cancelDragEvent(DropTargetEvent event) {
            super.cancelDragEvent(event);
            DropHandlerPlugin[] handlers = DropHandlerPlugin.getHandlers(this.editor);
            int i = 0;
            while (i < handlers.length) {
                DropHandlerPlugin handler = handlers[i];
                handler.cancelDragEvent(event);
                ++i;
            }
        }

        private void maybeExpandFoldedBlock(Point point) {
            Object block = this.getBlockAtPoint(point);
            if (block == null) {
                this._expansionTimer.stop();
                this._expansionBlockID = -1;
                return;
            }
            int blockID = block.hashCode();
            if (this._expansionTimer.isRunning()) {
                if (blockID != this._expansionBlockID) {
                    this._expansionBlockID = blockID;
                    this._expansionTimer.restart();
                }
            } else {
                this._expansionBlockID = blockID;
                this._expansionTimer.start();
            }
        }

        private Object getBlockAtPoint(Point point) {
            if (CodeEditor.ra$codeFoldingMargin(CodeEditor.this) == null) {
                return null;
            }
            int offset = CodeEditor.ra$editorComponent(CodeEditor.this).viewToModel(point) - 1;
            try {
                int endOfLineX = CodeEditor.ra$editorComponent((CodeEditor)CodeEditor.this).modelToView((int)offset).x;
                if (point.x > endOfLineX) {
                    Object var7_4 = null;
                    return var7_4;
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            CodeFoldingModel model = CodeEditor.ra$codeFoldingMargin(CodeEditor.this).getModel();
            if (model == null) {
                return null;
            }
            Object block = null;
            try {
                model.readLock();
                block = CodeEditor.ra$codeFoldingMargin(CodeEditor.this).getLargestCollapsedBlock(model, model.getRoot(), offset);
            }
            finally {
                model.readUnlock();
            }
            return block;
        }

        public void actionPerformed(ActionEvent e) {
            if (CodeEditor.ra$editorComponent(CodeEditor.this) == null) {
                return;
            }
            Point point = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(point, (Component)CodeEditor.ra$editorComponent(CodeEditor.this));
            Object block = this.getBlockAtPoint(point);
            if (block != null && block.hashCode() == this._expansionBlockID) {
                CodeEditor.ra$codeFoldingMargin(CodeEditor.this).setExpansionState(block, true, true);
            }
        }

        private CEDragDropPlugin() {
            this.$init$();
        }

        CEDragDropPlugin(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class CEOpenEditorDropHandler
    extends DropHandlerPlugin {
        protected Point getDropLocationToPaint(DropTargetDragEvent event) {
            return null;
        }

        protected int shouldAllowDrag(DropTargetDragEvent event) {
            return this._allow(event, event.getDropAction());
        }

        protected int shouldAllowDrop(DropTargetDropEvent event) {
            return this._allow(event, event.getDropAction());
        }

        private int _allow(DropTargetEvent event, int dropAction) {
            int i = 0;
            while (i < CodeEditor.ra$EXTRA_CUSTOM_FLAVORS().length) {
                if (DndUtils.isDataFlavorSupported((DropTargetEvent)event, (DataFlavor)CodeEditor.ra$EXTRA_CUSTOM_FLAVORS()[i])) {
                    return dropAction;
                }
                ++i;
            }
            return 0;
        }

        protected boolean performDrop(DropTargetDropEvent event) {
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(CodeEditor.ra$CONTEXT_FLAVOR())) {
                return this.handleContextDrop(transferable);
            }
            if (transferable.isDataFlavorSupported(CodeEditor.ra$FILELIST_FLAVOR())) {
                return this.handleFileListDrop(transferable);
            }
            return false;
        }

        protected boolean handleFileListDrop(Transferable transferable) {
            boolean dropSuccess = false;
            try {
                List fileList = (List)transferable.getTransferData(CodeEditor.ra$FILELIST_FLAVOR());
                for (File file : fileList) {
                    URL url = URLFactory.newFileURL((File)file);
                    EditorUtil.openDefaultEditorInFrameExternal((URL)url);
                }
                dropSuccess = true;
            }
            catch (IOException e) {
            }
            catch (UnsupportedFlavorException e) {
                // empty catch block
            }
            return dropSuccess;
        }

        protected boolean handleContextDrop(Transferable transferable) {
            boolean dropSuccess = false;
            try {
                EditorManager editorManager = EditorManager.getEditorManager();
                TransferableContext contextData = (TransferableContext)transferable.getTransferData(CodeEditor.ra$CONTEXT_FLAVOR());
                Context context = contextData.getContext();
                Element[] elements = context.getSelection();
                if (elements != null) {
                    int numElements = elements.length;
                    int i = 0;
                    while (i < numElements) {
                        Element element = elements[i];
                        if (element instanceof Node && editorManager.getDefaultAddin(element) != null) {
                            Context myContext = CodeEditor.this.getContext();
                            editorManager.openDefaultEditorInFrame(myContext);
                            EditorUtil.openDefaultEditorInFrame((Element)element);
                        }
                        ++i;
                    }
                }
                dropSuccess = true;
            }
            catch (IOException e) {
            }
            catch (UnsupportedFlavorException e) {
                // empty catch block
            }
            return dropSuccess;
        }

        private CEOpenEditorDropHandler() {
        }

        CEOpenEditorDropHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ViewSelectionSetterHelper
    implements CodeEditorViewSelectionSetter {
        public void setSelection(Element[] newSelection) {
            CodeEditor.mav$setSelection(CodeEditor.this, newSelection);
        }

        private ViewSelectionSetterHelper() {
        }

        ViewSelectionSetterHelper(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

