/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.Timer;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.ceditor.keymap.EditorKeyStrokes;
import oracle.ide.ceditor.keymap.KeymapManager;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.ceditor.options.GutterOptionsPanel;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.ceditor.options.PrintingHTMLOptions;
import oracle.ide.cmd.buffer.EditProcessor;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorSelectionColumns;
import oracle.javatools.editor.print.DocumentToHTMLGenerator;
import oracle.javatools.editor.print.HTMLGeneratorOptions;

public class CodeEditorController
implements Controller,
CodeMenuConstants,
ContextMenuListener,
DynamicMenuListener {
    public static final int UNDO_WRAPPER_CMD_ID = Ide.findOrCreateCmdID((String)"UndoWrapperCommand");
    private static final int PRINT_TO_HTML_CMD_ID = Ide.findOrCreateCmdID((String)"CodeEditor.PrintToHTMLCommand");
    private static final int TOGGLE_LINE_NUMBER_CMD_ID = Ide.findOrCreateCmdID((String)"ceditor.ToggleLineNumbers");
    private static final int PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"CodeEditor.Preferences");
    private static final int TOGGLE_TOOLBAR_CMD_ID = Ide.findOrCreateCmdID((String)"CodeEditor.ToggleToolbar");
    private static final int TOGGLE_BREADCRUMBS_CMD_ID = Ide.findOrCreateCmdID((String)"CodeEditor.ToggleBreadcrumbs");
    private static int COMPLETION_INSIGHT_CMD_ID;
    private static int SMART_COMPLETION_INSIGHT_CMD_ID;
    private static int PARAMETER_INSIGHT_CMD_ID;
    private static int TOGGLE_COMMENTS_CMD_ID;
    private static int BLOCK_INDENT_CMD_ID;
    private static int BLOCK_OUTDENT_CMD_ID;
    public static final int UNDO_WRAPPER_MSG;
    private IdeAction ideCutAction;
    private IdeAction ideCopyAction;
    private final Listener _listener;
    private static final int UPDATE_INTERVAL = 250;
    private final Timer _delayedUpdateTimer;
    static CodeEditorController _singleton;
    private JComponent[] dynamicItems;

    private void $init$() {
        this._listener = new Listener(null);
        this._delayedUpdateTimer = new Timer(250, this._listener);
    }

    private void initializeActions() {
        if (this.ideCutAction == null) {
            this.ideCutAction = IdeAction.find((int)17);
            this.ideCopyAction = IdeAction.find((int)18);
            String label = CEditorArb.getString(29);
            IdeAction.get((int)TOGGLE_LINE_NUMBER_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)StringUtils.getMnemonicKeyCode((String)label), (ArrayResourceBundle)CEditorArb.getInstance(), (int)17, null, (boolean)true);
            String label2 = CEditorArb.getString(26);
            IdeAction.get((int)PREFERENCES_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label2), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)StringUtils.getMnemonicKeyCode((String)label2), (ArrayResourceBundle)CEditorArb.getInstance(), (int)37, null, (boolean)true);
            String label3 = "Code Editor";
            IdeAction action = IdeAction.get((int)TOGGLE_TOOLBAR_CMD_ID, null, (String)StringUtils.stripMnemonic((String)"Code Editor"), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)StringUtils.getMnemonicKeyCode((String)"Code Editor"), (ResourceBundle)CEditorArb.getInstance(), null, null, (boolean)true);
            action.putValue("Check", (Object)Boolean.TRUE);
            action.addController((Controller)this);
            Menubar menuManager = Ide.getMenubar();
            if (menuManager != null) {
                JMenuItem item = menuManager.createMenuItem((ToggleAction)action);
                menuManager.add((Component)item, MenuManager.getJMenu((String)"ViewToolbars"));
            }
            String label4 = CEditorArb.getString(28);
            IdeAction action2 = IdeAction.get((int)TOGGLE_BREADCRUMBS_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label4), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)StringUtils.getMnemonicKeyCode((String)label4), (ResourceBundle)CEditorArb.getInstance(), null, null, (boolean)true);
            action2.putValue("Check", (Object)Boolean.TRUE);
            action2.addController((Controller)this);
            String label5 = CEditorArb.getString(23);
            IdeAction printToHTMLAction = IdeAction.get((int)PRINT_TO_HTML_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label5), (String)IdeMainWindow.ACTION_CATEGORY_FILE, (Integer)StringUtils.getMnemonicKeyCode((String)label5), (ArrayResourceBundle)CEditorArb.getInstance(), (int)13, null, (boolean)false);
            if (!Product.isRaptor()) {
                Menubar menubar = Ide.getMenubar();
                float printToHTMLWeight = MenuConstants.increment((float)MenuConstants.WEIGHT_FILE_PRINT);
                JMenuItem printToHTMLMenuItem = menubar.createMenuItem((ToggleAction)printToHTMLAction, printToHTMLWeight);
                JMenu fileMenu = MenuManager.getJMenu((String)"File");
                menubar.add((Component)printToHTMLMenuItem, fileMenu, MenuConstants.SECTION_FILE_PRINT);
                printToHTMLAction.addController((Controller)this);
            }
        }
    }

    static synchronized CodeEditorController getDefaultController() {
        if (_singleton == null) {
            _singleton = new CodeEditorController();
        }
        return _singleton;
    }

    static synchronized void disposeDefaultController() {
        if (_singleton != null) {
            _singleton.dispose();
            _singleton = null;
        }
    }

    private CodeEditorController() {
        ContextMenu menu;
        ContextMenu menu2;
        this.$init$();
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager != null && (menu2 = editorManager.getContextMenu()) != null) {
            menu2.addContextMenuListener((ContextMenuListener)this);
        }
        if ((menu = CodeEditorGutter.getGutterContextMenu()) != null) {
            menu.addContextMenuListener((ContextMenuListener)this);
        }
        this.initializeActions();
        if (Product.isRaptor()) {
            this.initializeSourceMenu();
        } else {
            Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
            this.initializeDynamicActions();
        }
    }

    void dispose() {
        ContextMenu menu;
        ContextMenu menu2;
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager != null && (menu2 = editorManager.getContextMenu()) != null) {
            menu2.removeContextMenuListener((ContextMenuListener)this);
        }
        if ((menu = CodeEditorGutter.getGutterContextMenu()) != null) {
            menu.removeContextMenuListener((ContextMenuListener)this);
        }
        this.deinitializeDynamicActions();
    }

    protected void checkCommandsAfterNavigation(Context context) {
        this._delayedUpdateTimer.stop();
        this._delayedUpdateTimer.start();
    }

    private static CodeEditor getCodeEditorFromContext(Context context) {
        CodeEditor codeEditor = null;
        View view = context.getView();
        if (view != null) {
            if (view instanceof CodeEditor) {
                codeEditor = (CodeEditor)view;
            } else if (view instanceof CodeEditorGutter.GutterView) {
                codeEditor = (CodeEditor)view.owner();
            }
        }
        return codeEditor;
    }

    private static BasicEditorPane getEditorPaneFromContext(Context context) {
        BasicEditorPane ret = null;
        CodeEditor codeEditor = CodeEditorController.getCodeEditorFromContext(context);
        if (codeEditor != null) {
            ret = codeEditor.getEditorComponent();
        }
        return ret;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 22) {
            action.setEnabled(true);
        } else if (cmdId == 17) {
            boolean canDo = this.whenCut(context, false);
            action.setEnabled(canDo);
        } else if (cmdId == 18) {
            boolean canDo = this.whenCopy(context, false);
            action.setEnabled(canDo);
        } else if (cmdId == 19) {
            boolean canDo = this.whenPaste(context, false);
            action.setEnabled(canDo);
        } else if (cmdId == 78) {
            boolean canDo = this.whenPasteExtended(context, false);
            action.setEnabled(canDo);
        } else if (cmdId == 20) {
            boolean canDo = this.whenDelete(context, false);
            action.setEnabled(canDo);
        } else if (cmdId == 82) {
            boolean canDo = this.whenDuplicateSelection(context, false);
            action.setEnabled(canDo);
        } else if (cmdId == COMPLETION_INSIGHT_CMD_ID || cmdId == SMART_COMPLETION_INSIGHT_CMD_ID || cmdId == PARAMETER_INSIGHT_CMD_ID || cmdId == TOGGLE_COMMENTS_CMD_ID || cmdId == BLOCK_INDENT_CMD_ID || cmdId == BLOCK_OUTDENT_CMD_ID) {
            boolean canDo = true;
            action.setEnabled(canDo);
        } else if (cmdId == PRINT_TO_HTML_CMD_ID) {
            CodeEditor codeEditor = CodeEditorController.getCodeEditorFromContext(context);
            action.setEnabled(codeEditor != null);
        } else if (cmdId == TOGGLE_TOOLBAR_CMD_ID) {
            Preferences preferences = Preferences.getPreferences();
            EditorOptions editorOptions = EditorOptions.getInstance((PropertyStorage)preferences);
            boolean showToolbar = editorOptions.getShowToolbar();
            action.setState(showToolbar);
        } else if (cmdId == TOGGLE_BREADCRUMBS_CMD_ID) {
            Preferences preferences = Preferences.getPreferences();
            action.setState(DisplayOptions.getInstance((PropertyStorage)preferences).getShowBreadcrumbs());
        } else if (cmdId == 81) {
            boolean canDo = false;
            CodeEditor codeEditor = CodeEditorController.getCodeEditorFromContext(context);
            if (codeEditor != null) {
                BasicEditorPane editorComponent = codeEditor.getEditorComponent();
                canDo = EditorSelectionColumns.isEditorFixedWidthFont((BasicEditorPane)editorComponent);
            }
            action.setEnabled(canDo);
        } else if (cmdId == Ide.findCmdID((String)"trim-whitespace")) {
            action.setEnabled(this.whenTrimWhitespace(context, false));
        } else {
            return false;
        }
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == TOGGLE_TOOLBAR_CMD_ID) {
            Preferences preferences = Preferences.getPreferences();
            EditorOptions editorOptions = EditorOptions.getInstance((PropertyStorage)preferences);
            boolean showToolbar = editorOptions.getShowToolbar();
            editorOptions.setShowToolbar(showToolbar ^ true);
            return true;
        }
        if (cmdId == TOGGLE_BREADCRUMBS_CMD_ID) {
            Preferences preferences = Preferences.getPreferences();
            DisplayOptions displayOptions = DisplayOptions.getInstance((PropertyStorage)preferences);
            displayOptions.setShowBreadcrumbs(displayOptions.getShowBreadcrumbs() ^ true);
            return true;
        }
        CodeEditor codeEditor = CodeEditorController.getCodeEditorFromContext(context);
        if (codeEditor == null) {
            return cmdId == COMPLETION_INSIGHT_CMD_ID || cmdId == SMART_COMPLETION_INSIGHT_CMD_ID || cmdId == PARAMETER_INSIGHT_CMD_ID || cmdId == TOGGLE_COMMENTS_CMD_ID || cmdId == BLOCK_INDENT_CMD_ID || cmdId == BLOCK_OUTDENT_CMD_ID || cmdId == PRINT_TO_HTML_CMD_ID;
        }
        BasicEditorPane editorComponent = codeEditor.getEditorComponent();
        if (!(cmdId != TOGGLE_COMMENTS_CMD_ID && cmdId != BLOCK_INDENT_CMD_ID && cmdId != BLOCK_OUTDENT_CMD_ID && cmdId != PRINT_TO_HTML_CMD_ID || editorComponent.isEditable())) {
            editorComponent.makeEditable();
        }
        if (cmdId == 17) {
            this.whenCut(context, true);
        } else if (cmdId == 18) {
            this.whenCopy(context, true);
        } else if (cmdId == 19) {
            this.whenPaste(context, true);
        } else if (cmdId == 78) {
            this.whenPasteExtended(context, true);
        } else if (cmdId == 82) {
            this.whenDuplicateSelection(context, true);
        } else if (cmdId == 20) {
            this.whenDelete(context, true);
        } else if (cmdId == 22) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("select-all");
        } else if (cmdId == COMPLETION_INSIGHT_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("completion-insight");
        } else if (cmdId == SMART_COMPLETION_INSIGHT_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("smart-completion-insight");
        } else if (cmdId == PARAMETER_INSIGHT_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("tooltip-insight");
        } else if (cmdId == TOGGLE_COMMENTS_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("toggle-java-comments");
        } else if (cmdId == BLOCK_INDENT_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("block-indent");
        } else if (cmdId == BLOCK_OUTDENT_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("block-outdent");
        } else if (cmdId == TOGGLE_LINE_NUMBER_CMD_ID) {
            DisplayOptions options = DisplayOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            boolean showing = options.getShowLineNumbers();
            options.setShowLineNumbers(showing ^ true);
            GutterOptionsPanel.applyOptions(options);
            editorComponent.requestFocus();
        } else if (cmdId == PREFERENCES_CMD_ID) {
            View view = context.getView();
            String[] path = view instanceof CodeEditorGutter.GutterView ? new String[]{OptionsArb.getString(38), OptionsArb.getString(109)} : new String[]{OptionsArb.getString(38)};
            IdeSettings settings = Ide.getSettings();
            settings.showDialog((Frame)Ide.getMainWindow(), path);
            editorComponent.requestFocus();
        } else if (cmdId == PRINT_TO_HTML_CMD_ID) {
            Node node = context.getNode();
            URL nodeURL = node.getURL();
            String filePath = URLFileSystem.getPlatformPathName((URL)nodeURL);
            String destFilename = URLFileSystem.getFileName((URL)nodeURL);
            int lastDot = destFilename.lastIndexOf(46);
            if (lastDot != -1) {
                destFilename = destFilename.substring(0, lastDot) + "_" + destFilename.substring(lastDot + 1);
            }
            destFilename = destFilename + ".html";
            URL destPathURL = URLFileSystem.getParent((URL)nodeURL);
            if (destPathURL == null) {
                destPathURL = URLFactory.newDirURL((String)Ide.getWorkDirectory());
            }
            URL destURL = URLFactory.newURL((URL)destPathURL, (String)destFilename);
            URLChooser urlChooser = DialogUtil.newURLChooser((URL)destURL);
            String chooserTitle = CEditorArb.getString(34);
            int result = urlChooser.showSaveDialog((Component)Ide.getMainWindow(), chooserTitle);
            if (result == 0) {
                destURL = urlChooser.getSelectedURL();
                BasicDocument editorDocument = (BasicDocument)editorComponent.getDocument();
                DocumentToHTMLGenerator generator = new DocumentToHTMLGenerator(editorDocument, filePath);
                int tabSize = editorComponent.getIntegerProperty("tab-size");
                generator.setTabSize(tabSize);
                PrintingHTMLOptions printingHTMLOptions = PrintingHTMLOptions.getInstance((PropertyStorage)Preferences.getPreferences());
                PrintingHTMLOptions options = (PrintingHTMLOptions)((Object)printingHTMLOptions.copyTo(null));
                WaitCursor waitCursor = Ide.getWaitCursor();
                waitCursor.show(500);
                Node destNode = NodeFactory.find((URL)destURL);
                try {
                    if (destNode != null && destNode instanceof TextNode && destNode.isOpen()) {
                        CharArrayWriter writer = new CharArrayWriter();
                        generator.generateHTML((Writer)writer, (HTMLGeneratorOptions)options);
                        char[] htmlText = writer.toCharArray();
                        writer.close();
                        EditProcessor.doReplaceAll((char[])htmlText, (Node)destNode, (boolean)false, (String)"", (Object)this);
                    } else {
                        OutputStream outputStream = URLFileSystem.openOutputStream((URL)destURL);
                        generator.generateHTML(outputStream, (HTMLGeneratorOptions)options);
                        outputStream.close();
                    }
                }
                catch (UnsupportedEncodingException e) {
                    String errorTitle = CEditorArb.getString(14);
                    String errorMessage = CEditorArb.getString(18);
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e, (String)errorTitle, (String)errorMessage);
                }
                catch (IOException e) {
                    String errorTitle = CEditorArb.getString(14);
                    String errorMessage = CEditorArb.getString(24);
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e, (String)errorTitle, (String)errorMessage);
                }
                waitCursor.hide();
            }
        } else if (cmdId == Ide.findCmdID((String)"trim-whitespace")) {
            this.whenTrimWhitespace(context, true);
        } else {
            return false;
        }
        return true;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        View view = context.getView();
        if (view instanceof CodeEditor) {
            IdeAction prefAction = IdeAction.find((int)PREFERENCES_CMD_ID);
            JMenuItem preferencesMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)prefAction);
            popup.add((Component)preferencesMenuItem, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
            this.addSourceSubMenu(popup);
        } else if (view instanceof CodeEditorGutter.GutterView && !CodeEditorGutter.isMarkDroppingDown(context)) {
            IdeAction toggleLineNumberAction = IdeAction.find((int)TOGGLE_LINE_NUMBER_CMD_ID);
            JMenuItem toggleLineNumberMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)toggleLineNumberAction);
            popup.add((Component)toggleLineNumberMenuItem, 4.0f);
            IdeAction prefAction = IdeAction.find((int)PREFERENCES_CMD_ID);
            JMenuItem preferencesMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)prefAction);
            popup.add((Component)preferencesMenuItem, 4.0f);
        }
    }

    private void addSourceSubMenu(ContextMenu popup) {
        Context context = popup.getContext();
        View view = context.getView();
        float menuSection = view instanceof Editor ? CodeMenuConstants.SECTION_SOURCE_CTXT_MENU : CodeMenuConstants.SECTION_SOURCE_CTXT_MENU_NON_EDITOR;
        String sourceMenuLabel = CEditorArb.getString(11);
        String menuLabel = StringUtils.stripMnemonic((String)sourceMenuLabel);
        int mnemonicKeyCode = StringUtils.getMnemonicKeyCode((String)sourceMenuLabel);
        JMenu sourceMenu = popup.createSubMenu(menuLabel, new Integer(mnemonicKeyCode), Float.MAX_VALUE, menuSection);
        this.createContextSubmenu(context, sourceMenu);
        if (sourceMenu.getMenuComponentCount() > 0) {
            popup.add((Component)sourceMenu, menuSection);
        }
    }

    private void createContextSubmenu(Context context, JMenu menu) {
        Menubar ideMenuManager = Ide.getMenubar();
        JMenuBar menubar = Ide.getMainWindow().getJMenuBar();
        String sourceMenuLabel = StringUtils.stripMnemonic((String)CEditorArb.getString(11));
        JMenu sourceMenu = null;
        float section = 0.0f;
        int i = 0;
        while (i < menubar.getMenuCount()) {
            JMenu aMenu = menubar.getMenu(i);
            if (aMenu.getText().equals(sourceMenuLabel)) {
                sourceMenu = aMenu;
                break;
            }
            ++i;
        }
        if (sourceMenu != null) {
            Component[] componentArray = sourceMenu.getMenuComponents();
            int n = 0;
            while (n < componentArray.length) {
                Component menuComponent = componentArray[n];
                if (menuComponent instanceof JMenuItem) {
                    JMenuItem menuItem = (JMenuItem)menuComponent;
                    IdeAction action = (IdeAction)menuItem.getAction();
                    action.updateAction(context);
                    if (action.isEnabled()) {
                        Float clientProperty = (Float)menuItem.getClientProperty("menu-weight");
                        float menuWeight = clientProperty == null ? Float.MAX_VALUE : clientProperty.floatValue();
                        JMenuItem newMenuItem = ideMenuManager.createMenuItem((ToggleAction)action, menuWeight);
                        ideMenuManager.add((Component)newMenuItem, menu, section);
                    }
                } else {
                    section += 1.0f;
                }
                ++n;
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void deinitializeDynamicActions() {
        Ide.getMainWindow().removeDynamicMenuListener((DynamicMenuListener)this);
        this.dynamicItems = null;
    }

    private static void updateActionName(IdeAction action, String name) {
        int mnemonic = StringUtils.getMnemonicKeyCode((String)name);
        action.putValue("Name", (Object)StringUtils.stripMnemonic((String)name));
        action.putValue("MnemonicKey", (Object)new Integer(mnemonic));
    }

    private void initializeSourceMenu() {
        Menubar menubar = Ide.getMenubar();
        String sourceMenuLabel = CEditorArb.getString(11);
        JMenu sourceMenu = menubar.createMenu(StringUtils.stripMnemonic((String)sourceMenuLabel), Integer.valueOf(StringUtils.getMnemonicKeyCode((String)sourceMenuLabel)), MenuConstants.WEIGHT_SOURCE_MENU);
        this.initializeSourceActions();
        menubar.add((Component)menubar.createMenuItem((ToggleAction)IdeAction.find((int)COMPLETION_INSIGHT_CMD_ID), 100.0f), sourceMenu);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)IdeAction.find((int)SMART_COMPLETION_INSIGHT_CMD_ID), 105.0f), sourceMenu);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)IdeAction.find((int)PARAMETER_INSIGHT_CMD_ID), 110.0f), sourceMenu);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)IdeAction.find((int)TOGGLE_COMMENTS_CMD_ID), 510.0f), sourceMenu);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)IdeAction.find((int)BLOCK_INDENT_CMD_ID), 520.0f), sourceMenu);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)IdeAction.find((int)BLOCK_OUTDENT_CMD_ID), 530.0f), sourceMenu);
        menubar.add((Component)sourceMenu);
    }

    private void initializeSourceActions() {
        KeymapManager keymapManager = KeymapManager.getInstance();
        EditorKeyStrokes editorContext = keymapManager.getEditorKeyStrokes();
        COMPLETION_INSIGHT_CMD_ID = this.initializeSourceAction(editorContext, "completion-insight", 15);
        SMART_COMPLETION_INSIGHT_CMD_ID = this.initializeSourceAction(editorContext, "smart-completion-insight", 3);
        PARAMETER_INSIGHT_CMD_ID = this.initializeSourceAction(editorContext, "tooltip-insight", 10);
        TOGGLE_COMMENTS_CMD_ID = this.initializeSourceAction(editorContext, "toggle-java-comments", 22);
        BLOCK_INDENT_CMD_ID = this.initializeSourceAction(editorContext, "block-indent", 25);
        BLOCK_OUTDENT_CMD_ID = this.initializeSourceAction(editorContext, "block-outdent", 4);
    }

    private int initializeSourceAction(EditorKeyStrokes editorContext, String actionName, int arbKey) {
        IdeAction action = editorContext.lookupAction(actionName);
        int ret = action.getCommandId();
        action.addController((Controller)this);
        CodeEditorController.updateActionName(action, CEditorArb.getString(arbKey));
        return ret;
    }

    private void initializeDynamicActions() {
        this.initializeSourceActions();
        JSeparator separator1 = new JSeparator();
        separator1.putClientProperty("menu-weight", Float.valueOf(199.0f));
        JSeparator separator2 = new JSeparator();
        separator2.putClientProperty("menu-weight", Float.valueOf(299.0f));
        JSeparator separator3 = new JSeparator();
        separator3.putClientProperty("menu-weight", Float.valueOf(399.0f));
        JSeparator separator4 = new JSeparator();
        separator4.putClientProperty("menu-weight", Float.valueOf(415.0f));
        JSeparator separator5 = new JSeparator();
        separator5.putClientProperty("menu-weight", Float.valueOf(459.0f));
        JSeparator separator6 = new JSeparator();
        separator6.putClientProperty("menu-weight", Float.valueOf(499.0f));
        JSeparator separator7 = new JSeparator();
        separator7.putClientProperty("menu-weight", Float.valueOf(599.0f));
        JSeparator separator8 = new JSeparator();
        separator8.putClientProperty("menu-weight", Float.valueOf(639.0f));
        Menubar ideMenuManager = Ide.getMenubar();
        this.dynamicItems = new JComponent[]{ideMenuManager.createMenuItem((ToggleAction)IdeAction.find((int)COMPLETION_INSIGHT_CMD_ID), 100.0f), ideMenuManager.createMenuItem((ToggleAction)IdeAction.find((int)SMART_COMPLETION_INSIGHT_CMD_ID), 105.0f), ideMenuManager.createMenuItem((ToggleAction)IdeAction.find((int)PARAMETER_INSIGHT_CMD_ID), 110.0f), ideMenuManager.createMenuItem((ToggleAction)IdeAction.find((int)TOGGLE_COMMENTS_CMD_ID), 510.0f), ideMenuManager.createMenuItem((ToggleAction)IdeAction.find((int)BLOCK_INDENT_CMD_ID), 520.0f), ideMenuManager.createMenuItem((ToggleAction)IdeAction.find((int)BLOCK_OUTDENT_CMD_ID), 530.0f), separator1, separator2, separator3, separator4, separator5, separator6, separator7, separator8};
    }

    public JComponent[] gatherDynamicActions(Context context) {
        View view = context.getView();
        if (view != null && view instanceof CodeEditor) {
            return this.dynamicItems;
        }
        return new JComponent[0];
    }

    private boolean whenCut(Context context, boolean doit) {
        boolean ret = false;
        BasicEditorPane editorPane = CodeEditorController.getEditorPaneFromContext(context);
        if (editorPane != null && editorPane.canCopy() && editorPane.isEnabled()) {
            ret = true;
            if (doit) {
                editorPane.requestFocus();
                editorPane.invokeAction("cut-to-clipboard");
            }
        }
        return ret;
    }

    private boolean whenCopy(Context context, boolean doit) {
        boolean ret = false;
        BasicEditorPane editorPane = CodeEditorController.getEditorPaneFromContext(context);
        if (editorPane != null && editorPane.canCopy()) {
            ret = true;
            if (doit) {
                editorPane.requestFocus();
                editorPane.invokeAction("copy-to-clipboard");
            }
        }
        return ret;
    }

    private boolean whenPaste(Context context, boolean doit) {
        boolean ret = false;
        BasicEditorPane editorPane = CodeEditorController.getEditorPaneFromContext(context);
        if (editorPane != null && editorPane.isValidClipboardContent()) {
            ret = true;
            if (doit) {
                editorPane.requestFocus();
                editorPane.invokeAction("paste-from-clipboard");
            }
        }
        return ret;
    }

    private boolean whenPasteExtended(Context context, boolean doit) {
        boolean ret = false;
        BasicEditorPane editorPane = CodeEditorController.getEditorPaneFromContext(context);
        if (editorPane != null) {
            ret = true;
            if (doit) {
                editorPane.requestFocus();
                if (ClipboardStack.adjustCurrentClipboard()) {
                    editorPane.invokeAction("paste-from-clipboard");
                }
            }
        }
        return ret;
    }

    private boolean whenDelete(Context context, boolean doit) {
        boolean ret = false;
        BasicEditorPane editorPane = CodeEditorController.getEditorPaneFromContext(context);
        if (editorPane != null && editorPane.isEditable()) {
            ret = true;
            if (doit) {
                editorPane.requestFocus();
                editorPane.invokeAction("delete-next");
            }
        }
        return ret;
    }

    private boolean whenDuplicateSelection(Context context, boolean doit) {
        boolean ret = false;
        BasicEditorPane editorPane = CodeEditorController.getEditorPaneFromContext(context);
        if (editorPane != null && editorPane.isEditable()) {
            ret = true;
            if (doit) {
                editorPane.requestFocus();
                editorPane.invokeAction("duplicate-selection");
            }
        }
        return ret;
    }

    private boolean whenTrimWhitespace(Context context, boolean doit) {
        boolean ret = false;
        BasicEditorPane editorPane = CodeEditorController.getEditorPaneFromContext(context);
        if (editorPane != null && editorPane.isEditable()) {
            ret = true;
            if (doit) {
                editorPane.requestFocus();
                editorPane.invokeAction("trim-whitespace");
            }
        }
        return ret;
    }

    static {
        UNDO_WRAPPER_MSG = UpdateMessage.newMessageID((String)"CodeEditorController.UNDO_WRAPPER_MSG");
        _singleton = null;
    }

    static Timer ra$_delayedUpdateTimer(CodeEditorController codeEditorController) {
        return codeEditorController._delayedUpdateTimer;
    }

    static IdeAction ra$ideCopyAction(CodeEditorController codeEditorController) {
        return codeEditorController.ideCopyAction;
    }

    static IdeAction ra$ideCutAction(CodeEditorController codeEditorController) {
        return codeEditorController.ideCutAction;
    }

    private class Listener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            CodeEditorController.ra$_delayedUpdateTimer(CodeEditorController.this).stop();
            CodeEditorController.ra$ideCopyAction(CodeEditorController.this).updateAction();
            CodeEditorController.ra$ideCutAction(CodeEditorController.this).updateAction();
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

