/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Timer;
import oracle.ide.ceditor.CodeEditorController;
import oracle.ide.ceditor.NodeObserver;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;

public final class NodeUpdater
implements ActionListener,
TextBufferListener {
    private TextBuffer textBuffer;
    private Subject nodeSubject;
    private Timer timer;
    private NodeObserver observer;
    private static final int NOTIFY_TIMER_DELAY = 2000;
    private static final ArrayList updaterList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeUpdater getUpdater(Subject nodeSubject, TextBuffer textBuffer) {
        ArrayList arrayList = updaterList;
        synchronized (arrayList) {
            Iterator iterator = updaterList.iterator();
            while (iterator.hasNext()) {
                WeakReference updaterReference = (WeakReference)iterator.next();
                if (updaterReference == null || updaterReference.get() == null) {
                    iterator.remove();
                    continue;
                }
                NodeUpdater updater = (NodeUpdater)updaterReference.get();
                if (updater.textBuffer != textBuffer || updater.nodeSubject != nodeSubject) continue;
                NodeUpdater nodeUpdater = updater;
                return nodeUpdater;
            }
            NodeUpdater updater = new NodeUpdater(nodeSubject, textBuffer);
            WeakReference updaterReference = updater.observer.updaterReference;
            updaterList.add(updaterReference);
            NodeUpdater nodeUpdater = updater;
            return nodeUpdater;
        }
    }

    private NodeUpdater(Subject nodeSubject, TextBuffer textBuffer) {
        textBuffer.addTextBufferListener((TextBufferListener)this);
        this.textBuffer = textBuffer;
        this.nodeSubject = nodeSubject;
        this.timer = new Timer(2000, this);
        this.timer.setRepeats(false);
        this.observer = new NodeObserver(nodeSubject, this);
    }

    synchronized void requestCleanup() {
        if (this.textBuffer != null) {
            this.textBuffer.removeTextBufferListener((TextBufferListener)this);
            this.textBuffer = null;
        }
        this.nodeSubject = null;
        if (this.timer != null) {
            this.timer.stop();
            this.timer.removeActionListener(this);
            this.timer = null;
        }
        if (this.observer != null) {
            this.observer.respondCleanup();
            this.observer = null;
        }
    }

    protected void finalize() throws Throwable {
        this.requestCleanup();
    }

    public synchronized void actionPerformed(ActionEvent event) {
        UpdateMessage updateMessage = new UpdateMessage(CodeEditorController.UNDO_WRAPPER_MSG, null);
        this.nodeSubject.notifyObservers((Object)this.nodeSubject, updateMessage);
    }

    void startTimer() {
        this.timer.restart();
    }

    void stopTimer() {
        this.timer.stop();
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
        this.startTimer();
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
        this.startTimer();
    }

    public void attributeUpdate(TextBuffer buffer, int attribute) {
    }
}

