/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.util.List;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "FindOptions";
    private static final String MATCH_CASE = "matchCase";
    private static final String SEARCH_FROM_BEGINNING = "searchFromBeginning";
    private static final String HIGHLIGHT_OCCURRENCES = "highlightOccurrences";
    private static final String WRAP_AROUND = "wrapAround";
    private static final String WHOLE_WORD_ONLY = "wholeWordOnly";
    private static final String REGEXP_SEARCH = "regexpSearch";
    private static final String SEARCH_HIST_LIST = "searchHistoryList";
    private static final String REPLACE_HIST_LIST = "replaceHistoryList";
    private static final int MAX_HIST_SIZE = 32;

    public FindOptions() {
        this(HashStructure.newInstance());
    }

    private FindOptions(HashStructure hash) {
        super(hash);
    }

    public static FindOptions getInstance(PropertyStorage prefs) {
        return new FindOptions(FindOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public boolean getSaveOnExit() {
        return true;
    }

    public void setSaveOnExit(boolean saveOnExit) {
    }

    public boolean getMatchCase() {
        return this._hash.getBoolean(MATCH_CASE, false);
    }

    public void setMatchCase(boolean matchCase) {
        this._hash.putBoolean(MATCH_CASE, matchCase);
    }

    public boolean getSearchFromBeginning() {
        return this._hash.getBoolean(SEARCH_FROM_BEGINNING, false);
    }

    public void setSearchFromBeginning(boolean searchFromBeginning) {
        this._hash.putBoolean(SEARCH_FROM_BEGINNING, searchFromBeginning);
    }

    public boolean getHighlightOccurrences() {
        return this._hash.getBoolean(HIGHLIGHT_OCCURRENCES, false);
    }

    public void setHighlightOccurrences(boolean highlightOccurrences) {
        this._hash.putBoolean(HIGHLIGHT_OCCURRENCES, highlightOccurrences);
    }

    public boolean getWrapAround() {
        return this._hash.getBoolean(WRAP_AROUND, true);
    }

    public void setWrapAround(boolean wrapAround) {
        this._hash.putBoolean(WRAP_AROUND, wrapAround);
    }

    public boolean getWholeWordOnly() {
        return this._hash.getBoolean(WHOLE_WORD_ONLY, false);
    }

    public void setWholeWordOnly(boolean wholeWordOnly) {
        this._hash.putBoolean(WHOLE_WORD_ONLY, wholeWordOnly);
    }

    public boolean getRegexpSearch() {
        return this._hash.getBoolean(REGEXP_SEARCH, false);
    }

    public void setRegexpSearch(boolean regexpSearch) {
        this._hash.putBoolean(REGEXP_SEARCH, regexpSearch);
    }

    public List<String> getSearchHistory() {
        return this.getHistory(SEARCH_HIST_LIST);
    }

    void updateSearchHistory(String searchText) {
        this.updateHistory(SEARCH_HIST_LIST, searchText);
    }

    public List<String> getReplaceHistory() {
        return this.getHistory(REPLACE_HIST_LIST);
    }

    void updateReplaceHistory(String searchText) {
        this.updateHistory(REPLACE_HIST_LIST, searchText);
    }

    private List<String> getHistory(String key) {
        ListStructure listStructure = this._hash.getOrCreateListStructure(key);
        return listStructure;
    }

    private void updateHistory(String key, String text) {
        ListStructure listStructure = this._hash.getOrCreateListStructure(key);
        int i = listStructure.indexOf((Object)text);
        if (i == -1) {
            listStructure.add(0, (Object)text);
            int size = listStructure.size();
            if (size > 32) {
                listStructure.remove(size - 1);
            }
        } else {
            listStructure.remove(i);
            listStructure.add(0, (Object)text);
        }
    }
}

