/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.ceditor.find.FindArb;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.help.HelpSystem;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;

final class GotoLineDialog {
    private static boolean OFFSETS_UI = Boolean.getBoolean("ceditor.offsets.ui");
    private boolean offsetMode;
    private Context context;

    GotoLineDialog() {
    }

    public void performGotoLine(Context context) {
        this.context = context;
        BasicEditorPane editor = ((FindableEditor)context.getView()).getFocusedEditorPane();
        int position = editor.getCaretPosition();
        BasicDocument document = (BasicDocument)editor.getDocument();
        LineMap lineMap = document.getLineMap();
        int line = lineMap.getLineFromOffset(position) + 1;
        this.showDialog(editor, line, position);
    }

    private void goToLine(int requestedLine) {
        BasicEditorPane editor;
        block12: {
            editor = ((FindableEditor)this.context.getView()).getFocusedEditorPane();
            BasicDocument document = (BasicDocument)editor.getDocument();
            LineMap lineMap = document.getLineMap();
            if (this.offsetMode) {
                int newOffset = requestedLine;
                if (newOffset >= 0 && newOffset < document.getLength()) {
                    NavigationManager mgr = NavigationManager.getNavigationManager();
                    OffsetNavigationPoint point = new OffsetNavigationPoint(this.context, newOffset, 0);
                    try {
                        if (mgr != null) {
                            mgr.navigateTo((NavigationPoint)point);
                            break block12;
                        }
                        point.navigate();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    String badLineText = FindArb.getString(27);
                    String badLineTitle = FindArb.getString(19);
                    MessageDialog.error((Component)editor, (Object)badLineText, (String)badLineTitle, (String)"f1_idedgotolinenumbadline_html");
                }
            } else {
                int newLine = requestedLine;
                if (newLine > 0 && newLine <= lineMap.getLineCount()) {
                    int lineStart = lineMap.getLineStartOffset(--newLine);
                    NavigationManager mgr = NavigationManager.getNavigationManager();
                    OffsetNavigationPoint point = new OffsetNavigationPoint(this.context, lineStart, 0);
                    try {
                        if (mgr != null) {
                            mgr.navigateTo((NavigationPoint)point);
                            break block12;
                        }
                        point.navigate();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    String badLineText = FindArb.getString(28);
                    String badLineTitle = FindArb.getString(37);
                    MessageDialog.error((Component)editor, (Object)badLineText, (String)badLineTitle, (String)"f1_idedgotolinenumbadline_html");
                }
            }
        }
        editor.requestFocus();
    }

    public boolean canPerformGotoLine(Context context) {
        return true;
    }

    private void showDialog(BasicEditorPane editor, int currentLine, int currentOffset) {
        String gotoTitle = FindArb.getString(29);
        String lineText = FindArb.getString(44);
        String offsetText = FindArb.getString(14);
        JLabel gotoLabel = new JLabel();
        WholeNumberField gotoField = new WholeNumberField(currentLine, 6);
        gotoField.selectAll();
        ResourceUtils.resLabel((JLabel)gotoLabel, (Component)gotoField, (String)lineText);
        GhostPalette gp = new GhostPalette((JComponent)editor);
        gp.setTitle(gotoTitle);
        gp.setLook(UIConstants.Look.LIGHT);
        JPanel gotoPanel = new JPanel(new GridBagLayout());
        Locale locale = LocaleUtils.getDefaultableLocale((Component)gotoPanel);
        ResourceBundle bundle = ResourceBundle.getBundle("oracle.bali.ewt.resource.JEWTBundle", locale);
        String translatedText = bundle.getString("HELP");
        JButton helpButton = new JButton(OracleIcons.getIcon((String)"help.png"));
        helpButton.setToolTipText(StringUtils.stripMnemonic((String)translatedText));
        helpButton.setActionCommand("HELP");
        helpButton.addActionListener(new 1(this, gotoPanel));
        helpButton.setName("Help_Button");
        helpButton.setMargin(new Insets(1, 1, 0, 0));
        JButton goButton = new JButton(OracleIcons.getIcon((String)"quick_query.png"));
        goButton.setToolTipText(FindArb.getString(15));
        goButton.setActionCommand("OK");
        goButton.addActionListener(new 2(this, gotoField, gp));
        goButton.setName("OK_Button");
        goButton.setMargin(new Insets(1, 1, 0, 0));
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        String ENTER_KEY = "ENTER_KEY";
        gp.getInputMap(1).put(enter, ENTER_KEY);
        gp.getActionMap().put(ENTER_KEY, new 3(this, goButton));
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 0, 0, 0), 0, 0);
        gotoPanel.add((Component)gotoLabel, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 8, 0, 0), 0, 0);
        gotoPanel.add((Component)gotoField, constraints);
        constraints.insets.left = 8;
        constraints = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0);
        gotoPanel.add((Component)goButton, constraints);
        constraints.insets.left = 8;
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0);
        gotoPanel.add((Component)helpButton, constraints);
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic((JComponent)gotoPanel, "f1_idedgotolinenum_html");
        }
        if (OFFSETS_UI) {
            gotoField.addKeyListener((KeyListener)new 4(this, gotoLabel, gotoField, offsetText, lineText, currentOffset, currentLine, gotoPanel));
        }
        JPanel fullPanel = new JPanel(new BorderLayout(5, 5));
        fullPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 3));
        fullPanel.add((Component)gotoPanel, "Center");
        gp.setLayout((LayoutManager)new BorderLayout(0, 0));
        gp.add((Component)fullPanel, (Object)"South");
        gp.pack();
        gp.setResizable(false);
        gp.show(Ide.getMainWindow().getLayeredPane(), true, true);
    }

    static void mav$goToLine(GotoLineDialog gotoLineDialog, int n) {
        gotoLineDialog.goToLine(n);
    }

    static boolean ra$offsetMode(GotoLineDialog gotoLineDialog) {
        return gotoLineDialog.offsetMode;
    }

    static void wa$offsetMode(GotoLineDialog gotoLineDialog, boolean bl) {
        gotoLineDialog.offsetMode = bl;
    }

    final class 1
    implements ActionListener {
        private final /* synthetic */ JPanel v$gotoPanel;
        final /* synthetic */ GotoLineDialog this$0;

        public void actionPerformed(ActionEvent e) {
            HelpSystem.getHelpSystem().showHelp((JComponent)this.v$gotoPanel);
        }

        public 1(GotoLineDialog gotoLineDialog, JPanel jPanel) {
            this.v$gotoPanel = jPanel;
            this.this$0 = gotoLineDialog;
        }
    }

    final class 2
    implements ActionListener {
        private final /* synthetic */ WholeNumberField v$gotoField;
        private final /* synthetic */ GhostPalette v$gp;
        final /* synthetic */ GotoLineDialog this$0;

        public void actionPerformed(ActionEvent e) {
            try {
                GotoLineDialog.mav$goToLine(this.this$0, this.v$gotoField.getValue());
                this.v$gp.fadeInOut(false);
            }
            catch (NullPointerException npe) {
                GotoLineDialog.mav$goToLine(this.this$0, -1);
            }
        }

        public 2(GotoLineDialog gotoLineDialog, WholeNumberField wholeNumberField, GhostPalette ghostPalette) {
            this.v$gp = ghostPalette;
            this.v$gotoField = wholeNumberField;
            this.this$0 = gotoLineDialog;
        }
    }

    final class 3
    extends AbstractAction {
        private final /* synthetic */ JButton v$goButton;
        final /* synthetic */ GotoLineDialog this$0;

        public void actionPerformed(ActionEvent e) {
            this.v$goButton.doClick();
        }

        public 3(GotoLineDialog gotoLineDialog, JButton jButton) {
            this.v$goButton = jButton;
            this.this$0 = gotoLineDialog;
        }
    }

    final class 4
    extends KeyAdapter {
        private final /* synthetic */ JLabel v$gotoLabel;
        private final /* synthetic */ WholeNumberField v$gotoField;
        private final /* synthetic */ String v$offsetText;
        private final /* synthetic */ String v$lineText;
        private final /* synthetic */ int v$currentOffset;
        private final /* synthetic */ int v$currentLine;
        private final /* synthetic */ JPanel v$gotoPanel;
        final /* synthetic */ GotoLineDialog this$0;

        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() != '\u000f') {
                return;
            }
            GotoLineDialog.wa$offsetMode(this.this$0, GotoLineDialog.ra$offsetMode(this.this$0) ^ true);
            ResourceUtils.resLabel((JLabel)this.v$gotoLabel, (Component)this.v$gotoField, (String)(GotoLineDialog.ra$offsetMode(this.this$0) ? this.v$offsetText : this.v$lineText));
            this.v$gotoField.setValue(GotoLineDialog.ra$offsetMode(this.this$0) ? this.v$currentOffset : this.v$currentLine);
            this.v$gotoField.selectAll();
            this.v$gotoPanel.revalidate();
        }

        public 4(GotoLineDialog gotoLineDialog, JLabel jLabel, WholeNumberField wholeNumberField, String string, String string2, int n, int n2, JPanel jPanel) {
            this.v$gotoPanel = jPanel;
            this.v$currentLine = n2;
            this.v$currentOffset = n;
            this.v$lineText = string2;
            this.v$offsetText = string;
            this.v$gotoField = wholeNumberField;
            this.v$gotoLabel = jLabel;
            this.this$0 = gotoLineDialog;
        }
    }
}

