/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeNavigationPoint;
import oracle.ide.ceditor.find.FindArb;
import oracle.ide.ceditor.find.FindController;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.config.IdeSettings;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.editor.ActionInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.keys.MultiKeyHandler;
import oracle.javatools.editor.keys.MultiKeymap;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.search.SearchFieldBorder;

final class ISearchDialog
implements ActionInvoker,
DocumentListener,
AncestorListener {
    private static final boolean RESTORE = true;
    private static final boolean NO_RESTORE = false;
    private static final boolean REQUEST_FOCUS = true;
    private GhostPalette ghostPanel;
    private Context searchContext;
    private FindHighlightPlugin findPlugin;
    private JTextField searchField;
    private JLabel messageLabel;
    private int searchDirection;
    private static final int FORWARD = 1;
    private static final int BACKWARD = 2;
    private int anchorOffset;
    private Rectangle anchorRect;
    private int lastFoundOffset;
    private int originalOffset;
    private Rectangle originalRect;
    private MultiKeyHandler keyHandler;
    private FindController controller;
    private boolean beepedForNotFound;
    private boolean beepedForEndBuffer;
    private static final String FORWARD_ACTION = "isearch-forward";
    private static final String BACKWARD_ACTION = "isearch-backward";
    private static final String OK_ACTION = "isearch-ok";
    private static final String CANCEL_ACTION = "isearch-cancel";
    private static final int FROM_ANCHOR = 1;
    private static final int FROM_CURRENT = 2;
    private static final int FROM_NEXT = 3;
    private static final int MINIMUM_LENGTH_TO_HIGHLIGHT = 2;
    private Point lastLocation;
    private String lastSearchText;

    ISearchDialog(FindController controller) {
        this.$init$();
        this.controller = controller;
    }

    public void performISearchForward(Context context) {
        this.showDialog(context, 1);
    }

    public boolean canPerformISearchForward(Context context) {
        return true;
    }

    public void performISearchBackward(Context context) {
        this.showDialog(context, 2);
    }

    public boolean canPerformISearchBackward(Context context) {
        return true;
    }

    private void showDialog(Context context, int direction) {
        BasicEditorPane editor = ((FindableEditor)context.getView()).getFocusedEditorPane();
        if (this.ghostPanel != null && this.ghostPanel.isShowing() && this.searchField != null) {
            this.searchField.requestFocus();
            return;
        }
        this.ghostPanel = new GhostPalette((JComponent)editor);
        this.ghostPanel.setHideOnLoseFocus(true);
        this.ghostPanel.addAncestorListener((AncestorListener)this);
        FindArb.getString(48);
        this.searchField = new JTextField(30);
        this.messageLabel = new JLabel();
        this.clearMessage();
        this.messageLabel.setHorizontalTextPosition(2);
        this.messageLabel.putClientProperty(UIConstants.INSTRUCTION_LABEL, true);
        JPanel jpField = new JPanel(new BorderLayout(0, 2));
        JPanel searchBorderPanel = new JPanel(new BorderLayout());
        SearchFieldBorder fieldBorder = new SearchFieldBorder();
        searchBorderPanel.setBorder((Border)fieldBorder);
        fieldBorder.setForeground(UIConstants.getColor((String)"ghost.panel.shadow", (UIConstants.Look)UIConstants.Look.DARK));
        this.searchField.setBorder(null);
        searchBorderPanel.add(this.searchField);
        JPanel p = new JPanel(new BorderLayout(0, 2));
        p.add((Component)searchBorderPanel, "North");
        p.add((Component)this.messageLabel, "South");
        this.ghostPanel.setLayout((LayoutManager)new BorderLayout());
        this.ghostPanel.add((Component)p);
        if (this.lastLocation != null) {
            this.ghostPanel.setLocation(this.lastLocation);
        } else {
            Point editorOrigin = editor.getLocationOnScreen();
            Rectangle visibleRect = new Rectangle();
            editor.computeVisibleRect(visibleRect);
            int xPos = editorOrigin.x;
            int yPos = editorOrigin.y + visibleRect.y + visibleRect.height + 10;
            Dimension screenSize = editor.getToolkit().getScreenSize();
            int dialogHeight = this.ghostPanel.getHeight();
            int dialogWidth = this.ghostPanel.getWidth();
            int FUDGE_FACTOR = 30;
            yPos = Math.min(yPos, screenSize.height - dialogHeight - 30);
            xPos = Math.min(xPos, screenSize.width - dialogWidth - 30);
            this.ghostPanel.setLocation(xPos, yPos);
        }
        if (this.originalRect == null) {
            this.originalRect = new Rectangle();
            this.anchorRect = new Rectangle();
            this.findPlugin = new FindHighlightPlugin();
        }
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions ksOptions = ideSettings.getKeyStrokeOptions();
        KeyStrokeMap ksMap = ksOptions.getGlobalKeyMap();
        Integer iSearchForwardCmdId = new Integer(26);
        List iSearchForwardKeyStrokes = ksMap.getKeyStrokesFor(iSearchForwardCmdId);
        Integer iSearchBackwardCmdId = new Integer(27);
        List iSearchBackwardKeyStrokes = ksMap.getKeyStrokesFor(iSearchBackwardCmdId);
        if (iSearchForwardKeyStrokes.size() == 0 || iSearchBackwardKeyStrokes.size() == 0) {
            String missingShortcut = this.getMissingShortcutMessage();
            JOptionPane.showMessageDialog((Component)editor, missingShortcut);
            return;
        }
        MultiKeymap multiKeymap = new MultiKeymap();
        int numForward = iSearchForwardKeyStrokes.size();
        int i = 0;
        while (i < numForward) {
            KeyStrokes ks = (KeyStrokes)iSearchForwardKeyStrokes.get(i);
            int numKeys = ks.getLength();
            KeyStroke[] keys = new KeyStroke[numKeys];
            int j = 0;
            while (j < numKeys) {
                keys[j] = ks.getKeyStroke(j);
                ++j;
            }
            multiKeymap.put(keys, numKeys, FORWARD_ACTION);
            ++i;
        }
        int numBackward = iSearchBackwardKeyStrokes.size();
        int i2 = 0;
        while (i2 < numBackward) {
            KeyStrokes ks = (KeyStrokes)iSearchBackwardKeyStrokes.get(i2);
            int numKeys = ks.getLength();
            KeyStroke[] keys = new KeyStroke[numKeys];
            int j = 0;
            while (j < numKeys) {
                keys[j] = ks.getKeyStroke(j);
                ++j;
            }
            multiKeymap.put(keys, numKeys, BACKWARD_ACTION);
            ++i2;
        }
        KeyStroke downKey = KeyStroke.getKeyStroke("DOWN");
        KeyStroke upKey = KeyStroke.getKeyStroke("UP");
        multiKeymap.put(downKey, FORWARD_ACTION);
        multiKeymap.put(upKey, BACKWARD_ACTION);
        KeyStroke enterKey = KeyStroke.getKeyStroke("ENTER");
        KeyStroke escapeKey = KeyStroke.getKeyStroke("ESCAPE");
        multiKeymap.put(enterKey, OK_ACTION);
        multiKeymap.put(escapeKey, CANCEL_ACTION);
        this.keyHandler = new MultiKeyHandler(multiKeymap);
        this.keyHandler.install((Component)this.searchField, (ActionInvoker)this);
        this.searchContext = context;
        editor.computeVisibleRect(this.originalRect);
        this.originalOffset = editor.getCaretPosition();
        editor.computeVisibleRect(this.anchorRect);
        this.anchorOffset = this.originalOffset;
        this.lastFoundOffset = -1;
        if (this.lastSearchText != null) {
            this.searchField.setText(this.lastSearchText);
        }
        this.searchField.selectAll();
        editor.installPlugin((EditorPlugin)this.findPlugin);
        this.findPlugin.clearFindHighlighting();
        this.setDirection(direction);
        Document document = this.searchField.getDocument();
        document.addDocumentListener(this);
        this.clearMessage();
        this.ghostPanel.pack();
        this.ghostPanel.show(Ide.getMainWindow().getLayeredPane(), false, true);
        SwingUtilities.invokeLater(new 1());
        this.beepedForNotFound = false;
        this.beepedForEndBuffer = false;
    }

    private void hideDialog(boolean restoreOffset, boolean requestFocus) {
        if (this.ghostPanel == null) {
            throw new IllegalStateException("Cannot hide null dialog");
        }
        if (this.ghostPanel.isVisible()) {
            this.searchField.selectAll();
            this.ghostPanel.fadeInOut(false);
            if (requestFocus) {
                ((FindableEditor)this.searchContext.getView()).getFocusedEditorPane().requestFocus();
            }
        } else {
            this.cleanUp(restoreOffset, requestFocus);
        }
    }

    private void cleanUp(boolean restoreOffset, boolean requestFocus) {
        this.detatchSearchEditor(restoreOffset, requestFocus);
        this.lastLocation = this.ghostPanel.getLocation();
        this.lastSearchText = this.searchField.getText();
        Document document = this.searchField.getDocument();
        document.removeDocumentListener(this);
        this.findPlugin.clearFindHighlighting();
        this.ghostPanel = null;
        this.searchField = null;
        this.keyHandler.deinstall();
        this.keyHandler = null;
    }

    private void detatchSearchEditor(boolean restoreOffset, boolean requestFocus) {
        BasicEditorPane searchEditor = ((FindableEditor)this.searchContext.getView()).getFocusedEditorPane();
        if (searchEditor == null) {
            return;
        }
        searchEditor.deinstallPlugin((EditorPlugin)this.findPlugin);
        if (restoreOffset) {
            searchEditor.scrollRectToVisible(this.originalRect);
            searchEditor.setCaretPosition(this.originalOffset);
        } else {
            NavigationManager mgr = NavigationManager.getNavigationManager();
            CodeNavigationPoint point = new CodeNavigationPoint();
            point.setContext(this.searchContext);
            try {
                if (mgr != null) {
                    mgr.navigateTo((NavigationPoint)point);
                } else {
                    point.navigate();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.controller != null) {
            String text = this.searchField.getText();
            this.controller.updateSearchText(text);
        }
        if (requestFocus) {
            searchEditor.requestFocus();
        }
        this.searchContext = null;
    }

    private boolean containsUpperCase(String str) {
        int length = str.length();
        int i = 0;
        while (i < length) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void $init$() {
        this.lastLocation = null;
        this.lastSearchText = null;
    }

    private void doSearch(int fromAnchor) {
        int startOffset;
        this.clearMessage();
        String searchText = this.searchField.getText();
        BasicEditorPane searchEditor = ((FindableEditor)this.searchContext.getView()).getFocusedEditorPane();
        Document document = searchEditor.getDocument();
        int documentEnd = document.getLength() - 1;
        if (searchText.length() == 0) {
            searchEditor.scrollRectToVisible(this.anchorRect);
            searchEditor.setCaretPosition(this.anchorOffset);
            this.lastFoundOffset = -1;
            this.findPlugin.clearFindHighlighting();
            return;
        }
        boolean matchCase = this.containsUpperCase(searchText);
        boolean searchForward = this.searchDirection == 1;
        boolean wrapAround = false;
        boolean highlightOccurrences = searchText.length() >= 2;
        switch (fromAnchor) {
            case 1: {
                startOffset = this.anchorOffset;
                break;
            }
            case 2: {
                if (this.lastFoundOffset == -1) {
                    startOffset = this.anchorOffset;
                    break;
                }
                if (this.searchDirection == 1) {
                    startOffset = this.lastFoundOffset;
                    break;
                }
                int selectionStart = searchEditor.getSelectionStart();
                int selectionEnd = searchEditor.getSelectionEnd();
                int oldLength = selectionEnd - selectionStart;
                int newLength = searchText.length();
                startOffset = selectionEnd + (newLength - oldLength);
                startOffset = Math.max(0, startOffset);
                startOffset = Math.min(startOffset, documentEnd);
                break;
            }
            case 3: {
                startOffset = this.lastFoundOffset == -1 ? this.anchorOffset : (this.searchDirection == 1 ? this.lastFoundOffset + 1 : searchEditor.getSelectionEnd() - 1);
                break;
            }
            default: {
                throw new IllegalStateException("unknown from: " + fromAnchor);
            }
        }
        boolean notFound = false;
        boolean wrappedAround = false;
        int nextOffset = this.findPlugin.findText(searchText, startOffset, searchForward, matchCase, wrapAround, false, highlightOccurrences);
        if (nextOffset == -1) {
            wrappedAround = true;
            notFound = true;
            startOffset = this.searchDirection == 1 ? 0 : documentEnd;
            nextOffset = this.findPlugin.findText(searchText, startOffset, searchForward, matchCase, wrapAround, false, highlightOccurrences);
        }
        if (nextOffset != -1) {
            if (wrappedAround && !this.beepedForEndBuffer) {
                this.beepedForEndBuffer = true;
                searchEditor.getToolkit().beep();
                String message = this.searchDirection == 1 ? this.getEndBufferMessage() : this.getStartBufferMessage();
                this.showMessage(message);
                wrappedAround = false;
            } else {
                searchEditor.setCaretPositionCenter(nextOffset);
                searchEditor.moveCaretPositionCenter(nextOffset + searchText.length());
                this.lastFoundOffset = nextOffset;
                this.beepedForEndBuffer = false;
            }
            this.beepedForNotFound = false;
            notFound = false;
        }
        if (notFound) {
            if (!this.beepedForNotFound) {
                searchEditor.getToolkit().beep();
            }
            this.showMessage(this.getNotFoundMessage());
            this.beepedForNotFound = true;
        } else if (wrappedAround) {
            this.showMessage(this.getWrappedMessage());
        }
    }

    private void searchForward() {
        if (this.searchDirection == 2) {
            this.setDirection(1);
            if (this.lastFoundOffset != -1) {
                BasicEditorPane searchEditor = ((FindableEditor)this.searchContext.getView()).getFocusedEditorPane();
                this.anchorOffset = this.lastFoundOffset;
                searchEditor.computeVisibleRect(this.anchorRect);
            }
            this.clearMessage();
            return;
        }
        this.doSearch(3);
    }

    private void searchBackward() {
        if (this.searchDirection == 1) {
            this.setDirection(2);
            if (this.lastFoundOffset != -1) {
                BasicEditorPane searchEditor = ((FindableEditor)this.searchContext.getView()).getFocusedEditorPane();
                this.anchorOffset = searchEditor.getSelectionEnd();
                searchEditor.computeVisibleRect(this.anchorRect);
            }
            this.clearMessage();
            return;
        }
        this.doSearch(3);
    }

    private void setDirection(int direction) {
        this.searchDirection = direction;
        String title = null;
        switch (direction) {
            case 1: {
                title = FindArb.getString(8);
                break;
            }
            case 2: {
                title = FindArb.getString(56);
                break;
            }
            default: {
                throw new IllegalStateException("unknown direction: " + direction);
            }
        }
        this.ghostPanel.setTitle(title);
    }

    private String getNotFoundMessage() {
        return FindArb.getString(10);
    }

    private String getWrappedMessage() {
        return FindArb.getString(46);
    }

    private String getEndBufferMessage() {
        return FindArb.getString(49);
    }

    private String getStartBufferMessage() {
        return FindArb.getString(0);
    }

    private String getMissingShortcutMessage() {
        return FindArb.getString(43);
    }

    private void showMessage(String message) {
        this.messageLabel.setText(message);
    }

    private void clearMessage() {
        this.messageLabel.setText(" ");
    }

    public void insertUpdate(DocumentEvent event) {
        this.beepedForEndBuffer = false;
        this.doSearch(2);
    }

    public void removeUpdate(DocumentEvent event) {
        this.beepedForEndBuffer = false;
        this.doSearch(2);
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void invokeAction(String actionKey) {
        if (actionKey == FORWARD_ACTION) {
            this.searchForward();
        } else if (actionKey == BACKWARD_ACTION) {
            this.searchBackward();
        } else if (actionKey == OK_ACTION) {
            this.hideDialog(false, true);
        } else if (actionKey == CANCEL_ACTION) {
            this.hideDialog(true, true);
        } else {
            throw new IllegalStateException("unknown action: " + actionKey);
        }
    }

    public void ancestorRemoved(AncestorEvent event) {
        if (this.ghostPanel != null) {
            this.ghostPanel.removeAncestorListener((AncestorListener)this);
            this.cleanUp(false, false);
        }
    }

    public void ancestorAdded(AncestorEvent event) {
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    static JTextField ra$searchField(ISearchDialog iSearchDialog) {
        return iSearchDialog.searchField;
    }

    final class 1
    implements Runnable {
        public void run() {
            ISearchDialog.ra$searchField(ISearchDialog.this).requestFocus();
        }
    }
}

