/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import oracle.ide.ceditor.find.FindArb;
import oracle.ide.ceditor.find.FindController;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.controls.ButtonKeyController;
import oracle.ide.util.ResourceUtils;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.ObjectModifier;
import org.jdesktop.animation.timing.interpolation.PropertyRange;

class IncrementalOptionPanel
extends JPanel {
    private JCheckBox _matchCase;
    private JCheckBox _wholeWord;
    private JCheckBox _highlight;
    private static IncrementalOptionPanel _panel;
    private JLayeredPane layeredPane;

    private IncrementalOptionPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.WHITE);
        this._matchCase = this.buildCheckBox(FindArb.getString(36));
        this._wholeWord = this.buildCheckBox(FindArb.getString(38));
        this._highlight = this.buildCheckBox(FindArb.getString(54));
        this.add(this._matchCase);
        this.add(this._wholeWord);
        this.add(this._highlight);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        ButtonKeyController.attach((AbstractButton[])new AbstractButton[]{this._matchCase, this._wholeWord, this._highlight});
        this.loadOptions();
        FocusLossListener foculsLossListener = new FocusLossListener(null);
        this._matchCase.addFocusListener(foculsLossListener);
        this._wholeWord.addFocusListener(foculsLossListener);
        this._highlight.addFocusListener(foculsLossListener);
    }

    public static IncrementalOptionPanel getIncrementalOptionPanel() {
        if (_panel == null) {
            _panel = new IncrementalOptionPanel();
        }
        return _panel;
    }

    void show(Component reference, int x, int y) {
        JRootPane rootPane = SwingUtilities.getRootPane(reference);
        if (rootPane != null) {
            this.layeredPane = rootPane.getLayeredPane();
            this.layeredPane.add((Component)this, JLayeredPane.PALETTE_LAYER);
            this.setVisible(true);
            Point point = SwingUtilities.convertPoint(reference, x, y, this.layeredPane);
            this.setLocation(point);
            Dimension preferredSize = this.getPreferredSize();
            Dimension from = new Dimension(preferredSize.width, 0);
            Dimension to = new Dimension(preferredSize.width, preferredSize.height);
            PropertyRange range = PropertyRange.createPropertyRangeDimension((String)"size", (Dimension[])new Dimension[]{from, to});
            ObjectModifier modifier = new ObjectModifier((Object)this, range);
            1 controller = new 1(100, (TimingTarget)modifier);
            controller.start();
        }
    }

    void dismiss() {
        if (this.layeredPane != null) {
            this.setVisible(false);
            this.layeredPane.remove(this);
        }
        this.layeredPane = null;
    }

    private JCheckBox buildCheckBox(String label) {
        JCheckBox ret = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)ret, (String)label);
        ret.setOpaque(false);
        return ret;
    }

    private void loadOptions() {
        FindOptions findOptions = FindController.getFindOptions();
        this._matchCase.setSelected(findOptions.getMatchCase());
        this._wholeWord.setSelected(findOptions.getWholeWordOnly());
        this._highlight.setSelected(findOptions.getHighlightOccurrences());
    }

    void saveOptions() {
        FindOptions findOptions = FindController.getFindOptions();
        findOptions.setMatchCase(this._matchCase.isSelected());
        findOptions.setWholeWordOnly(this._wholeWord.isSelected());
        findOptions.setHighlightOccurrences(this._highlight.isSelected());
    }

    static JCheckBox ra$_matchCase(IncrementalOptionPanel incrementalOptionPanel) {
        return incrementalOptionPanel._matchCase;
    }

    static JCheckBox ra$_highlight(IncrementalOptionPanel incrementalOptionPanel) {
        return incrementalOptionPanel._highlight;
    }

    static JCheckBox ra$_wholeWord(IncrementalOptionPanel incrementalOptionPanel) {
        return incrementalOptionPanel._wholeWord;
    }

    final class 1
    extends TimingController {
        public void timingEvent(long l, long l1, float v) {
            super.timingEvent(l, l1, v);
            IncrementalOptionPanel.this.repaint();
        }

        public void end() {
            KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            FocusTraversalPolicy focusTraversalPolicy = currentKeyboardFocusManager.getDefaultFocusTraversalPolicy();
            Component firstComponent = focusTraversalPolicy.getFirstComponent(IncrementalOptionPanel.this);
            if (firstComponent != null) {
                firstComponent.requestFocus();
            }
        }

        public 1(int n, TimingTarget timingTarget) {
            super(n, timingTarget);
        }
    }

    private class FocusLossListener
    extends FocusAdapter {
        public void focusLost(FocusEvent e) {
            if (!(IncrementalOptionPanel.ra$_matchCase(IncrementalOptionPanel.this).hasFocus() || IncrementalOptionPanel.ra$_highlight(IncrementalOptionPanel.this).hasFocus() || IncrementalOptionPanel.ra$_wholeWord(IncrementalOptionPanel.this).hasFocus() || e.getOppositeComponent() == IncrementalOptionPanel.ra$_matchCase(IncrementalOptionPanel.this) || e.getOppositeComponent() == IncrementalOptionPanel.ra$_highlight(IncrementalOptionPanel.this) || e.getOppositeComponent() == IncrementalOptionPanel.ra$_wholeWord(IncrementalOptionPanel.this))) {
                IncrementalOptionPanel.this.saveOptions();
                IncrementalOptionPanel.this.dismiss();
            }
        }

        private FocusLossListener() {
        }

        FocusLossListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

