/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.find.FindArb;
import oracle.ide.ceditor.find.FindController;
import oracle.ide.ceditor.find.FindDialog;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.ceditor.find.IncrementalOptionPanel;
import oracle.ide.controls.Toolbar;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class IncrementalSearch
implements EditorPlugin {
    private static final String INCREMENTAL_SEARCH_PROPERTY = "incremental_search_property";
    private Listeners _listeners;
    private ArrayList<StackEntry> _stack;
    private BasicEditorPane _editorPane;
    private SearchField _searchField;
    private Popup _notFoundPopup;
    private IncrementalOptionPanel _optionPanel;
    private Action _showOptionsAction;

    private void $init$() {
        this._listeners = new Listeners(null);
        this._stack = new ArrayList();
    }

    public IncrementalSearch() {
        this.$init$();
    }

    public static boolean activateSearch(BasicEditorPane editorPane) {
        JTextField textField;
        boolean ret = false;
        IncrementalSearch incrementalSearch = IncrementalSearch.getIncrementalSearch(editorPane);
        if (incrementalSearch != null && (textField = IncrementalSearch.getTextField((Container)incrementalSearch._searchField)).isShowing()) {
            if (editorPane.hasFocus()) {
                String text = FindDialog.getInitialText(editorPane);
                FindController.getInstance().updateSearchText(text);
                incrementalSearch._searchField.setText(text, true);
                textField.requestFocus();
            } else {
                incrementalSearch.whenInvokeFindDialog(editorPane);
            }
            ret = true;
        }
        return ret;
    }

    private static IncrementalSearch getIncrementalSearch(BasicEditorPane editorPane) {
        return (IncrementalSearch)editorPane.getProperty(INCREMENTAL_SEARCH_PROPERTY);
    }

    private void whenInvokeFindDialog(BasicEditorPane editorPane) {
        FindController findController = FindController.getInstance();
        CodeEditor codeEditor = CodeEditor.getCodeEditor(editorPane);
        if (codeEditor != null) {
            Context context = codeEditor.getContext();
            FindOptions findOptions = FindController.getFindOptions();
            findController.invokeFindDialog(context, findOptions);
            String searchText = findController.getSearchText();
            this._searchField.setText(searchText, true);
            this._editorPane.requestFocus();
        }
    }

    private static JTextField getTextField(Container parent) {
        if (parent instanceof JTextField) {
            JTextField jTextField = (JTextField)parent;
            return jTextField;
        }
        Component[] children = parent.getComponents();
        int i = 0;
        while (i < children.length) {
            Container container;
            JTextField textField;
            Component child = children[i];
            if (child instanceof Container && (textField = IncrementalSearch.getTextField(container = (Container)child)) != null) {
                return textField;
            }
            ++i;
        }
        return null;
    }

    private void clearStack() {
        this._stack.clear();
    }

    private void navigate(String searchText) {
        int searchStart;
        int minLen = Math.min(searchText.length(), this._stack.size());
        int commonChars = 0;
        while (commonChars < minLen) {
            StackEntry entry;
            char stackChar;
            char typedChar = searchText.charAt(commonChars);
            if (typedChar != (stackChar = StackEntry.ra$_c(entry = this._stack.get(commonChars)))) break;
            ++commonChars;
        }
        boolean isShorter = false;
        int i = this._stack.size() - 1;
        while (i >= commonChars) {
            this._stack.remove(i);
            isShorter = true;
            --i;
        }
        FindOptions findOptions = FindController.getFindOptions();
        FindHighlightPlugin findHighlightPlugin = FindController.getFindHighlightPlugin(this._editorPane);
        int searchPosition = searchStart = this._editorPane.getSelectionStart();
        int searchLength = searchText.length();
        boolean highlightOccurrences = false;
        int pos = commonChars;
        while (pos < searchLength) {
            char c = searchText.charAt(pos);
            String searchedText = searchText.substring(0, pos + 1);
            if (pos > 0 && pos + 1 == searchLength) {
                highlightOccurrences = findOptions.getHighlightOccurrences();
            }
            int textPos = findHighlightPlugin.findText(searchedText, searchPosition, true, findOptions.getMatchCase(), false, findOptions.getWholeWordOnly(), highlightOccurrences);
            StackEntry entry = new StackEntry(c, textPos, searchedText.length());
            this._stack.add(entry);
            if (textPos >= 0) {
                searchPosition = textPos;
            }
            ++pos;
        }
        this.hideNotFoundTip();
        StackEntry lastEntry = this.getLastEntry();
        if (lastEntry != null) {
            if (StackEntry.ra$_position(lastEntry) >= 0) {
                this.navigateTo(StackEntry.ra$_position(lastEntry), searchText.length());
            } else {
                int textPos;
                StackEntry lastValidEntry;
                if (searchPosition != searchStart && (lastValidEntry = this.getLastValidEntry()) != null) {
                    this.navigateTo(StackEntry.ra$_position(lastValidEntry), StackEntry.ra$_matchLength(lastValidEntry));
                }
                if ((textPos = findHighlightPlugin.findText(searchText, searchPosition, true, findOptions.getMatchCase(), true, findOptions.getWholeWordOnly(), highlightOccurrences)) >= 0 && textPos != searchPosition) {
                    this.showNotFoundTip(true, true);
                } else {
                    this.showNotFoundTip(false, true);
                    if (!isShorter) {
                        this._editorPane.getToolkit().beep();
                    }
                }
            }
        } else {
            this.navigateTo(searchPosition, 0);
        }
        FindController findController = FindController.getInstance();
        findController.updateSearchText(searchText);
        this.updateSearchActions();
    }

    private void updateSearchActions() {
        CodeEditor codeEditor = CodeEditor.getCodeEditor(this._editorPane);
        codeEditor.updateVisibleActions();
    }

    private void findNext(boolean forward) {
        String searchedText = this._searchField.getText();
        if (searchedText.length() > 0) {
            int searchStart = this._editorPane.getSelectionStart();
            int searchFrom = forward ? searchStart + searchedText.length() : searchStart;
            boolean wrapAround = this._notFoundPopup != null;
            this.hideNotFoundTip();
            FindOptions findOptions = FindController.getFindOptions();
            FindHighlightPlugin findHighlightPlugin = FindController.getFindHighlightPlugin(this._editorPane);
            boolean highlightOccurrences = searchedText.length() > 1 && findOptions.getHighlightOccurrences();
            int textPos = findHighlightPlugin.findText(searchedText, searchFrom, forward, findOptions.getMatchCase(), wrapAround, findOptions.getWholeWordOnly(), highlightOccurrences);
            if (textPos >= 0) {
                this.navigateTo(textPos, searchedText.length());
            } else {
                int wrapPos = findHighlightPlugin.findText(searchedText, searchFrom, forward, findOptions.getMatchCase(), true, findOptions.getWholeWordOnly(), highlightOccurrences);
                boolean canWrap = wrapPos >= 0 && wrapPos != searchStart;
                this.showNotFoundTip(canWrap, forward);
            }
        }
    }

    private void navigateTo(int position, int matchLength) {
        this._editorPane.setCaretPositionCenter(position);
        this._editorPane.setSelectionEnd(position + matchLength);
    }

    private StackEntry getLastValidEntry() {
        int i = this._stack.size() - 1;
        while (i >= 0) {
            StackEntry entry = this._stack.get(i);
            if (StackEntry.ra$_position(entry) >= 0) {
                return entry;
            }
            --i;
        }
        return null;
    }

    private StackEntry getLastEntry() {
        int stackSize = this._stack.size();
        StackEntry lastEntry = stackSize > 0 ? this._stack.get(stackSize - 1) : null;
        return lastEntry;
    }

    private void showNotFoundTip(boolean canWrap, boolean forward) {
        this.hideNotFoundTip();
        if (this._notFoundPopup == null) {
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            Point location = new Point(0, this._searchField.getHeight());
            SwingUtilities.convertPointToScreen(location, (Component)this._searchField);
            String text = canWrap ? (forward ? FindArb.getString(51) : FindArb.getString(16)) : FindArb.getString(55);
            JLabel contents = new JLabel(text);
            contents.setOpaque(true);
            contents.setBackground(UIManager.getColor("ToolTip.background"));
            contents.setForeground(UIManager.getColor("ToolTip.foreground"));
            Border tooltipBorder = UIManager.getBorder("ToolTip.border");
            contents.setBorder(BorderFactory.createCompoundBorder(tooltipBorder, BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this._notFoundPopup = popupFactory.getPopup((Component)this._searchField, contents, location.x, location.y);
            this._notFoundPopup.show();
        }
    }

    private void hideNotFoundTip() {
        if (this._notFoundPopup != null) {
            this._notFoundPopup.hide();
            this._notFoundPopup = null;
            this._editorPane.repaint();
        }
    }

    private void showOptionPanel() {
        this.hideNotFoundTip();
        if (this._optionPanel == null) {
            this._optionPanel = IncrementalOptionPanel.getIncrementalOptionPanel();
            InputMap inputMap = this._optionPanel.getInputMap(1);
            ActionMap actionMap = this._optionPanel.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(40, 8), "showOptions");
            inputMap.put(KeyStroke.getKeyStroke(38, 8), "showOptions");
            inputMap.put(KeyStroke.getKeyStroke(10, 0), "showOptions");
            actionMap.put("showOptions", this._showOptionsAction);
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancelOptions");
            actionMap.put("cancelOptions", new MyAction('o'));
        }
        if (this._optionPanel.isShowing()) {
            this._optionPanel.dismiss();
            this._optionPanel.saveOptions();
            this._searchField.requestFocus();
            String searchText = this._searchField.getText();
            if (searchText.length() > 0) {
                this.navigate(searchText);
            }
            return;
        }
        this._optionPanel.addAncestorListener(new 1());
        this._optionPanel.show((Component)this._searchField, 3, this._searchField.getHeight() + 3);
    }

    private void hideOptionPanel() {
        JTextField textField = IncrementalSearch.getTextField((Container)this._searchField);
        textField.requestFocus();
    }

    private void whenAccept() {
        FindOptions findOptions = FindController.getFindOptions();
        String searchedText = this._searchField.getText();
        if (searchedText.length() > 0) {
            findOptions.updateSearchHistory(searchedText);
        }
        this._editorPane.requestFocus();
        this.updateSearchActions();
    }

    private void whenCancel() {
        if (this._notFoundPopup == null) {
            FindHighlightPlugin findHighlightPlugin = FindController.getFindHighlightPlugin(this._editorPane);
            findHighlightPlugin.clearFindHighlighting();
            this._editorPane.requestFocus();
            this.updateSearchActions();
        } else {
            this.hideNotFoundTip();
        }
    }

    private void whenSearchEnds() {
        this.hideNotFoundTip();
        if (this._optionPanel != null) {
            this._optionPanel.dismiss();
        }
    }

    public void install(BasicEditorPane editor) {
        Toolbar toolbar;
        CodeEditor codeEditor = CodeEditor.getCodeEditor(editor);
        if (codeEditor != null && (toolbar = codeEditor.getToolbar()) != null) {
            this._showOptionsAction = new MyAction('O');
            this._showOptionsAction.putValue("SmallIcon", OracleIcons.getIcon((String)"find.png"));
            KeyStroke keyStroke = KeyStroke.getKeyStroke("alt DOWN");
            this._showOptionsAction.putValue("AcceleratorKey", keyStroke);
            String tooltip = MessageFormat.format("Options ({0})", KeyUtil.toString((KeyStroke)keyStroke));
            this._showOptionsAction.putValue("ShortDescription", tooltip);
            this._searchField = new SearchField();
            this._searchField.setStyle(SearchField.Style.FIND);
            this._searchField.setAutoFind(true);
            Listeners listeners = this._listeners;
            this._searchField.addSearchListener((SearchListener)listeners);
            this._searchField.setPopDownAction(this._showOptionsAction);
            JTextField textField = IncrementalSearch.getTextField((Container)this._searchField);
            InputMap inputMap = textField.getInputMap(0);
            ActionMap actionMap = textField.getActionMap();
            MyAction cancelAction = new MyAction('C');
            MyAction acceptAction = new MyAction('A');
            inputMap.put(KeyStroke.getKeyStroke(10, 0), acceptAction);
            inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelAction);
            actionMap.put(acceptAction, acceptAction);
            actionMap.put(cancelAction, cancelAction);
            actionMap.put(this._showOptionsAction, this._showOptionsAction);
            textField.addFocusListener(listeners);
            Dimension preferredSize = this._searchField.getPreferredSize();
            this._searchField.setMaximumSize(new Dimension(250, preferredSize.height));
            toolbar.add((Component)this._searchField);
            codeEditor.addViewListener(this._listeners);
            this._editorPane = editor;
            editor.putProperty(INCREMENTAL_SEARCH_PROPERTY, (Object)this);
        }
    }

    public void deinstall(BasicEditorPane editor) {
        this.hideNotFoundTip();
        this.hideOptionPanel();
        CodeEditor codeEditor = CodeEditor.getCodeEditor(editor);
        if (codeEditor != null) {
            Toolbar toolbar = codeEditor.getToolbar();
            if (toolbar != null) {
                toolbar.remove((Component)this._searchField);
            }
            codeEditor.removeViewListener(this._listeners);
        }
        editor.putProperty(INCREMENTAL_SEARCH_PROPERTY, null);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    static void mav$hideNotFoundTip(IncrementalSearch incrementalSearch) {
        incrementalSearch.hideNotFoundTip();
    }

    static void mav$clearStack(IncrementalSearch incrementalSearch) {
        incrementalSearch.clearStack();
    }

    static SearchField ra$_searchField(IncrementalSearch incrementalSearch) {
        return incrementalSearch._searchField;
    }

    static JTextField maS$getTextField(Container container) {
        return IncrementalSearch.getTextField(container);
    }

    static void mav$navigate(IncrementalSearch incrementalSearch, String string) {
        incrementalSearch.navigate(string);
    }

    static void mav$findNext(IncrementalSearch incrementalSearch, boolean bl) {
        incrementalSearch.findNext(bl);
    }

    static IncrementalOptionPanel ra$_optionPanel(IncrementalSearch incrementalSearch) {
        return incrementalSearch._optionPanel;
    }

    static void mav$whenSearchEnds(IncrementalSearch incrementalSearch) {
        incrementalSearch.whenSearchEnds();
    }

    static void mav$whenAccept(IncrementalSearch incrementalSearch) {
        incrementalSearch.whenAccept();
    }

    static void mav$whenCancel(IncrementalSearch incrementalSearch) {
        incrementalSearch.whenCancel();
    }

    static void mav$showOptionPanel(IncrementalSearch incrementalSearch) {
        incrementalSearch.showOptionPanel();
    }

    final class 1
    implements AncestorListener {
        public void ancestorAdded(AncestorEvent event) {
        }

        public void ancestorMoved(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
            IncrementalSearch.ra$_optionPanel(IncrementalSearch.this).removeAncestorListener(this);
            IncrementalSearch.ra$_optionPanel(IncrementalSearch.this).saveOptions();
            String searchText = IncrementalSearch.ra$_searchField(IncrementalSearch.this).getText();
            if (searchText.length() > 0) {
                try {
                    IncrementalSearch.mav$navigate(IncrementalSearch.this, searchText);
                }
                catch (ExpiredTextBufferException expiredTextBufferException) {
                    // empty catch block
                }
            }
        }
    }

    private class Listeners
    implements SearchListener,
    FocusListener,
    PropertyChangeListener,
    ViewListener {
        private int _hasGlobalFocusListener;

        private void installFocusListener() {
            ++this._hasGlobalFocusListener;
            KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            currentKeyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this);
        }

        private void deinstallFocusListener() {
            KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            currentKeyboardFocusManager.removePropertyChangeListener("permanentFocusOwner", this);
            --this._hasGlobalFocusListener;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Component focusedComponent;
            String propertyName = evt.getPropertyName();
            if ("permanentFocusOwner".equals(propertyName) && (focusedComponent = (Component)evt.getNewValue()) != null) {
                boolean isInSearchFields = false;
                if (SwingUtilities.isDescendingFrom(focusedComponent, (Component)IncrementalSearch.ra$_searchField(IncrementalSearch.this))) {
                    isInSearchFields = true;
                } else if (IncrementalSearch.ra$_optionPanel(IncrementalSearch.this) != null && SwingUtilities.isDescendingFrom(focusedComponent, IncrementalSearch.ra$_optionPanel(IncrementalSearch.this))) {
                    isInSearchFields = true;
                }
                if (!isInSearchFields) {
                    this.deinstallFocusListener();
                    IncrementalSearch.mav$whenSearchEnds(IncrementalSearch.this);
                }
            }
        }

        public void searchPerformed(SearchEvent se) {
            if (se.isTriggeredByKeypress()) {
                String searchText = se.getSearchText();
                IncrementalSearch.mav$navigate(IncrementalSearch.this, searchText);
            } else {
                SearchEvent.Direction direction = se.getDirection();
                IncrementalSearch.mav$findNext(IncrementalSearch.this, direction == SearchEvent.Direction.FORWARD);
            }
        }

        public void searchCategoryChanged(SearchEvent se) {
        }

        public void focusGained(FocusEvent e) {
            IncrementalSearch.mav$clearStack(IncrementalSearch.this);
            IncrementalSearch.mav$hideNotFoundTip(IncrementalSearch.this);
            JTextField textField = IncrementalSearch.maS$getTextField((Container)IncrementalSearch.ra$_searchField(IncrementalSearch.this));
            textField.selectAll();
            if (this._hasGlobalFocusListener == 0) {
                this.installFocusListener();
            }
        }

        public void focusLost(FocusEvent e) {
        }

        public void viewActivated(ViewEvent e) {
        }

        public void viewDeactivated(ViewEvent e) {
            IncrementalSearch.mav$hideNotFoundTip(IncrementalSearch.this);
        }

        public void viewClosed(ViewEvent e) {
        }

        private Listeners() {
        }

        Listeners(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class MyAction
    extends AbstractAction {
        private char _type;

        public MyAction(char type) {
            this._type = type;
        }

        public void actionPerformed(ActionEvent e) {
            switch (this._type) {
                case 'A': {
                    IncrementalSearch.mav$whenAccept(IncrementalSearch.this);
                    break;
                }
                case 'C': {
                    IncrementalSearch.mav$whenCancel(IncrementalSearch.this);
                    break;
                }
                case 'O': {
                    IncrementalSearch.mav$showOptionPanel(IncrementalSearch.this);
                    break;
                }
                case 'o': {
                    IncrementalSearch.mav$showOptionPanel(IncrementalSearch.this);
                    break;
                }
            }
        }
    }

    private static class StackEntry {
        private char _c;
        private int _position;
        private int _matchLength;

        public StackEntry(char c, int position, int matchLength) {
            this._c = c;
            this._position = position;
            this._matchLength = matchLength;
        }

        static int ra$_position(StackEntry stackEntry) {
            return stackEntry._position;
        }

        static char ra$_c(StackEntry stackEntry) {
            return stackEntry._c;
        }

        static int ra$_matchLength(StackEntry stackEntry) {
            return stackEntry._matchLength;
        }
    }
}

