/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.htmlpopup;

import java.awt.Component;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import oracle.ide.ceditor.htmlpopup.ContentProvider;
import oracle.ide.ceditor.htmlpopup.HtmlPopupView;
import oracle.ide.ceditor.htmlpopup.PopupEventListener;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.popup.PopupWindow;
import oracle.javatools.editor.popup.PopupWindowListener;
import oracle.javatools.editor.popup.PopupWindowManager;

public final class HtmlPopup
implements EditorPlugin {
    private HashMap commandMap;
    private BasicEditorPane editor;
    private PopupWindow popup;
    private HtmlPopupView docPopupView;
    private final Listeners listeners;
    private static final String PLUGIN_KEY = HtmlPopup.class.getName();
    public static final String SHOW_JAVADOC_POPUP_ACTION_NAME = "show-javadoc-popup";
    private static final int UP_COMMAND = 1;
    private static final int DOWN_COMMAND = 2;
    private static final int LEFT_COMMAND = 3;
    private static final int RIGHT_COMMAND = 4;
    private static final int PAGE_UP_COMMAND = 5;
    private static final int PAGE_DOWN_COMMAND = 6;
    private static final int BEGIN_COMMAND = 7;
    private static final int END_COMMAND = 8;
    private static final int CANCEL_COMMAND = 11;
    private static final int UNKNOWN_COMMAND = 0;

    private void $init$() {
        this.listeners = new Listeners(null);
    }

    public HtmlPopup() {
        this.$init$();
    }

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        editor.putProperty(PLUGIN_KEY, (Object)this);
    }

    public void deinstall(BasicEditorPane editor) {
        this.cancelPopup();
        editor.putProperty(PLUGIN_KEY, null);
        this.editor = null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public static HtmlPopupView invokePopup(BasicEditorPane editor, ContentProvider contentProvider) {
        HtmlPopupView ret = null;
        HtmlPopup plugin = (HtmlPopup)editor.getProperty(PLUGIN_KEY);
        if (plugin != null) {
            try {
                HtmlPopupView popupView = new HtmlPopupView(contentProvider);
                int caretPosition = editor.getCaretPosition();
                Rectangle rect = editor.modelToView(caretPosition);
                plugin.showPopup(popupView, rect);
                ret = popupView;
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        return ret;
    }

    public static void cancelPopup(BasicEditorPane editor) {
        HtmlPopup plugin = (HtmlPopup)editor.getProperty(PLUGIN_KEY);
        if (plugin != null) {
            plugin.cancelPopup();
        }
    }

    private void showPopup(HtmlPopupView popupView, Rectangle caretRect) {
        if (!this.isPopupVisible()) {
            popupView.addPopupEventListener(this.listeners);
            this.docPopupView = popupView;
            this.initializeCommands();
            this.editor.addActionHookInvoker((ActionHookInvoker)this.listeners);
            PopupWindowManager pwManager = PopupWindowManager.getPopupWindowManager((BasicEditorPane)this.editor);
            this.popup = pwManager.createPopup((Component)popupView, false);
            int[] locations = new int[]{8, 4};
            pwManager.positionPopup(this.popup, caretRect, locations);
            pwManager.showPopup(this.popup, (PopupWindowListener)this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelPopup() {
        HtmlPopup htmlPopup = this;
        synchronized (htmlPopup) {
            if (this.popup != null) {
                PopupWindowManager pwManager = PopupWindowManager.getPopupWindowManager((BasicEditorPane)this.editor);
                pwManager.dismissPopup(this.popup);
                this.popup = null;
                this.docPopupView.disposePopup();
                this.docPopupView = null;
            }
        }
    }

    private boolean up() {
        if (this.docPopupView != null) {
            return this.docPopupView.up();
        }
        return false;
    }

    private boolean down() {
        if (this.docPopupView != null) {
            return this.docPopupView.down();
        }
        return false;
    }

    private boolean left() {
        if (this.docPopupView != null) {
            return this.docPopupView.left();
        }
        return false;
    }

    private boolean right() {
        if (this.docPopupView != null) {
            return this.docPopupView.right();
        }
        return false;
    }

    private boolean home() {
        if (this.docPopupView != null) {
            return this.docPopupView.home();
        }
        return false;
    }

    private boolean end() {
        if (this.docPopupView != null) {
            return this.docPopupView.end();
        }
        return false;
    }

    private boolean pageUp() {
        if (this.docPopupView != null) {
            return this.docPopupView.pageUp();
        }
        return false;
    }

    private boolean pageDown() {
        if (this.docPopupView != null) {
            return this.docPopupView.pageDown();
        }
        return false;
    }

    private boolean isPopupVisible() {
        return this.popup != null;
    }

    private int lookupCommand(String actionKey) {
        Integer command = (Integer)this.commandMap.get(actionKey);
        return command == null ? 0 : command;
    }

    private void initializeCommands() {
        if (this.commandMap == null) {
            this.commandMap = new HashMap(21);
            this.commandMap.put("caret-up", 1);
            this.commandMap.put("selection-up", 1);
            this.commandMap.put("caret-down", 2);
            this.commandMap.put("selection-down", 2);
            this.commandMap.put("caret-backward", 3);
            this.commandMap.put("selection-backward", 3);
            this.commandMap.put("caret-forward", 4);
            this.commandMap.put("selection-forward", 4);
            this.commandMap.put("page-up", 5);
            this.commandMap.put("selection-page-up", 5);
            this.commandMap.put("page-down", 6);
            this.commandMap.put("selection-page-down", 6);
            this.commandMap.put("caret-begin", 7);
            this.commandMap.put("selection-begin", 7);
            this.commandMap.put("caret-begin-line", 7);
            this.commandMap.put("selection-begin-line", 7);
            this.commandMap.put("caret-end", 8);
            this.commandMap.put("selection-end", 8);
            this.commandMap.put("caret-end-line", 8);
            this.commandMap.put("selection-end-line", 8);
            this.commandMap.put("cancel", 11);
        }
    }

    static HtmlPopupView ra$docPopupView(HtmlPopup htmlPopup) {
        return htmlPopup.docPopupView;
    }

    static Listeners ra$listeners(HtmlPopup htmlPopup) {
        return htmlPopup.listeners;
    }

    static BasicEditorPane ra$editor(HtmlPopup htmlPopup) {
        return htmlPopup.editor;
    }

    static PopupWindow ra$popup(HtmlPopup htmlPopup) {
        return htmlPopup.popup;
    }

    static void mav$cancelPopup(HtmlPopup htmlPopup) {
        htmlPopup.cancelPopup();
    }

    static void wa$popup(HtmlPopup htmlPopup, PopupWindow popupWindow) {
        htmlPopup.popup = popupWindow;
    }

    static int mav$lookupCommand(HtmlPopup htmlPopup, String string) {
        return htmlPopup.lookupCommand(string);
    }

    static boolean mav$up(HtmlPopup htmlPopup) {
        return htmlPopup.up();
    }

    static boolean mav$down(HtmlPopup htmlPopup) {
        return htmlPopup.down();
    }

    static boolean mav$left(HtmlPopup htmlPopup) {
        return htmlPopup.left();
    }

    static boolean mav$right(HtmlPopup htmlPopup) {
        return htmlPopup.right();
    }

    static boolean mav$pageUp(HtmlPopup htmlPopup) {
        return htmlPopup.pageUp();
    }

    static boolean mav$pageDown(HtmlPopup htmlPopup) {
        return htmlPopup.pageDown();
    }

    static boolean mav$home(HtmlPopup htmlPopup) {
        return htmlPopup.home();
    }

    static boolean mav$end(HtmlPopup htmlPopup) {
        return htmlPopup.end();
    }

    private class Listeners
    implements ActionHookInvoker,
    PopupEventListener,
    PopupWindowListener {
        public boolean invokeAction(String actionKey) {
            block11: {
                if (HtmlPopup.ra$docPopupView(HtmlPopup.this) == null) break block11;
                int command = HtmlPopup.mav$lookupCommand(HtmlPopup.this, actionKey);
                switch (command) {
                    case 1: {
                        return HtmlPopup.mav$up(HtmlPopup.this);
                    }
                    case 2: {
                        return HtmlPopup.mav$down(HtmlPopup.this);
                    }
                    case 3: {
                        return HtmlPopup.mav$left(HtmlPopup.this);
                    }
                    case 4: {
                        return HtmlPopup.mav$right(HtmlPopup.this);
                    }
                    case 5: {
                        return HtmlPopup.mav$pageUp(HtmlPopup.this);
                    }
                    case 6: {
                        return HtmlPopup.mav$pageDown(HtmlPopup.this);
                    }
                    case 7: {
                        return HtmlPopup.mav$home(HtmlPopup.this);
                    }
                    case 8: {
                        return HtmlPopup.mav$end(HtmlPopup.this);
                    }
                    case 11: {
                        HtmlPopup.mav$cancelPopup(HtmlPopup.this);
                        HtmlPopup.ra$editor(HtmlPopup.this).requestFocus();
                        return false;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void popupClosed(PopupWindow popupWindow, int how) {
            Listeners listeners = this;
            synchronized (listeners) {
                HtmlPopup.wa$popup(HtmlPopup.this, null);
            }
        }

        public void editorFocusGained(PopupWindow popupWindow) {
        }

        public void editorFocusLost(PopupWindow popupWindow, boolean isTemporary) {
            HtmlPopup.mav$cancelPopup(HtmlPopup.this);
        }

        public void popupCanceled() {
            HtmlPopup.mav$cancelPopup(HtmlPopup.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contentsChanged() {
            Listeners listeners = this;
            synchronized (listeners) {
                if (HtmlPopup.ra$popup(HtmlPopup.this) != null && HtmlPopup.ra$docPopupView(HtmlPopup.this) != null) {
                    PopupWindowManager pwManager = PopupWindowManager.getPopupWindowManager((BasicEditorPane)HtmlPopup.ra$editor(HtmlPopup.this));
                    pwManager.changePopupContent(HtmlPopup.ra$popup(HtmlPopup.this), (Component)HtmlPopup.ra$docPopupView(HtmlPopup.this), false);
                }
            }
        }

        public void popupClosed() {
            HtmlPopup.ra$docPopupView(HtmlPopup.this).removePopupEventListener(HtmlPopup.ra$listeners(HtmlPopup.this));
            HtmlPopup.ra$editor(HtmlPopup.this).removeActionHookInvoker((ActionHookInvoker)HtmlPopup.ra$listeners(HtmlPopup.this));
        }

        private Listeners() {
        }

        Listeners(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

