/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.htmlpopup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.PanelUI;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import oracle.ide.ceditor.htmlpopup.ContentProvider;
import oracle.ide.ceditor.htmlpopup.PopupEventListener;
import oracle.javatools.icons.OracleIcons;

public final class HtmlPopupView
extends JPanel {
    private JButton _backButton;
    private JButton _nextButton;
    private JScrollPane _scrollPane;
    private JTextPane _textPane;
    private JToolBar _toolbar;
    private Stack<ContentProvider> _back = new Stack();
    private Stack<ContentProvider> _next = new Stack();
    private ContentProvider _activeProvider;
    private final CopyOnWriteArrayList<PopupEventListener> _listeners;
    private HashMap<ContentProvider, String> _history = new HashMap();

    HtmlPopupView(ContentProvider contentProvider) {
        this._listeners = new CopyOnWriteArrayList();
        this.initialize();
        this.setActiveContentProvider(contentProvider);
        this.push(contentProvider);
    }

    public void push(ContentProvider contentProvider) {
        this.updateStack(contentProvider);
        this.formatView(contentProvider);
    }

    protected void disposePopup() {
        this.notifyClosed();
        this._back = null;
        this._next = null;
        this._activeProvider = null;
        this._history = null;
    }

    public boolean up() {
        JViewport port = this._scrollPane.getViewport();
        Rectangle aperture = port.getViewRect();
        int unit = this._textPane.getScrollableUnitIncrement(aperture, 1, -1);
        if (aperture.y > 0) {
            int y = aperture.y > unit ? aperture.y - unit : 0;
            Point scrollPoint = new Point(aperture.x, y);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    public boolean pageUp() {
        JViewport port = this._scrollPane.getViewport();
        Dimension view = port.getViewSize();
        Rectangle aperture = port.getViewRect();
        if (aperture.y > 0 && view.height > aperture.height) {
            int y = aperture.y > aperture.height ? aperture.y - aperture.height : 0;
            Point scrollPoint = new Point(aperture.x, y);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    public boolean down() {
        JViewport port = this._scrollPane.getViewport();
        Dimension view = port.getViewSize();
        Rectangle aperture = port.getViewRect();
        int unit = this._textPane.getScrollableUnitIncrement(aperture, 1, 1);
        if (view.height > aperture.height && view.height - (aperture.y + aperture.height) > 0) {
            int y = aperture.y + unit < view.height ? aperture.y + unit : view.height - aperture.height;
            Point scrollPoint = new Point(aperture.x, y);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    public boolean pageDown() {
        JViewport port = this._scrollPane.getViewport();
        Dimension view = port.getViewSize();
        Rectangle aperture = port.getViewRect();
        if (view.height > aperture.height && aperture.y < view.height - aperture.height) {
            int y = aperture.y + aperture.height < view.height ? aperture.y + aperture.height : view.height - aperture.height;
            Point scrollPoint = new Point(aperture.x, y);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    public boolean home() {
        JViewport port = this._scrollPane.getViewport();
        Rectangle aperture = port.getViewRect();
        if (aperture.x > 0 || aperture.y > 0) {
            Point scrollPoint = new Point(0, 0);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    public boolean end() {
        JViewport port = this._scrollPane.getViewport();
        Dimension view = port.getViewSize();
        Rectangle aperture = port.getViewRect();
        if (aperture.y + aperture.height < view.height || aperture.x + aperture.width < view.width) {
            Point scrollPoint = new Point(view.width - aperture.width, view.height - aperture.height);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    public boolean left() {
        JViewport port = this._scrollPane.getViewport();
        Rectangle aperture = port.getViewRect();
        int unit = this._textPane.getScrollableUnitIncrement(aperture, 0, -1);
        if (aperture.x > 0) {
            int x = aperture.x > unit ? aperture.x - unit : 0;
            Point scrollPoint = new Point(x, aperture.y);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    public boolean right() {
        JViewport port = this._scrollPane.getViewport();
        Dimension view = port.getViewSize();
        Rectangle aperture = port.getViewRect();
        int unit = this._textPane.getScrollableUnitIncrement(aperture, 0, 1);
        if (view.width > aperture.width && view.width - (aperture.x + aperture.width) > 0) {
            int x = aperture.x + unit < view.width ? aperture.x + unit : view.width - aperture.width;
            Point scrollPoint = new Point(x, aperture.y);
            port.setViewPosition(scrollPoint);
        }
        return true;
    }

    private void initialize() {
        this._textPane = new 1();
        this._textPane.setEditable(false);
        this._textPane.setDragEnabled(true);
        this._textPane.setFocusable(true);
        this._textPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        HTMLEditorKit kit = new HTMLEditorKit();
        StyleSheet styleSheet = kit.getStyleSheet();
        Style bodyStyle = styleSheet.getStyle("body");
        StyleConstants.setFontFamily(bodyStyle, "sans-serif");
        StyleConstants.setFontSize(bodyStyle, 12);
        this._textPane.setEditorKit(kit);
        Listeners listeners = new Listeners(null);
        this._textPane.addHyperlinkListener(listeners);
        this._textPane.addMouseListener(listeners);
        this._scrollPane = new 2();
        this._scrollPane.getViewport().add(this._textPane);
        this._scrollPane.setVerticalScrollBarPolicy(20);
        this._scrollPane.setHorizontalScrollBarPolicy(30);
        this._scrollPane.setBorder(null);
        this._backButton = new JButton();
        this._backButton.setIcon(OracleIcons.getIcon((String)"navigateBack.png"));
        this._backButton.setEnabled(false);
        this._backButton.setDefaultCapable(false);
        this._nextButton = new JButton();
        this._nextButton.setIcon(OracleIcons.getIcon((String)"navigateForward.png"));
        this._nextButton.setEnabled(false);
        this._nextButton.setDefaultCapable(false);
        this._toolbar = new JToolBar();
        this._toolbar.setFloatable(false);
        this._toolbar.setRollover(true);
        this._toolbar.setVisible(false);
        this._toolbar.add(this._backButton);
        this._toolbar.add(this._nextButton);
        this.setBorder(UIManager.getBorder("ToolTip.border"));
        this.setLayout(new BorderLayout());
        this.add((Component)this._toolbar, "North");
        this.add((Component)this._scrollPane, "Center");
        this._backButton.addActionListener(listeners);
        this._nextButton.addActionListener(listeners);
        this.setupActionMap();
    }

    public void setUI(PanelUI ui) {
        super.setUI(ui);
        LookAndFeel.installColorsAndFont(this, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
    }

    private void setupActionMap() {
        InputMap inputMap = this._textPane.getInputMap(2);
        ActionMap actionMap = new ActionMap();
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        3 action = new 3("cancel");
        inputMap.put(ks, action);
        actionMap.put(action.toString(), action);
    }

    private void setActiveContentProvider(ContentProvider contentProvider) {
        this._activeProvider = contentProvider;
    }

    private void updateStack(ContentProvider contentProvider) {
        boolean isError;
        if (!(this._activeProvider == null || this._activeProvider.equals(contentProvider) || !this._back.empty() && this._activeProvider.equals(this._back.peek()))) {
            this._toolbar.setVisible(true);
            this._back.push(this._activeProvider);
        } else {
            this._toolbar.setVisible(false);
        }
        boolean bl = isError = contentProvider == null || contentProvider.isError();
        if (!isError) {
            this.setActiveContentProvider(contentProvider);
            this._next.clear();
        }
        this._backButton.setEnabled(this._back.empty() ^ true);
        this._nextButton.setEnabled(!isError && !this._next.empty());
    }

    private void formatView(ContentProvider contentProvider) {
        String message;
        boolean containsKey = this._history.containsKey(contentProvider);
        if (containsKey) {
            message = this._history.get(contentProvider);
        } else {
            message = contentProvider.getHTML();
            this._history.put(contentProvider, message);
        }
        StringBuffer data = new StringBuffer(5000);
        data.append("<body>");
        data.append(message);
        data.append("</body>");
        this._textPane.setText(data.toString());
        this._textPane.setCaretPosition(0);
        SwingUtilities.invokeLater(new 4());
    }

    public void addPopupEventListener(PopupEventListener listener) {
        this._listeners.add(listener);
    }

    public void removePopupEventListener(PopupEventListener listener) {
        this._listeners.remove(listener);
    }

    private void notifyCanceled() {
        for (PopupEventListener popupEventListener : this._listeners) {
            popupEventListener.popupCanceled();
        }
    }

    private void notifyContentsChanged() {
        for (PopupEventListener popupEventListener : this._listeners) {
            popupEventListener.contentsChanged();
        }
    }

    private void notifyClosed() {
        for (PopupEventListener popupEventListener : this._listeners) {
            popupEventListener.popupClosed();
        }
    }

    static JButton ra$_backButton(HtmlPopupView htmlPopupView) {
        return htmlPopupView._backButton;
    }

    static Stack ra$_back(HtmlPopupView htmlPopupView) {
        return htmlPopupView._back;
    }

    static ContentProvider ra$_activeProvider(HtmlPopupView htmlPopupView) {
        return htmlPopupView._activeProvider;
    }

    static Stack ra$_next(HtmlPopupView htmlPopupView) {
        return htmlPopupView._next;
    }

    static void mav$setActiveContentProvider(HtmlPopupView htmlPopupView, ContentProvider contentProvider) {
        htmlPopupView.setActiveContentProvider(contentProvider);
    }

    static void mav$formatView(HtmlPopupView htmlPopupView, ContentProvider contentProvider) {
        htmlPopupView.formatView(contentProvider);
    }

    static JButton ra$_nextButton(HtmlPopupView htmlPopupView) {
        return htmlPopupView._nextButton;
    }

    static void mav$notifyContentsChanged(HtmlPopupView htmlPopupView) {
        htmlPopupView.notifyContentsChanged();
    }

    static void mav$notifyCanceled(HtmlPopupView htmlPopupView) {
        htmlPopupView.notifyCanceled();
    }

    final class 1
    extends JTextPane {
        public Dimension getPreferredScrollableViewportSize() {
            Dimension d = super.getPreferredScrollableViewportSize();
            d.height = Math.min(300, d.height);
            return d;
        }
    }

    final class 2
    extends JScrollPane {
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = 530;
            return d;
        }

        public boolean isValidateRoot() {
            return false;
        }
    }

    final class 3
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            HtmlPopupView.mav$notifyCanceled(HtmlPopupView.this);
        }

        public 3(String string) {
            super(string);
        }
    }

    final class 4
    implements Runnable {
        public void run() {
            HtmlPopupView.mav$notifyContentsChanged(HtmlPopupView.this);
        }
    }

    private class Listeners
    extends MouseAdapter
    implements ActionListener,
    HyperlinkListener {
        public void mouseClicked(MouseEvent e) {
            e.getComponent().getParent().requestFocus();
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String href = e.getDescription();
                HtmlPopupView.ra$_activeProvider(HtmlPopupView.this).navigate(HtmlPopupView.this, href);
            }
        }

        public void actionPerformed(ActionEvent event) {
            Object b = event.getSource();
            if (b == HtmlPopupView.ra$_backButton(HtmlPopupView.this)) {
                if (((ContentProvider)HtmlPopupView.ra$_back(HtmlPopupView.this).peek()).equals(HtmlPopupView.ra$_activeProvider(HtmlPopupView.this))) {
                    HtmlPopupView.ra$_back(HtmlPopupView.this).pop();
                } else {
                    HtmlPopupView.ra$_next(HtmlPopupView.this).push(HtmlPopupView.ra$_activeProvider(HtmlPopupView.this));
                    HtmlPopupView.mav$setActiveContentProvider(HtmlPopupView.this, (ContentProvider)HtmlPopupView.ra$_back(HtmlPopupView.this).pop());
                }
                HtmlPopupView.mav$formatView(HtmlPopupView.this, HtmlPopupView.ra$_activeProvider(HtmlPopupView.this));
            } else if (b == HtmlPopupView.ra$_nextButton(HtmlPopupView.this)) {
                HtmlPopupView.ra$_back(HtmlPopupView.this).push(HtmlPopupView.ra$_activeProvider(HtmlPopupView.this));
                HtmlPopupView.mav$setActiveContentProvider(HtmlPopupView.this, (ContentProvider)HtmlPopupView.ra$_next(HtmlPopupView.this).pop());
                HtmlPopupView.mav$formatView(HtmlPopupView.this, HtmlPopupView.ra$_activeProvider(HtmlPopupView.this));
            }
            HtmlPopupView.ra$_backButton(HtmlPopupView.this).setEnabled(HtmlPopupView.ra$_back(HtmlPopupView.this).empty() ^ true);
            HtmlPopupView.ra$_nextButton(HtmlPopupView.this).setEnabled(HtmlPopupView.ra$_next(HtmlPopupView.this).empty() ^ true);
        }

        private Listeners() {
        }

        Listeners(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

