/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.keymap;

import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

abstract class KeymapHelper
implements EditorPlugin {
    private WeakReference reference = new WeakReference<KeymapHelper>(this);
    private BasicEditorPane editor;

    KeymapHelper() {
    }

    protected void keymapChanged() {
        if (this.editor != null) {
            this.deinstallKeymap();
            this.installKeymap();
        }
    }

    final WeakReference getWeakReference() {
        return this.reference;
    }

    protected abstract void installKeymap();

    protected abstract void deinstallKeymap();

    public void install(BasicEditorPane editor) {
        if (this.reference.get() == null) {
            throw new IllegalStateException("empty reference on install()");
        }
        this.editor = editor;
        this.installKeymap();
    }

    public void deinstall(BasicEditorPane editor) {
        this.deinstallKeymap();
        this.reference.clear();
        this.editor = null;
    }

    protected BasicEditorPane getEditor() {
        return this.editor;
    }

    public void propertyChange(PropertyChangeEvent event) {
    }
}

