/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.keymap;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import oracle.ide.ceditor.keymap.KeymapHelper;
import oracle.ide.ceditor.keymap.KeymapManager;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.javatools.editor.ActionInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.keys.MultiKeyHandler;
import oracle.javatools.editor.keys.MultiKeymap;

final class StandaloneKeymapHelper
extends KeymapHelper
implements ActionInvoker {
    private MultiKeyHandler keyHandler;
    private KeyStrokeContext[] localContexts;
    private Map localActionMap;

    StandaloneKeymapHelper() {
        this(null);
    }

    StandaloneKeymapHelper(KeyStrokeContext[] keystrokeContexts) {
        this.localContexts = keystrokeContexts;
        this.localActionMap = null;
    }

    protected void installKeymap() {
        BasicEditorPane editor = this.getEditor();
        if (editor != null) {
            KeymapManager keymapManager = KeymapManager.getInstance();
            MultiKeymap keymap = keymapManager.getStandaloneKeymap();
            if (this.localContexts == null) {
                this.keyHandler = new MultiKeyHandler(keymap);
                this.keyHandler.install((Component)editor, (ActionInvoker)this);
            } else {
                MultiKeymap[] extendedKeymap_in = new MultiKeymap[1];
                Map[] extendedActionMap_in = new Map[1];
                keymapManager.buildExtendedMaps(this.localContexts, extendedKeymap_in, extendedActionMap_in);
                MultiKeymap extendedKeymap = extendedKeymap_in[0];
                extendedKeymap.setParent(keymap);
                this.localActionMap = extendedActionMap_in[0];
                this.keyHandler = new MultiKeyHandler(extendedKeymap);
                this.keyHandler.install((Component)editor, (ActionInvoker)this);
            }
        }
    }

    protected void deinstallKeymap() {
        if (this.keyHandler != null) {
            this.keyHandler.deinstall();
            this.keyHandler = null;
        }
        this.localActionMap = null;
    }

    public void invokeAction(String actionKey) {
        BasicEditorPane editor = this.getEditor();
        boolean preHandled = editor.preInvokeAction(actionKey);
        if (!preHandled) {
            IdeAction action;
            if (this.localActionMap != null && (action = (IdeAction)this.localActionMap.get(actionKey)) != null) {
                ActionEvent event = new ActionEvent(editor, 1001, null);
                action.actionPerformed(event);
                return;
            }
            editor.invokeAction(actionKey);
        }
    }
}

