/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.macrorecorder;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.macrorecorder.MacroEvent;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;

final class MacroController
implements AWTEventListener,
Controller,
Runnable {
    private static final int TOGGLE_CMD_ID = Ide.findOrCreateCmdID((String)"MacroRecord");
    private IdeAction toggleAction;
    private static final int PLAYBACK_CMD_ID = Ide.findOrCreateCmdID((String)"MacroPlay");
    private IdeAction playbackAction;
    private Window activeWindow;
    private Thread playbackThread;
    private boolean shutdown;
    private List macroList;
    private boolean recording;
    private boolean playing;

    MacroController() {
        this.$init$();
        this.toggleAction = IdeAction.get((int)TOGGLE_CMD_ID, null, (String)"Toggle Macro Recording", (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, null, null, (boolean)false);
        this.toggleAction.addController((Controller)this);
        this.toggleAction.setEnabled(true);
        this.playbackAction = IdeAction.get((int)PLAYBACK_CMD_ID, null, (String)"Play Recorded Macro", (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, null, null, (boolean)false);
        this.playbackAction.addController((Controller)this);
        this.playbackAction.setEnabled(false);
        Menubar menuManager = Ide.getMenubar();
        JMenuItem toggleItem = menuManager.createMenuItem((ToggleAction)this.toggleAction);
        JMenuItem playbackItem = menuManager.createMenuItem((ToggleAction)this.playbackAction);
        JMenu toolsMenu = MenuManager.getJMenu((String)"Tools");
        toolsMenu.addSeparator();
        toolsMenu.add(toggleItem);
        toolsMenu.add(playbackItem);
        long mask = 72;
        Toolkit.getDefaultToolkit().addAWTEventListener(this, mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void shutdown() {
        if (this.playbackThread != null) {
            Thread thread = this.playbackThread;
            synchronized (thread) {
                this.shutdown = true;
                this.playbackThread.notify();
            }
        }
    }

    private void $init$() {
        this.activeWindow = null;
        this.playbackThread = null;
        this.shutdown = false;
        this.macroList = null;
        this.recording = false;
        this.playing = false;
    }

    private synchronized void toggleRecording() {
        if (this.playing) {
            return;
        }
        if (this.recording) {
            this.recording = false;
            this.playbackAction.setEnabled(true);
        } else {
            this.recording = true;
            this.playbackAction.setEnabled(false);
            if (this.macroList == null) {
                this.macroList = new ArrayList();
            }
        }
    }

    private synchronized void playbackRecording() {
        if (this.recording) {
            return;
        }
        this.playing = true;
        this.toggleAction.setEnabled(false);
        this.playbackAction.setEnabled(false);
        this.playbackThread = new Thread(this);
        this.playbackThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        System.out.println("Playback thread started");
        Thread thread = this.playbackThread;
        synchronized (thread) {
            System.out.println("Beginning initial sleep");
            this.sleep(this.playbackThread, 100);
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            int numEvents = this.macroList.size();
            int i = 0;
            while (i < numEvents) {
                if (this.shutdown) break;
                MacroEvent recordedEvent = (MacroEvent)this.macroList.get(i);
                KeyEvent keyEvent = recordedEvent.getKeyEvent(this.activeWindow);
                eventQueue.postEvent(keyEvent);
                System.out.println("Posted key event type: " + keyEvent.getID());
                System.out.println("old source class: " + recordedEvent.source.getClass().getName());
                long sleepTime = 25;
                if (i + 1 < numEvents) {
                    MacroEvent nextEvent = (MacroEvent)this.macroList.get(i + 1);
                    long interval = nextEvent.when - recordedEvent.when;
                    sleepTime = Math.max(sleepTime, interval);
                }
                System.out.println("sleeping for: " + sleepTime);
                this.sleep(this.playbackThread, sleepTime);
                ++i;
            }
        }
        System.out.println("playback complete");
        this.playing = false;
        this.toggleAction.setEnabled(true);
        this.playbackAction.setEnabled(true);
        this.playbackThread = null;
    }

    private void sleep(Object object, long milliseconds) {
        try {
            object.wait(milliseconds);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public synchronized void eventDispatched(AWTEvent event) {
        block9: {
            Component source;
            int eventID;
            block8: {
                eventID = event.getID();
                source = (Component)event.getSource();
                if (eventID < 200 || eventID > 209) break block8;
                switch (eventID) {
                    case 205: {
                        this.activeWindow = (Window)source;
                        break;
                    }
                    case 206: {
                        if (source == this.activeWindow) {
                            this.activeWindow = null;
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block9;
            }
            if (eventID >= 400 && eventID <= 402) {
                if (this.activeWindow == null) {
                    this.activeWindow = SwingUtilities.getWindowAncestor(source);
                }
                if (this.recording && event instanceof KeyEvent) {
                    MacroEvent recordedEvent = new MacroEvent((KeyEvent)event);
                    this.macroList.add(recordedEvent);
                }
            }
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (action == this.toggleAction) {
            this.toggleRecording();
            return true;
        }
        if (action == this.playbackAction) {
            this.playbackRecording();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action == this.toggleAction) {
            action.setEnabled(this.playing ^ true);
            return true;
        }
        if (action == this.playbackAction) {
            action.setEnabled(!this.recording && !this.playing && this.macroList != null);
            return true;
        }
        return false;
    }
}

