/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class DisplayOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener,
ChangeListener {
    private JCheckBox checkBox_showCodeFoldingMargin;
    private JCheckBox checkBox_showCodeFoldingHighlight;
    private JCheckBox checkBox_showWhitespaceChars;
    private WholeNumberField textField_rightMarginColumn;
    private JCheckBox checkBox_showRightMargin;
    private CustomColorChoice colorChoice_rightMarginColor;
    private JCheckBox checkBox_autoBraceMatch;
    private JCheckBox checkBox_braceEnclosingBlock;
    private JCheckBox checkBox_braceEnclosingParens;
    private JSlider slider_braceMatchDelay;
    private JLabel label_braceMatchDelayText;
    private NumberFormat numberFormatter;
    private JCheckBox checkBox_useAAText;
    private JCheckBox checkBox_showBreadcrumbs;
    private JCheckBox checkBox_usePeek;

    public DisplayOptionsPanel() {
        this.setHelpID("f1_idedidesetdisplay_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        DisplayOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        DisplayOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private DisplayOptions findOptions(TraversableContext tc) {
        DisplayOptions options = DisplayOptions.getInstance(tc.getPropertyStorage());
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        DisplayOptions options = this.findOptions(tc);
        DisplayOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(DisplayOptions options) {
        EditorProperties properties = EditorProperties.getProperties();
        boolean showCodeFoldingMargin = options.getShowCodeFoldingMargin();
        properties.putBooleanProperty("code-folding-margin-visible", showCodeFoldingMargin);
        boolean showCodeFoldingHighlight = options.getShowCodeFoldingHighlight();
        properties.putBooleanProperty("code-folding-highlight", showCodeFoldingHighlight);
        boolean codeFoldingEnabled = options.getCodeFoldingEnabled();
        properties.putBooleanProperty("code-folding-enabled", codeFoldingEnabled);
        boolean showRightMargin = options.getShowRightMargin();
        properties.putBooleanProperty("right-margin-visible", showRightMargin);
        int rightMarginColumn = options.getRightMarginColumn();
        properties.putIntegerProperty("right-margin-column", rightMarginColumn);
        int rightMarginColorRGB = options.getRightMarginColor();
        Color rightMarginColor = new Color(rightMarginColorRGB);
        properties.putProperty("right-margin-color", (Object)rightMarginColor);
        boolean autoBraceMatch = options.getAutoBraceMatch();
        boolean braceEnclosingBlock = options.getBraceEnclosingBlock();
        boolean braceEnclosingParens = options.getBraceEnclosingParens();
        int braceMatchDelay = options.getBraceMatchDelay();
        properties.putBooleanProperty("brace-matching-auto", autoBraceMatch);
        properties.putBooleanProperty("brace-matching-enclosing-blocks", braceEnclosingBlock);
        properties.putBooleanProperty("brace-matching-enclosing-parens", braceEnclosingParens);
        properties.putIntegerProperty("brace-matching-delay", braceMatchDelay);
        if (!DisplayOptionsPanel.hasAntialiasProperty()) {
            boolean useAAText = options.getUseAAText();
            properties.putBooleanProperty("editor-antialiasing", useAAText);
        }
        boolean showWhitespaceChars = options.getShowWhitespaceChars();
        properties.putBooleanProperty("show-whitespace-chars", showWhitespaceChars);
    }

    private static boolean hasAntialiasProperty() {
        EditorProperties properties = EditorProperties.getProperties();
        return properties.getBooleanProperty("editor-antialiasing-set");
    }

    public void stateChanged(ChangeEvent event) {
        float value = (float)this.slider_braceMatchDelay.getValue() / 10.0f;
        String valueStr = OptionsArb.format(40, this.numberFormatter.format(value));
        this.slider_braceMatchDelay.setToolTipText(valueStr);
        this.label_braceMatchDelayText.setText(valueStr);
    }

    void loadSettingsFrom(DisplayOptions options) {
        boolean showCodeFoldingMargin = options.getShowCodeFoldingMargin();
        boolean showCodeFoldingHighlight = options.getShowCodeFoldingHighlight();
        boolean showRightMargin = options.getShowRightMargin();
        int rightMarginColumn = options.getRightMarginColumn();
        int rightMarginColor = options.getRightMarginColor();
        this.checkBox_showCodeFoldingMargin.setSelected(showCodeFoldingMargin);
        this.checkBox_showCodeFoldingHighlight.setSelected(showCodeFoldingHighlight);
        this.checkBox_showRightMargin.setSelected(showRightMargin);
        this.textField_rightMarginColumn.setText(Integer.toString(rightMarginColumn));
        this.colorChoice_rightMarginColor.setClosestSelectedColor(new Color(rightMarginColor));
        boolean autoBraceMatch = options.getAutoBraceMatch();
        boolean braceEnclosingBlock = options.getBraceEnclosingBlock();
        boolean braceEnclosingParens = options.getBraceEnclosingParens();
        int braceMatchDelay = options.getBraceMatchDelay();
        this.checkBox_autoBraceMatch.setSelected(autoBraceMatch);
        this.checkBox_braceEnclosingBlock.setSelected(braceEnclosingBlock);
        this.checkBox_braceEnclosingParens.setSelected(braceEnclosingParens);
        this.slider_braceMatchDelay.setValue(braceMatchDelay / 100);
        boolean useAAText = options.getUseAAText();
        this.checkBox_useAAText.setSelected(useAAText);
        this.checkBox_showBreadcrumbs.setSelected(options.getShowBreadcrumbs());
        this.checkBox_showWhitespaceChars.setSelected(options.getShowWhitespaceChars());
        this.checkBox_usePeek.setSelected(options.getUsePeek());
    }

    void saveSettingsTo(DisplayOptions options) throws TraversalException {
        int rightMarginColumn;
        try {
            rightMarginColumn = this.textField_rightMarginColumn.getValue();
        }
        catch (NullPointerException e) {
            rightMarginColumn = -1;
        }
        if (rightMarginColumn < 10 || rightMarginColumn > 200) {
            String rightMarginError = OptionsArb.getString(180);
            String rightMarginTitle = OptionsArb.getString(102);
            this.showErrorDialog(rightMarginError, rightMarginTitle);
            this.textField_rightMarginColumn.selectAll();
            this.textField_rightMarginColumn.requestFocus();
            throw new TraversalException(null);
        }
        boolean showCodeFoldingMargin = this.checkBox_showCodeFoldingMargin.isSelected();
        boolean showCodeFoldingHighlight = this.checkBox_showCodeFoldingHighlight.isSelected();
        boolean showRightMargin = this.checkBox_showRightMargin.isSelected();
        Color rightMarginColor = this.colorChoice_rightMarginColor.getSelectedColor();
        boolean showWhitespace = this.checkBox_showWhitespaceChars.isSelected();
        options.setShowCodeFoldingMargin(showCodeFoldingMargin);
        options.setShowCodeFoldingHighlight(showCodeFoldingHighlight);
        options.setRightMarginColumn(rightMarginColumn);
        options.setShowRightMargin(showRightMargin);
        options.setRightMarginColor(rightMarginColor.getRGB());
        options.setShowWhitespaceChars(showWhitespace);
        boolean autoBraceMatch = this.checkBox_autoBraceMatch.isSelected();
        boolean braceEnclosingBlock = this.checkBox_braceEnclosingBlock.isSelected();
        boolean braceEnclosingParens = this.checkBox_braceEnclosingParens.isSelected();
        int braceMatchDelay = this.slider_braceMatchDelay.getValue() * 100;
        options.setAutoBraceMatch(autoBraceMatch);
        options.setBraceEnclosingBlock(braceEnclosingBlock);
        options.setBraceEnclosingParens(braceEnclosingParens);
        options.setBraceMatchDelay(braceMatchDelay);
        boolean useAAText = this.checkBox_useAAText.isSelected();
        options.setUseAAText(useAAText);
        options.setShowBreadcrumbs(this.checkBox_showBreadcrumbs.isSelected());
        options.setUsePeek(this.checkBox_usePeek.isSelected());
    }

    private void showErrorDialog(String message, String title) {
        JOptionPane.showMessageDialog((Component)((Object)this), message, title, 2);
    }

    private void initializeComponent() {
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(1);
        String showCodeFoldingMarginText = OptionsArb.getString(150);
        this.checkBox_showCodeFoldingMargin = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_showCodeFoldingMargin, (String)showCodeFoldingMarginText);
        String showCodeFoldingHighlightText = OptionsArb.getString(53);
        this.checkBox_showCodeFoldingHighlight = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_showCodeFoldingHighlight, (String)showCodeFoldingHighlightText);
        Component[] dependents = new Component[]{this.checkBox_showCodeFoldingHighlight};
        ItemSelectableTracker tracker = new ItemSelectableTracker((ItemSelectable)this.checkBox_showCodeFoldingMargin, dependents);
        String showRightMarginText = OptionsArb.getString(3);
        this.checkBox_showRightMargin = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_showRightMargin, (String)showRightMarginText);
        String rightMarginColumnText = OptionsArb.getString(9);
        JLabel label_rightMarginColumn = new JLabel();
        this.textField_rightMarginColumn = new WholeNumberField(5);
        this.textField_rightMarginColumn.setHorizontalAlignment(4);
        ResourceUtils.resLabel((JLabel)label_rightMarginColumn, (Component)this.textField_rightMarginColumn, (String)rightMarginColumnText);
        String rightMarginColorText = OptionsArb.getString(138);
        JLabel label_rightMarginColor = new JLabel();
        this.colorChoice_rightMarginColor = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)label_rightMarginColor, (Component)this.colorChoice_rightMarginColor, (String)rightMarginColorText);
        dependents = new Component[]{this.textField_rightMarginColumn, label_rightMarginColumn, label_rightMarginColor, this.colorChoice_rightMarginColor};
        tracker = new ItemSelectableTracker((ItemSelectable)this.checkBox_showRightMargin, dependents);
        String autoBraceMatchText = OptionsArb.getString(60);
        this.checkBox_autoBraceMatch = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_autoBraceMatch, (String)autoBraceMatchText);
        String braceEnclosingBlockText = OptionsArb.getString(37);
        this.checkBox_braceEnclosingBlock = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_braceEnclosingBlock, (String)braceEnclosingBlockText);
        String showWhitespaceChars = OptionsArb.getString(151);
        this.checkBox_showWhitespaceChars = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_showWhitespaceChars, (String)showWhitespaceChars);
        String braceEnclosingParensText = OptionsArb.getString(1);
        this.checkBox_braceEnclosingParens = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_braceEnclosingParens, (String)braceEnclosingParensText);
        String braceMatchDelayText = OptionsArb.getString(36);
        JLabel label_braceMatchDelay = new JLabel();
        this.slider_braceMatchDelay = new JSlider(1, 20, 2);
        this.slider_braceMatchDelay.addChangeListener(this);
        this.label_braceMatchDelayText = new JLabel();
        ResourceUtils.resLabel((JLabel)label_braceMatchDelay, (Component)this.slider_braceMatchDelay, (String)braceMatchDelayText);
        String minValue = "Faster";
        String maxValue = "Slower";
        JLabel label_minValue = new JLabel(minValue);
        JLabel label_maxValue = new JLabel(maxValue);
        this.slider_braceMatchDelay.setPaintLabels(false);
        this.slider_braceMatchDelay.setPaintTicks(true);
        this.slider_braceMatchDelay.setMajorTickSpacing(10);
        this.slider_braceMatchDelay.setMinorTickSpacing(1);
        this.slider_braceMatchDelay.setSnapToTicks(true);
        dependents = new Component[]{this.slider_braceMatchDelay, label_braceMatchDelay, this.label_braceMatchDelayText, label_minValue, label_maxValue, this.checkBox_braceEnclosingBlock, this.checkBox_braceEnclosingParens};
        tracker = new ItemSelectableTracker((ItemSelectable)this.checkBox_autoBraceMatch, dependents);
        this.checkBox_autoBraceMatch.addItemListener((ItemListener)tracker);
        this.slider_braceMatchDelay.setValue(1);
        this.checkBox_usePeek = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_usePeek, (String)OptionsArb.getString(43));
        String useAAText = OptionsArb.getString(100);
        this.checkBox_useAAText = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useAAText, (String)useAAText);
        String showBreadcrumbsText = OptionsArb.getString(128);
        this.checkBox_showBreadcrumbs = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_showBreadcrumbs, (String)showBreadcrumbsText);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        Insets defaultInsets = new Insets(0, 0, 2, 5);
        Insets indentedInsets = new Insets(0, 18, 2, 5);
        Insets indentedHeaderInsets = new Insets(0, 18, 7, 5);
        JPanel panel_margin = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_margin.add((Component)this.checkBox_showRightMargin, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_margin.add((Component)label_rightMarginColumn, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_margin.add((Component)this.textField_rightMarginColumn, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_margin.add((Component)label_rightMarginColor, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_margin.add((Component)this.colorChoice_rightMarginColor, constraints);
        JPanel panel_brace = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_brace.add((Component)this.checkBox_autoBraceMatch, constraints);
        constraints = new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_brace.add((Component)this.checkBox_braceEnclosingBlock, constraints);
        constraints = new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_brace.add((Component)this.checkBox_braceEnclosingParens, constraints);
        constraints = new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 0, indentedHeaderInsets, 0, 0);
        panel_brace.add((Component)label_braceMatchDelay, constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 2, indentedInsets, 0, 0);
        panel_brace.add((Component)label_minValue, constraints);
        constraints = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_brace.add((Component)this.slider_braceMatchDelay, constraints);
        constraints = new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 18, 2, defaultInsets, 0, 0);
        panel_brace.add((Component)label_maxValue, constraints);
        constraints = new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, emptyInsets, 0, 0);
        panel_brace.add((Component)this.label_braceMatchDelayText, constraints);
        Insets panelInsets = new Insets(0, 0, 0, 0);
        if (!DisplayOptionsPanel.hasAntialiasProperty()) {
            constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
            this.add(this.checkBox_useAAText, constraints);
        }
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add(this.checkBox_showWhitespaceChars, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add(this.checkBox_showBreadcrumbs, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 5), 0, 0);
        this.add(this.checkBox_usePeek, constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add(this.checkBox_showCodeFoldingMargin, constraints);
        constraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, indentedInsets, 0, 0);
        this.add(this.checkBox_showCodeFoldingHighlight, constraints);
        constraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add(Box.createVerticalStrut(5), constraints);
        constraints = new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 2, panelInsets, 0, 0);
        this.add(panel_margin, constraints);
        constraints = new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(Box.createVerticalStrut(5), constraints);
        constraints = new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 17, 2, panelInsets, 0, 0);
        this.add(panel_brace, constraints);
        constraints = new GridBagConstraints(0, 10, 1, 1, 1.0, 1.0, 17, 1, defaultInsets, 0, 0);
        this.add(Box.createVerticalGlue(), constraints);
    }
}

