/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class EditorOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkBox_autoIndent;
    private JCheckBox checkBox_useBlockOnSelection;
    private JCheckBox checkBox_useJumpScroll;
    private JCheckBox checkBox_useSmartHome;
    private JCheckBox checkBox_useSmartEnd;
    private JCheckBox checkBox_useCaseForWord;
    private JCheckBox checkBox_cutCopyLine;
    private JCheckBox checkBox_importsCopyPaste;
    private JCheckBox checkBox_indentCopyPaste;
    private JCheckBox checkBox_reformatCopyPaste;
    private JCheckBox checkBox_escapeStringPaste;

    public EditorOptionsPanel() {
        this.setHelpID("f1_idedideseteditor_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        EditorOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) {
        EditorOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private EditorOptions findOptions(TraversableContext tc) {
        return EditorOptions.getInstance(tc.getPropertyStorage());
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        EditorOptions options = this.findOptions(tc);
        EditorOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(EditorOptions options) {
        EditorProperties properties = EditorProperties.getProperties();
        boolean autoIndent = options.getAutoIndent();
        properties.putBooleanProperty("use-auto-indent", autoIndent);
        boolean useBlockOnSelection = options.getUseBlockOnSelection();
        properties.putBooleanProperty("do-block-indents-on-selection", useBlockOnSelection);
        boolean useJumpScroll = options.getUseJumpScroll();
        properties.putBooleanProperty("use-jump-scroll", useJumpScroll);
        boolean useSmartHome = options.getUseSmartHome();
        properties.putBooleanProperty("use-smart-home", useSmartHome);
        boolean useSmartEnd = options.getUseSmartEnd();
        properties.putBooleanProperty("use-smart-end", useSmartEnd);
        boolean useCaseDelimited = options.getUseCaseDelimitedWord();
        properties.putBooleanProperty("word-boundary-use-case", useCaseDelimited);
        boolean useLineStart = options.getUseLineStartForWord();
        properties.putBooleanProperty("word-boundary-use-line-start", useLineStart);
        boolean useLineEnd = options.getUseLineEndForWord();
        properties.putBooleanProperty("word-boundary-use-line-end", useLineEnd);
        boolean useCutCopyLine = options.getCutCopyLine();
        properties.putBooleanProperty("cut-copy-line", useCutCopyLine);
        boolean importsCopyPaste = options.getImportsCopyPaste();
        properties.putBooleanProperty("smart-copy-paste", importsCopyPaste);
        boolean indentCopyPaste = options.getIndentCopyPaste();
        properties.putBooleanProperty("autoindent-copy-paste", indentCopyPaste);
        boolean reformatCopyPaste = options.getReformatCopyPaste();
        properties.putBooleanProperty("autoreformat-copy-paste", reformatCopyPaste);
        boolean escapeStringPaste = options.getEscapeStringPaste();
        properties.putBooleanProperty("escape-string-paste", escapeStringPaste);
        boolean reuseUndoEvent = options.getReuseUndoEvent();
        properties.putBooleanProperty("reuse-undoable-edit", reuseUndoEvent);
        boolean reuseDocEvent = options.getReuseDocEvent();
        properties.putBooleanProperty("reuse-document-event", reuseDocEvent);
        boolean useExpensivePaste = options.getUseExpensivePasteChecking();
        properties.putBooleanProperty("check-clipboard-for-paste", useExpensivePaste);
    }

    void loadSettingsFrom(EditorOptions options) {
        boolean autoIndent = options.getAutoIndent();
        boolean useBlockOnSelection = options.getUseBlockOnSelection();
        boolean useJumpScroll = options.getUseJumpScroll();
        boolean useSmartHome = options.getUseSmartHome();
        boolean useSmartEnd = options.getUseSmartEnd();
        boolean useCaseForWord = options.getUseCaseDelimitedWord();
        boolean cutCopyLine = options.getCutCopyLine();
        boolean smartCopyPaste = options.getImportsCopyPaste();
        boolean indentCopyPaste = options.getIndentCopyPaste();
        boolean reformatCopyPaste = options.getReformatCopyPaste();
        boolean escapeStringPaste = options.getEscapeStringPaste();
        this.checkBox_autoIndent.setSelected(autoIndent);
        this.checkBox_useBlockOnSelection.setSelected(useBlockOnSelection);
        this.checkBox_useJumpScroll.setSelected(useJumpScroll);
        this.checkBox_useSmartHome.setSelected(useSmartHome);
        this.checkBox_useSmartEnd.setSelected(useSmartEnd);
        this.checkBox_useCaseForWord.setSelected(useCaseForWord);
        this.checkBox_cutCopyLine.setSelected(cutCopyLine);
        this.checkBox_importsCopyPaste.setSelected(smartCopyPaste);
        this.checkBox_indentCopyPaste.setSelected(indentCopyPaste);
        this.checkBox_reformatCopyPaste.setSelected(reformatCopyPaste);
        this.checkBox_escapeStringPaste.setSelected(escapeStringPaste);
    }

    void saveSettingsTo(EditorOptions options) {
        boolean autoIndent = this.checkBox_autoIndent.isSelected();
        boolean useBlockOnSelection = this.checkBox_useBlockOnSelection.isSelected();
        boolean useJumpScroll = this.checkBox_useJumpScroll.isSelected();
        boolean useSmartHome = this.checkBox_useSmartHome.isSelected();
        boolean useSmartEnd = this.checkBox_useSmartEnd.isSelected();
        boolean useCaseForWord = this.checkBox_useCaseForWord.isSelected();
        boolean cutCopyLine = this.checkBox_cutCopyLine.isSelected();
        boolean importsCopyPaste = this.checkBox_importsCopyPaste.isSelected();
        boolean indentCopyPaste = this.checkBox_indentCopyPaste.isSelected();
        boolean reformatCopyPaste = this.checkBox_reformatCopyPaste.isSelected();
        boolean escapeStringPaste = this.checkBox_escapeStringPaste.isSelected();
        options.setAutoIndent(autoIndent);
        options.setUseBlockOnSelection(useBlockOnSelection);
        options.setUseJumpScroll(useJumpScroll);
        options.setUseSmartHome(useSmartHome);
        options.setUseSmartEnd(useSmartEnd);
        options.setUseCaseDelimitedWord(useCaseForWord);
        options.setCutCopyLine(cutCopyLine);
        options.setImportsCopyPaste(importsCopyPaste);
        options.setIndentCopyPaste(indentCopyPaste);
        options.setReformatCopyPaste(reformatCopyPaste);
        options.setEscapeStringPaste(escapeStringPaste);
    }

    private void initializeComponent() {
        String autoIndentText = OptionsArb.getString(130);
        this.checkBox_autoIndent = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_autoIndent, (String)autoIndentText);
        String blockIndentText = OptionsArb.getString(74);
        this.checkBox_useBlockOnSelection = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useBlockOnSelection, (String)blockIndentText);
        String useJumpScrollText = OptionsArb.getString(56);
        this.checkBox_useJumpScroll = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useJumpScroll, (String)useJumpScrollText);
        String useSmartHomeText = OptionsArb.getString(66);
        this.checkBox_useSmartHome = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useSmartHome, (String)useSmartHomeText);
        String useSmartEndText = OptionsArb.getString(83);
        this.checkBox_useSmartEnd = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useSmartEnd, (String)useSmartEndText);
        String useCaseText = OptionsArb.getString(177);
        this.checkBox_useCaseForWord = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useCaseForWord, (String)useCaseText);
        String cutCopyLineText = OptionsArb.getString(87);
        this.checkBox_cutCopyLine = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_cutCopyLine, (String)cutCopyLineText);
        String importCopyPasteText = OptionsArb.getString(164);
        this.checkBox_importsCopyPaste = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_importsCopyPaste, (String)importCopyPasteText);
        String indentCopyPasteText = OptionsArb.getString(143);
        this.checkBox_indentCopyPaste = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_indentCopyPaste, (String)indentCopyPasteText);
        String reformatCopyPasteText = OptionsArb.getString(28);
        this.checkBox_reformatCopyPaste = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_reformatCopyPaste, (String)reformatCopyPasteText);
        String escapeStringPasteText = OptionsArb.getString(94);
        this.checkBox_escapeStringPaste = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_escapeStringPaste, (String)escapeStringPasteText);
        Insets defaultInsets = new Insets(0, 5, 0, 5);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkBox_autoIndent, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkBox_useBlockOnSelection, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkBox_useSmartHome, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkBox_useSmartEnd, constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkBox_useJumpScroll, constraints);
        constraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkBox_useCaseForWord, constraints);
        constraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkBox_cutCopyLine, constraints);
        constraints = new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkBox_importsCopyPaste, constraints);
        constraints = new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkBox_indentCopyPaste, constraints);
        constraints = new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkBox_reformatCopyPaste, constraints);
        constraints = new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkBox_escapeStringPaste, constraints);
        constraints = new GridBagConstraints(0, 11, 1, 1, 1.0, 1.0, 17, 1, defaultInsets, 0, 0);
        this.add(Box.createVerticalGlue(), constraints);
    }
}

