/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.ceditor.options.FontManager;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class FontSizeOptionsPanel
extends DefaultTraversablePanel
implements ActionListener,
ApplyListener,
DocumentListener,
ItemListener {
    private JCheckBox checkBox_showFixedOnly;
    private JComboBox comboBox_fontFamily;
    private JComboBox comboBox_fontSize;
    private JTextField textField_sampleText;
    private JLabel label_normalFont;
    private JLabel label_boldFont;
    private JLabel label_italicFont;
    private JLabel label_boldItalicFont;
    private Timer fontCheckTimer;
    private static String DEFAULT_FONT = "DialogInput";

    public FontSizeOptionsPanel() {
        this.setHelpID("f1_idedidesetfonts_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        FontSizeOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) {
        FontSizeOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private FontSizeOptions findOptions(TraversableContext tc) {
        FontSizeOptions options = FontSizeOptions.getInstance(tc.getPropertyStorage());
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        FontSizeOptions options = this.findOptions(tc);
        FontSizeOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(FontSizeOptions options) {
        EditorProperties properties = EditorProperties.getProperties();
        String fontFamily = options.getFontFamily();
        int fontSize = options.getFontSize();
        properties.setBaseFont(fontFamily, fontSize);
    }

    void loadSettingsFrom(FontSizeOptions options) {
        String fontFamily = options.getFontFamily();
        int fontSize = options.getFontSize();
        boolean showOnlyFixedWidth = options.getShowOnlyFixedWidth();
        this.checkBox_showFixedOnly.setSelected(false);
        this.setSelectedFontFamily(fontFamily);
        this.comboBox_fontSize.setSelectedItem(new Integer(fontSize));
        this.checkBox_showFixedOnly.setSelected(showOnlyFixedWidth);
    }

    void saveSettingsTo(FontSizeOptions options) {
        String fontFamily = this.comboBox_fontFamily.getSelectedItem().toString();
        Integer fontSizeInteger = (Integer)this.comboBox_fontSize.getSelectedItem();
        int fontSize = fontSizeInteger;
        boolean showOnlyFixedWidth = this.checkBox_showFixedOnly.isSelected();
        options.setFontFamily(fontFamily);
        options.setFontSize(fontSize);
        options.setShowOnlyFixedWidth(showOnlyFixedWidth);
    }

    private void initializeComponent() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        String fontFamilyText = OptionsArb.getString(62);
        JLabel label_fontFamily = new JLabel();
        Object[] families = new String[]{DEFAULT_FONT};
        NonNullableComboBoxModel fontModel = new NonNullableComboBoxModel(families);
        this.comboBox_fontFamily = new JComboBox(fontModel);
        this.comboBox_fontFamily.setEditable(false);
        this.comboBox_fontFamily.setSelectedItem(families[0]);
        this.comboBox_fontFamily.addItemListener(this);
        ResourceUtils.resLabel((JLabel)label_fontFamily, (Component)this.comboBox_fontFamily, (String)fontFamilyText);
        String fontSizeText = OptionsArb.getString(54);
        JLabel label_fontSize = new JLabel();
        Object[] sizes = new Integer[]{new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16), new Integer(17), new Integer(18), new Integer(19), new Integer(20), new Integer(21), new Integer(22), new Integer(23), new Integer(24)};
        NonNullableComboBoxModel sizeModel = new NonNullableComboBoxModel(sizes);
        this.comboBox_fontSize = new JComboBox(sizeModel);
        this.comboBox_fontSize.setEditable(false);
        this.comboBox_fontSize.setSelectedItem(sizes[0]);
        this.comboBox_fontSize.addItemListener(this);
        ResourceUtils.resLabel((JLabel)label_fontSize, (Component)this.comboBox_fontSize, (String)fontSizeText);
        String sampleText = OptionsArb.getString(84);
        String initialSampleText = OptionsArb.getString(13);
        JLabel label_sampleText = new JLabel();
        this.textField_sampleText = new JTextField(initialSampleText);
        Document fieldDocument = this.textField_sampleText.getDocument();
        fieldDocument.addDocumentListener(this);
        ResourceUtils.resLabel((JLabel)label_sampleText, (Component)this.textField_sampleText, (String)sampleText);
        String renderedText = OptionsArb.getString(162);
        JLabel label_renderedText = new JLabel(renderedText, 2);
        this.label_normalFont = new JLabel(initialSampleText);
        this.label_boldFont = new JLabel(initialSampleText);
        this.label_italicFont = new JLabel(initialSampleText);
        this.label_boldItalicFont = new JLabel(initialSampleText);
        Box sampleBox = Box.createVerticalBox();
        sampleBox.add(this.label_normalFont);
        sampleBox.add(this.label_boldFont);
        sampleBox.add(this.label_italicFont);
        sampleBox.add(this.label_boldItalicFont);
        JPanel samplePanel = new JPanel(new BorderLayout());
        samplePanel.add((Component)sampleBox, "Center");
        JScrollPane sampleScroller = new JScrollPane(samplePanel);
        FontManager fontManager = FontManager.getInstance();
        String fixedOnlyText = fontManager.isFontInfoComplete() ? OptionsArb.getString(90) : OptionsArb.getString(159);
        this.checkBox_showFixedOnly = new JCheckBox();
        this.checkBox_showFixedOnly.setSelected(true);
        this.checkBox_showFixedOnly.addItemListener(this);
        this.checkBox_showFixedOnly.setSelected(false);
        ResourceUtils.resButton((AbstractButton)this.checkBox_showFixedOnly, (String)fixedOnlyText);
        Insets defaultInsets = new Insets(0, 0, 5, 5);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(label_fontFamily, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.comboBox_fontFamily, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkBox_showFixedOnly, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(label_fontSize, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.comboBox_fontSize, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(label_sampleText, constraints);
        constraints = new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add(this.textField_sampleText, constraints);
        constraints = new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0);
        this.add(label_renderedText, constraints);
        constraints = new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 17, 1, defaultInsets, 0, 0);
        this.add(sampleScroller, constraints);
    }

    private void setSelectedFontFamily(String fontFamily) {
        ComboBoxModel model = this.comboBox_fontFamily.getModel();
        int numItems = model.getSize();
        int i = 0;
        while (i < numItems) {
            Object element = model.getElementAt(i);
            if (element.equals(fontFamily)) {
                this.comboBox_fontFamily.setSelectedItem(fontFamily);
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent event) {
        boolean isComplete;
        Frame owner = null;
        Container parent = this.getParent();
        while (parent != null) {
            if (parent instanceof Frame) {
                owner = (Frame)parent;
                break;
            }
            parent = parent.getParent();
        }
        FontManager fontManager = FontManager.getInstance();
        if (!fontManager.isFontInfoComplete()) {
            fontManager.updateFontInfo(owner);
        }
        if (!(isComplete = fontManager.isFontInfoComplete())) {
            this.checkBox_showFixedOnly.setSelected(false);
        } else {
            String selectedFont = (String)this.comboBox_fontFamily.getSelectedItem();
            Object[] families = fontManager.getKnownFixedFamilies();
            NonNullableComboBoxModel fontModel = new NonNullableComboBoxModel(families);
            this.comboBox_fontFamily.setModel(fontModel);
            this.setSelectedFontFamily(DEFAULT_FONT);
            this.setSelectedFontFamily(selectedFont);
            String fixedOnlyText = OptionsArb.getString(90);
            ResourceUtils.resButton((AbstractButton)this.checkBox_showFixedOnly, (String)fixedOnlyText);
        }
        if (this.fontCheckTimer != null) {
            this.fontCheckTimer.removeActionListener(this);
            this.fontCheckTimer = null;
        }
    }

    public void insertUpdate(DocumentEvent event) {
        this.updateSampleLabelText();
    }

    public void removeUpdate(DocumentEvent event) {
        this.updateSampleLabelText();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    private void updateSampleLabelText() {
        String labelText = this.textField_sampleText.getText();
        this.label_normalFont.setText(labelText);
        this.label_boldFont.setText(labelText);
        this.label_italicFont.setText(labelText);
        this.label_boldItalicFont.setText(labelText);
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.comboBox_fontFamily || source == this.comboBox_fontSize) {
            ItemSelectable comboBox = event.getItemSelectable();
            Object item = event.getItem();
            int selected = event.getStateChange();
            if (selected == 1) {
                this.updateSampleFonts();
            }
        } else if (source == this.checkBox_showFixedOnly) {
            boolean isSelected = this.checkBox_showFixedOnly.isSelected();
            if (isSelected) {
                this.fontCheckTimer = new Timer(100, this);
                this.fontCheckTimer.setRepeats(false);
                this.fontCheckTimer.start();
            } else {
                FontManager fontManager = FontManager.getInstance();
                Object[] families = fontManager.getAllFontFamilies();
                NonNullableComboBoxModel fontModel = new NonNullableComboBoxModel(families);
                Object selected = this.comboBox_fontFamily.getSelectedItem();
                this.comboBox_fontFamily.setModel(fontModel);
                this.setSelectedFontFamily(DEFAULT_FONT);
                this.setSelectedFontFamily((String)selected);
            }
        }
    }

    private void updateSampleFonts() {
        String fontFamily = this.comboBox_fontFamily.getSelectedItem().toString();
        Integer fontSizeInteger = (Integer)this.comboBox_fontSize.getSelectedItem();
        int fontSize = fontSizeInteger;
        Font normalFont = new Font(fontFamily, 0, fontSize);
        Font boldFont = normalFont.deriveFont(1);
        Font italicFont = normalFont.deriveFont(2);
        Font boldItalicFont = normalFont.deriveFont(3);
        this.label_normalFont.setFont(normalFont);
        this.label_boldFont.setFont(boldFont);
        this.label_italicFont.setFont(italicFont);
        this.label_boldItalicFont.setFont(boldItalicFont);
    }
}

