/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.ceditor.options.FontManager;
import oracle.ide.ceditor.options.InsightOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class InsightOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener,
ChangeListener {
    private static String DEFAULT_FONT = "Dialog";
    private JComboBox combobox_fontFamily;
    private JComboBox combobox_fontSize;
    private JCheckBox checkbox_completionEnablePopup;
    private JSlider slider_completionPopupDelay;
    private JLabel label_completionSliderMax;
    private JLabel label_completionSliderMin;
    private JLabel label_completionPopupDelayText;
    private JCheckBox checkbox_parameterEnablePopup;
    private JSlider slider_parameterPopupDelay;
    private JLabel label_parameterPopupDelayText;
    private JLabel label_parameterSliderMin;
    private JLabel label_parameterSliderMax;
    private NumberFormat numberFormatter;

    public InsightOptionsPanel() {
        this.setHelpID("f1_idedidesetcodeinsight_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        InsightOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) {
        InsightOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private InsightOptions findOptions(TraversableContext tc) {
        InsightOptions options = InsightOptions.getInstance(tc.getPropertyStorage());
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        InsightOptions options = this.findOptions(tc);
        InsightOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(InsightOptions options) {
        EditorProperties properties = EditorProperties.getProperties();
        String fontFamily = options.getFontFamily();
        properties.putProperty("insight-font-family", (Object)fontFamily);
        int fontSize = options.getFontSize();
        properties.putIntegerProperty("insight-font-size", fontSize);
        boolean completionEnablePopup = options.getCompletionEnablePopup();
        properties.putBooleanProperty("completion-enable-autopopup", completionEnablePopup);
        int completionPopupDelay = options.getCompletionPopupDelay();
        properties.putIntegerProperty("completion-popup-delay", completionPopupDelay);
        boolean parameterEnablePopup = options.getParameterEnablePopup();
        properties.putBooleanProperty("parameter-enable-autopopup", parameterEnablePopup);
        int parameterPopupDelay = options.getParameterPopupDelay();
        properties.putIntegerProperty("parameter-popup-delay", parameterPopupDelay);
    }

    public void stateChanged(ChangeEvent event) {
        JLabel label;
        JSlider slider;
        Object source = event.getSource();
        if (source == this.slider_completionPopupDelay) {
            slider = this.slider_completionPopupDelay;
            label = this.label_completionPopupDelayText;
        } else if (source == this.slider_parameterPopupDelay) {
            slider = this.slider_parameterPopupDelay;
            label = this.label_parameterPopupDelayText;
        } else {
            throw new IllegalStateException("unknown source");
        }
        float value = (float)slider.getValue() / 10.0f;
        String valueStr = OptionsArb.format(40, this.numberFormatter.format(value));
        label.setText(valueStr);
        slider.setToolTipText(valueStr);
    }

    void loadSettingsFrom(InsightOptions options) {
        String fontFamily = options.getFontFamily();
        int fontSize = options.getFontSize();
        boolean completionEnablePopup = options.getCompletionEnablePopup();
        int completionPopupDelay = options.getCompletionPopupDelay();
        boolean parameterEnablePopup = options.getParameterEnablePopup();
        int parameterPopupDelay = options.getParameterPopupDelay();
        this.setSelectedFontFamily(fontFamily);
        this.combobox_fontSize.setSelectedItem(new Integer(fontSize));
        this.checkbox_completionEnablePopup.setSelected(completionEnablePopup);
        this.slider_completionPopupDelay.setValue(completionPopupDelay / 100);
        this.checkbox_parameterEnablePopup.setSelected(parameterEnablePopup);
        this.slider_parameterPopupDelay.setValue(parameterPopupDelay / 100);
    }

    void saveSettingsTo(InsightOptions options) {
        String fontFamily = this.combobox_fontFamily.getSelectedItem().toString();
        Integer fontSizeInteger = (Integer)this.combobox_fontSize.getSelectedItem();
        int fontSize = fontSizeInteger;
        boolean completionEnablePopup = this.checkbox_completionEnablePopup.isSelected();
        int completionPopupDelay = this.slider_completionPopupDelay.getValue() * 100;
        boolean parameterEnablePopup = this.checkbox_parameterEnablePopup.isSelected();
        int parameterPopupDelay = this.slider_parameterPopupDelay.getValue() * 100;
        options.setFontFamily(fontFamily);
        options.setFontSize(fontSize);
        options.setCompletionEnablePopup(completionEnablePopup);
        options.setCompletionPopupDelay(completionPopupDelay);
        options.setParameterEnablePopup(parameterEnablePopup);
        options.setParameterPopupDelay(parameterPopupDelay);
    }

    private void setSelectedFontFamily(String fontFamily) {
        ComboBoxModel model = this.combobox_fontFamily.getModel();
        int numItems = model.getSize();
        int i = 0;
        while (i < numItems) {
            Object element = model.getElementAt(i);
            if (element.equals(fontFamily)) {
                this.combobox_fontFamily.setSelectedItem(fontFamily);
            }
            ++i;
        }
    }

    private void initializeComponent() {
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(1);
        String fontFamilyText = OptionsArb.getString(78);
        JLabel label_fontFamily = new JLabel();
        FontManager fontManager = FontManager.getInstance();
        Object[] families = fontManager.getAllFontFamilies();
        NonNullableComboBoxModel fontModel = new NonNullableComboBoxModel(families);
        this.combobox_fontFamily = new JComboBox(fontModel);
        this.combobox_fontFamily.setEditable(false);
        this.combobox_fontFamily.setSelectedItem(DEFAULT_FONT);
        ResourceUtils.resLabel((JLabel)label_fontFamily, (Component)this.combobox_fontFamily, (String)fontFamilyText);
        String fontSizeText = OptionsArb.getString(67);
        JLabel label_fontSize = new JLabel();
        Object[] sizes = new Integer[]{new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16)};
        NonNullableComboBoxModel sizeModel = new NonNullableComboBoxModel(sizes);
        this.combobox_fontSize = new JComboBox(sizeModel);
        this.combobox_fontSize.setEditable(false);
        this.combobox_fontSize.setSelectedItem(sizes[0]);
        ResourceUtils.resLabel((JLabel)label_fontSize, (Component)this.combobox_fontSize, (String)fontSizeText);
        String completionEnablePopupText = OptionsArb.getString(63);
        this.checkbox_completionEnablePopup = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_completionEnablePopup, (String)completionEnablePopupText);
        String completionPopupDelayText = OptionsArb.getString(92);
        JLabel label_completionPopupDelay = new JLabel();
        this.slider_completionPopupDelay = new JSlider(1, 30, 10);
        this.slider_completionPopupDelay.addChangeListener(this);
        this.label_completionPopupDelayText = new JLabel();
        ResourceUtils.resLabel((JLabel)label_completionPopupDelay, (Component)this.slider_completionPopupDelay, (String)completionPopupDelayText);
        String completionPopupMinText = OptionsArb.getString(124);
        this.label_completionSliderMin = new JLabel(completionPopupMinText);
        String completionPopupMaxText = OptionsArb.getString(104);
        this.label_completionSliderMax = new JLabel(completionPopupMaxText);
        this.slider_completionPopupDelay.setPaintLabels(false);
        this.slider_completionPopupDelay.setPaintTicks(true);
        this.slider_completionPopupDelay.setMajorTickSpacing(10);
        this.slider_completionPopupDelay.setMinorTickSpacing(1);
        this.slider_completionPopupDelay.setSnapToTicks(true);
        Component[] completionDependents = new Component[]{this.slider_completionPopupDelay, label_completionPopupDelay, this.label_completionPopupDelayText, this.label_completionSliderMin, this.label_completionSliderMax};
        ItemSelectableTracker completionTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_completionEnablePopup, completionDependents);
        this.checkbox_completionEnablePopup.addItemListener((ItemListener)completionTracker);
        String parameterEnablePopupText = OptionsArb.getString(155);
        this.checkbox_parameterEnablePopup = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_parameterEnablePopup, (String)parameterEnablePopupText);
        String parameterPopupDelayText = OptionsArb.getString(175);
        JLabel label_parameterPopupDelay = new JLabel();
        this.slider_parameterPopupDelay = new JSlider(1, 30, 10);
        this.slider_parameterPopupDelay.addChangeListener(this);
        this.label_parameterPopupDelayText = new JLabel();
        ResourceUtils.resLabel((JLabel)label_parameterPopupDelay, (Component)this.slider_parameterPopupDelay, (String)parameterPopupDelayText);
        String paramPopupMinText = OptionsArb.getString(124);
        this.label_parameterSliderMin = new JLabel(paramPopupMinText);
        String paramPopupMaxText = OptionsArb.getString(104);
        this.label_parameterSliderMax = new JLabel(paramPopupMaxText);
        this.slider_parameterPopupDelay.setPaintLabels(false);
        this.slider_parameterPopupDelay.setPaintTicks(true);
        this.slider_parameterPopupDelay.setMajorTickSpacing(10);
        this.slider_parameterPopupDelay.setMinorTickSpacing(1);
        this.slider_parameterPopupDelay.setSnapToTicks(true);
        Component[] parameterDependents = new Component[]{this.slider_parameterPopupDelay, label_parameterPopupDelay, this.label_parameterPopupDelayText, this.label_parameterSliderMin, this.label_parameterSliderMax};
        ItemSelectableTracker parameterTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_parameterEnablePopup, parameterDependents);
        this.checkbox_parameterEnablePopup.addItemListener((ItemListener)parameterTracker);
        this.slider_completionPopupDelay.setValue(1);
        this.slider_parameterPopupDelay.setValue(1);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        Insets defaultInsets = new Insets(0, 0, 5, 5);
        Insets indentedInsets = new Insets(0, 18, 5, 0);
        Insets indentedHeaderInsets = new Insets(0, 18, 7, 5);
        JPanel panel_font = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_font.add((Component)label_fontFamily, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 30, 0);
        panel_font.add((Component)this.combobox_fontFamily, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_font.add((Component)label_fontSize, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 0, defaultInsets, 0, 0);
        panel_font.add((Component)this.combobox_fontSize, constraints);
        JPanel panel_completion = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_completion.add((Component)this.checkbox_completionEnablePopup, constraints);
        constraints = new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, indentedHeaderInsets, 0, 0);
        panel_completion.add((Component)label_completionPopupDelay, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, indentedInsets, 0, 0);
        panel_completion.add((Component)this.label_completionSliderMin, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, emptyInsets, 0, 0);
        panel_completion.add((Component)this.slider_completionPopupDelay, constraints);
        constraints = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 2, defaultInsets, 0, 0);
        panel_completion.add((Component)this.label_completionSliderMax, constraints);
        constraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, emptyInsets, 0, 0);
        panel_completion.add((Component)this.label_completionPopupDelayText, constraints);
        JPanel panel_parameter = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_parameter.add((Component)this.checkbox_parameterEnablePopup, constraints);
        constraints = new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, indentedHeaderInsets, 0, 0);
        panel_parameter.add((Component)label_parameterPopupDelay, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, indentedInsets, 0, 0);
        panel_parameter.add((Component)this.label_parameterSliderMin, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, emptyInsets, 0, 0);
        panel_parameter.add((Component)this.slider_parameterPopupDelay, constraints);
        constraints = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, defaultInsets, 0, 0);
        panel_parameter.add((Component)this.label_parameterSliderMax, constraints);
        constraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, emptyInsets, 0, 0);
        panel_parameter.add((Component)this.label_parameterPopupDelayText, constraints);
        constraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_font, constraints);
        constraints = new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, emptyInsets, 0, 0);
        this.add(Box.createVerticalStrut(10), constraints);
        constraints = new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_completion, constraints);
        constraints = new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, emptyInsets, 0, 0);
        this.add(Box.createVerticalStrut(10), constraints);
        constraints = new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_parameter, constraints);
        constraints = new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 17, 0, emptyInsets, 0, 0);
        this.add(Box.createGlue(), constraints);
    }
}

