/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.saveactions;

import java.beans.PropertyChangeEvent;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.saveactions.SaveActionsArb;
import oracle.ide.ceditor.saveactions.SaveActionsOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

public final class SaveActionsPlugin
implements EditorPlugin {
    private Listener listener;
    private CodeEditor codeEditor;
    private static boolean isSaving = false;

    private void $init$() {
        this.listener = new Listener(null);
    }

    public void install(BasicEditorPane editor) {
        this.codeEditor = CodeEditor.getCodeEditor(editor);
        this.codeEditor.getContext().getNode().addNodeListener((NodeListener)this.listener);
    }

    public void deinstall(BasicEditorPane editor) {
        this.codeEditor.getContext().getNode().removeNodeListener((NodeListener)this.listener);
        this.codeEditor = null;
    }

    private void runSaveActions() {
        if (isSaving) {
            return;
        }
        Context context = this.codeEditor.getContext();
        CommandProcessor cp = CommandProcessor.getInstance();
        try {
            isSaving = true;
            cp.beginTrans(SaveActionsArb.getString(3));
            SaveActionsOptions saOptions = SaveActionsOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            for (Object name : saOptions.getActionList()) {
                Integer cmdId = Ide.findCmdID((String)((String)name));
                if (cmdId == null) continue;
                this.doAction(context, cmdId);
            }
        }
        finally {
            cp.endTrans();
            isSaving = false;
        }
    }

    private void doAction(Context context, int commandID) {
        try {
            IdeAction action = IdeAction.get((int)commandID);
            action.updateAction(context);
            if (action.isEnabled()) {
                action.performAction(context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public SaveActionsPlugin() {
        this.$init$();
    }

    static void mav$runSaveActions(SaveActionsPlugin saveActionsPlugin) {
        saveActionsPlugin.runSaveActions();
    }

    private class Listener
    extends NodeListener {
        public void nodeWillBeSaved(NodeEvent e) {
            SaveActionsPlugin.mav$runSaveActions(SaveActionsPlugin.this);
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

