/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorAddin;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.panels.Navigable;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.bookmarks.BookmarkManager;
import oracle.jdevimpl.bookmarks.BookmarkOptions;
import oracle.jdevimpl.bookmarks.BookmarkOptionsPanel;
import oracle.jdevimpl.bookmarks.GotoBookmarkPanel;
import oracle.jdevimpl.bookmarks.resource.BookmarkArb;

public final class BookmarkAddin
implements Addin,
ShutdownHook,
Controller,
ContextMenuListener {
    private static String extensionID;
    public static final int TOGGLE_BOOKMARK_CMD_ID;
    public static final int GOTO_BOOKMARK_CMD_ID;
    public static final int NEXT_BOOKMARK_CMD_ID;
    public static final int PREV_BOOKMARK_CMD_ID;
    public static final int REMOVE_BOOKMARKS_FROM_FILE_CMD_ID;
    public static final int REMOVE_ALL_BOOKMARKS_CMD_ID;
    private final BookmarkManager bookmarkManager;

    public BookmarkAddin() {
        extensionID = AddinManager.getAddinManager().getExtensionForAddin((Addin)this).getID();
        this.bookmarkManager = new BookmarkManager();
        IdeAction toggleBookmarkAction = IdeAction.get((int)TOGGLE_BOOKMARK_CMD_ID, null, (String)BookmarkArb.getString(14), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)BookmarkArb.getInteger(32), (ArrayResourceBundle)BookmarkArb.getInstance(), (int)12, null, (boolean)false);
        toggleBookmarkAction.addController((Controller)this);
        IdeAction gotoBookmarkAction = IdeAction.get((int)GOTO_BOOKMARK_CMD_ID, null, (String)BookmarkArb.getString(21), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)BookmarkArb.getInteger(27), (Icon)OracleIcons.getIcon((String)"go_to_bookmark.png"), null, (boolean)true);
        gotoBookmarkAction.addController((Controller)this);
        IdeAction nextBookmarkAction = IdeAction.get((int)NEXT_BOOKMARK_CMD_ID, null, (String)BookmarkArb.getString(38), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)BookmarkArb.getInteger(29), (Icon)OracleIcons.getIcon((String)"go_to_next_bookmark.png"), null, (boolean)false);
        nextBookmarkAction.addController((Controller)this);
        IdeAction previousBookmarkAction = IdeAction.get((int)PREV_BOOKMARK_CMD_ID, null, (String)BookmarkArb.getString(36), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)BookmarkArb.getInteger(9), (Icon)OracleIcons.getIcon((String)"go_to_prev_bookmark.png"), null, (boolean)false);
        previousBookmarkAction.addController((Controller)this);
        IdeAction removeBookmarksFromFileAction = IdeAction.get((int)REMOVE_BOOKMARKS_FROM_FILE_CMD_ID, null, (String)BookmarkArb.getString(24), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)BookmarkArb.getInteger(31), (ArrayResourceBundle)BookmarkArb.getInstance(), (int)22, null, (boolean)false);
        removeBookmarksFromFileAction.addController((Controller)this);
        IdeAction removeAllBookmarksAction = IdeAction.get((int)REMOVE_ALL_BOOKMARKS_CMD_ID, null, (String)BookmarkArb.getString(6), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)BookmarkArb.getInteger(23), (ArrayResourceBundle)BookmarkArb.getInstance(), (int)4, null, (boolean)true);
        removeAllBookmarksAction.addController((Controller)this);
        Menubar ideMenuManager = Ide.getMenubar();
        JMenu navigateMenu = MenuManager.getJMenu((String)"Navigate");
        JMenuItem toggleBookmarkMenuItem = ideMenuManager.createMenuItem((ToggleAction)toggleBookmarkAction, MenuConstants.WEIGHT_NAVIGATE_TOGGLE_BOOKMARK);
        ideMenuManager.add((Component)toggleBookmarkMenuItem, navigateMenu, MenuConstants.SECTION_NAVIGATE_BOOKMARK);
        JMenuItem gotoBookmarkMenuItem = ideMenuManager.createMenuItem((ToggleAction)gotoBookmarkAction, MenuConstants.WEIGHT_NAVIGATE_GO_TO_BOOKMARK);
        ideMenuManager.add((Component)gotoBookmarkMenuItem, navigateMenu, MenuConstants.SECTION_NAVIGATE_GOTO_BOOKMARK);
        JMenuItem nextBookmarkMenuItem = ideMenuManager.createMenuItem((ToggleAction)nextBookmarkAction, MenuConstants.WEIGHT_NAVIGATE_GO_TO_NEXT_BOOKMARK);
        ideMenuManager.add((Component)nextBookmarkMenuItem, navigateMenu, MenuConstants.SECTION_NAVIGATE_GOTO_BOOKMARK);
        JMenuItem previousBookmarkMenuItem = ideMenuManager.createMenuItem((ToggleAction)previousBookmarkAction, MenuConstants.WEIGHT_NAVIGATE_GO_TO_PREVIOUS_BOOKMARK);
        ideMenuManager.add((Component)previousBookmarkMenuItem, navigateMenu, MenuConstants.SECTION_NAVIGATE_GOTO_BOOKMARK);
        JMenuItem removeBookmarksFromFileMenuItem = ideMenuManager.createMenuItem((ToggleAction)removeBookmarksFromFileAction, MenuConstants.WEIGHT_NAVIGATE_REMOVE_BOOKMARKS_FROM_FILE);
        ideMenuManager.add((Component)removeBookmarksFromFileMenuItem, navigateMenu, MenuConstants.SECTION_NAVIGATE_BOOKMARK);
        JMenuItem removeAllBookmarksMenuItem = ideMenuManager.createMenuItem((ToggleAction)removeAllBookmarksAction, MenuConstants.WEIGHT_NAVIGATE_REMOVE_ALL_BOOKMARKS);
        ideMenuManager.add((Component)removeAllBookmarksMenuItem, navigateMenu, MenuConstants.SECTION_NAVIGATE_BOOKMARK);
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    public void initialize() {
        KeyStrokeContextRegistry registry = Ide.getKeyStrokeContextRegistry();
        registry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/bookmarks/accelerators.xml");
        Preferences prefs = Preferences.getPreferences();
        Ide.getSettings().putLegacyData("BookmarkOptions", (Copyable)BookmarkOptions.getInstance((PropertyStorage)prefs));
        String optionsName = BookmarkArb.getString(8);
        Navigable navigable = new Navigable(optionsName, BookmarkOptionsPanel.class);
        CodeEditorAddin addin = (CodeEditorAddin)AddinManager.getAddinManager().getAddin(CodeEditorAddin.class);
        if (addin != null) {
            Navigable editorNavigable = addin.getEditorNavigable();
            editorNavigable.addChildNavigable(navigable);
        } else {
            ClientSetting.registerUI((Navigable)navigable);
        }
        BookmarkOptionsPanel.applyOptions(BookmarkOptions.getInstance((PropertyStorage)prefs));
        EditorManager editorManager = EditorManager.getEditorManager();
        ContextMenu menu = editorManager.getContextMenu();
        if (menu != null) {
            menu.addContextMenuListener((ContextMenuListener)this);
        }
        if ((menu = CodeEditorGutter.getGutterContextMenu()) != null) {
            menu.addContextMenuListener((ContextMenuListener)this);
        }
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        this.bookmarkManager.shutdown();
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == TOGGLE_BOOKMARK_CMD_ID) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                CodeEditor codeEditor = (CodeEditor)view;
                this.bookmarkManager.toggleBookmark(codeEditor);
                codeEditor.activate();
            } else if (view instanceof CodeEditorGutter.GutterView) {
                CodeEditor codeEditor = (CodeEditor)view.owner();
                int line = CodeEditorGutter.getLineForContext(context);
                if (line != -1) {
                    this.bookmarkManager.toggleBookmark(codeEditor, line);
                }
            }
            return true;
        }
        if (commandId == GOTO_BOOKMARK_CMD_ID) {
            GotoBookmarkPanel.runDialog(this.bookmarkManager);
            return true;
        }
        if (commandId == NEXT_BOOKMARK_CMD_ID) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                CodeEditor codeEditor = (CodeEditor)view;
                this.bookmarkManager.gotoNextBookmark(codeEditor);
            }
            return true;
        }
        if (commandId == PREV_BOOKMARK_CMD_ID) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                CodeEditor codeEditor = (CodeEditor)view;
                this.bookmarkManager.gotoPreviousBookmark(codeEditor);
            }
            return true;
        }
        if (commandId == REMOVE_BOOKMARKS_FROM_FILE_CMD_ID) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                CodeEditor codeEditor = (CodeEditor)view;
                this.bookmarkManager.removeAllBookmarks(codeEditor);
            }
            return true;
        }
        if (commandId == REMOVE_ALL_BOOKMARKS_CMD_ID) {
            this.bookmarkManager.removeAllBookmarks();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == TOGGLE_BOOKMARK_CMD_ID || commandId == NEXT_BOOKMARK_CMD_ID || commandId == PREV_BOOKMARK_CMD_ID || commandId == REMOVE_BOOKMARKS_FROM_FILE_CMD_ID) {
            CodeEditor codeEditor = null;
            View view = context.getView();
            if (view != null) {
                if (view instanceof CodeEditor) {
                    codeEditor = (CodeEditor)view;
                } else if (view instanceof CodeEditorGutter.GutterView) {
                    codeEditor = (CodeEditor)view.owner();
                }
            }
            if (codeEditor == null) {
                action.setEnabled(false);
            } else if (commandId == TOGGLE_BOOKMARK_CMD_ID) {
                action.setEnabled(true);
            } else if (commandId == NEXT_BOOKMARK_CMD_ID) {
                action.setEnabled(this.bookmarkManager.canGotoNextBookmark(codeEditor));
            } else if (commandId == PREV_BOOKMARK_CMD_ID) {
                action.setEnabled(this.bookmarkManager.canGotoPreviousBookmark(codeEditor));
            } else if (commandId == REMOVE_BOOKMARKS_FROM_FILE_CMD_ID) {
                action.setEnabled(this.bookmarkManager.hasBookmarks(codeEditor));
            }
            return true;
        }
        if (commandId == REMOVE_ALL_BOOKMARKS_CMD_ID) {
            action.setEnabled(this.bookmarkManager.hasBookmarks());
            return true;
        }
        if (commandId == GOTO_BOOKMARK_CMD_ID) {
            action.setEnabled(this.bookmarkManager.hasBookmarks());
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        int line;
        Context context = popup.getContext();
        View view = context.getView();
        if (view instanceof CodeEditorGutter.GutterView && !CodeEditorGutter.isMarkDroppingDown(context) && (line = CodeEditorGutter.getLineForContext(context)) != -1) {
            IdeAction action = IdeAction.find((int)TOGGLE_BOOKMARK_CMD_ID);
            JMenuItem menuItem = popup.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_NAVIGATE_TOGGLE_BOOKMARK);
            popup.add((Component)menuItem, 2.0f);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    static String getExtensionID() {
        return extensionID;
    }

    static {
        TOGGLE_BOOKMARK_CMD_ID = Ide.findOrCreateCmdID((String)"ojb.ToggleBookmarkCommand");
        GOTO_BOOKMARK_CMD_ID = Ide.findOrCreateCmdID((String)"ojb.GotoBookmarkCommand");
        NEXT_BOOKMARK_CMD_ID = Ide.findOrCreateCmdID((String)"ojb.NextBookmarkCommand");
        PREV_BOOKMARK_CMD_ID = Ide.findOrCreateCmdID((String)"ojb.PreviousBookmarkCommand");
        REMOVE_BOOKMARKS_FROM_FILE_CMD_ID = Ide.findOrCreateCmdID((String)"ojb.RemoveBookmarksFromFileCommand");
        REMOVE_ALL_BOOKMARKS_CMD_ID = Ide.findOrCreateCmdID((String)"ojb.RemoveAllBookmarksCommand");
    }
}

