/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.bookmarks.Bookmark;
import oracle.jdevimpl.bookmarks.BookmarkComparator;

public final class BookmarkList
implements Copyable {
    private List bookmarkList = new ArrayList();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int numBookmarks = this.bookmarkList.size();
        buffer.append("num bookmarks: " + numBookmarks);
        buffer.append("\n");
        int i = 0;
        while (i < numBookmarks) {
            Bookmark bookmark = (Bookmark)this.bookmarkList.get(i);
            buffer.append(bookmark.toString());
            ++i;
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark[] getAllBookmarks() {
        Bookmark[] allBookmarks;
        List list = this.bookmarkList;
        synchronized (list) {
            int numBookmarks = this.bookmarkList.size();
            allBookmarks = this.bookmarkList.toArray(new Bookmark[numBookmarks]);
        }
        return allBookmarks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBookmarkCount() {
        List list = this.bookmarkList;
        synchronized (list) {
            int n = this.bookmarkList.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark getNextBookmark(URL url, int line, boolean thisURLOnly) {
        Bookmark bookmarkFound = null;
        List list = this.bookmarkList;
        synchronized (list) {
            BookmarkComparator comparator = BookmarkComparator.BOOKMARK_COMPARATOR;
            List<Bookmark> listToUse = this.bookmarkList;
            if (thisURLOnly) {
                Bookmark[] urlBookmarks = this.findBookmarks(url);
                listToUse = Arrays.asList(urlBookmarks);
            }
            int startIndex = 0;
            Bookmark startBookmark = new Bookmark(url, line);
            int numBookmarks = listToUse.size();
            int i = 0;
            while (i < numBookmarks) {
                Bookmark bookmark = listToUse.get(i);
                if (comparator.compare(startBookmark, bookmark) < 0) {
                    startIndex = i;
                    break;
                }
                ++i;
            }
            if (numBookmarks > 0) {
                bookmarkFound = listToUse.get(startIndex);
            }
        }
        return bookmarkFound;
    }

    public Bookmark getNextBookmark(Bookmark bookmark, boolean thisURLOnly) {
        return this.getNextBookmark(bookmark.getURL(), bookmark.getLine(), thisURLOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark getPreviousBookmark(URL url, int line, boolean thisURLOnly) {
        Bookmark bookmarkFound = null;
        List list = this.bookmarkList;
        synchronized (list) {
            BookmarkComparator comparator = BookmarkComparator.BOOKMARK_COMPARATOR;
            List<Bookmark> listToUse = this.bookmarkList;
            if (thisURLOnly) {
                Bookmark[] urlBookmarks = this.findBookmarks(url);
                listToUse = Arrays.asList(urlBookmarks);
            }
            int numBookmarks = listToUse.size();
            int startIndex = numBookmarks - 1;
            Bookmark startBookmark = new Bookmark(url, line);
            int i = startIndex;
            while (i >= 0) {
                Bookmark bookmark = listToUse.get(i);
                if (comparator.compare(startBookmark, bookmark) > 0) {
                    startIndex = i;
                    break;
                }
                --i;
            }
            if (numBookmarks > 0) {
                bookmarkFound = listToUse.get(startIndex);
            }
        }
        return bookmarkFound;
    }

    public Bookmark getPreviousBookmark(Bookmark bookmark, boolean thisURLOnly) {
        return this.getPreviousBookmark(bookmark.getURL(), bookmark.getLine(), thisURLOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark[] findBookmarks(URL url) {
        ArrayList<Bookmark> matchingList = new ArrayList<Bookmark>();
        List list = this.bookmarkList;
        synchronized (list) {
            int numBookmarks = this.bookmarkList.size();
            int i = 0;
            while (i < numBookmarks) {
                Bookmark bookmark = (Bookmark)this.bookmarkList.get(i);
                if (bookmark.matches(url)) {
                    matchingList.add(bookmark);
                }
                ++i;
            }
        }
        int numMatches = matchingList.size();
        return matchingList.toArray(new Bookmark[numMatches]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark findBookmark(URL url, int line) {
        Bookmark foundBookmark = null;
        List list = this.bookmarkList;
        synchronized (list) {
            int numBookmarks = this.bookmarkList.size();
            int i = 0;
            while (i < numBookmarks) {
                Bookmark bookmark = (Bookmark)this.bookmarkList.get(i);
                if (bookmark.matches(url, line)) {
                    foundBookmark = bookmark;
                    break;
                }
                ++i;
            }
        }
        return foundBookmark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark addBookmark(URL url, int line) {
        Bookmark existingBookmark = this.findBookmark(url, line);
        if (existingBookmark != null) {
            return existingBookmark;
        }
        Bookmark newBookmark = new Bookmark(url, line);
        List list = this.bookmarkList;
        synchronized (list) {
            this.insertBookmark(newBookmark);
        }
        return newBookmark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifyBookmark(Bookmark bookmark, int line) {
        boolean result;
        if (bookmark.getLine() == line) {
            return true;
        }
        List list = this.bookmarkList;
        synchronized (list) {
            this.removeBookmark(bookmark);
            bookmark.setLine(line);
            result = this.insertBookmark(bookmark);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBookmark(Bookmark bookmark) {
        List list = this.bookmarkList;
        synchronized (list) {
            int index = this.bookmarkList.indexOf(bookmark);
            if (index != -1) {
                this.bookmarkList.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllBookmarks() {
        List list = this.bookmarkList;
        synchronized (list) {
            this.bookmarkList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertBookmark(Bookmark bookmarkToInsert) {
        BookmarkComparator comparator = BookmarkComparator.BOOKMARK_COMPARATOR;
        boolean result = true;
        List list = this.bookmarkList;
        synchronized (list) {
            boolean inserted = false;
            int numBookmarks = this.bookmarkList.size();
            int i = 0;
            while (i < numBookmarks) {
                Bookmark bookmark = (Bookmark)this.bookmarkList.get(i);
                int order = comparator.compare(bookmarkToInsert, bookmark);
                if (order < 0) {
                    this.bookmarkList.add(i, bookmarkToInsert);
                    inserted = true;
                    break;
                }
                if (order == 0) {
                    inserted = true;
                    result = false;
                    break;
                }
                ++i;
            }
            if (!inserted) {
                this.bookmarkList.add(bookmarkToInsert);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object copyTo(Object target) {
        BookmarkList copy = target != null ? (BookmarkList)target : new BookmarkList();
        List list = copy.bookmarkList;
        synchronized (list) {
            copy.bookmarkList.clear();
            copy.bookmarkList.addAll(this.bookmarkList);
        }
        return copy;
    }

    public List getBookmarkList() {
        return this.bookmarkList;
    }

    public void setBookmarkList(List list) {
        this.bookmarkList = list;
    }
}

