/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.config.DTCache;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.bookmarks.Bookmark;
import oracle.jdevimpl.bookmarks.BookmarkList;
import oracle.jdevimpl.bookmarks.BookmarkOptions;
import oracle.jdevimpl.bookmarks.OpenBookmark;
import oracle.jdevimpl.bookmarks.OpenEditor;
import oracle.jdevimpl.bookmarks.resource.BookmarkArb;

final class BookmarkManager
implements EditorListener,
GutterColumnListener {
    private static final int VERY_BIG_LINE = 2000000000;
    private static Icon bookmarkIcon;
    private static final HighlightStyle bookmarkStyle;
    private static final String BOOKMARK_STYLE = "bookmark-style";
    private static final String BOOKMARK_COLUMN = "bookmark-column";
    private static final String BOOKMARKLIST_KEY = "ojb.BookmarkList";
    private BookmarkList bookmarkList;
    private List openEditorList;

    BookmarkManager() {
        this.$init$();
        this.startup();
    }

    private void startup() {
        EditorManager editorManager = EditorManager.getEditorManager();
        editorManager.addEditorListener((EditorListener)this);
        if (this.shouldRemoveBookmarksWhenShutdown()) {
            this.clearBookmarksFromStorage();
        } else {
            this.loadBookmarksFromStorage();
        }
    }

    void shutdown() {
        EditorManager editorManager = EditorManager.getEditorManager();
        editorManager.removeEditorListener((EditorListener)this);
        if (this.shouldRemoveBookmarksWhenShutdown()) {
            this.clearBookmarksFromStorage();
        } else {
            this.saveBookmarksToStorage();
        }
    }

    void toggleBookmark(CodeEditor codeEditor) {
        int line = codeEditor.getCaretLine();
        this.toggleBookmark(codeEditor, line);
    }

    void toggleBookmark(CodeEditor codeEditor, int line) {
        URL url = this.getURLFor(codeEditor);
        if (url == null) {
            return;
        }
        Bookmark bookmark = this.bookmarkList.findBookmark(url, line);
        if (bookmark == null) {
            this.createBookmarkFor(url, line);
        } else {
            this.removeBookmark(bookmark);
        }
    }

    boolean hasBookmarks() {
        return this.bookmarkList.getBookmarkCount() != 0;
    }

    boolean hasBookmarks(CodeEditor codeEditor) {
        URL url = this.getURLFor(codeEditor);
        if (url == null) {
            return false;
        }
        Bookmark bookmark = this.bookmarkList.getNextBookmark(url, 0, true);
        return bookmark != null;
    }

    Bookmark[] getAllBookmarks() {
        return this.bookmarkList.getAllBookmarks();
    }

    boolean canGotoNextBookmark(CodeEditor codeEditor) {
        return this.gotoNextBookmark(codeEditor, false);
    }

    void gotoNextBookmark(CodeEditor codeEditor) {
        this.gotoNextBookmark(codeEditor, true);
    }

    boolean gotoNextBookmark(CodeEditor codeEditor, boolean performGoto) {
        boolean thisURLOnly = this.shouldOnlyTraverseCurrent();
        boolean openEditorsOnly = this.shouldOnlyTraverseOpen();
        URL url = this.getURLFor(codeEditor);
        if (url == null) {
            return false;
        }
        int line = codeEditor.getCaretLine();
        Bookmark nextBookmark = this.bookmarkList.getNextBookmark(url, line, thisURLOnly);
        if (openEditorsOnly) {
            Bookmark sentinel = nextBookmark;
            while (nextBookmark != null) {
                URL nextURL = nextBookmark.getURL();
                if (this.hasOpenEditorsFor(nextURL)) break;
                int lineToUse = Math.max(nextBookmark.getLine() + 1, 2000000000);
                if ((nextBookmark = this.bookmarkList.getNextBookmark(nextURL, lineToUse, false)) != sentinel) continue;
                nextBookmark = null;
            }
        }
        if (nextBookmark != null) {
            if (performGoto) {
                this.gotoBookmark(nextBookmark);
            }
            return true;
        }
        return false;
    }

    boolean canGotoPreviousBookmark(CodeEditor codeEditor) {
        return this.gotoPreviousBookmark(codeEditor, false);
    }

    void gotoPreviousBookmark(CodeEditor codeEditor) {
        this.gotoPreviousBookmark(codeEditor, true);
    }

    boolean gotoPreviousBookmark(CodeEditor codeEditor, boolean performGoto) {
        boolean thisURLOnly = this.shouldOnlyTraverseCurrent();
        boolean openEditorsOnly = this.shouldOnlyTraverseOpen();
        URL url = this.getURLFor(codeEditor);
        if (url == null) {
            return false;
        }
        int line = codeEditor.getCaretLine();
        Bookmark previousBookmark = this.bookmarkList.getPreviousBookmark(url, line, thisURLOnly);
        if (openEditorsOnly) {
            Bookmark sentinel = previousBookmark;
            while (previousBookmark != null) {
                URL previousURL = previousBookmark.getURL();
                if (this.hasOpenEditorsFor(previousURL)) break;
                previousBookmark = this.bookmarkList.getPreviousBookmark(previousURL, 1, false);
                if (previousBookmark != sentinel) continue;
                previousBookmark = null;
            }
        }
        if (previousBookmark != null) {
            if (performGoto) {
                this.gotoBookmark(previousBookmark);
            }
            return true;
        }
        return false;
    }

    void gotoBookmark(Bookmark bookmark) {
        Workspace activeWorkspace = Ide.getActiveWorkspace();
        Project activeProject = Ide.getActiveProject();
        Context context = new Context(activeWorkspace, activeProject);
        URL url = bookmark.getURL();
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            context.setNode(node);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, CodeEditor.class);
            EditorManager editorManager = EditorManager.getEditorManager();
            Editor editor = editorManager.openEditor(openEditorOptions);
            if (editor instanceof CodeEditor) {
                NavigationManager mgr = NavigationManager.getNavigationManager();
                Context editorContext = editor.getContext();
                LineNavigationPoint point = new LineNavigationPoint(editorContext, bookmark.getLine(), 1, false);
                mgr.navigateTo((NavigationPoint)point);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void removeAllBookmarks() {
        Bookmark[] allBookmarks = this.getAllBookmarks();
        int numBookmarks = allBookmarks.length;
        int i = 0;
        while (i < numBookmarks) {
            this.removeBookmark(allBookmarks[i]);
            ++i;
        }
    }

    void removeAllBookmarks(CodeEditor codeEditor) {
        URL url = this.getURLFor(codeEditor);
        if (url == null) {
            return;
        }
        Bookmark bookmark = this.bookmarkList.getNextBookmark(url, 0, true);
        while (bookmark != null) {
            this.removeBookmark(bookmark);
            bookmark = this.bookmarkList.getNextBookmark(url, 0, true);
        }
    }

    void removeBookmark(Bookmark bookmark) {
        this.bookmarkList.removeBookmark(bookmark);
        OpenBookmark[] openBookmarks = this.getOpenBookmarksFor(bookmark);
        int numBookmarks = openBookmarks.length;
        int i = 0;
        while (i < numBookmarks) {
            OpenBookmark openBookmark = openBookmarks[i];
            OpenEditor openEditor = this.getOpenEditorFor(openBookmark);
            if (openEditor != null) {
                openEditor.openBookmarkList.remove(openBookmark);
                openBookmark.guttermark.getGutterColumn().removeGutterMark(openBookmark.guttermark);
            }
            ++i;
        }
    }

    static {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        String translatedName = BookmarkArb.getString(39);
        bookmarkStyle = registry.createStyle(BOOKMARK_STYLE, translatedName, 20, Color.black, new Color(153, 255, 255));
        FileOverviewMargin.setMarkColor((String)BOOKMARK_COLUMN, (HighlightStyle)bookmarkStyle);
    }

    private void $init$() {
        this.bookmarkList = new BookmarkList();
        this.openEditorList = new ArrayList();
    }

    private static Icon getBookmarkIcon() {
        if (bookmarkIcon == null) {
            bookmarkIcon = BookmarkArb.getIcon(3);
        }
        return bookmarkIcon;
    }

    private void clearBookmarksFromStorage() {
        BookmarkList emptyCopy = new BookmarkList();
        DTCache storage = Ide.getDTCache();
        storage.putData(BOOKMARKLIST_KEY, (Copyable)emptyCopy);
    }

    private void createBookmarkFor(URL url, int line) {
        Bookmark bookmark = this.bookmarkList.addBookmark(url, line);
        OpenEditor[] openEditors = this.getOpenEditorsFor(url);
        int numEditors = openEditors.length;
        int i = 0;
        while (i < numEditors) {
            OpenEditor openEditor = openEditors[i];
            this.createGutterColumnFor(openEditor.editor);
            OpenBookmark openBookmark = this.createOpenBookmarkFor(openEditor.gutter, bookmark);
            openEditor.openBookmarkList.add(openBookmark);
            ++i;
        }
    }

    private boolean isBookmarkOnOpenList(Bookmark bookmark) {
        URL url = bookmark.getURL();
        return this.hasOpenEditorsFor(url);
    }

    private void loadBookmarksFromStorage() {
        DTCache storage = Ide.getDTCache();
        BookmarkList storageCopy = (BookmarkList)storage.getData(BOOKMARKLIST_KEY);
        if (storageCopy != null) {
            storageCopy.copyTo(this.bookmarkList);
        }
    }

    private void saveBookmarksToStorage() {
        BookmarkList copyList = (BookmarkList)this.bookmarkList.copyTo(null);
        DTCache storage = Ide.getDTCache();
        storage.putData(BOOKMARKLIST_KEY, (Copyable)copyList);
    }

    private BookmarkOptions getBookmarkOptions() {
        return BookmarkOptions.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private boolean shouldOnlyTraverseCurrent() {
        int behavior = this.getBookmarkOptions().getTraverseBehavior();
        return behavior == 1;
    }

    private boolean shouldOnlyTraverseOpen() {
        int behavior = this.getBookmarkOptions().getTraverseBehavior();
        return behavior == 2;
    }

    private boolean shouldRemoveBookmarksWhenEditorClose() {
        return this.getBookmarkOptions().getDiscardOnClose();
    }

    private boolean shouldRemoveBookmarksWhenShutdown() {
        return this.getBookmarkOptions().getDiscardOnExit();
    }

    private boolean shouldRemoveBookmarkForNonExistentLine() {
        int behavior = this.getBookmarkOptions().getMissingLineBehavior();
        return behavior == 2;
    }

    private OpenBookmark getOpenBookmarkFor(GutterMark gutterMark) {
        CodeEditorGutter gutter = (CodeEditorGutter)gutterMark.getGutter();
        OpenEditor openEditor = this.getOpenEditorFor(gutter);
        List openBookmarkList = openEditor.openBookmarkList;
        int numBookmarks = openBookmarkList.size();
        int i = 0;
        while (i < numBookmarks) {
            OpenBookmark openBookmark = (OpenBookmark)openBookmarkList.get(i);
            if (openBookmark.guttermark == gutterMark) {
                return openBookmark;
            }
            ++i;
        }
        return null;
    }

    private OpenEditor getOpenEditorFor(CodeEditorGutter gutter) {
        int numEditors = this.openEditorList.size();
        int i = 0;
        while (i < numEditors) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            if (openEditor.gutter == gutter) {
                return openEditor;
            }
            ++i;
        }
        return null;
    }

    private OpenBookmark[] getOpenBookmarksFor(Bookmark bookmark) {
        ArrayList<OpenBookmark> matchingList = new ArrayList<OpenBookmark>();
        int numEditors = this.openEditorList.size();
        int i = 0;
        while (i < numEditors) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            OpenBookmark openBookmark = this.getOpenBookmarkFor(openEditor, bookmark);
            if (openBookmark != null) {
                matchingList.add(openBookmark);
            }
            ++i;
        }
        int numMatches = matchingList.size();
        return matchingList.toArray(new OpenBookmark[numMatches]);
    }

    private OpenBookmark getOpenBookmarkFor(OpenEditor openEditor, Bookmark bookmark) {
        List openBookmarkList = openEditor.openBookmarkList;
        int numBookmarks = openBookmarkList.size();
        int i = 0;
        while (i < numBookmarks) {
            OpenBookmark openBookmark = (OpenBookmark)openBookmarkList.get(i);
            if (openBookmark.bookmark == bookmark) {
                return openBookmark;
            }
            ++i;
        }
        return null;
    }

    private OpenEditor getOpenEditorFor(OpenBookmark openBookmark) {
        int numEditors = this.openEditorList.size();
        int i = 0;
        while (i < numEditors) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            if (openEditor.openBookmarkList.contains(openBookmark)) {
                return openEditor;
            }
            ++i;
        }
        return null;
    }

    private boolean hasOpenEditorsFor(URL url) {
        int numEditors = this.openEditorList.size();
        int i = 0;
        while (i < numEditors) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            if (openEditor.url.equals(url)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private OpenEditor[] getOpenEditorsFor(URL url) {
        ArrayList<OpenEditor> matchingList = new ArrayList<OpenEditor>();
        int numEditors = this.openEditorList.size();
        int i = 0;
        while (i < numEditors) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            if (openEditor.url.equals(url)) {
                matchingList.add(openEditor);
            }
            ++i;
        }
        int numMatches = matchingList.size();
        return matchingList.toArray(new OpenEditor[numMatches]);
    }

    private OpenEditor getOpenEditorFor(CodeEditor codeEditor) {
        int numEditors = this.openEditorList.size();
        int i = 0;
        while (i < numEditors) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            if (openEditor.editor == codeEditor) {
                return openEditor;
            }
            ++i;
        }
        return null;
    }

    private URL getURLFor(CodeEditor codeEditor) {
        Node node;
        Context context;
        if (codeEditor != null && (context = codeEditor.getContext()) != null && (node = context.getNode()) != null) {
            return node.getURL();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Bookmark[] getNormalizedBookmarksFor(CodeEditor codeEditor, URL url) {
        validList = new ArrayList<Bookmark>();
        bookmarks = this.bookmarkList.findBookmarks(url);
        numBookmarks = bookmarks.length;
        lineCount = codeEditor.getLineCount();
        i = 0;
        while (i < numBookmarks) {
            bookmark = bookmarks[i];
            v0 = lineNotFound = bookmark.getLine() > lineCount;
            if (!lineNotFound) ** GOTO lbl-1000
            if (this.isBookmarkOnOpenList(bookmark)) {
                throw new IllegalStateException("bad line open elsewhere");
            }
            shouldRemove = this.shouldRemoveBookmarkForNonExistentLine();
            if (!shouldRemove && !(bookmarkMoved = this.bookmarkList.modifyBookmark(bookmark, lineCount))) {
                shouldRemove = true;
            }
            if (shouldRemove) {
                this.bookmarkList.removeBookmark(bookmark);
                bookmarks[i] = null;
            } else lbl-1000:
            // 2 sources

            {
                validList.add(bookmark);
            }
            ++i;
        }
        validBookmarks = validList.size();
        return validList.toArray(new Bookmark[validBookmarks]);
    }

    private void createGutterColumnFor(CodeEditor codeEditor) {
        CodeEditorGutter gutter = codeEditor.getGutter();
        if (gutter.lookupGutterColumn(BOOKMARK_COLUMN) == null) {
            gutter.createGutterColumn(BOOKMARK_COLUMN, this);
        }
    }

    private void removeGutterColumnFrom(CodeEditor codeEditor) {
        CodeEditorGutter gutter = codeEditor.getGutter();
        GutterColumn column = gutter.lookupGutterColumn(BOOKMARK_COLUMN);
        if (column != null) {
            gutter.removeGutterColumn(column);
        }
    }

    private OpenBookmark createOpenBookmarkFor(CodeEditorGutter gutter, Bookmark bookmark) {
        GutterColumn column = gutter.lookupGutterColumn(BOOKMARK_COLUMN);
        GutterMark gutterMark = column.addGutterMark(bookmark.getLine(), BookmarkManager.getBookmarkIcon(), bookmarkStyle, 2000, 5);
        OpenBookmark openBookmark = new OpenBookmark(bookmark, gutterMark);
        return openBookmark;
    }

    private OpenEditor createOpenEditorFor(CodeEditor codeEditor) {
        URL url = this.getURLFor(codeEditor);
        if (url == null) {
            return null;
        }
        Bookmark[] bookmarks = this.getNormalizedBookmarksFor(codeEditor, url);
        int numBookmarks = bookmarks.length;
        CodeEditorGutter gutter = codeEditor.getGutter();
        ArrayList<OpenBookmark> openBookmarkList = new ArrayList<OpenBookmark>();
        if (numBookmarks > 0) {
            this.createGutterColumnFor(codeEditor);
            int i = 0;
            while (i < numBookmarks) {
                Bookmark bookmark = bookmarks[i];
                OpenBookmark openBookmark = this.createOpenBookmarkFor(gutter, bookmark);
                openBookmarkList.add(openBookmark);
                ++i;
            }
        }
        OpenEditor openEditor = new OpenEditor(codeEditor, url, gutter, openBookmarkList);
        return openEditor;
    }

    public void editorOpened(Editor editor) {
        if (editor instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)editor;
            OpenEditor openEditor = this.createOpenEditorFor(codeEditor);
            this.openEditorList.add(openEditor);
        }
    }

    public void editorClosed(Editor editor) {
        if (editor instanceof CodeEditor) {
            OpenEditor[] otherEditors;
            URL url;
            CodeEditor codeEditor = (CodeEditor)editor;
            OpenEditor openEditor = this.getOpenEditorFor(codeEditor);
            this.removeGutterColumnFrom(codeEditor);
            this.openEditorList.remove(openEditor);
            if (this.shouldRemoveBookmarksWhenEditorClose() && (url = this.getURLFor(codeEditor)) != null && (otherEditors = this.getOpenEditorsFor(url)).length == 0) {
                List openBookmarkList = openEditor.openBookmarkList;
                int numBookmarks = openBookmarkList.size();
                int i = 0;
                while (i < numBookmarks) {
                    OpenBookmark openBookmark = (OpenBookmark)openBookmarkList.get(i);
                    Bookmark bookmark = openBookmark.bookmark;
                    this.removeBookmark(bookmark);
                    ++i;
                }
            }
        }
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
        Bookmark bookmark;
        boolean bookmarkMoved;
        OpenBookmark openBookmark = this.getOpenBookmarkFor(gutterMark);
        if (openBookmark != null && !(bookmarkMoved = this.bookmarkList.modifyBookmark(bookmark = openBookmark.bookmark, newLine))) {
            this.removeBookmark(bookmark);
        }
    }

    public void markRemoved(GutterMark gutterMark, int deletedLine) {
        OpenBookmark openBookmark = this.getOpenBookmarkFor(gutterMark);
        if (openBookmark != null) {
            Bookmark bookmark = openBookmark.bookmark;
            this.removeBookmark(bookmark);
        }
    }

    public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
        this.markRemoved(gutterMark, clickedLine);
    }

    public String getMarkToolTip(GutterMark mark, MouseEvent event) {
        OpenBookmark openBookmark = this.getOpenBookmarkFor(mark);
        if (openBookmark != null) {
            Bookmark bookmark = openBookmark.bookmark;
            return BookmarkArb.format(1, Integer.toString(bookmark.getLine()));
        }
        return null;
    }
}

