/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.tigris.subversion.javahl.BlameCallback;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Info;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClient;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.svnclientadapter.AbstractClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNInfoUnversioned;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNNotificationHandler;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.javahl.JhlAnnotations;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;
import org.tigris.subversion.svnclientadapter.javahl.JhlInfo;
import org.tigris.subversion.svnclientadapter.javahl.JhlInfo2;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlPromptUserPassword;
import org.tigris.subversion.svnclientadapter.javahl.JhlPropertyData;
import org.tigris.subversion.svnclientadapter.javahl.JhlStatus;
import org.tigris.subversion.svnclientadapter.utils.Messages;

public abstract class AbstractJhlClientAdapter
extends AbstractClientAdapter {
    protected static final int SVN_ERR_WC_NOT_DIRECTORY = 155007;
    protected SVNClientInterface svnClient;
    protected JhlNotificationHandler notificationHandler;

    public SVNClientInterface getSVNClient() {
        return this.svnClient;
    }

    public void addNotifyListener(ISVNNotifyListener listener) {
        this.notificationHandler.add(listener);
    }

    public void removeNotifyListener(ISVNNotifyListener listener) {
        this.notificationHandler.remove(listener);
    }

    public SVNNotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    public void setUsername(String username) {
        this.svnClient.username(username);
    }

    public void setPassword(String password) {
        this.notificationHandler.setCommand(0);
        this.svnClient.password(password);
    }

    public void setPromptUserPassword(PromptUserPassword prompt) {
        this.svnClient.setPrompt(prompt);
    }

    protected static String fileToSVNPath(File file, boolean canonical) {
        if (canonical) {
            try {
                return file.getCanonicalPath().replace('\\', '/');
            }
            catch (IOException e) {
                return null;
            }
        }
        return file.getPath().replace('\\', '/');
    }

    public void addFile(File file) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(1);
            this.notificationHandler.logCommandLine("add -N " + file.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.add(AbstractJhlClientAdapter.fileToSVNPath(file, false), false);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void addDirectory(File file, boolean recurse) throws SVNClientException {
        this.addDirectory(file, recurse, false);
    }

    public void addDirectory(File dir, boolean recurse, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(1);
            this.notificationHandler.logCommandLine("add" + (recurse ? "" : " -N") + (force ? " --force" : "") + " " + dir.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(dir));
            this.svnClient.add(AbstractJhlClientAdapter.fileToSVNPath(dir, false), recurse, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void checkout(SVNUrl moduleName, File destPath, SVNRevision revision, boolean recurse) throws SVNClientException {
        try {
            String url = moduleName.toString();
            this.notificationHandler.setCommand(2);
            this.notificationHandler.logCommandLine("checkout" + (recurse ? "" : " -N") + " -r " + revision.toString() + " " + url);
            this.notificationHandler.setBaseDir(new File("."));
            this.svnClient.checkout(url, AbstractJhlClientAdapter.fileToSVNPath(destPath, false), JhlConverter.convert(revision), JhlConverter.convert(revision), recurse, false);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public long commit(File[] paths, String message, boolean recurse) throws SVNClientException {
        return this.commit(paths, message, recurse, false);
    }

    public long commit(File[] paths, String message, boolean recurse, boolean keepLocks) throws SVNClientException {
        try {
            if (message == null) {
                message = "";
            }
            this.notificationHandler.setCommand(3);
            String[] files = new String[paths.length];
            String commandLine = "commit -m \"" + message + "\"";
            if (!recurse) {
                commandLine = commandLine + " -N";
            }
            if (keepLocks) {
                commandLine = commandLine + " --no-unlock";
            }
            for (int i = 0; i < paths.length; ++i) {
                files[i] = AbstractJhlClientAdapter.fileToSVNPath(paths[i], false);
                commandLine = commandLine + " " + files[i];
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(paths));
            long newRev = this.svnClient.commit(files, message, recurse, keepLocks);
            if (newRev > 0L) {
                this.notificationHandler.logCompleted("Committed revision " + newRev + ".");
            }
            return newRev;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNDirEntry[] getList(SVNUrl url, SVNRevision revision, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(11);
            String commandLine = "list -r " + revision.toString() + (recurse ? "-R" : "") + " " + url.toString();
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(new File("."));
            return JhlConverter.convert(this.svnClient.list(url.toString(), JhlConverter.convert(revision), recurse));
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNDirEntry[] getList(File path, SVNRevision revision, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(11);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String commandLine = "list -r " + revision.toString() + (recurse ? "-R" : "") + " " + path;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(new File("."));
            return JhlConverter.convert(this.svnClient.list(target, JhlConverter.convert(revision), recurse));
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNDirEntry getDirEntry(SVNUrl url, SVNRevision revision) throws SVNClientException {
        ISVNDirEntry[] entries = this.getList(url.getParent(), revision, false);
        String expectedPath = url.getLastPathSegment();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getPath().equals(expectedPath)) continue;
            return entries[i];
        }
        return null;
    }

    public ISVNDirEntry getDirEntry(File path, SVNRevision revision) throws SVNClientException {
        ISVNDirEntry[] entries = this.getList(path.getParentFile(), revision, false);
        String expectedPath = path.getName();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getPath().equals(expectedPath)) continue;
            return entries[i];
        }
        return null;
    }

    public ISVNStatus getSingleStatus(File path) throws SVNClientException {
        return this.getStatus(new File[]{path})[0];
    }

    public ISVNStatus[] getStatus(File[] path) throws SVNClientException {
        this.notificationHandler.setCommand(12);
        String[] filePathSVN = new String[path.length];
        String commandLine = "status -N --no-ignore";
        for (int i = 0; i < filePathSVN.length; ++i) {
            filePathSVN[i] = AbstractJhlClientAdapter.fileToSVNPath(path[i], false);
            commandLine = commandLine + " " + filePathSVN[i];
        }
        this.notificationHandler.logCommandLine(commandLine);
        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
        ISVNStatus[] statuses = new ISVNStatus[path.length];
        for (int i = 0; i < filePathSVN.length; ++i) {
            try {
                Status status = this.svnClient.singleStatus(filePathSVN[i], false);
                if (status == null) {
                    statuses[i] = new SVNStatusUnversioned(path[i]);
                    continue;
                }
                statuses[i] = new JhlStatus(status);
                continue;
            }
            catch (ClientException e) {
                if (e.getAprError() == 155007) {
                    statuses[i] = new SVNStatusUnversioned(path[i]);
                    continue;
                }
                this.notificationHandler.logException((Exception)((Object)e));
                throw new SVNClientException(e);
            }
        }
        return statuses;
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll) throws SVNClientException {
        return this.getStatus(path, descend, getAll, false);
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer) throws SVNClientException {
        return this.getStatus(path, descend, getAll, contactServer, false);
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals) throws SVNClientException {
        this.notificationHandler.setCommand(12);
        String filePathSVN = AbstractJhlClientAdapter.fileToSVNPath(path, false);
        this.notificationHandler.logCommandLine("status " + (contactServer ? "-u " : "") + filePathSVN);
        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
        try {
            return this.processFolderStatuses(this.processExternalStatuses(JhlConverter.convert(this.svnClient.status(filePathSVN, descend, contactServer, getAll, getAll, ignoreExternals))), getAll, contactServer);
        }
        catch (ClientException e) {
            if (e.getAprError() == 155007) {
                return new ISVNStatus[]{new SVNStatusUnversioned(path)};
            }
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    protected JhlStatus[] processExternalStatuses(JhlStatus[] statuses) throws SVNClientException {
        JhlStatus jhlStatus;
        int index;
        ArrayList<Integer> externalStatusesIndexes = new ArrayList<Integer>();
        for (int i = 0; i < statuses.length; ++i) {
            if (!SVNStatusKind.EXTERNAL.equals(statuses[i].getTextStatus())) continue;
            externalStatusesIndexes.add(new Integer(i));
        }
        if (externalStatusesIndexes.isEmpty()) {
            return statuses;
        }
        Iterator iter = externalStatusesIndexes.iterator();
        while (iter.hasNext()) {
            index = (Integer)iter.next();
            jhlStatus = statuses[index];
            for (int i = 0; i < statuses.length; ++i) {
                if (statuses[i].getPath() == null || !statuses[i].getPath().equals(jhlStatus.getPath())) continue;
                statuses[i] = new JhlStatus.JhlStatusExternal(statuses[i]);
                statuses[index] = statuses[i];
            }
        }
        iter = externalStatusesIndexes.iterator();
        while (iter.hasNext()) {
            ISVNInfo info;
            index = (Integer)iter.next();
            jhlStatus = statuses[index];
            if (jhlStatus.getUrlString() != null && jhlStatus.getUrlString().length() != 0 || (info = this.getInfoFromWorkingCopy(jhlStatus.getFile())) == null) continue;
            statuses[index] = new JhlStatus.JhlStatusExternal(jhlStatus, info.getUrlString());
        }
        return statuses;
    }

    protected ISVNStatus[] processFolderStatuses(JhlStatus[] statuses, boolean getAll, boolean contactServer) throws SVNClientException {
        JhlStatus jhlStatus;
        int i;
        if (!getAll || !contactServer) {
            return statuses;
        }
        ArrayList<JhlStatus> folders = new ArrayList<JhlStatus>();
        for (i = 0; i < statuses.length; ++i) {
            jhlStatus = statuses[i];
            if (SVNNodeKind.DIR != jhlStatus.getNodeKind() || jhlStatus.getReposLastChangedRevision() != null) continue;
            folders.add(jhlStatus);
        }
        for (i = 0; i < statuses.length; ++i) {
            jhlStatus = statuses[i];
            if (jhlStatus.getLastChangedRevision() == null) continue;
            Iterator iter = folders.iterator();
            while (iter.hasNext()) {
                JhlStatus folder = (JhlStatus)iter.next();
                if (!jhlStatus.getUrlString().startsWith(folder.getUrlString() + "/") || folder.getLastChangedRevision() != null && folder.getLastChangedRevision().getNumber() >= jhlStatus.getLastChangedRevision().getNumber()) continue;
                folder.updateFromStatus(jhlStatus);
            }
        }
        return statuses;
    }

    public void copy(File srcPath, File destPath) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(6);
            String src = AbstractJhlClientAdapter.fileToSVNPath(srcPath, false);
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("copy " + src + " " + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{srcPath, destPath}));
            this.svnClient.copy(src, dest, "", Revision.WORKING);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void copy(File srcPath, SVNUrl destUrl, String message) throws SVNClientException {
        try {
            if (message == null) {
                message = "";
            }
            this.notificationHandler.setCommand(6);
            String src = AbstractJhlClientAdapter.fileToSVNPath(srcPath, false);
            String dest = destUrl.toString();
            this.notificationHandler.logCommandLine("copy " + src + " " + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(srcPath));
            this.svnClient.copy(src, dest, message, Revision.WORKING);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void copy(SVNUrl srcUrl, File destPath, SVNRevision revision) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(6);
            String src = srcUrl.toString();
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("copy " + src + " " + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(destPath));
            this.svnClient.copy(src, dest, "", JhlConverter.convert(revision));
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void copy(SVNUrl srcUrl, SVNUrl destUrl, String message, SVNRevision revision) throws SVNClientException {
        try {
            if (message == null) {
                message = "";
            }
            this.notificationHandler.setCommand(6);
            String src = srcUrl.toString();
            String dest = destUrl.toString();
            this.notificationHandler.logCommandLine("copy -r" + revision.toString() + " " + src + " " + dest);
            this.notificationHandler.setBaseDir();
            this.svnClient.copy(src, dest, message, JhlConverter.convert(revision));
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void remove(SVNUrl[] url, String message) throws SVNClientException {
        try {
            if (message == null) {
                message = "";
            }
            this.notificationHandler.setCommand(7);
            String commandLine = "delete -m \"" + message + "\"";
            String[] targets = new String[url.length];
            for (int i = 0; i < url.length; ++i) {
                targets[i] = url[i].toString();
                commandLine = commandLine + " " + targets[i];
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            this.svnClient.remove(targets, message, false);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void remove(File[] file, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(7);
            String commandLine = "delete" + (force ? " --force" : "");
            String[] targets = new String[file.length];
            for (int i = 0; i < file.length; ++i) {
                targets[i] = AbstractJhlClientAdapter.fileToSVNPath(file[i], false);
                commandLine = commandLine + " " + targets[i];
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.remove(targets, "", force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void doExport(SVNUrl srcUrl, File destPath, SVNRevision revision, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(8);
            String src = srcUrl.toString();
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("export -r " + revision.toString() + ' ' + src + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(destPath));
            this.svnClient.doExport(src, dest, JhlConverter.convert(revision), force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void doExport(File srcPath, File destPath, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(8);
            String src = AbstractJhlClientAdapter.fileToSVNPath(srcPath, false);
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("export " + src + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{srcPath, destPath}));
            this.svnClient.doExport(src, dest, Revision.WORKING, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void doImport(File path, SVNUrl url, String message, boolean recurse) throws SVNClientException {
        try {
            if (message == null) {
                message = "";
            }
            this.notificationHandler.setCommand(9);
            String src = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String dest = url.toString();
            this.notificationHandler.logCommandLine("import -m \"" + message + "\" " + (recurse ? "" : "-N ") + src + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this.svnClient.doImport(src, dest, message, recurse);
            this.notificationHandler.logCompleted(Messages.bind("notify.import.complete"));
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void mkdir(SVNUrl url, String message) throws SVNClientException {
        try {
            if (message == null) {
                message = "";
            }
            this.notificationHandler.setCommand(10);
            String target = url.toString();
            this.notificationHandler.logCommandLine("mkdir -m \"" + message + "\" " + target);
            this.notificationHandler.setBaseDir();
            this.svnClient.mkdir(new String[]{target}, message);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void mkdir(File file) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(10);
            String target = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            this.notificationHandler.logCommandLine("mkdir " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.mkdir(new String[]{target}, "");
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void move(File srcPath, File destPath, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(5);
            String src = AbstractJhlClientAdapter.fileToSVNPath(srcPath, false);
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("move " + src + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{srcPath, destPath}));
            this.svnClient.move(src, dest, "", Revision.HEAD, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void move(SVNUrl srcUrl, SVNUrl destUrl, String message, SVNRevision revision) throws SVNClientException {
        try {
            if (message == null) {
                message = "";
            }
            this.notificationHandler.setCommand(5);
            String src = srcUrl.toString();
            String dest = destUrl.toString();
            this.notificationHandler.logCommandLine("move -m \"" + message + "\" -r " + revision.toString() + ' ' + src + ' ' + dest);
            this.notificationHandler.setBaseDir();
            this.svnClient.move(src, dest, message, JhlConverter.convert(revision), false);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public long update(File path, SVNRevision revision, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(4);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("update -r " + revision.toString() + ' ' + (recurse ? "" : "-N ") + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            return this.svnClient.update(target, JhlConverter.convert(revision), recurse);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public long[] update(File[] path, SVNRevision revision, boolean recurse, boolean ignoreExternals) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(4);
            String[] targets = new String[path.length];
            StringBuffer targetsString = new StringBuffer();
            for (int i = 0; i < targets.length; ++i) {
                targets[i] = AbstractJhlClientAdapter.fileToSVNPath(path[i], false);
                targetsString.append(targets[i]);
                targetsString.append(" ");
            }
            this.notificationHandler.logCommandLine("update -r " + revision.toString() + ' ' + (recurse ? "" : "-N ") + (ignoreExternals ? "--ignore-externals " : "") + targetsString.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this.notificationHandler.holdStats();
            long[] rtnCode = this.svnClient.update(targets, JhlConverter.convert(revision), recurse, ignoreExternals);
            this.notificationHandler.releaseStats();
            return rtnCode;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void revert(File path, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(16);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("revert " + (recurse ? "" : "-N ") + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this.svnClient.revert(target, recurse);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public static void enableLogging(int logLevel, File filePath) {
        SVNClient.enableLogging((int)logLevel, (String)AbstractJhlClientAdapter.fileToSVNPath(filePath, false));
    }

    public InputStream getContent(SVNUrl url, SVNRevision revision) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(18);
            this.notificationHandler.logCommandLine("cat -r " + revision.toString() + " " + url.toString());
            this.notificationHandler.setBaseDir();
            byte[] contents = this.svnClient.fileContent(url.toString(), JhlConverter.convert(revision), Revision.HEAD);
            ByteArrayInputStream input = new ByteArrayInputStream(contents);
            return input;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public InputStream getContent(File path, SVNRevision revision) throws SVNClientException {
        try {
            ISVNStatus status;
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.setCommand(18);
            this.notificationHandler.logCommandLine("cat -r " + revision.toString() + " " + target);
            this.notificationHandler.setBaseDir();
            if (revision.equals(SVNRevision.BASE) && (status = this.getSingleStatus(path)).getTextStatus().equals(SVNStatusKind.ADDED)) {
                return new ByteArrayInputStream(new byte[0]);
            }
            byte[] contents = this.svnClient.fileContent(target, JhlConverter.convert(revision));
            ByteArrayInputStream input = new ByteArrayInputStream(contents);
            return input;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNProperty[] getProperties(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("proplist " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            PropertyData[] propertiesData = this.svnClient.properties(target);
            if (propertiesData == null) {
                return new JhlPropertyData[0];
            }
            ISVNProperty[] svnProperties = new JhlPropertyData[propertiesData.length];
            for (int i = 0; i < propertiesData.length; ++i) {
                svnProperties[i] = JhlPropertyData.newForFile(propertiesData[i]);
            }
            return svnProperties;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNProperty[] getProperties(SVNUrl url) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            String target = url.toString();
            this.notificationHandler.logCommandLine("proplist " + target);
            this.notificationHandler.setBaseDir();
            PropertyData[] propertiesData = this.svnClient.properties(target);
            if (propertiesData == null) {
                return new JhlPropertyData[0];
            }
            ISVNProperty[] svnProperties = new JhlPropertyData[propertiesData.length];
            for (int i = 0; i < propertiesData.length; ++i) {
                svnProperties[i] = JhlPropertyData.newForUrl(propertiesData[i]);
            }
            return svnProperties;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void propertySet(File path, String propertyName, String propertyValue, boolean recurse) throws SVNClientException {
        try {
            int i;
            ISVNStatus[] statuses;
            this.notificationHandler.setCommand(14);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("propset " + (recurse ? "-R " : "") + propertyName + " \"" + propertyValue + "\" " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            HashSet<String> statusBefore = null;
            if (recurse) {
                statusBefore = new HashSet<String>();
                statuses = this.getStatus(path, recurse, false);
                for (i = 0; i < statuses.length; ++i) {
                    statusBefore.add(statuses[i].getFile().getAbsolutePath());
                }
            }
            this.svnClient.propertySet(target, propertyName, propertyValue, recurse);
            if (recurse) {
                statuses = this.getStatus(path, recurse, false);
                for (i = 0; i < statuses.length; ++i) {
                    String statusPath = statuses[i].getFile().getAbsolutePath();
                    this.notificationHandler.notifyListenersOfChange(statusPath);
                    statusBefore.remove(statusPath);
                }
                Iterator it = statusBefore.iterator();
                while (it.hasNext()) {
                    this.notificationHandler.notifyListenersOfChange((String)it.next());
                }
            } else {
                this.notificationHandler.notifyListenersOfChange(path.getAbsolutePath());
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void propertySet(File path, String propertyName, File propertyFile, boolean recurse) throws SVNClientException {
        try {
            int i;
            ISVNStatus[] statuses;
            this.notificationHandler.setCommand(14);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("propset " + (recurse ? "-R " : "") + propertyName + "-F \"" + propertyFile.toString() + "\" " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            byte[] propertyBytes = new byte[(int)propertyFile.length()];
            FileInputStream is = null;
            try {
                is = new FileInputStream(propertyFile);
                is.read(propertyBytes);
            }
            catch (IOException ioe) {
                throw new SVNClientException(ioe);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            HashSet<String> statusBefore = null;
            if (recurse) {
                statusBefore = new HashSet<String>();
                statuses = this.getStatus(path, recurse, false);
                for (i = 0; i < statuses.length; ++i) {
                    statusBefore.add(statuses[i].getFile().getAbsolutePath());
                }
            }
            this.svnClient.propertySet(target, propertyName, propertyBytes, recurse);
            if (recurse) {
                statuses = this.getStatus(path, recurse, false);
                for (i = 0; i < statuses.length; ++i) {
                    String statusPath = statuses[i].getFile().getAbsolutePath();
                    this.notificationHandler.notifyListenersOfChange(statusPath);
                    statusBefore.remove(statusPath);
                }
                Iterator it = statusBefore.iterator();
                while (it.hasNext()) {
                    this.notificationHandler.notifyListenersOfChange((String)it.next());
                }
            } else {
                this.notificationHandler.notifyListenersOfChange(path.getAbsolutePath());
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNProperty propertyGet(File path, String propertyName) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(20);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("propget " + propertyName + " " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            PropertyData propData = this.svnClient.propertyGet(target, propertyName);
            if (propData == null) {
                return null;
            }
            return JhlPropertyData.newForFile(propData);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNProperty propertyGet(SVNUrl url, SVNRevision revision, SVNRevision peg, String propertyName) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(20);
            String target = url.toString();
            String commandLine = "propget -r " + revision.toString() + " " + propertyName + " " + target;
            if (!peg.equals(SVNRevision.HEAD)) {
                commandLine = commandLine + "@" + peg.toString();
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            PropertyData propData = this.svnClient.propertyGet(target, propertyName, JhlConverter.convert(revision), JhlConverter.convert(peg));
            if (propData == null) {
                return null;
            }
            return JhlPropertyData.newForUrl(propData);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void propertyDel(File path, String propertyName, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(15);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("propdel " + propertyName + " " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            HashSet<String> statusBefore = null;
            if (recurse) {
                statusBefore = new HashSet<String>();
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                for (int i = 0; i < statuses.length; ++i) {
                    statusBefore.add(statuses[i].getFile().getAbsolutePath());
                }
            }
            PropertyData propData = this.svnClient.propertyGet(target, propertyName);
            propData.remove(recurse);
            if (recurse) {
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                for (int i = 0; i < statuses.length; ++i) {
                    String statusPath = statuses[i].getFile().getAbsolutePath();
                    this.notificationHandler.notifyListenersOfChange(statusPath);
                    statusBefore.remove(statusPath);
                }
                Iterator it = statusBefore.iterator();
                while (it.hasNext()) {
                    this.notificationHandler.notifyListenersOfChange((String)it.next());
                }
            } else {
                this.notificationHandler.notifyListenersOfChange(path.getAbsolutePath());
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void diff(File oldPath, SVNRevision oldPathRevision, File newPath, SVNRevision newPathRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(oldPath, oldPathRevision, newPath, newPathRevision, outFile, recurse, true, false, false);
    }

    public void diff(File oldPath, SVNRevision oldPathRevision, File newPath, SVNRevision newPathRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (oldPath == null) {
                oldPath = new File(".");
            }
            if (newPath == null) {
                newPath = oldPath;
            }
            if (oldPathRevision == null) {
                oldPathRevision = SVNRevision.BASE;
            }
            if (newPathRevision == null) {
                newPathRevision = SVNRevision.WORKING;
            }
            String oldTarget = AbstractJhlClientAdapter.fileToSVNPath(oldPath, false);
            String newTarget = AbstractJhlClientAdapter.fileToSVNPath(newPath, false);
            String svnOutFile = AbstractJhlClientAdapter.fileToSVNPath(outFile, false);
            String commandLine = "diff ";
            if (oldPathRevision.getKind() != 5 || newPathRevision.getKind() != 6) {
                commandLine = commandLine + "-r " + oldPathRevision.toString();
                if (newPathRevision.getKind() != 6) {
                    commandLine = commandLine + ":" + newPathRevision.toString();
                }
                commandLine = commandLine + " ";
            }
            if (!oldPath.equals(new File("."))) {
                commandLine = commandLine + "--old " + oldTarget + " ";
            }
            if (!newPath.equals(oldPath)) {
                commandLine = commandLine + "--new " + newTarget + " ";
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{oldPath, newPath}));
            this.svnClient.diff(oldTarget, JhlConverter.convert(oldPathRevision), newTarget, JhlConverter.convert(newPathRevision), svnOutFile, recurse, ignoreAncestry, noDiffDeleted, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void diff(File path, File outFile, boolean recurse) throws SVNClientException {
        this.diff(path, null, null, null, outFile, recurse);
    }

    public void diff(SVNUrl oldUrl, SVNRevision oldUrlRevision, SVNUrl newUrl, SVNRevision newUrlRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(oldUrl, oldUrlRevision, newUrl, newUrlRevision, outFile, recurse, true, false, false);
    }

    public void diff(SVNUrl oldUrl, SVNRevision oldUrlRevision, SVNUrl newUrl, SVNRevision newUrlRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (newUrl == null) {
                newUrl = oldUrl;
            }
            if (oldUrlRevision == null) {
                oldUrlRevision = SVNRevision.HEAD;
            }
            if (newUrlRevision == null) {
                newUrlRevision = SVNRevision.HEAD;
            }
            String svnOutFile = AbstractJhlClientAdapter.fileToSVNPath(outFile, false);
            String commandLine = "diff ";
            if (oldUrlRevision.getKind() != 7 || newUrlRevision.getKind() != 7) {
                commandLine = commandLine + "-r " + oldUrlRevision.toString();
                if (newUrlRevision.getKind() != 7) {
                    commandLine = commandLine + ":" + newUrlRevision.toString();
                }
                commandLine = commandLine + " ";
            }
            commandLine = commandLine + oldUrl + " ";
            if (!newUrl.equals(oldUrl)) {
                commandLine = commandLine + newUrl + " ";
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            this.svnClient.diff(oldUrl.toString(), JhlConverter.convert(oldUrlRevision), newUrl.toString(), JhlConverter.convert(newUrlRevision), svnOutFile, recurse, ignoreAncestry, noDiffDeleted, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void diff(SVNUrl url, SVNRevision oldUrlRevision, SVNRevision newUrlRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(url, oldUrlRevision, url, newUrlRevision, outFile, recurse);
    }

    private ISVNAnnotations annotate(String target, SVNRevision revisionStart, SVNRevision revisionEnd) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(25);
            if (revisionStart == null) {
                revisionStart = new SVNRevision.Number(1L);
            }
            if (revisionEnd == null) {
                revisionEnd = SVNRevision.HEAD;
            }
            String commandLine = "blame ";
            commandLine = commandLine + "-r " + revisionEnd.toString() + " ";
            commandLine = commandLine + target + "@HEAD";
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            JhlAnnotations annotations = new JhlAnnotations();
            this.svnClient.blame(target, Revision.HEAD, JhlConverter.convert(revisionStart), JhlConverter.convert(revisionEnd), (BlameCallback)annotations);
            return annotations;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNAnnotations annotate(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd) throws SVNClientException {
        return this.annotate(url.toString(), revisionStart, revisionEnd);
    }

    public ISVNAnnotations annotate(File file, SVNRevision revisionStart, SVNRevision revisionEnd) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(file, false);
        ISVNInfo info = this.getInfoFromWorkingCopy(file);
        if (SVNScheduleKind.ADD == info.getSchedule() && info.getCopyUrl() != null) {
            target = info.getCopyUrl().toString();
        }
        return this.annotate(target, revisionStart, revisionEnd);
    }

    public void resolved(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(22);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, true);
            this.notificationHandler.logCommandLine("resolved " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this.svnClient.resolved(target, false);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void cancelOperation() throws SVNClientException {
        try {
            this.svnClient.cancelOperation();
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNInfo getInfoFromWorkingCopy(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("info " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            Info info = this.svnClient.info(target);
            if (info == null) {
                return new SVNInfoUnversioned(path);
            }
            return new JhlInfo(path, info);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNInfo getInfo(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("info " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            Info info = this.svnClient.info(target);
            if (info == null) {
                return new SVNInfoUnversioned(path);
            }
            if (info.getLastChangedRevision() == -1L) {
                return new JhlInfo(path, info);
            }
            Info2[] info2 = this.svnClient.info2(target, Revision.HEAD, Revision.HEAD, false);
            if (info2 == null || info2.length == 0) {
                return new SVNInfoUnversioned(path);
            }
            return new JhlInfo2(path, info2[0]);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNInfo getInfo(SVNUrl url, SVNRevision revision, SVNRevision peg) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String target = url.toString();
            this.notificationHandler.logCommandLine("info " + target);
            Info2[] info = this.svnClient.info2(target, JhlConverter.convert(revision), JhlConverter.convert(peg), false);
            if (info == null || info.length == 0) {
                return new SVNInfoUnversioned(null);
            }
            return new JhlInfo2(null, info[0]);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(26);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String commandLine = "switch " + url + " " + target + " " + "-r" + revision.toString();
            if (!recurse) {
                commandLine = commandLine + " -N";
            }
            this.notificationHandler.logCommandLine(commandLine);
            File baseDir = SVNBaseDir.getBaseDir(path);
            this.notificationHandler.setBaseDir(baseDir);
            this.svnClient.doSwitch(target, url.toString(), JhlConverter.convert(revision), recurse);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void setConfigDirectory(File dir) throws SVNClientException {
        try {
            this.svnClient.setConfigDirectory(AbstractJhlClientAdapter.fileToSVNPath(dir, false));
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void cleanup(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(24);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String commandLine = "cleanup " + target;
            this.notificationHandler.logCommandLine(commandLine);
            this.svnClient.cleanup(target);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, boolean recurse, boolean dryRun, boolean ignoreAncestry) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(27);
            String target = AbstractJhlClientAdapter.fileToSVNPath(localPath, false);
            String commandLine = "merge";
            boolean samePath = false;
            if (!recurse) {
                commandLine = commandLine + " -N";
            }
            if (dryRun) {
                commandLine = commandLine + " --dry-run";
            }
            if (force) {
                commandLine = commandLine + " --force";
            }
            if (ignoreAncestry) {
                commandLine = commandLine + " --ignore-ancestry";
            }
            if (path1.toString().equals(path2.toString())) {
                samePath = true;
                commandLine = commandLine + " -r" + revision1.toString() + ":" + revision2.toString() + " " + path1;
            } else {
                commandLine = commandLine + " " + path1 + "@" + revision1.toString() + " " + path2 + "@" + revision2.toString();
            }
            commandLine = commandLine + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            File baseDir = SVNBaseDir.getBaseDir(localPath);
            this.notificationHandler.setBaseDir(baseDir);
            if (samePath) {
                Revision peg = JhlConverter.convert(revision2);
                this.svnClient.merge(path1.toString(), peg, JhlConverter.convert(revision1), JhlConverter.convert(revision2), target, force, recurse, ignoreAncestry, dryRun);
            } else {
                this.svnClient.merge(path1.toString(), JhlConverter.convert(revision1), path2.toString(), JhlConverter.convert(revision2), target, force, recurse, ignoreAncestry, dryRun);
            }
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge complete.");
            } else {
                this.notificationHandler.logCompleted("Merge complete.");
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void addPasswordCallback(ISVNPromptUserPassword callback) {
        if (callback != null) {
            JhlPromptUserPassword prompt = new JhlPromptUserPassword(callback);
            this.setPromptUserPassword((PromptUserPassword)prompt);
        }
    }

    public void lock(SVNUrl[] uris, String comment, boolean force) throws SVNClientException {
        this.notImplementedYet();
    }

    public void unlock(SVNUrl[] uris, boolean force) throws SVNClientException {
        this.notImplementedYet();
    }

    public void lock(File[] paths, String comment, boolean force) throws SVNClientException {
        try {
            int i;
            this.notificationHandler.setCommand(28);
            String[] files = new String[paths.length];
            String commandLine = "lock -m \"" + comment + "\"";
            if (force) {
                commandLine = commandLine + " --force";
            }
            for (i = 0; i < paths.length; ++i) {
                files[i] = AbstractJhlClientAdapter.fileToSVNPath(paths[i], false);
                commandLine = commandLine + " " + files[i];
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(paths));
            this.svnClient.lock(files, comment, force);
            for (i = 0; i < files.length; ++i) {
                this.notificationHandler.notifyListenersOfChange(files[i]);
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
        }
    }

    public void unlock(File[] paths, boolean force) throws SVNClientException {
        try {
            int i;
            this.notificationHandler.setCommand(28);
            String[] files = new String[paths.length];
            String commandLine = "unlock ";
            if (force) {
                commandLine = commandLine + " --force";
            }
            for (i = 0; i < paths.length; ++i) {
                files[i] = AbstractJhlClientAdapter.fileToSVNPath(paths[i], false);
                commandLine = commandLine + " " + files[i];
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(paths));
            this.svnClient.unlock(files, force);
            for (i = 0; i < files.length; ++i) {
                this.notificationHandler.notifyListenersOfChange(files[i]);
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
        }
    }

    public void setRevProperty(SVNUrl url, SVNRevision.Number revisionNo, String propName, String propertyData, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(14);
            this.notificationHandler.logCommandLine("propset --revprop -r " + revisionNo.toString() + (force ? "--force " : "") + " \"" + propName + "\"  \"" + propertyData + "\" " + url.toString());
            this.notificationHandler.setBaseDir();
            this.svnClient.setRevProperty(url.toString(), propName, Revision.getInstance((long)revisionNo.getNumber()), propertyData, true);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public String getAdminDirectoryName() {
        return this.svnClient.getAdminDirectoryName();
    }

    public boolean isAdminDirectory(String name) {
        return this.svnClient.isAdminDirectory(name);
    }

    public ISVNLogMessage[] getLogMessages(File path, SVNRevision revisionStart, SVNRevision revisionEnd, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(path, revisionStart, revisionEnd, false, fetchChangePath);
    }

    public ISVNLogMessage[] getLogMessages(File path, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(path, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, 0L);
    }

    public ISVNLogMessage[] getLogMessages(File path, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
        ISVNInfo info = this.getInfoFromWorkingCopy(path);
        if (SVNScheduleKind.ADD == info.getSchedule() && info.getCopyUrl() != null) {
            target = info.getCopyUrl().toString();
        }
        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
        return this.getLogMessages(target, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd, boolean fetchChangePath) throws SVNClientException {
        String target = url.toString();
        this.notificationHandler.setBaseDir();
        return this.getLogMessages(target, revisionStart, revisionEnd, false, fetchChangePath, 0L);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        String target = url.toString();
        this.notificationHandler.setBaseDir();
        return this.getLogMessages(target, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, String[] paths, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    private ISVNLogMessage[] getLogMessages(String target, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(13);
            String logExtras = "";
            if (stopOnCopy) {
                logExtras = logExtras + " --stop-on-copy";
            }
            if (limit > 0L) {
                logExtras = logExtras + " --limit " + limit;
            }
            this.notificationHandler.logCommandLine("log -r " + revisionStart.toString() + ":" + revisionEnd.toString() + " " + target + logExtras);
            return JhlConverter.convert(this.svnClient.logMessages(target, JhlConverter.convert(revisionStart), JhlConverter.convert(revisionEnd), stopOnCopy, fetchChangePath, limit));
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void relocate(String from, String to, String path, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(30);
            if (recurse) {
                this.notificationHandler.logCommandLine("switch --relocate " + from + " " + to + " " + path);
            } else {
                this.notificationHandler.logCommandLine("switch --relocate -N" + from + " " + to + " " + path);
            }
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File(path)));
            this.svnClient.relocate(from, to, path, recurse);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void diff(File path, SVNUrl url, SVNRevision urlRevision, File outFile, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            String wcPath = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String svnOutFile = AbstractJhlClientAdapter.fileToSVNPath(outFile, false);
            String commandLine = "diff --old " + wcPath + " ";
            commandLine = commandLine + "--new " + url.toString();
            if (!urlRevision.equals(SVNRevision.HEAD)) {
                commandLine = commandLine + "@" + urlRevision.toString();
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this.svnClient.diff(wcPath, Revision.WORKING, url.toString(), JhlConverter.convert(urlRevision), svnOutFile, recurse);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void mkdir(SVNUrl url, boolean makeParents, String message) throws SVNClientException {
        SVNUrl parent;
        if (makeParents && (parent = url.getParent()) != null) {
            ISVNInfo info;
            block4: {
                info = null;
                try {
                    info = this.getInfo(parent);
                }
                catch (SVNClientException e) {
                    ClientException ce;
                    if (!(e.getCause() instanceof ClientException) || (ce = (ClientException)e.getCause()).getAprError() == 170000) break block4;
                    throw e;
                }
            }
            if (info == null) {
                this.mkdir(parent, makeParents, message);
            }
        }
        this.mkdir(url, message);
    }

    public static class DefaultPromptUserPassword
    implements PromptUserPassword {
        public String askQuestion(String realm, String question, boolean showAnswer) {
            return "";
        }

        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            return yesIsDefault;
        }

        public String getPassword() {
            return "";
        }

        public String getUsername() {
            return "";
        }

        public boolean prompt(String realm, String username) {
            return false;
        }
    }
}

