/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.highlighting;

import java.io.File;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.migration.gui.highlighting.HighLightingBlock;
import oracle.dbtools.migration.gui.logger.FileLog;
import oracle.dbtools.migration.gui.logger.LoggerRosetta;
import oracle.dbtools.migration.parser.log.TranslationMessages;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighLightingBlocks {
    protected ArrayList<HighLightingBlock> m_blocks;
    protected LoggerRosetta m_log = new FileLog();

    public HighLightingBlocks() {
        this.init();
    }

    public HighLightingBlocks(String string) {
        this.init();
        this.loadFromXML(string);
    }

    protected void init() {
        this.m_blocks = new ArrayList();
    }

    public void SetBlocks(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = nArray.length < nArray2.length ? nArray.length : nArray2.length;
        for (int i = 0; i < n; ++i) {
            HighLightingBlock highLightingBlock = new HighLightingBlock(nArray[i], nArray2[i], nArray3[i], nArray4[i]);
            this.m_blocks.add(highLightingBlock);
        }
    }

    public ArrayList<HighLightingBlock> getBlocks() {
        return this.m_blocks;
    }

    public void LoadFromXMLString(String string) {
        try {
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(stringBufferInputStream);
            this.SetBlocks(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.m_log.writeLog(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            this.m_log.writeLog(sAXException.getMessage());
        }
        catch (Exception exception) {
            this.m_log.writeLog(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void loadFromXML(String string) {
        try {
            File file = new File(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            this.SetBlocks(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.m_log.writeLog(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            this.m_log.writeLog(sAXException.getMessage());
        }
        catch (Exception exception) {
            this.m_log.writeLog(exception.getMessage());
        }
    }

    protected void SetBlocks(Document document) {
        NodeList nodeList = document.getElementsByTagName("highlighting");
        this.m_blocks.clear();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            try {
                int n = Integer.parseInt(namedNodeMap.getNamedItem("startline").getNodeValue());
                int n2 = Integer.parseInt(namedNodeMap.getNamedItem("startcolumn").getNodeValue());
                int n3 = Integer.parseInt(namedNodeMap.getNamedItem("numchars").getNodeValue());
                int n4 = Integer.parseInt(namedNodeMap.getNamedItem("type").getNodeValue());
                HighLightingBlock highLightingBlock = new HighLightingBlock(n, n2, n3, n4);
                this.m_blocks.add(highLightingBlock);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.m_log.writeLog(numberFormatException.getMessage());
                numberFormatException.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        HighLightingBlocks highLightingBlocks = new HighLightingBlocks("D:\\workspace-rosetta-new\\translation_ui\\examples\\foldingtest1.xml");
        ArrayList<HighLightingBlock> arrayList = highLightingBlocks.getBlocks();
        for (int i = 0; i < arrayList.size(); ++i) {
            TranslationMessages.debuginfo((String)(arrayList.get((int)i).m_startline + ";" + arrayList.get((int)i).m_startcolumn + ";" + arrayList.get((int)i).m_count));
        }
    }
}

