/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.highlighting;

import java.awt.Color;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;

public class HighlightingFactory {
    private static final EditorProperties m_properties = EditorProperties.getProperties();
    private static final HighlightRegistry m_registry = m_properties.getHighlightRegistry();
    private static final String[] m_styleNames = new String[]{"zebraHighlight", "keywordHighlight", "commentHighlight", "identifierHighlight", "operatorHighlight"};

    public static HighlightStyle getHighlight(int n) {
        HighlightStyle highlightStyle = null;
        switch (n) {
            case 1: {
                highlightStyle = HighlightingFactory.getIdentifierHighlight();
                break;
            }
            case 2: {
                highlightStyle = HighlightingFactory.getKeywordHighlight();
                break;
            }
            case 3: {
                highlightStyle = HighlightingFactory.getCommentHighlight();
                break;
            }
            case 4: {
                highlightStyle = HighlightingFactory.getOperatorHighlight();
            }
        }
        return highlightStyle;
    }

    public static HighlightStyle getZebraHighlight() {
        HighlightStyle highlightStyle = m_registry.lookupStyle(m_styleNames[0]);
        if (highlightStyle == null) {
            String string = m_styleNames[0];
            String string2 = m_styleNames[0];
            Color color = Color.white;
            Color color2 = Color.blue;
            int n = 100;
            int n2 = 0;
            highlightStyle = m_registry.createStyle(string, string2, true, n, color, color2, n2, -1, null);
        }
        return highlightStyle;
    }

    public static HighlightStyle getKeywordHighlight() {
        HighlightStyle highlightStyle = m_registry.lookupStyle(m_styleNames[1]);
        if (highlightStyle == null) {
            String string = m_styleNames[1];
            String string2 = m_styleNames[1];
            Color color = Color.black;
            Color color2 = Color.white;
            int n = 1;
            int n2 = 1;
            highlightStyle = m_registry.createStyle(string, string2, true, n, color, color2, n2, -1, null);
        }
        return highlightStyle;
    }

    public static HighlightStyle getCommentHighlight() {
        HighlightStyle highlightStyle = m_registry.lookupStyle(m_styleNames[2]);
        if (highlightStyle == null) {
            String string = m_styleNames[2];
            String string2 = m_styleNames[2];
            Color color = Color.green;
            Color color2 = Color.white;
            int n = 1;
            int n2 = 2;
            highlightStyle = m_registry.createStyle(string, string2, true, n, color, color2, n2, -1, null);
        }
        return highlightStyle;
    }

    public static HighlightStyle getOperatorHighlight() {
        HighlightStyle highlightStyle = m_registry.lookupStyle(m_styleNames[4]);
        if (highlightStyle == null) {
            String string = m_styleNames[4];
            String string2 = m_styleNames[4];
            Color color = Color.red;
            Color color2 = Color.white;
            int n = 1;
            int n2 = 0;
            highlightStyle = m_registry.createStyle(string, string2, true, n, color, color2, n2, -1, null);
        }
        return highlightStyle;
    }

    public static HighlightStyle getIdentifierHighlight() {
        HighlightStyle highlightStyle = m_registry.lookupStyle(m_styleNames[3]);
        if (highlightStyle == null) {
            String string = m_styleNames[3];
            String string2 = m_styleNames[3];
            Color color = Color.blue;
            Color color2 = Color.white;
            int n = 1;
            int n2 = 2;
            highlightStyle = m_registry.createStyle(string, string2, true, n, color, color2, n2, -1, null);
        }
        return highlightStyle;
    }
}

