/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.newzebra;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import oracle.dbtools.metadata.persistence.DBObjectHierarchy;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.convert.TranslationContext;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.gui.newzebra.ZebraEditor;
import oracle.dbtools.migration.gui.newzebra.ZebraNode;
import oracle.dbtools.migration.gui.scratch.ScratchEditor;
import oracle.dbtools.migration.gui.scratch.ScratchMainPanel;
import oracle.dbtools.migration.parser.internalapi.ITranslationAll;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.ITranslationLogging;
import oracle.dbtools.migration.translation.api.ITranslationManager;
import oracle.dbtools.migration.translation.api.TranslationResult;
import oracle.dbtools.migration.translation.api.TranslationSession;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFormatHelper;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.geneditor.TSQLController;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.javatools.dialogs.MessageDialog;

public class CompareInitiator
extends AbstractMenuAction {
    public void launch() {
        try {
            Context context = this.getContext();
            DBObject dBObject = this.getDBObject();
            MigrationURLFormatHelper migrationURLFormatHelper = new MigrationURLFormatHelper();
            PersistenceUtility persistenceUtility = PersistenceUtility.getInstance((PersistenceManager)MigrationAddin.getPersistenceManager());
            PersistableObject persistableObject = persistenceUtility.loadPersistableObject(MigrationURLFormatHelper.getObjectId((URL)dBObject.getURL()), MigrationUtils.mapSDToSDMWType((String)dBObject.getObjectType()));
            DBObjectHierarchy dBObjectHierarchy = new DBObjectHierarchy(persistableObject, MigrationAddin.getPersistenceManager());
            PersistableObject persistableObject2 = ConvertUtils.findPersistableOrigional((PersistenceManager)MigrationAddin.getPersistenceManager(), (PersistableObject)persistableObject, (DBObjectId)dBObjectHierarchy.getConnection().getKey());
            DBObjectHierarchy dBObjectHierarchy2 = new DBObjectHierarchy(persistableObject2, MigrationAddin.getPersistenceManager());
            MdConnection mdConnection = dBObjectHierarchy.getConnection();
            MigrationPlugin migrationPlugin = MigrationAddin.findPlugin((String)MigrationUtils.getPluginIdForConnection((MdConnection)mdConnection));
            TranslationDBObject translationDBObject = this.getTranslationDBObject(dBObjectHierarchy2);
            ScratchEditor scratchEditor = TSQLController.openScratchEditor();
            scratchEditor.getSourceEditor().setText(translationDBObject.getDdl());
            ((ScratchMainPanel)scratchEditor.getGUI()).migrateAction();
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "MigrationLog.UNKNOWN_ERROR";
            }
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Translation Problem Encountered", (String)"Translation Problem Encountered", null);
        }
    }

    private TranslationContext getTranslationContext(DBObjectId dBObjectId) {
        TranslationContext translationContext = null;
        try {
            translationContext = new TranslationContext(MigrationAddin.getPersistenceManager(), dBObjectId, 100, null);
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable((String)persistenceException.getLocalizedMessage(), (String)"Convert", (Throwable)persistenceException);
        }
        return translationContext;
    }

    private TranslationDBObject getTranslationDBObject(DBObjectHierarchy dBObjectHierarchy) {
        TranslationDBObject translationDBObject = null;
        try {
            translationDBObject = ConvertUtils.asDBObject((String)dBObjectHierarchy.getConnection().getHost(), (String)dBObjectHierarchy.getCatalog().getCatalogName(), (String)dBObjectHierarchy.getSchema().getName(), (MdStoredProgram)((MdStoredProgram)dBObjectHierarchy.getObject()));
        }
        catch (IOException iOException) {
            MigrationLogUtil.logThrowable((String)iOException.getLocalizedMessage(), (String)"Convert", (Throwable)iOException);
        }
        return translationDBObject;
    }

    private void openTranslationDiffViewer(Block block, TranslationDBObject translationDBObject, TranslationDBObject translationDBObject2) {
        String string = "Oracle Diff " + translationDBObject.getFullName();
        ZebraNode zebraNode = new ZebraNode(URLFactory.newFileURL((String)string), "TSQL", "PL/SQL");
        Context context = Context.newIdeContext((Node)zebraNode);
        context.setProperty("zebra.file1String", (Object)translationDBObject.getDdl());
        context.setProperty("zebra.file2String", (Object)translationDBObject2.getDdl());
        context.setProperty("zebra.ignoreWS", (Object)true);
        context.setProperty("zebra.ancestorFile", null);
        context.setProperty("zebra.algorithmEngine", (Object)block);
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
        openEditorOptions.setFlags(1);
        ZebraEditor zebraEditor = (ZebraEditor)EditorManager.getEditorManager().openEditor(openEditorOptions);
    }

    private TranslationResult Translate(TranslationDBObject translationDBObject, ITranslationContext iTranslationContext, Converter converter) {
        ITranslationAll iTranslationAll = (ITranslationAll)converter.getPlaformTranslator();
        TranslationResult translationResult = null;
        try {
            if (translationDBObject.getDdl().trim().length() > 0) {
                ITranslationLogging iTranslationLogging = null;
                ITranslationManager iTranslationManager = null;
                TranslationSession translationSession = null;
                translationResult = iTranslationAll.translate(translationDBObject, iTranslationContext, iTranslationLogging, iTranslationManager, translationSession);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return translationResult;
    }

    private String standardizeNewLines(String string) {
        return string.replaceAll("\r\n", "\n");
    }

    public void setArgs(String string) {
    }
}

