/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.scratch;

import java.awt.Component;
import javax.swing.Icon;
import oracle.dbtools.migration.gui.scratch.ScratchMainPanel;
import oracle.dbtools.migration.parser.ParserFactory;
import oracle.dbtools.migration.parser.internalapi.ITranslationAll;
import oracle.dbtools.raptor.geneditor.RosettaArb;
import oracle.dbtools.raptor.geneditor.config.ParserSetting;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.dialogs.MessageDialog;

public class ScratchController
implements Controller {
    private static final Object LOCK = new Object();
    private static ScratchController m_controller;
    protected static final int MAIN_SE_CMD_ID;
    protected static final int NEW_SE_CMD_ID;
    protected static final int OPEN_SE_CMD_ID;
    protected static final int MIGRATE_SE_CMD_ID;
    protected static final int SAVE_SE_CMD_ID;
    protected static final int ZEBRA_SE_CMD_ID;
    protected static IdeAction m_genEditorToolbarMain;
    protected static IdeAction m_genEditorToolbarNew;
    protected static IdeAction m_genEditorToolbarOpen;
    protected static IdeAction m_genEditorToolbarMigrate;
    protected static IdeAction m_genEditorToolbarZebra;
    protected static IdeAction m_genEditorToolbarSave;

    private ScratchController() {
        this.createActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScratchController getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (m_controller == null) {
                m_controller = new ScratchController();
            }
        }
        return m_controller;
    }

    private void createActions() {
        String string = null;
        m_genEditorToolbarNew = IdeAction.get((int)NEW_SE_CMD_ID, null, (String)RosettaArb.getString(10), string, (Integer)new Integer(2), (Icon)RosettaArb.getIcon(11), null, (boolean)true);
        m_genEditorToolbarNew.addController((Controller)this);
        m_genEditorToolbarOpen = IdeAction.get((int)OPEN_SE_CMD_ID, null, (String)RosettaArb.getString(8), string, (Integer)new Integer(3), (Icon)RosettaArb.getIcon(9), null, (boolean)true);
        m_genEditorToolbarOpen.addController((Controller)this);
        m_genEditorToolbarMigrate = IdeAction.get((int)MIGRATE_SE_CMD_ID, null, (String)RosettaArb.getString(12), string, (Integer)new Integer(4), (Icon)RosettaArb.getIcon(13), null, (boolean)true);
        m_genEditorToolbarMigrate.addController((Controller)this);
        m_genEditorToolbarZebra = IdeAction.get((int)ZEBRA_SE_CMD_ID, null, (String)RosettaArb.getString(14), string, (Integer)new Integer(5), (Icon)RosettaArb.getIcon(15), null, (boolean)true);
        m_genEditorToolbarZebra.addController((Controller)this);
        m_genEditorToolbarSave = IdeAction.get((int)SAVE_SE_CMD_ID, null, (String)RosettaArb.getString(16), string, (Integer)new Integer(5), (Icon)RosettaArb.getIcon(17), null, (boolean)true);
        m_genEditorToolbarSave.addController((Controller)this);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n != NEW_SE_CMD_ID) {
            if (n == MIGRATE_SE_CMD_ID) {
                this.migrateAction(ideAction, context);
            } else if (n == OPEN_SE_CMD_ID || n == SAVE_SE_CMD_ID || n == ZEBRA_SE_CMD_ID) {
                // empty if block
            }
        }
        return false;
    }

    private void migrateAction(IdeAction ideAction, Context context) {
        Component component = context.getView().getGUI();
        if (component instanceof ScratchMainPanel) {
            ScratchMainPanel scratchMainPanel = (ScratchMainPanel)component;
            String string = scratchMainPanel.getSourceSWText();
            if (ParserSetting.getParserString() == null) {
                return;
            }
            ITranslationAll iTranslationAll = (ITranslationAll)ParserFactory.getParser((String)ParserSetting.getParserString());
            try {
                if (string.trim().length() > 0) {
                    String string2 = iTranslationAll.translate(string);
                    scratchMainPanel.setTargetSWText(string2);
                }
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Translating ", (String)"Problem encountered ", null);
            }
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    static {
        MAIN_SE_CMD_ID = Ide.findOrCreateCmdID((String)"scratcheditor.main");
        NEW_SE_CMD_ID = Ide.findOrCreateCmdID((String)"scratcheditor.new");
        OPEN_SE_CMD_ID = Ide.findOrCreateCmdID((String)"scratcheditor.open");
        MIGRATE_SE_CMD_ID = Ide.findOrCreateCmdID((String)"scratcheditor.migrate");
        SAVE_SE_CMD_ID = Ide.findOrCreateCmdID((String)"scratcheditor.save");
        ZEBRA_SE_CMD_ID = Ide.findOrCreateCmdID((String)"scratcheditor.zebra");
        m_genEditorToolbarMain = null;
        m_genEditorToolbarNew = null;
        m_genEditorToolbarOpen = null;
        m_genEditorToolbarMigrate = null;
        m_genEditorToolbarZebra = null;
        m_genEditorToolbarSave = null;
    }
}

