/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.scratch;

import java.awt.Component;
import java.io.IOException;
import java.util.EventObject;
import oracle.dbtools.migration.gui.scratch.ScratchMainPanel;
import oracle.dbtools.migration.gui.scratch.ScratchNode;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorController;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorNode;
import oracle.ide.Context;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.editor.BasicEditorPane;

public class ScratchEditor
extends Editor
implements FindableEditor {
    Component m_uiComponent = null;
    private SqlEditorController _controller = null;

    public ScratchEditor() {
        this.getGUI().requestFocus();
        this.addViewListener(new ViewListener(){

            public void viewActivated(ViewEvent viewEvent) {
                Toolbar toolbar = ((ScratchMainPanel)ScratchEditor.this.m_uiComponent).getSqlEditorSource().getToolbar();
                Toolbar toolbar2 = ((ScratchMainPanel)ScratchEditor.this.m_uiComponent).getSqlEditorTarget().getToolbar();
                View.updateToolbarActions((Toolbar)toolbar);
                View.updateToolbarActions((Toolbar)toolbar2);
            }

            public void viewClosed(ViewEvent viewEvent) {
            }

            public void viewDeactivated(ViewEvent viewEvent) {
            }
        });
    }

    public void open() {
    }

    public synchronized void close() {
        Node node = this.getContext().getNode();
        if (node instanceof ScratchNode) {
            ScratchNode scratchNode = (ScratchNode)node;
            try {
                scratchNode.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        ((ScratchMainPanel)this.m_uiComponent).getSqlEditorSource().close();
        ((ScratchMainPanel)this.m_uiComponent).getSqlEditorTarget().close();
        try {
            ((ScratchMainPanel)this.m_uiComponent).getSourceSqlNode().close();
            ((ScratchMainPanel)this.m_uiComponent).getTargetSqlNode().close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        super.close();
    }

    public Object getEditorAttribute(String string) {
        if ("horizontal_scrollbar_policy".equals(string)) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string)) {
            return new Integer(21);
        }
        if ("scrollable".equals(string)) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }

    public Component getGUI() {
        if (this.m_uiComponent == null) {
            this.m_uiComponent = new ScratchMainPanel();
        }
        this._controller = (SqlEditorController)((ScratchMainPanel)this.m_uiComponent).getSqlEditorSource().getController();
        return this.m_uiComponent;
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public Controller getController() {
        return this._controller;
    }

    public Context getContext(EventObject eventObject) {
        boolean bl = true;
        try {
            bl = ((ScratchMainPanel)this.getGUI()).isSourceSelected();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.setId(((ScratchMainPanel)this.getGUI()).getSqlEditorSource().getId());
        } else {
            this.setId(((ScratchMainPanel)this.getGUI()).getSqlEditorTarget().getId());
        }
        SqlEditor sqlEditor = bl ? ((ScratchMainPanel)this.getGUI()).getSqlEditorSource() : ((ScratchMainPanel)this.getGUI()).getSqlEditorTarget();
        Node node = this.getSelectedNode();
        Context context = Context.newIdeContext((View)sqlEditor, (EventObject)eventObject);
        context.setNode(node);
        return context;
    }

    public BasicEditorPane getFocusedEditorPane() {
        boolean bl = ((ScratchMainPanel)this.getGUI()).isSourceSelected();
        BasicEditorPane basicEditorPane = bl ? ((ScratchMainPanel)this.m_uiComponent).getSqlEditorSource().getFocusedEditorPane() : ((ScratchMainPanel)this.m_uiComponent).getSqlEditorTarget().getFocusedEditorPane();
        return basicEditorPane;
    }

    protected Element[] getSelectionFromUI() {
        Element[] elementArray;
        Node node = this.getSelectedNode();
        if (node != null) {
            Element[] elementArray2 = new Element[1];
            elementArray = elementArray2;
            elementArray2[0] = node;
        } else {
            elementArray = super.getSelectionFromUI();
        }
        return elementArray;
    }

    private Node getSelectedNode() {
        SqlEditorNode sqlEditorNode = null;
        sqlEditorNode = ((ScratchMainPanel)this.getGUI()).isSourceSelected() ? ((ScratchMainPanel)this.m_uiComponent).getSourceSqlEditorNode() : ((ScratchMainPanel)this.m_uiComponent).getTargetSqlEditorNode();
        return sqlEditorNode;
    }

    public SqlEditorNode getSourceNode() {
        return ((ScratchMainPanel)this.m_uiComponent).getSourceSqlEditorNode();
    }

    public SqlEditorNode getTargetNode() {
        return ((ScratchMainPanel)this.m_uiComponent).getTargetSqlEditorNode();
    }

    public SqlEditor getSourceEditor() {
        return ((ScratchMainPanel)this.m_uiComponent).getSqlEditorSource();
    }
}

