/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.scratch;

import antlr.collections.AST;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dbtools.migration.gui.newzebra.ZebraEditor;
import oracle.dbtools.migration.gui.newzebra.ZebraNode;
import oracle.dbtools.migration.gui.scratch.LanguageComboBoxRenderer;
import oracle.dbtools.migration.parser.ParserFactory;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.parser.internalapi.ITranslationAll;
import oracle.dbtools.migration.parser.internalapi.TranslateResultWithASTs;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.exceptions.TranslationException;
import oracle.dbtools.migration.translation.api.prefs.TranslationPreferences;
import oracle.dbtools.migration.util.Preprocessing;
import oracle.dbtools.migration.workbench.core.preferences.ConfigurationData;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.geneditor.RosettaArb;
import oracle.dbtools.raptor.geneditor.config.ParserSetting;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorController;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorMainPanel;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorNode;
import oracle.dbtools.util.Resource;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;

public class ScratchMainPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JSplitPane m_scratchSplitPane = null;
    private JButton m_buttonTranslate = null;
    private JPanel m_sourcePanel = null;
    private JPanel m_targetPanel = null;
    private CustomTabbedPane m_jTabbedPaneRight = null;
    private CustomTabbedPane m_jTabbedPaneLeft = null;
    private JScrollPane m_jScrollPaneRight2 = null;
    private JTree m_jTreeRight = null;
    private JButton m_jButtonZebra = null;
    private Block m_topblock = null;
    private ITranslationAll m_translator = null;
    private JComboBox m_translatorSelectBox = null;
    private static int panelIDCount = 0;
    private int panelID = 0;
    private ZebraEditor _zebraEditor = null;
    private SqlEditor m_sqlEditorSource = null;
    private SqlEditor m_sqlEditorTarget = null;
    private JComboBox m_connections = null;
    private static final GridBagConstraints LBL_CONS = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 2, 0), 0, 0);
    private boolean isFirstPaint = true;
    private SqlNode m_sourceSqlNode = null;
    private SqlNode m_targetSqlNode = null;
    private SqlEditorNode m_sourceSqlEditorNode = null;
    private SqlEditorNode m_targetSqlEditorNode = null;
    private boolean m_isSourceSelected = true;

    public ScratchMainPanel() {
        this.jbInit();
        this.m_sqlEditorTarget.getFocusedEditorPane().requestFocus();
        this.m_sqlEditorSource.getFocusedEditorPane().requestFocus();
        this.m_sqlEditorTarget.activate();
        this.m_sqlEditorSource.activate();
        this.panelID = panelIDCount++;
    }

    private void initialize() {
        this.setSize(new Dimension(184, 150));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getScratchSplitPane(), "Center");
        this.setupTraversalPolicy();
    }

    private void jbInit() {
        this.initialize();
    }

    private JSplitPane getScratchSplitPane() {
        if (this.m_scratchSplitPane == null) {
            this.m_scratchSplitPane = new JSplitPane();
            this.m_scratchSplitPane.setSize(this.getWidth(), this.getHeight());
            this.m_scratchSplitPane.setOrientation(1);
            this.m_scratchSplitPane.setLeftComponent(this.getSourceSWPane());
            this.m_scratchSplitPane.setRightComponent(this.getTargetSWPanel());
            this.m_scratchSplitPane.setOneTouchExpandable(true);
            this.m_scratchSplitPane.updateUI();
        }
        return this.m_scratchSplitPane;
    }

    public void paint(Graphics graphics) {
        if (this.isFirstPaint) {
            double d = 0.5;
            this.m_scratchSplitPane.setDividerLocation(d);
            this.m_sqlEditorSource.getView().getSplitPane().setDividerLocation(0.75);
            this.m_sqlEditorTarget.getView().getSplitPane().setDividerLocation(0.75);
            this.m_scratchSplitPane.doLayout();
            this.m_sqlEditorSource.getView().doLayout();
            this.m_sqlEditorTarget.getView().doLayout();
            this.isFirstPaint = false;
            this.doLayout();
        }
        super.paint(graphics);
    }

    private void modifyDivider() {
    }

    public String getSourceSWText() {
        return this.m_sqlEditorSource.getText();
    }

    public void setSourceSWText(String string) {
        this.m_sqlEditorSource.setText(string);
        this.m_sqlEditorSource.refreshView();
    }

    public String getTargetSWText() {
        return this.m_sqlEditorTarget.getText();
    }

    public void setTargetSWText(String string) {
        this.m_sqlEditorTarget.setText(string);
        this.m_sqlEditorTarget.refreshView();
    }

    private JButton getButtonTranslate() {
        if (this.m_buttonTranslate == null) {
            this.m_buttonTranslate = new JButton();
            this.m_buttonTranslate.setMnemonic(90);
            this.m_buttonTranslate.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    ScratchMainPanel.this.m_buttonTranslate.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        ScratchMainPanel.this.migrateAction();
                    }
                    catch (Exception exception) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RosettaArb.getString(35) + "\n" + exception.getLocalizedMessage()), (String)RosettaArb.getString(36), null);
                    }
                    catch (Throwable throwable) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RosettaArb.getString(35) + "\n" + throwable.getLocalizedMessage()), (String)RosettaArb.getString(36), null);
                    }
                    ScratchMainPanel.this.m_buttonTranslate.setCursor(Cursor.getDefaultCursor());
                }
            });
            this.m_buttonTranslate.setIcon(RosettaArb.getIcon(24));
            this.m_buttonTranslate.setPreferredSize(new Dimension(20, 20));
            this.m_buttonTranslate.setToolTipText(RosettaArb.getString(12));
        }
        return this.m_buttonTranslate;
    }

    public void migrateAction() throws TranslationException {
        if (ParserSetting.getParserString() == null) {
            return;
        }
        this.m_translator = (ITranslationAll)ParserFactory.getParser((String)ParserSetting.getParserString());
        this.setupTranslatorForScratchEditor(this.m_translator);
        TranslateResultWithASTs translateResultWithASTs = null;
        TextBuffer textBuffer = TextBufferFactory.createTextBuffer();
        textBuffer.append(this.getSourceSWText().toCharArray());
        String string = Preprocessing.preProcessing(textBuffer);
        string = this.standardizeNewLines(string);
        if (string.trim().length() > 0) {
            AST aST;
            translateResultWithASTs = this.m_translator.translateAndGetASTS(string);
            String string2 = translateResultWithASTs.getTargetString();
            this.setTargetSWText(string2);
            TranslationHelper translationHelper = translateResultWithASTs.getHelper();
            if (translationHelper != null) {
                this.m_topblock = translationHelper.getCodeBlockManager().getTopBlock();
            }
            if ((aST = translateResultWithASTs.getAst("SOURCE_AST")) != null) {
                this.getSourceTreePane().setViewportView(this.setupTree(aST));
            } else {
                this.getSourceTreePane().setViewportView(null);
            }
        }
    }

    private void setupTranslatorForScratchEditor(ITranslationAll iTranslationAll) {
        TranslationPreferences translationPreferences = this.getTranslationPreferences(null);
        iTranslationAll.setPreferences(translationPreferences);
    }

    public TranslationPreferences getTranslationPreferences(Object object) {
        TranslationPreferences translationPreferences = new TranslationPreferences();
        translationPreferences.setFormatMask(this.getFormatMaskPreference());
        translationPreferences.setQueryAssignmentPreference(this.getQueryAssignmentPreference());
        translationPreferences.setIsQuotedIdentifierOn(this.getIsQuotedIdentifierOn());
        return translationPreferences;
    }

    private String getFormatMaskPreference() {
        Preferences preferences = null;
        try {
            preferences = Preferences.getPreferences();
        }
        catch (Exception exception) {
            return null;
        }
        ConfigurationData configurationData = ConfigurationData.getInstance((PropertyStorage)preferences);
        return configurationData.getDateFormat();
    }

    private String getQueryAssignmentPreference() {
        Preferences preferences = null;
        try {
            preferences = Preferences.getPreferences();
        }
        catch (Exception exception) {
            return null;
        }
        ConfigurationData configurationData = ConfigurationData.getInstance((PropertyStorage)preferences);
        return configurationData.getQueryAssignment();
    }

    private boolean getIsQuotedIdentifierOn() {
        Preferences preferences = null;
        try {
            preferences = Preferences.getPreferences();
        }
        catch (Exception exception) {
            return true;
        }
        MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
        return migrationConfig.isQuotedIdentifierOn();
    }

    private String standardizeNewLines(String string) {
        return string.replaceAll("\r\n", "\n");
    }

    private JPanel getSourceSWPane() {
        if (this.m_sourcePanel == null) {
            this.m_sourcePanel = new JPanel();
            this.m_sourcePanel.setLayout(new BorderLayout());
            this.m_sourcePanel.add(this.getSourceSWEditor(), "Center");
        }
        this.m_sourcePanel.setMinimumSize(new Dimension(1, 1));
        return this.m_sourcePanel;
    }

    private JPanel getTargetSWPanel() {
        if (this.m_targetPanel == null) {
            this.m_targetPanel = new JPanel();
            this.m_targetPanel.setLayout(new BorderLayout());
            this.m_targetPanel.add(this.getTargetSWEditor(), "Center");
        }
        this.m_targetPanel.setMinimumSize(new Dimension(1, 1));
        return this.m_targetPanel;
    }

    private Component getSourceSWEditor() {
        String string;
        Component component = null;
        if (this.m_jTabbedPaneLeft == null) {
            this.m_jTabbedPaneLeft = new CustomTabbedPane();
            string = "";
            File file = null;
            try {
                file = File.createTempFile("TranslationScratchSource", ".sql", Resource.raptorUserTmp);
                file.deleteOnExit();
                this.m_sourceSqlNode = (SqlNode)NodeFactory.findOrCreate((URL)file.toURL());
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = file.getAbsolutePath();
            this.m_sourceSqlNode.ensureOpen();
            URL uRL = URLFactory.newURL((String)"sqldev.worksheet", (String)(System.currentTimeMillis() + "/" + SqlEditorController.getUniqueTabName((String)"source_scratch_panel")));
            SqlEditorNode sqlEditorNode = new SqlEditorNode(uRL, null);
            sqlEditorNode.setSqlNode(this.m_sourceSqlNode);
            sqlEditorNode.setTempFile(true);
            Context context = Context.newIdeContext((Node)this.m_sourceSqlNode);
            Context context2 = Context.newIdeContext((Node)sqlEditorNode);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context2);
            openEditorOptions.setFlags(1);
            this.m_sqlEditorSource = new SqlEditor();
            sqlEditorNode.add((Object)this.m_sqlEditorSource);
            this.m_sourceSqlEditorNode = sqlEditorNode;
            Toolbar toolbar = this.m_sqlEditorSource.getToolbar();
            if (toolbar != null) {
                toolbar.add((Component)this.getButtonTranslate(), null);
            }
            this.m_sqlEditorSource.setContext(context2);
            this.m_sqlEditorSource.open();
            ((SqlEditorNode)this.m_sqlEditorSource.getContext().getNode()).add((Object)this.m_sqlEditorSource);
            component = this.m_sqlEditorSource.getGUI();
            this.m_sqlEditorSource.getView().setEditorHeaderLabelStr(RosettaArb.getString(37));
            this.modifyToolBarForSource(this.m_sqlEditorSource.getToolbar());
            if (component instanceof SqlEditorMainPanel) {
                CustomTabbedPane customTabbedPane = ((SqlEditorMainPanel)component).getCustomTabbedPanel();
                this.modifyBottomTabForSource(customTabbedPane);
            }
        }
        this.m_sqlEditorSource.getDefaultFocusComponent().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ScratchMainPanel.this.m_isSourceSelected = true;
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        string = this.m_sqlEditorSource.getView().getSQLEditorPane();
        string.getInputMap(2).put(KeyStroke.getKeyStroke(88, 8), "TKeyAction");
        string.getInputMap(2).put(KeyStroke.getKeyStroke(90, 8), "DKeyAction");
        string.getActionMap().put("TKeyAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScratchMainPanel.this.m_buttonTranslate.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    ScratchMainPanel.this.migrateAction();
                }
                catch (Exception exception) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RosettaArb.getString(35) + "\n" + exception.getLocalizedMessage()), (String)RosettaArb.getString(36), null);
                }
                catch (Throwable throwable) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RosettaArb.getString(35) + "\n" + throwable.getLocalizedMessage()), (String)RosettaArb.getString(36), null);
                }
                ScratchMainPanel.this.m_buttonTranslate.setCursor(Cursor.getDefaultCursor());
            }
        });
        string.getActionMap().put("DKeyAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScratchMainPanel.this.m_jButtonZebra.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    ScratchMainPanel.this.migrateAction();
                    ScratchMainPanel.this.zebraAction();
                }
                catch (Exception exception) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RosettaArb.getString(35) + "\n" + exception.getLocalizedMessage()), (String)RosettaArb.getString(36), null);
                }
                catch (Throwable throwable) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RosettaArb.getString(35) + "\n" + throwable.getLocalizedMessage()), (String)RosettaArb.getString(36), null);
                }
                ScratchMainPanel.this.m_jButtonZebra.setCursor(Cursor.getDefaultCursor());
            }
        });
        return component;
    }

    private void modifyBottomTabForSource(CustomTabbedPane customTabbedPane) {
        Object[] objectArray;
        DefaultListModel defaultListModel = customTabbedPane.getTabModel();
        for (Object object : objectArray = defaultListModel.toArray()) {
            if (!(object instanceof DefaultCustomTabPage)) continue;
            String string = ((DefaultCustomTabPage)object).getLabel();
            if (string != null && string.equals("Explain")) {
                defaultListModel.removeElement(object);
                continue;
            }
            if (string != null && string.equals("DBMS Output")) {
                defaultListModel.removeElement(object);
                continue;
            }
            if (string != null && string.equals("OWA Output")) {
                defaultListModel.removeElement(object);
                continue;
            }
            if (string == null || !string.equals("Autotrace")) continue;
            defaultListModel.removeElement(object);
        }
        customTabbedPane.addTab(null, "Source Tree", (Component)this.getSourceTreePane());
    }

    private void modifyToolBarForTarget(Toolbar toolbar) {
        JComboBox jComboBox = null;
        Object var3_3 = null;
        if (toolbar != null) {
            Component[] componentArray;
            for (Component component : componentArray = toolbar.getComponents()) {
                Object object;
                if (component instanceof JComboBox) {
                    jComboBox = (JComboBox)component;
                    continue;
                }
                if (component instanceof JLabel) {
                    toolbar.remove(component);
                    object = (JLabel)component;
                    this.m_sqlEditorTarget.getView().getEditorHeader().add((Component)object, LBL_CONS);
                    continue;
                }
                if (component instanceof JProgressBar) {
                    toolbar.remove(component);
                    object = (JProgressBar)component;
                    this.m_sqlEditorTarget.getView().getEditorHeader().add((Component)object, LBL_CONS);
                    continue;
                }
                if (component instanceof ToolButton) {
                    object = ((ToolButton)component).getAction();
                    if (((IdeAction)object).getCommandId() != SqlEditorController.MONITOR_CMD_ID) continue;
                    toolbar.remove(component);
                    continue;
                }
                if (!(component instanceof JSeparator)) continue;
                toolbar.remove(component);
            }
        }
        int n = jComboBox.getItemCount();
        for (int i = 0; i < n; ++i) {
            String string = (String)jComboBox.getItemAt(i);
            if (this.isOracleConnection(string)) continue;
            jComboBox.removeItem(string);
            --i;
            --n;
        }
    }

    private void addConnectionListener(JComboBox jComboBox) {
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                String string;
                if (itemEvent.getStateChange() == 1 && (string = (String)ScratchMainPanel.this.m_connections.getSelectedItem()) != null && !string.equals("")) {
                    try {
                        Database database = Connections.getInstance().getDatabase(string);
                        String string2 = database.getDatabaseType();
                        String string3 = database.getConnection().getMetaData().getDatabaseProductName();
                        if (string3.equals("Microsoft SQL Server")) {
                            ScratchMainPanel.this.m_translatorSelectBox.setSelectedIndex(0);
                        } else if (string3.equals("Microsoft Access")) {
                            ScratchMainPanel.this.m_translatorSelectBox.setSelectedIndex(1);
                        }
                    }
                    catch (DBException dBException) {
                    }
                    catch (SQLException sQLException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void modifyToolBarForSource(Toolbar toolbar) {
        Box.Filler filler = null;
        if (toolbar != null) {
            Component[] componentArray;
            for (Component component : componentArray = toolbar.getComponents()) {
                Object object;
                if (component instanceof ToolButton) {
                    object = ((ToolButton)component).getAction();
                    if (!(object instanceof IdeAction)) continue;
                    if (((IdeAction)object).getCommandId() == SqlEditorController.AUTOTRACE_CMD_ID) {
                        toolbar.remove(component);
                        continue;
                    }
                    if (((IdeAction)object).getCommandId() == SqlEditorController.EXPLAIN_PLAN_CMD_ID) {
                        toolbar.remove(component);
                        continue;
                    }
                    if (((IdeAction)object).getCommandId() != SqlEditorController.MONITOR_CMD_ID) continue;
                    toolbar.remove(component);
                    continue;
                }
                if (component instanceof JComboBox) {
                    this.m_connections = (JComboBox)component;
                    toolbar.remove(component);
                    this.addConnectionListener(this.m_connections);
                    continue;
                }
                if (component instanceof JLabel) {
                    toolbar.remove(component);
                    object = (JLabel)component;
                    this.m_sqlEditorSource.getView().getEditorHeader().add((Component)object, LBL_CONS);
                    continue;
                }
                if (component instanceof JProgressBar) {
                    toolbar.remove(component);
                    object = (JProgressBar)component;
                    this.m_sqlEditorSource.getView().getEditorHeader().add((Component)object, LBL_CONS);
                    continue;
                }
                if (component instanceof JToolBar.Separator) {
                    toolbar.remove(component);
                    continue;
                }
                if (!(component instanceof Box.Filler)) continue;
                filler = (Box.Filler)component;
            }
        }
        int n = this.m_connections.getItemCount();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.m_connections.getItemAt(i);
            if (!this.isOracleConnection(string)) continue;
            this.m_connections.removeItem(string);
            --i;
            --n;
        }
        Component[] componentArray = this.m_connections.getComponents();
        toolbar.add((Component)this.getButtonTranslate());
        toolbar.add((Component)this.getJButtonZebra());
        toolbar.add((Component)this.getTranslatorSelector());
        toolbar.add(filler);
        toolbar.add((Component)this.m_connections);
    }

    private Component getTargetSWEditor() {
        Component component = null;
        if (this.m_jTabbedPaneRight == null) {
            this.m_jTabbedPaneRight = new CustomTabbedPane();
            File file = null;
            String string = "";
            try {
                file = File.createTempFile("TranslationScratchTarget", ".sql", Resource.raptorUserTmp);
                file.deleteOnExit();
                this.m_targetSqlNode = (SqlNode)NodeFactory.findOrCreate((URL)file.toURL());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.m_targetSqlNode.ensureOpen();
            string = file.getAbsolutePath();
            URL uRL = URLFactory.newURL((String)"sqldev.worksheet", (String)(System.currentTimeMillis() + "/" + SqlEditorController.getUniqueTabName((String)"target_scratch_panel")));
            SqlEditorNode sqlEditorNode = new SqlEditorNode(uRL, null);
            sqlEditorNode.setSqlNode(this.m_targetSqlNode);
            sqlEditorNode.setTempFile(true);
            Context context = Context.newIdeContext((Node)this.m_targetSqlNode);
            Context context2 = Context.newIdeContext((Node)sqlEditorNode);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context2);
            openEditorOptions.setFlags(1);
            this.m_sqlEditorTarget = new SqlEditor();
            sqlEditorNode.add((Object)this.m_sqlEditorTarget);
            this.m_targetSqlEditorNode = sqlEditorNode;
            this.m_sqlEditorTarget.setContext(context2);
            this.m_sqlEditorTarget.open();
            ((SqlEditorNode)this.m_sqlEditorTarget.getContext().getNode()).add((Object)this.m_sqlEditorTarget);
            component = this.m_sqlEditorTarget.getGUI();
            this.m_sqlEditorTarget.getView().setEditorHeaderLabelStr(RosettaArb.getString(38));
            this.modifyToolBarForTarget(this.m_sqlEditorTarget.getToolbar());
            this.m_sqlEditorTarget.getDefaultFocusComponent().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    ScratchMainPanel.this.m_isSourceSelected = false;
                }

                public void focusLost(FocusEvent focusEvent) {
                }
            });
        }
        return component;
    }

    public boolean isOracleConnection(String string) {
        return Connections.getInstance().isOracle(string);
    }

    private JScrollPane getSourceTreePane() {
        if (this.m_jScrollPaneRight2 == null) {
            this.m_jScrollPaneRight2 = new JScrollPane();
        }
        return this.m_jScrollPaneRight2;
    }

    private JTree setupTree(AST aST) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("The Source AST Tree");
        this.createNodes(aST, defaultMutableTreeNode);
        this.m_jTreeRight = new JTree(defaultMutableTreeNode);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        defaultTreeCellRenderer.setLeafIcon(null);
        this.m_jTreeRight.setCellRenderer(defaultTreeCellRenderer);
        for (int i = 0; i < this.m_jTreeRight.getRowCount(); ++i) {
            this.m_jTreeRight.expandRow(i);
        }
        return this.m_jTreeRight;
    }

    private void createNodes(AST aST, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        AST aST2 = aST.getFirstChild();
        for (int i = 0; i < aST.getNumberOfChildren(); ++i) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(aST2.getText() + " " + (aST2.getSourceStartLine() == -1 ? "<NA>" : "<" + aST2.getSourceStartLine() + ":" + aST2.getSourceStartCol() + ">") + " to " + (aST2.getSourceEndLine() == -1 ? "<NA>" : "<" + aST2.getSourceEndLine() + ":" + aST2.getSourceEndCol() + ">"));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.createNodes(aST2, defaultMutableTreeNode2);
            aST2 = aST2.getNextSibling();
        }
    }

    private JComboBox getTranslatorSelector() {
        if (this.m_translatorSelectBox == null) {
            String[] stringArray = new String[]{RosettaArb.getString(39), RosettaArb.getString(40), RosettaArb.getString(41)};
            Icon[] iconArray = new Icon[]{RosettaArb.getIcon(1), RosettaArb.getIcon(4), RosettaArb.getIcon(2)};
            Integer[] integerArray = new Integer[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                integerArray[i] = new Integer(i);
            }
            JComboBox<Integer> jComboBox = new JComboBox<Integer>(integerArray);
            jComboBox.setSize(new Dimension(40, 20));
            jComboBox.setPreferredSize(new Dimension(40, 20));
            jComboBox.setMaximumSize(jComboBox.getPreferredSize());
            LanguageComboBoxRenderer languageComboBoxRenderer = new LanguageComboBoxRenderer(iconArray, stringArray);
            jComboBox.setRenderer(languageComboBoxRenderer);
            this.m_translatorSelectBox = jComboBox;
            this.m_translatorSelectBox.setToolTipText(RosettaArb.getString(42));
            this.m_translatorSelectBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (ScratchMainPanel.this.m_translatorSelectBox.getSelectedIndex() == 0) {
                        ParserSetting.setParserString("oracle.dbtools.migration.parser.tsql.TSQLParserMain");
                    } else if (ScratchMainPanel.this.m_translatorSelectBox.getSelectedIndex() == 1) {
                        ParserSetting.setParserString("oracle.dbtools.migration.parser.msaccess.MSAccessParserMain");
                    } else if (ScratchMainPanel.this.m_translatorSelectBox.getSelectedIndex() == 2) {
                        ParserSetting.setParserString("oracle.dbtools.migration.parser.sybase.SybaseParserMain");
                    } else {
                        ParserSetting.setParserString(null);
                    }
                }
            });
        }
        return this.m_translatorSelectBox;
    }

    private JButton getJButtonZebra() {
        if (this.m_jButtonZebra == null) {
            this.m_jButtonZebra = new JButton();
            this.m_jButtonZebra.setMnemonic(88);
            this.m_jButtonZebra.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    ScratchMainPanel.this.m_jButtonZebra.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        ScratchMainPanel.this.migrateAction();
                        ScratchMainPanel.this.zebraAction();
                    }
                    catch (Exception exception) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RosettaArb.getString(35) + "\n" + exception.getLocalizedMessage()), (String)RosettaArb.getString(36), null);
                    }
                    catch (Throwable throwable) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RosettaArb.getString(35) + "\n" + throwable.getLocalizedMessage()), (String)RosettaArb.getString(36), null);
                    }
                    ScratchMainPanel.this.m_jButtonZebra.setCursor(Cursor.getDefaultCursor());
                }
            });
            this.m_jButtonZebra.setIcon(RosettaArb.getIcon(29));
            this.m_jButtonZebra.setPreferredSize(new Dimension(20, 20));
            this.m_jButtonZebra.setToolTipText(RosettaArb.getString(14));
        }
        return this.m_jButtonZebra;
    }

    private void zebraAction() {
        try {
            TextBuffer textBuffer = TextBufferFactory.createTextBuffer();
            textBuffer.append(this.getSourceSWText().toCharArray());
            String string = Preprocessing.preProcessing(textBuffer);
            String string2 = this.getTargetSWText();
            String string3 = "Oracle Diff " + this.panelID;
            if (ParserSetting.getParserString() == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Not Supported", (String)"Not Supported", null);
                return;
            }
            if (string2 == null || string2.length() == 0) {
                return;
            }
            boolean bl = true;
            Object var6_8 = null;
            if (this._zebraEditor == null || !this._zebraEditor.isOpen) {
                ZebraNode zebraNode = new ZebraNode(URLFactory.newFileURL((String)string3), "TSQL", "PL/SQL");
                Context context = Context.newIdeContext((Node)zebraNode);
                context.setProperty("zebra.file1String", (Object)string);
                context.setProperty("zebra.file2String", (Object)string2);
                context.setProperty("zebra.ignoreWS", (Object)bl);
                context.setProperty("zebra.ancestorFile", var6_8);
                context.setProperty("zebra.algorithmEngine", (Object)this.m_topblock);
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                openEditorOptions.setFlags(1);
                this._zebraEditor = (ZebraEditor)EditorManager.getEditorManager().openEditor(openEditorOptions);
            } else {
                Context context = this._zebraEditor.getContext();
                context.setProperty("zebra.file1String", (Object)string);
                context.setProperty("zebra.file2String", (Object)string2);
                context.setProperty("zebra.ignoreWS", (Object)bl);
                context.setProperty("zebra.ancestorFile", var6_8);
                context.setProperty("zebra.algorithmEngine", (Object)this.m_topblock);
                this._zebraEditor.refresh();
            }
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RosettaArb.getString(35) + "\n" + exception.getLocalizedMessage()), (String)RosettaArb.getString(36), null);
        }
        catch (Throwable throwable) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RosettaArb.getString(35) + "\n" + throwable.getLocalizedMessage()), (String)RosettaArb.getString(36), null);
        }
    }

    public void setupTraversalPolicy() {
        final Component[] componentArray = new Component[]{this.getButtonTranslate(), this.getJButtonZebra(), this.getTranslatorSelector(), this.getSourceTreePane()};
        FocusTraversalPolicy focusTraversalPolicy = new FocusTraversalPolicy(){
            List list;
            {
                this.list = Arrays.asList(componentArray);
            }

            public Component getInitialComponent(Window window) {
                return componentArray[0];
            }

            public Component getFirstComponent(Container container) {
                return componentArray[0];
            }

            public Component getLastComponent(Container container) {
                return componentArray[componentArray.length - 1];
            }

            public Component getComponentAfter(Container container, Component component) {
                int n = this.list.indexOf(component);
                return componentArray[(n + 1) % componentArray.length];
            }

            public Component getComponentBefore(Container container, Component component) {
                int n = this.list.indexOf(component);
                return componentArray[(n - 1 + componentArray.length) % componentArray.length];
            }

            public Component getDefaultComponent(Container container) {
                return componentArray[0];
            }
        };
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(focusTraversalPolicy);
    }

    public SqlEditor getSqlEditorSource() {
        return this.m_sqlEditorSource;
    }

    public void setSqlEditorSource(SqlEditor sqlEditor) {
        this.m_sqlEditorSource = sqlEditor;
    }

    public SqlEditor getSqlEditorTarget() {
        return this.m_sqlEditorTarget;
    }

    public void setSqlEditorTarget(SqlEditor sqlEditor) {
        this.m_sqlEditorTarget = sqlEditor;
    }

    public SqlNode getSourceSqlNode() {
        return this.m_sourceSqlNode;
    }

    public void setSourceSqlNode(SqlNode sqlNode) {
        this.m_sourceSqlNode = sqlNode;
    }

    public SqlNode getTargetSqlNode() {
        return this.m_targetSqlNode;
    }

    public void setTargetSqlNode(SqlNode sqlNode) {
        this.m_targetSqlNode = sqlNode;
    }

    public JSplitPane getSplitPane() {
        return this.m_scratchSplitPane;
    }

    public void setSplitPane(JSplitPane jSplitPane) {
        this.m_scratchSplitPane = jSplitPane;
    }

    public boolean isSourceSelected() {
        return this.m_isSourceSelected;
    }

    public void setIsSourceSelected(boolean bl) {
        this.m_isSourceSelected = bl;
    }

    public SqlEditorNode getSourceSqlEditorNode() {
        return this.m_sourceSqlEditorNode;
    }

    public void setSourceSqlEditorNode(SqlEditorNode sqlEditorNode) {
        this.m_sourceSqlEditorNode = sqlEditorNode;
    }

    public SqlEditorNode getTargetSqlEditorNode() {
        return this.m_targetSqlEditorNode;
    }

    public void setTargetSqlEditorNode(SqlEditorNode sqlEditorNode) {
        this.m_targetSqlEditorNode = sqlEditorNode;
    }
}

