/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.util;

import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;

public class Preprocessing {
    public static String replacer = "     ";

    public static void main(String[] stringArray) {
    }

    public static String preProcessing(TextBuffer textBuffer) {
        textBuffer.beginEdit();
        String string = textBuffer.getString(0, textBuffer.getLength());
        string = Preprocessing.replaceTab(string);
        textBuffer.remove(0, textBuffer.getLength());
        textBuffer.append(string.toCharArray());
        Preprocessing.padLines(textBuffer);
        UndoableEdit undoableEdit = textBuffer.endEdit();
        String string2 = textBuffer.getString(0, textBuffer.getLength());
        undoableEdit.undo();
        return string2;
    }

    public static String replaceTab(String string) {
        return string.replace("\t", replacer);
    }

    public static String padLines(TextBuffer textBuffer) {
        int n;
        LineMap lineMap = textBuffer.getLineMap();
        int n2 = lineMap.getLineCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n = Preprocessing.getIndent(textBuffer, i);
            if (n <= n3) continue;
            n3 = n;
        }
        char[] cArray = new char[n3];
        for (n = 0; n < n3; ++n) {
            cArray[n] = 32;
        }
        for (n = 0; n < n2; ++n) {
            if (!Preprocessing.isEmptyLine(textBuffer, n)) continue;
            Preprocessing.insertIndent(textBuffer, n, cArray);
        }
        return textBuffer.getString(0, textBuffer.getLength());
    }

    private static boolean isEmptyLine(TextBuffer textBuffer, int n) {
        LineMap lineMap = textBuffer.getLineMap();
        int n2 = lineMap.getLineStartOffset(n);
        int n3 = lineMap.getLineEndOffset(n);
        for (int i = n2; i < n3; ++i) {
            char c;
            if (i >= textBuffer.getLength() || Character.isWhitespace(c = textBuffer.getChar(i))) continue;
            return false;
        }
        return true;
    }

    private static int getIndent(TextBuffer textBuffer, int n) {
        int n2 = 0;
        LineMap lineMap = textBuffer.getLineMap();
        int n3 = lineMap.getLineStartOffset(n);
        int n4 = lineMap.getLineEndOffset(n);
        if (n3 >= textBuffer.getLength()) {
            return n2;
        }
        int n5 = n3;
        char c = textBuffer.getChar(n5);
        while (Character.isWhitespace(c) && ++n5 != n4) {
            c = textBuffer.getChar(n5);
            ++n2;
        }
        return n2;
    }

    private static void insertIndent(TextBuffer textBuffer, int n, char[] cArray) {
        LineMap lineMap = textBuffer.getLineMap();
        int n2 = lineMap.getLineStartOffset(n);
        textBuffer.insert(n2, cArray);
    }
}

