/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.geneditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.gui.newzebra.ZebraNode;
import oracle.dbtools.migration.gui.scratch.ScratchEditor;
import oracle.dbtools.migration.gui.scratch.ScratchNode;
import oracle.dbtools.migration.parser.ParserFactory;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.parser.internalapi.ITranslationAll;
import oracle.dbtools.migration.parser.internalapi.TranslateResultWithASTs;
import oracle.dbtools.migration.parser.log.TranslationMessages;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.util.Preprocessing;
import oracle.dbtools.migration.util.Utility;
import oracle.dbtools.migration.workbench.core.navigator.nodes.TSQLNode;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.geneditor.RosettaArb;
import oracle.dbtools.raptor.geneditor.TSQLAddin;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.log.LogManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.jdeveloper.compiler.JCompiler;

public class TSQLController
implements Controller {
    private static final Object LOCK = new Object();
    private static TSQLController _controller;
    public static final int COMPILE_DEBUG_COMMAND;
    protected static final int MAIN_GE_CMD_ID;
    protected static final int NEW_GE_CMD_ID;
    protected static final int OPEN_GE_CMD_ID;
    public static final int MIGRATE_GE_CMD_ID;
    protected static final int SAVE_GE_CMD_ID;
    protected static final int ZEBRA_GE_CMD_ID;
    protected static final int SCRATCH_GE_CMD_ID;
    protected static IdeAction genEditorToolbarMain;
    protected static IdeAction genEditorToolbarNew;
    protected static IdeAction genEditorToolbarOpen;
    protected static IdeAction genEditorToolbarMigrate;
    protected static IdeAction genEditorToolbarZebra;
    protected static IdeAction genEditorToolbarScratch;
    protected static IdeAction genEditorToolbarSave;
    public JMenuItem compileMenu;
    public IdeAction actionCompileDebug;
    public JMenuItem compileDebugMenu = null;
    private Editor tempEditor = null;
    private final File tempFolder = new File(Ide.getHomeDirectory() + "/temp/");
    private String lastPath = Ide.getUserHomeDirectory();
    private final HashMap<View, View> zebraMap = new HashMap();
    private Block _block = null;
    private static int numScratchEditor;

    private TSQLController() {
        if (!this.tempFolder.exists()) {
            this.tempFolder.mkdir();
        }
        this.createActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TSQLController getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_controller == null) {
                _controller = new TSQLController();
            }
        }
        return _controller;
    }

    private void createActions() {
        String string = ConnectionArb.getString((int)1);
        genEditorToolbarNew = IdeAction.get((int)NEW_GE_CMD_ID, null, (String)RosettaArb.getString(10), (String)string, (Integer)new Integer(2), (ArrayResourceBundle)RosettaArb.getInstance(), (int)11, null, (boolean)true);
        genEditorToolbarNew.addController((Controller)this);
        genEditorToolbarOpen = IdeAction.get((int)OPEN_GE_CMD_ID, null, (String)RosettaArb.getString(8), (String)string, (Integer)new Integer(3), (ArrayResourceBundle)RosettaArb.getInstance(), (int)9, null, (boolean)true);
        genEditorToolbarOpen.addController((Controller)this);
        genEditorToolbarSave = IdeAction.get((int)SAVE_GE_CMD_ID, null, (String)RosettaArb.getString(16), (String)string, (Integer)new Integer(4), (ArrayResourceBundle)RosettaArb.getInstance(), (int)17, null, (boolean)true);
        genEditorToolbarSave.addController((Controller)this);
        genEditorToolbarMigrate = IdeAction.get((int)MIGRATE_GE_CMD_ID, null, (String)RosettaArb.getString(12), (String)string, (Integer)new Integer(5), (ArrayResourceBundle)RosettaArb.getInstance(), (int)13, null, (boolean)true);
        genEditorToolbarMigrate.addController((Controller)this);
        genEditorToolbarZebra = IdeAction.get((int)ZEBRA_GE_CMD_ID, null, (String)RosettaArb.getString(14), (String)string, (Integer)new Integer(6), (ArrayResourceBundle)RosettaArb.getInstance(), (int)15, null, (boolean)true);
        genEditorToolbarZebra.addController((Controller)this);
        genEditorToolbarScratch = IdeAction.get((int)SCRATCH_GE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)RosettaArb.getString(18)), (String)string, (Integer)new Integer(7), (ArrayResourceBundle)RosettaArb.getInstance(), (int)19, null, (boolean)true);
        genEditorToolbarScratch.addController((Controller)this);
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == OPEN_GE_CMD_ID) {
            return true;
        }
        if (n == MIGRATE_GE_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == ZEBRA_GE_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == SAVE_GE_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == TSQLAddin.TSQLADDIN_ID || n == NEW_GE_CMD_ID) {
            this.newAction();
            return true;
        }
        if (n == OPEN_GE_CMD_ID) {
            this.openAction(this.getFileName(context.getView(), null, true));
            return true;
        }
        if (n == MIGRATE_GE_CMD_ID) {
            this.translate(ideAction, context);
            return true;
        }
        if (n == ZEBRA_GE_CMD_ID) {
            this.translate(ideAction, context);
            this.zebraAction(ideAction, context);
            return true;
        }
        if (n == SAVE_GE_CMD_ID) {
            this.saveAction(ideAction, context);
        }
        if (n == SCRATCH_GE_CMD_ID) {
            this.scratchAction(ideAction, context);
        }
        if (n == 4) {
            this.clearTemp();
            return true;
        }
        if (n == JCompiler.MAKE_SELECTED_CMD_ID || n == COMPILE_DEBUG_COMMAND) {
            IdeSettings ideSettings;
            for (IdeSettings ideSettings2 : ideSettings = context.getSelection()) {
                Node node = (Node)ideSettings2;
                node.markDirty(true);
            }
            IdeSettings ideSettings3 = Ide.getSettings();
            IdeAction ideAction2 = IdeActions.getFileSaveAction();
            ideAction2.setEnabled(true);
            ideAction2.actionPerformed(new ActionEvent(this, 1001, ""));
            if (context.getView() != null) {
                View.updateToolbarActions((Toolbar)context.getView().getToolbar());
            }
            return true;
        }
        return false;
    }

    private void clearTemp() {
        TranslationMessages.debuginfo((String)"clean");
        this.tempFolder.delete();
    }

    private void scratchAction(IdeAction ideAction, Context context) {
        TSQLController.openScratchEditor();
    }

    public static ScratchEditor openScratchEditor() {
        String string = "Scratch Editor " + numScratchEditor;
        ScratchNode scratchNode = new ScratchNode(URLFactory.newFileURL((String)string), "", "");
        Context context = Context.newIdeContext((Node)scratchNode);
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
        openEditorOptions.setFlags(1);
        Editor editor = EditorManager.getEditorManager().openEditor(openEditorOptions);
        editor.activate();
        scratchNode.setChildren(((ScratchEditor)editor).getSourceNode(), ((ScratchEditor)editor).getTargetNode());
        ((ScratchEditor)editor).getSourceNode().setParentNode((Node)scratchNode);
        ((ScratchEditor)editor).getTargetNode().setParentNode((Node)scratchNode);
        ++numScratchEditor;
        return (ScratchEditor)editor;
    }

    private void saveAction(IdeAction ideAction, Context context) {
        View view = context.getView();
        Node node = context.getNode();
        String string = this.getEditorText(view);
        if (node instanceof TSQLNode) {
            try {
                Utility.saveFile(node.getLongLabel(), string);
            }
            catch (Exception exception) {}
        } else if (node instanceof PlSqlNode) {
            JFileChooser jFileChooser = new JFileChooser(this.lastPath + "/" + node.getShortLabel());
            String string2 = this.getFileName(context.getView(), jFileChooser, false);
            Utility.saveFile(string2, string);
        }
    }

    private String getEditorText(View view) {
        try {
            if (view instanceof CodeEditor) {
                CodeEditor codeEditor = (CodeEditor)view;
                BasicDocument basicDocument = (BasicDocument)codeEditor.getFocusedEditorPane().getDocument();
                TextBuffer textBuffer = basicDocument.getTextBuffer();
                String string = Preprocessing.preProcessing(textBuffer);
                return string;
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void translate(IdeAction ideAction, Context context) {
        View view = context.getView();
        Node node = context.getNode();
        ITranslationAll iTranslationAll = null;
        if (node instanceof TSQLNode) {
            iTranslationAll = (ITranslationAll)ParserFactory.getParser((String)"oracle.dbtools.migration.parser.tsql.TSQLParserMain");
        }
        TextNode textNode = (TextNode)node;
        TranslateResultWithASTs translateResultWithASTs = null;
        try {
            String string = this.getEditorText(view);
            if (string.trim().length() > 0) {
                translateResultWithASTs = iTranslationAll.translateAndGetASTS(string);
                String string2 = translateResultWithASTs.getTargetString();
                TranslationHelper translationHelper = translateResultWithASTs.getHelper();
                this._block = translationHelper.getCodeBlockManager().getTopBlock();
                this.openNewEditor(string2, textNode, view);
            }
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Translation Problem Encountered", (String)"Translation Problem Encountered", null);
            exception.printStackTrace();
        }
    }

    private void openNewEditor(String string, TextNode textNode, View view) {
        String string2 = textNode.getShortLabel();
        int n = string2.indexOf(46);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        TextNode textNode2 = new TextNode();
        try {
            File file = new File(this.tempFolder + "/" + string2 + ".sql");
            Utility.saveFile(file.getAbsolutePath(), string);
            textNode2.setURL(URLFactory.newFileURL((String)file.getAbsolutePath()));
            Context context = Context.newIdeContext((Node)textNode2);
            EditorManager editorManager = EditorManager.getEditorManager();
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, CodeEditor.class);
            Editor editor = editorManager.openEditor(openEditorOptions);
            textNode2.markDirty(true);
            this.zebraMap.put(view, (View)editor);
            this.zebraMap.put((View)editor, view);
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Open Editor Problem Encountered", (String)"Open Editor Problem Encountered", null);
            exception.printStackTrace();
        }
    }

    private String getFileName(View view, JFileChooser jFileChooser, boolean bl) {
        String string = Utility.getFileName(view.getGUI(), jFileChooser, bl, "Open File...");
        this.lastPath = Utility.lastPath;
        return string;
    }

    private void zebraAction(IdeAction ideAction, Context context) {
        View view = context.getView();
        View view2 = this.zebraMap.get(view);
        if (view2 == null) {
            return;
        }
        String string = this.getEditorText(view);
        String string2 = this.getEditorText(view2);
        String string3 = "Oracle Diff";
        if (string2 == null || string2.length() == 0) {
            return;
        }
        boolean bl = true;
        Object var9_9 = null;
        ZebraNode zebraNode = new ZebraNode(URLFactory.newFileURL((String)string3), "TSQL", "PL/SQL");
        Context context2 = Context.newIdeContext((Node)zebraNode);
        context2.setProperty("zebra.file1String", (Object)string);
        context2.setProperty("zebra.file2String", (Object)string2);
        context2.setProperty("zebra.ignoreWS", (Object)bl);
        context2.setProperty("zebra.ancestorFile", var9_9);
        context2.setProperty("zebra.algorithmEngine", (Object)this._block);
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context2);
        openEditorOptions.setFlags(1);
        EditorManager.getEditorManager().openEditor(openEditorOptions);
    }

    public void displayBlock(Block block) {
        if (block != null) {
            TranslationMessages.debuginfo((String)(">>GenEditor>>blocktype:" + block.getBlockType() + " " + block.getSourceStartLine() + " > " + block.getSourceEndLine()));
        }
    }

    private void newAction() {
        try {
            String string = this.tempFolder + "\\Untitled.tsql";
            URL uRL = URLFactory.newFileURL((String)string);
            TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)uRL);
            Context context = Context.newIdeContext((Node)textNode);
            context.setWorkspace(Ide.getActiveWorkspace());
            Project project = null;
            project = Ide.getActiveProject();
            if (project == null) {
                project = new Project();
            }
            context.setProject(project);
            EditorManager editorManager = EditorManager.getEditorManager();
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, CodeEditor.class);
            this.tempEditor = editorManager.openEditor(openEditorOptions);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Open Editor Problem Encountered", (String)"Open Editor Problem Encountered", null);
        }
    }

    private void openAction(String string) {
        try {
            TextNode textNode = null;
            if (string == null) {
                Context context = Context.newIdeContext();
                EditorManager editorManager = EditorManager.getEditorManager();
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, CodeEditor.class);
                editorManager.openEditor(openEditorOptions);
            } else {
                if (string.equals("")) {
                    return;
                }
                URL uRL = URLFactory.newFileURL((String)string);
                textNode = (TextNode)NodeFactory.findOrCreate((URL)uRL);
                Context context = Context.newIdeContext((Node)textNode);
                EditorManager editorManager = EditorManager.getEditorManager();
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, CodeEditor.class);
                editorManager.openEditor(openEditorOptions);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogManager.getLogManager().getMsgPage().log((Object)"error");
        }
    }

    static {
        COMPILE_DEBUG_COMMAND = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.compilemenu.CompileAddin.COMPILE_DEBUG");
        MAIN_GE_CMD_ID = Ide.findOrCreateCmdID((String)"geneditor.main");
        NEW_GE_CMD_ID = Ide.findOrCreateCmdID((String)"geneditor.new");
        OPEN_GE_CMD_ID = Ide.findOrCreateCmdID((String)"geneditor.open");
        MIGRATE_GE_CMD_ID = Ide.findOrCreateCmdID((String)"geneditor.migrate");
        SAVE_GE_CMD_ID = Ide.findOrCreateCmdID((String)"geneditor.save");
        ZEBRA_GE_CMD_ID = Ide.findOrCreateCmdID((String)"geneditor.zebra");
        SCRATCH_GE_CMD_ID = Ide.findOrCreateCmdID((String)"geneditor.scratch");
        genEditorToolbarMain = null;
        genEditorToolbarNew = null;
        genEditorToolbarOpen = null;
        genEditorToolbarMigrate = null;
        genEditorToolbarZebra = null;
        genEditorToolbarScratch = null;
        genEditorToolbarSave = null;
        numScratchEditor = 1;
    }
}

